/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.data;

import java.io.IOException;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.data.AnvilChunk;
import wecui.vendor.com.sk89q.worldedit.data.Chunk;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.OldChunk;

public abstract class ChunkStore {
    public static final int CHUNK_SHIFTS = 4;

    public static BlockVector2D toChunk(Vector pos) {
        int chunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
        int chunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
        return new BlockVector2D(chunkX, chunkZ);
    }

    public abstract CompoundTag getChunkTag(Vector2D var1, LocalWorld var2) throws DataException, IOException;

    public Chunk getChunk(Vector2D pos, LocalWorld world) throws DataException, IOException {
        CompoundTag tag = this.getChunkTag(pos, world);
        Object tags = tag.getValue();
        if (tags.containsKey("Sections")) {
            return new AnvilChunk(world, tag);
        }
        return new OldChunk(world, tag);
    }

    public void close() throws IOException {
    }

    public abstract boolean isValid();
}

