/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import com.sk89q.worldedit.snapshots.Snapshot;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.data.MissingWorldException;
import wecui.vendor.com.sk89q.worldedit.snapshots.InvalidSnapshotException;

public class SnapshotCommands {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public SnapshotCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"list"}, usage="[num]", desc="List snapshots", min=0, max=1)
    @CommandPermissions(value={"worldedit.snapshots.list"})
    public void list(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (snapshots.size() > 0) {
                int num = args.argsLength() > 0 ? Math.min(40, Math.max(5, args.getInteger(0))) : 5;
                player.print("Snapshots for world: '" + player.getWorld().getName() + "'");
                for (int i = 0; i < Math.min(num, snapshots.size()); i = (int)((byte)(i + 1))) {
                    player.print(i + 1 + ". " + ((wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot)snapshots.get(i)).getName());
                }
                player.print("Use /snap use [snapshot] or /snap use latest.");
            } else {
                player.printError("No snapshots are available. See console for details.");
                File dir = config.snapshotRepo.getDirectory();
                try {
                    logger.info("WorldEdit found no snapshots: looked in: " + dir.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                }
            }
        }
        catch (MissingWorldException ex) {
            player.printError("No snapshots were found for this world.");
        }
    }

    @Command(aliases={"use"}, usage="<snapshot>", desc="Choose a snapshot to use", min=1, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void use(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        block8: {
            LocalConfiguration config = this.we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("Snapshot/backup restore is not configured.");
                return;
            }
            String name = args.getString(0);
            if (name.equalsIgnoreCase("latest")) {
                try {
                    wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) {
                        session.setSnapshot(null);
                        player.print("Now using newest snapshot.");
                        break block8;
                    }
                    player.printError("No snapshots were found.");
                }
                catch (MissingWorldException ex) {
                    player.printError("No snapshots were found for this world.");
                }
            } else {
                try {
                    session.setSnapshot(config.snapshotRepo.getSnapshot(name));
                    player.print("Snapshot set to: " + name);
                }
                catch (InvalidSnapshotException e) {
                    player.printError("That snapshot does not exist or is not available.");
                }
            }
        }
    }

    @Command(aliases={"sel"}, usage="<index>", desc="Choose the snapshot based on the list id", min=1, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void sel(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        int index = -1;
        try {
            index = Integer.parseInt(args.getString(0));
        }
        catch (NumberFormatException e) {
            player.printError("Invalid index, " + args.getString(0) + " is not a valid integer.");
            return;
        }
        if (index < 1) {
            player.printError("Invalid index, must be equal or higher then 1.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (snapshots.size() < index) {
                player.printError("Invalid index, must be between 1 and " + snapshots.size() + ".");
                return;
            }
            wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot snapshot = (wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot)snapshots.get(index - 1);
            if (snapshot == null) {
                player.printError("That snapshot does not exist or is not available.");
                return;
            }
            session.setSnapshot(snapshot);
            player.print("Snapshot set to: " + snapshot.getName());
        }
        catch (MissingWorldException e) {
            player.printError("No snapshots were found for this world.");
        }
    }

    @Command(aliases={"before"}, usage="<date>", desc="Choose the nearest snapshot before a date", min=1, max=-1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void before(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        Calendar date = session.detectDate(args.getJoinedStrings(0));
        if (date == null) {
            player.printError("Could not detect the date inputted.");
        } else {
            try {
                wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot snapshot = config.snapshotRepo.getSnapshotBefore(date, player.getWorld().getName());
                if (snapshot == null) {
                    dateFormat.setTimeZone(session.getTimeZone());
                    player.printError("Couldn't find a snapshot before " + dateFormat.format(date.getTime()) + ".");
                } else {
                    session.setSnapshot(snapshot);
                    player.print("Snapshot set to: " + snapshot.getName());
                }
            }
            catch (MissingWorldException ex) {
                player.printError("No snapshots were found for this world.");
            }
        }
    }

    @Command(aliases={"after"}, usage="<date>", desc="Choose the nearest snapshot after a date", min=1, max=-1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void after(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        Calendar date = session.detectDate(args.getJoinedStrings(0));
        if (date == null) {
            player.printError("Could not detect the date inputted.");
        } else {
            try {
                wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot snapshot = config.snapshotRepo.getSnapshotAfter(date, player.getWorld().getName());
                if (snapshot == null) {
                    dateFormat.setTimeZone(session.getTimeZone());
                    player.printError("Couldn't find a snapshot after " + dateFormat.format(date.getTime()) + ".");
                } else {
                    session.setSnapshot(snapshot);
                    player.print("Snapshot set to: " + snapshot.getName());
                }
            }
            catch (MissingWorldException ex) {
                player.printError("No snapshots were found for this world.");
            }
        }
    }
}

