/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandAlias;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.Countable;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.blocks.BlockType;
import wecui.vendor.com.sk89q.worldedit.data.ChunkStore;
import wecui.vendor.com.sk89q.worldedit.regions.CuboidRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.CylinderRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.EllipsoidRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.ExtendingCuboidRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.Polygonal2DRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.Region;
import wecui.vendor.com.sk89q.worldedit.regions.RegionOperationException;
import wecui.vendor.com.sk89q.worldedit.regions.RegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.SphereRegionSelector;

public class SelectionCommands {
    private final WorldEdit we;

    public SelectionCommands(WorldEdit we) {
        this.we = we;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Command(aliases={"/pos1"}, usage="[coordinates]", desc="Set position 1", min=0, max=1)
    @CommandPermissions(value={"worldedit.selection.pos"})
    public void pos1(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        void var5_8;
        if (args.argsLength() == 1) {
            if (!args.getString(0).matches("-?\\d+,-?\\d+,-?\\d+")) {
                player.printError("Invalid coordinates " + args.getString(0));
                return;
            }
            String[] coords = args.getString(0).split(",");
            Vector vector = new Vector(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        } else {
            WorldVector worldVector = player.getBlockIn();
        }
        if (!session.getRegionSelector(player.getWorld()).selectPrimary((Vector)var5_8)) {
            player.printError("Position already set.");
            return;
        }
        session.getRegionSelector(player.getWorld()).explainPrimarySelection(player, session, (Vector)var5_8);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Command(aliases={"/pos2"}, usage="[coordinates]", desc="Set position 2", min=0, max=1)
    @CommandPermissions(value={"worldedit.selection.pos"})
    public void pos2(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        void var5_8;
        if (args.argsLength() == 1) {
            if (!args.getString(0).matches("-?\\d+,-?\\d+,-?\\d+")) {
                player.printError("Invalid coordinates " + args.getString(0));
                return;
            }
            String[] coords = args.getString(0).split(",");
            Vector vector = new Vector(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        } else {
            WorldVector worldVector = player.getBlockIn();
        }
        if (!session.getRegionSelector(player.getWorld()).selectSecondary((Vector)var5_8)) {
            player.printError("Position already set.");
            return;
        }
        session.getRegionSelector(player.getWorld()).explainSecondarySelection(player, session, (Vector)var5_8);
    }

    @Command(aliases={"/hpos1"}, usage="", desc="Set position 1 to targeted block", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.hpos"})
    public void hpos1(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockTrace(300);
        if (pos != null) {
            if (!session.getRegionSelector(player.getWorld()).selectPrimary(pos)) {
                player.printError("Position already set.");
                return;
            }
            session.getRegionSelector(player.getWorld()).explainPrimarySelection(player, session, pos);
        } else {
            player.printError("No block in sight!");
        }
    }

    @Command(aliases={"/hpos2"}, usage="", desc="Set position 2 to targeted block", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.hpos"})
    public void hpos2(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockTrace(300);
        if (pos != null) {
            if (!session.getRegionSelector(player.getWorld()).selectSecondary(pos)) {
                player.printError("Position already set.");
                return;
            }
            session.getRegionSelector(player.getWorld()).explainSecondarySelection(player, session, pos);
        } else {
            player.printError("No block in sight!");
        }
    }

    @Command(aliases={"/chunk"}, usage="", flags="s", desc="Set the selection to your current chunk.", help="Set the selection to the chunk you are currently in.\nWith the -s flag, your current selection is expanded\nto encompass all chunks that are part of it.", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.chunk"})
    public void chunk(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector max;
        Vector min;
        if (args.hasFlag('s')) {
            Region region = session.getSelection(player.getWorld());
            BlockVector2D min2D = ChunkStore.toChunk(region.getMinimumPoint());
            BlockVector2D max2D = ChunkStore.toChunk(region.getMaximumPoint());
            min = new Vector(min2D.getBlockX() * 16, 0, min2D.getBlockZ() * 16);
            max = new Vector(max2D.getBlockX() * 16 + 15, player.getWorld().getMaxY(), max2D.getBlockZ() * 16 + 15);
            player.print("Chunks selected: (" + min2D.getBlockX() + ", " + min2D.getBlockZ() + ") - (" + max2D.getBlockX() + ", " + max2D.getBlockZ() + ")");
        } else {
            BlockVector2D min2D = ChunkStore.toChunk(player.getBlockIn());
            min = new Vector(min2D.getBlockX() * 16, 0, min2D.getBlockZ() * 16);
            max = min.add(15, player.getWorld().getMaxY(), 15);
            player.print("Chunk selected: " + min2D.getBlockX() + ", " + min2D.getBlockZ());
        }
        CuboidRegionSelector selector = new CuboidRegionSelector(player.getWorld());
        selector.selectPrimary(min);
        selector.selectSecondary(max);
        session.setRegionSelector(player.getWorld(), selector);
        session.dispatchCUISelection(player);
    }

    @Command(aliases={"/wand"}, usage="", desc="Get the wand object", min=0, max=0)
    @CommandPermissions(value={"worldedit.wand"})
    public void wand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.giveItem(this.we.getConfiguration().wandItem, 1);
        player.print("Left click: select pos #1; Right click: select pos #2");
    }

    @Command(aliases={"toggleeditwand"}, usage="", desc="Toggle functionality of the edit wand", min=0, max=0)
    @CommandPermissions(value={"worldedit.wand.toggle"})
    public void toggleWand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setToolControl(!session.isToolControlEnabled());
        if (session.isToolControlEnabled()) {
            player.print("Edit wand enabled.");
        } else {
            player.print("Edit wand disabled.");
        }
    }

    @Command(aliases={"/expand"}, usage="<amount> [reverse-amount] <direction>", desc="Expand the selection area", min=1, max=3)
    @CommandPermissions(value={"worldedit.selection.expand"})
    public void expand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector dir;
        if (args.getString(0).equalsIgnoreCase("vert") || args.getString(0).equalsIgnoreCase("vertical")) {
            Region region = session.getSelection(player.getWorld());
            try {
                int oldSize = region.getArea();
                region.expand(new Vector(0, player.getWorld().getMaxY() + 1, 0), new Vector(0, -(player.getWorld().getMaxY() + 1), 0));
                session.getRegionSelector(player.getWorld()).learnChanges();
                int newSize = region.getArea();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
                player.print("Region expanded " + (newSize - oldSize) + " blocks [top-to-bottom].");
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
            return;
        }
        int change = args.getInteger(0);
        int reverseChange = 0;
        switch (args.argsLength()) {
            case 2: {
                try {
                    reverseChange = args.getInteger(1);
                    dir = this.we.getDirection(player, "me");
                }
                catch (NumberFormatException e) {
                    dir = this.we.getDirection(player, args.getString(1).toLowerCase());
                }
                break;
            }
            case 3: {
                reverseChange = args.getInteger(1);
                dir = this.we.getDirection(player, args.getString(2).toLowerCase());
                break;
            }
            default: {
                dir = this.we.getDirection(player, "me");
            }
        }
        Region region = session.getSelection(player.getWorld());
        int oldSize = region.getArea();
        if (reverseChange == 0) {
            region.expand(dir.multiply(change));
        } else {
            region.expand(dir.multiply(change), dir.multiply(-reverseChange));
        }
        session.getRegionSelector(player.getWorld()).learnChanges();
        int newSize = region.getArea();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region expanded " + (newSize - oldSize) + " blocks.");
    }

    @Command(aliases={"/contract"}, usage="<amount> [reverse-amount] [direction]", desc="Contract the selection area", min=1, max=3)
    @CommandPermissions(value={"worldedit.selection.contract"})
    public void contract(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector dir;
        int change = args.getInteger(0);
        int reverseChange = 0;
        switch (args.argsLength()) {
            case 2: {
                try {
                    reverseChange = args.getInteger(1);
                    dir = this.we.getDirection(player, "me");
                }
                catch (NumberFormatException e) {
                    dir = this.we.getDirection(player, args.getString(1).toLowerCase());
                }
                break;
            }
            case 3: {
                reverseChange = args.getInteger(1);
                dir = this.we.getDirection(player, args.getString(2).toLowerCase());
                break;
            }
            default: {
                dir = this.we.getDirection(player, "me");
            }
        }
        try {
            Region region = session.getSelection(player.getWorld());
            int oldSize = region.getArea();
            if (reverseChange == 0) {
                region.contract(dir.multiply(change));
            } else {
                region.contract(dir.multiply(change), dir.multiply(-reverseChange));
            }
            session.getRegionSelector(player.getWorld()).learnChanges();
            int newSize = region.getArea();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("Region contracted " + (oldSize - newSize) + " blocks.");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/shift"}, usage="<amount> [direction]", desc="Shift the selection area", min=1, max=2)
    @CommandPermissions(value={"worldedit.selection.shift"})
    public void shift(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int change = args.getInteger(0);
        Vector dir = args.argsLength() == 2 ? this.we.getDirection(player, args.getString(1).toLowerCase()) : this.we.getDirection(player, "me");
        try {
            Region region = session.getSelection(player.getWorld());
            region.shift(dir.multiply(change));
            session.getRegionSelector(player.getWorld()).learnChanges();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("Region shifted.");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/outset"}, usage="<amount>", desc="Outset the selection area", help="Expands the selection by the given amount in all directions.\nFlags:\n  -h only expand horizontally\n  -v only expand vertically\n", flags="hv", min=1, max=1)
    @CommandPermissions(value={"worldedit.selection.outset"})
    public void outset(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        region.expand(this.getChangesForEachDir(args));
        session.getRegionSelector(player.getWorld()).learnChanges();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region outset.");
    }

    @Command(aliases={"/inset"}, usage="<amount>", desc="Inset the selection area", help="Contracts the selection by the given amount in all directions.\nFlags:\n  -h only contract horizontally\n  -v only contract vertically\n", flags="hv", min=1, max=1)
    @CommandPermissions(value={"worldedit.selection.inset"})
    public void inset(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        region.contract(this.getChangesForEachDir(args));
        session.getRegionSelector(player.getWorld()).learnChanges();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region inset.");
    }

    private Vector[] getChangesForEachDir(CommandContext args) {
        ArrayList<Vector> changes = new ArrayList<Vector>(6);
        int change = args.getInteger(0);
        if (!args.hasFlag('h')) {
            changes.add(new Vector(0, 1, 0).multiply(change));
            changes.add(new Vector(0, -1, 0).multiply(change));
        }
        if (!args.hasFlag('v')) {
            changes.add(new Vector(1, 0, 0).multiply(change));
            changes.add(new Vector(-1, 0, 0).multiply(change));
            changes.add(new Vector(0, 0, 1).multiply(change));
            changes.add(new Vector(0, 0, -1).multiply(change));
        }
        return changes.toArray(new Vector[0]);
    }

    @Command(aliases={"/size"}, usage="", desc="Get information about the selection", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.size"})
    public void size(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        player.print("Type: " + session.getRegionSelector(player.getWorld()).getTypeName());
        for (String line : session.getRegionSelector(player.getWorld()).getInformationLines()) {
            player.print(line);
        }
        player.print("Size: " + size);
        player.print("Cuboid distance: " + region.getMaximumPoint().distance(region.getMinimumPoint()));
        player.print("# of blocks: " + region.getArea());
    }

    @Command(aliases={"/count"}, usage="<block>", desc="Counts the number of a certain type of block", min=1, max=1)
    @CommandPermissions(value={"worldedit.analysis.count"})
    public void count(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Set<Integer> searchIDs = this.we.getBlockIDs(player, args.getString(0), true);
        player.print("Counted: " + editSession.countBlocks(session.getSelection(player.getWorld()), searchIDs));
    }

    @Command(aliases={"/distr"}, usage="", desc="Get the distribution of blocks in the selection", help="Gets the distribution of blocks in the selection.\nThe -c flag makes it print to the console as well.", flags="c", min=0, max=0)
    @CommandPermissions(value={"worldedit.analysis.distr"})
    public void distr(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        List<com.sk89q.worldedit.Countable<Integer>> distribution = editSession.getBlockDistribution(session.getSelection(player.getWorld()));
        Logger logger = Logger.getLogger("Minecraft.WorldEdit");
        if (distribution.size() > 0) {
            int size = session.getSelection(player.getWorld()).getArea();
            player.print("# total blocks: " + size);
            if (args.hasFlag('c')) {
                logger.info("Block distribution (req. by " + player.getName() + "):");
                logger.info("# total blocks: " + size);
            }
            for (Countable countable : distribution) {
                BlockType block = BlockType.fromID((Integer)countable.getID());
                String str = String.format("%-7s (%.3f%%) %s #%d", String.valueOf(countable.getAmount()), (double)countable.getAmount() / (double)size * 100.0, block == null ? "Unknown" : block.getName(), countable.getID());
                player.print(str);
                if (!args.hasFlag('c')) continue;
                logger.info(str);
            }
        } else {
            player.printError("No blocks counted.");
        }
    }

    @Command(aliases={"/sel", ";"}, usage="[cuboid|extend|poly|ellipsoid|sphere|cyl]", desc="Choose a region selector", min=0, max=1)
    public void select(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        RegionSelector selector;
        LocalWorld world = player.getWorld();
        if (args.argsLength() == 0) {
            session.getRegionSelector(world).clear();
            session.dispatchCUISelection(player);
            player.print("Selection cleared.");
            return;
        }
        String typeName = args.getString(0);
        RegionSelector oldSelector = session.getRegionSelector(world);
        if (typeName.equalsIgnoreCase("cuboid")) {
            selector = new CuboidRegionSelector(oldSelector);
            player.print("Cuboid: left click for point 1, right click for point 2");
        } else if (typeName.equalsIgnoreCase("extend")) {
            selector = new ExtendingCuboidRegionSelector(oldSelector);
            player.print("Cuboid: left click for a starting point, right click to extend");
        } else if (typeName.equalsIgnoreCase("poly")) {
            selector = new Polygonal2DRegionSelector(oldSelector);
            player.print("2D polygon selector: Left/right click to add a point.");
        } else if (typeName.equalsIgnoreCase("ellipsoid")) {
            selector = new EllipsoidRegionSelector(oldSelector);
            player.print("Ellipsoid selector: left click=center, right click to extend");
        } else if (typeName.equalsIgnoreCase("sphere")) {
            selector = new SphereRegionSelector(oldSelector);
            player.print("Sphere selector: left click=center, right click to extend");
        } else if (typeName.equalsIgnoreCase("cyl")) {
            selector = new CylinderRegionSelector(oldSelector);
            player.print("Cylindrical selector: Left click=center, right click to extend.");
        } else {
            player.printError("Only cuboid|extend|poly|ellipsoid|sphere|cyl are accepted.");
            return;
        }
        session.setRegionSelector(world, selector);
        session.dispatchCUISelection(player);
    }

    @Command(aliases={"/desel", "/deselect"}, desc="Deselect the current selection")
    @CommandAlias(value={"/sel"})
    public void deselect() {
    }
}

