/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.Logging;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.data.LegacyChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.McRegionChunkStore;

public class ChunkCommands {
    private final WorldEdit we;

    public ChunkCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"chunkinfo"}, usage="", desc="Get information about the chunk that you are inside", min=0, max=0)
    @CommandPermissions(value={"worldedit.chunkinfo"})
    public void chunkInfo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockIn();
        int chunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
        int chunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
        String folder1 = Integer.toString(WorldEdit.divisorMod(chunkX, 64), 36);
        String folder2 = Integer.toString(WorldEdit.divisorMod(chunkZ, 64), 36);
        String filename = "c." + Integer.toString(chunkX, 36) + "." + Integer.toString(chunkZ, 36) + ".dat";
        player.print("Chunk: " + chunkX + ", " + chunkZ);
        player.print("Old format: " + folder1 + "/" + folder2 + "/" + filename);
        player.print("McRegion: region/" + McRegionChunkStore.getFilename(new Vector2D(chunkX, chunkZ)));
    }

    @Command(aliases={"listchunks"}, usage="", desc="List chunks that your selection includes", min=0, max=0)
    @CommandPermissions(value={"worldedit.listchunks"})
    public void listChunks(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Set<com.sk89q.worldedit.Vector2D> chunks = session.getSelection(player.getWorld()).getChunks();
        for (Vector2D vector2D : chunks) {
            player.print(LegacyChunkStore.getFilename(vector2D));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"delchunks"}, usage="", desc="Delete chunks that your selection includes", min=0, max=0)
    @CommandPermissions(value={"worldedit.delchunks"})
    @Logging(value=Logging.LogMode.REGION)
    public void deleteChunks(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("Note that this command does not yet support the mcregion format.");
        LocalConfiguration config = this.we.getConfiguration();
        Set<com.sk89q.worldedit.Vector2D> chunks = session.getSelection(player.getWorld()).getChunks();
        FileOutputStream out = null;
        if (config.shellSaveType == null) {
            player.printError("Shell script type must be configured: 'bat' or 'bash' expected.");
        } else if (config.shellSaveType.equalsIgnoreCase("bat")) {
            try {
                out = new FileOutputStream("worldedit-delchunks.bat");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write("@ECHO off\r\n");
                writer.write("ECHO This batch file was generated by WorldEdit.\r\n");
                writer.write("ECHO It contains a list of chunks that were in the selected region\r\n");
                writer.write("ECHO at the time that the /delchunks command was used. Run this file\r\n");
                writer.write("ECHO in order to delete the chunk files listed in this file.\r\n");
                writer.write("ECHO.\r\n");
                writer.write("PAUSE\r\n");
                for (Vector2D vector2D : chunks) {
                    String filename = LegacyChunkStore.getFilename(vector2D);
                    writer.write("ECHO " + filename + "\r\n");
                    writer.write("DEL \"world/" + filename + "\"\r\n");
                }
                writer.write("ECHO Complete.\r\n");
                writer.write("PAUSE\r\n");
                writer.close();
                player.print("worldedit-delchunks.bat written. Run it when no one is near the region.");
            }
            catch (IOException e) {
                player.printError("Error occurred: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ie) {}
                }
            }
        } else if (config.shellSaveType.equalsIgnoreCase("bash")) {
            try {
                out = new FileOutputStream("worldedit-delchunks.sh");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write("#!/bin/bash\n");
                writer.write("echo This shell file was generated by WorldEdit.\n");
                writer.write("echo It contains a list of chunks that were in the selected region\n");
                writer.write("echo at the time that the /delchunks command was used. Run this file\n");
                writer.write("echo in order to delete the chunk files listed in this file.\n");
                writer.write("echo\n");
                writer.write("read -p \"Press any key to continue...\"\n");
                for (Vector2D vector2D : chunks) {
                    String filename = LegacyChunkStore.getFilename(vector2D);
                    writer.write("echo " + filename + "\n");
                    writer.write("rm \"world/" + filename + "\"\n");
                }
                writer.write("echo Complete.\n");
                writer.write("read -p \"Press any key to continue...\"\n");
                writer.close();
                player.print("worldedit-delchunks.sh written. Run it when no one is near the region.");
                player.print("You will have to chmod it to be executable.");
            }
            catch (IOException e) {
                player.printError("Error occurred: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ie) {}
                }
            }
        } else {
            player.printError("Shell script type must be configured: 'bat' or 'bash' expected.");
        }
    }
}

