/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit;

import java.nio.charset.Charset;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.bukkit.WorldEditPlugin;

public class CUIChannelListener
implements PluginMessageListener {
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private final WorldEditPlugin plugin;

    public CUIChannelListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        LocalSession session = this.plugin.getSession(player);
        if (session.hasCUISupport()) {
            return;
        }
        String[] text = new String(message, UTF_8_CHARSET).split("\\|");
        if (text.length > 1 && text[0].equalsIgnoreCase("v")) {
            this.plugin.setPluginChannelCUI(player.getName(), true);
            session.setCUISupport(true);
            try {
                session.setCUIVersion(Integer.parseInt(text[1]));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Error while reading CUI init message: " + e.getMessage());
            }
        }
    }
}

