/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import wecui.vendor.com.sk89q.util.StringUtil;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBag;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitPlayerBlockBag;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitUtil;
import wecui.vendor.com.sk89q.worldedit.bukkit.CUIChannelListener;
import wecui.vendor.com.sk89q.worldedit.bukkit.WorldEditPlugin;
import wecui.vendor.com.sk89q.worldedit.cui.CUIEvent;

public class BukkitPlayer
extends LocalPlayer {
    private Player player;
    private WorldEditPlugin plugin;

    public BukkitPlayer(WorldEditPlugin plugin, ServerInterface server, Player player) {
        super(server);
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public int getItemInHand() {
        ItemStack itemStack = this.player.getItemInHand();
        return itemStack != null ? itemStack.getTypeId() : 0;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public WorldVector getPosition() {
        Location loc = this.player.getLocation();
        return new WorldVector(BukkitUtil.getLocalWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public double getPitch() {
        return this.player.getLocation().getPitch();
    }

    @Override
    public double getYaw() {
        return this.player.getLocation().getYaw();
    }

    @Override
    public void giveItem(int type, int amt) {
        this.player.getInventory().addItem(new ItemStack[]{new ItemStack(type, amt)});
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    @Override
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    @Override
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    @Override
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.teleport(new Location(this.player.getWorld(), pos.getX(), pos.getY(), pos.getZ(), yaw, pitch));
    }

    @Override
    public String[] getGroups() {
        return this.plugin.getPermissionsResolver().getGroups((OfflinePlayer)this.player);
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return new BukkitPlayerBlockBag(this.player);
    }

    @Override
    public boolean hasPermission(String perm) {
        return !this.plugin.getLocalConfiguration().noOpPermissions && this.player.isOp() || this.plugin.getPermissionsResolver().hasPermission(this.player.getWorld().getName(), (OfflinePlayer)this.player, perm);
    }

    @Override
    public LocalWorld getWorld() {
        return BukkitUtil.getLocalWorld(this.player.getWorld());
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        if (this.plugin.hasPluginChannelCUI(this.getName())) {
            this.player.sendPluginMessage((Plugin)this.plugin, "WECUI", send.getBytes(CUIChannelListener.UTF_8_CHARSET));
        } else {
            this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75" + send);
        }
    }

    @Override
    public void dispatchCUIHandshake() {
        if (!this.plugin.hasPluginChannelCUI(this.getName())) {
            this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75");
            this.player.sendRawMessage("\u00a74\u00a75\u00a73\u00a74");
        }
    }

    public Player getPlayer() {
        return this.player;
    }
}

