/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.jnbt.ListTag;
import wecui.vendor.com.sk89q.jnbt.NBTUtils;
import wecui.vendor.com.sk89q.jnbt.ShortTag;
import wecui.vendor.com.sk89q.jnbt.StringTag;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseItemStack;
import wecui.vendor.com.sk89q.worldedit.blocks.ContainerBlock;
import wecui.vendor.com.sk89q.worldedit.data.DataException;

public class FurnaceBlock
extends ContainerBlock {
    private short burnTime;
    private short cookTime;

    public FurnaceBlock(int type) {
        super(type, 2);
    }

    public FurnaceBlock(int type, int data) {
        super(type, data, 2);
    }

    public FurnaceBlock(int type, int data, BaseItemStack[] items) {
        super(type, data, 2);
        this.setItems(items);
    }

    public short getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(short burnTime) {
        this.burnTime = burnTime;
    }

    public short getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(short cookTime) {
        this.cookTime = cookTime;
    }

    @Override
    public String getTileEntityID() {
        return "Furnace";
    }

    @Override
    public Map<String, Tag> toTileEntityNBT() throws DataException {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("Items", (Tag)new ListTag("Items", CompoundTag.class, this.serializeInventory(this.getItems())));
        values.put("BurnTime", (Tag)new ShortTag("BurnTime", this.burnTime));
        values.put("CookTime", (Tag)new ShortTag("CookTime", this.cookTime));
        return values;
    }

    @Override
    public void fromTileEntityNBT(Map<String, Tag> values) throws DataException {
        if (values == null) {
            return;
        }
        wecui.vendor.com.sk89q.jnbt.Tag t = (wecui.vendor.com.sk89q.jnbt.Tag)values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("Furnace")) {
            throw new DataException("'Furnace' tile entity expected");
        }
        ListTag items = NBTUtils.getChildTag(values, "Items", ListTag.class);
        ArrayList<com.sk89q.jnbt.CompoundTag> compound = new ArrayList<com.sk89q.jnbt.CompoundTag>();
        Iterator i$ = items.getValue().iterator();
        while (i$.hasNext()) {
            wecui.vendor.com.sk89q.jnbt.Tag tag = (wecui.vendor.com.sk89q.jnbt.Tag)i$.next();
            if (!(tag instanceof CompoundTag)) {
                throw new DataException("CompoundTag expected as child tag of Furnace Items");
            }
            compound.add((com.sk89q.jnbt.CompoundTag)((CompoundTag)tag));
        }
        this.setItems(this.deserializeInventory(compound));
        t = (wecui.vendor.com.sk89q.jnbt.Tag)values.get("BurnTime");
        if (t instanceof ShortTag) {
            this.burnTime = ((ShortTag)t).getValue();
        }
        if ((t = (wecui.vendor.com.sk89q.jnbt.Tag)values.get("CookTime")) instanceof ShortTag) {
            this.cookTime = ((ShortTag)t).getValue();
        }
    }
}

