/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.wepif;

import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import wecui.vendor.com.sk89q.util.yaml.YAMLProcessor;
import wecui.vendor.com.sk89q.wepif.PermissionsResolver;

public class PermissionsExResolver
implements PermissionsResolver {
    private final PermissionManager manager;
    private final Server server;

    public static PermissionsResolver factory(Server server, YAMLProcessor config) {
        try {
            PermissionManager manager = (PermissionManager)server.getServicesManager().load(PermissionManager.class);
            if (manager == null) {
                return null;
            }
            return new PermissionsExResolver(server, manager);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public PermissionsExResolver(Server server, PermissionManager manager) {
        this.server = server;
        this.manager = manager;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean hasPermission(String name, String permission) {
        Player player = this.server.getPlayerExact(name);
        return this.manager.has(name, permission, player == null ? null : player.getWorld().getName());
    }

    @Override
    public boolean hasPermission(String worldName, String name, String permission) {
        return this.manager.has(name, permission, worldName);
    }

    @Override
    public boolean inGroup(String player, String group) {
        PermissionUser user = this.manager.getUser(player);
        if (user == null) {
            return false;
        }
        return user.inGroup(group);
    }

    @Override
    public String[] getGroups(String player) {
        PermissionUser user = this.manager.getUser(player);
        if (user == null) {
            return new String[0];
        }
        return user.getGroupsNames();
    }

    @Override
    public boolean hasPermission(OfflinePlayer player, String permission) {
        Player onlinePlayer = player.getPlayer();
        return this.manager.has(player.getName(), permission, onlinePlayer == null ? null : onlinePlayer.getWorld().getName());
    }

    @Override
    public boolean hasPermission(String worldName, OfflinePlayer player, String permission) {
        return this.hasPermission(worldName, player.getName(), permission);
    }

    @Override
    public boolean inGroup(OfflinePlayer player, String group) {
        return this.inGroup(player.getName(), group);
    }

    @Override
    public String[] getGroups(OfflinePlayer player) {
        return this.getGroups(player.getName());
    }

    @Override
    public String getDetectionMessage() {
        return "PermissionsEx detected! Using PermissionsEx for permissions.";
    }
}

