/*
 * Decompiled with CFR 0.152.
 */
package wecui.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChatColor {
    BLACK(0),
    DARK_BLUE(1),
    DARK_GREEN(2),
    DARK_AQUA(3),
    DARK_RED(4),
    DARK_PURPLE(5),
    GOLD(6),
    GRAY(7),
    DARK_GRAY(8),
    BLUE(9),
    GREEN(10),
    AQUA(11),
    RED(12),
    LIGHT_PURPLE(13),
    YELLOW(14),
    WHITE(15);

    private final int code;
    private static final Map<Integer, ChatColor> colors;

    private ChatColor(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("\u00a7%x", this.code);
    }

    public static ChatColor getByCode(int code) {
        return colors.get(code);
    }

    public static String stripColor(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("(?i)\u00a7[0-9A-F]", "");
    }

    static {
        colors = new HashMap<Integer, ChatColor>();
        for (ChatColor color : ChatColor.values()) {
            colors.put(color.getCode(), color);
        }
    }
}

