/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.shapes;

import wecui.obfuscation.RenderObfuscation;
import wecui.render.LineColor;
import wecui.render.LineInfo;
import wecui.render.points.PointCube;
import wecui.util.Vector3;

public class RenderEllipsoid {
    protected LineColor color;
    protected PointCube center;
    protected Vector3 radii;
    protected RenderObfuscation obf = RenderObfuscation.getInstance();
    protected static final double twoPi = Math.PI * 2;
    protected double centerX;
    protected double centerY;
    protected double centerZ;

    public RenderEllipsoid(LineColor color, PointCube center, Vector3 radii) {
        this.color = color;
        this.center = center;
        this.radii = radii;
        this.centerX = (double)center.getPoint().getX() + 0.5;
        this.centerY = (double)center.getPoint().getY() + 0.5;
        this.centerZ = (double)center.getPoint().getZ() + 0.5;
    }

    public void render() {
        for (LineInfo tempColor : this.color.getColors()) {
            tempColor.prepareRender();
            this.drawXZPlane(tempColor);
            this.drawYZPlane(tempColor);
            this.drawXYPlane(tempColor);
        }
    }

    protected void drawXZPlane(LineInfo color) {
        int yRad = (int)Math.floor(this.radii.getY());
        for (int yBlock = -yRad; yBlock < yRad; ++yBlock) {
            this.obf.startDrawing(2);
            color.prepareColor();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = (double)this.radii.getX() * Math.cos(tempTheta) * Math.cos(Math.asin((float)yBlock / this.radii.getY()));
                double tempZ = (double)this.radii.getZ() * Math.sin(tempTheta) * Math.cos(Math.asin((float)yBlock / this.radii.getY()));
                this.obf.addVertex(this.centerX + tempX, this.centerY + (double)yBlock, this.centerZ + tempZ);
            }
            this.obf.finishDrawing();
        }
        this.obf.startDrawing(2);
        color.prepareColor();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = (double)this.radii.getX() * Math.cos(tempTheta);
            double tempZ = (double)this.radii.getZ() * Math.sin(tempTheta);
            this.obf.addVertex(this.centerX + tempX, this.centerY, this.centerZ + tempZ);
        }
        this.obf.finishDrawing();
    }

    protected void drawYZPlane(LineInfo color) {
        int xRad = (int)Math.floor(this.radii.getX());
        for (int xBlock = -xRad; xBlock < xRad; ++xBlock) {
            this.obf.startDrawing(2);
            color.prepareColor();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempY = (double)this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((float)xBlock / this.radii.getX()));
                double tempZ = (double)this.radii.getZ() * Math.sin(tempTheta) * Math.sin(Math.acos((float)xBlock / this.radii.getX()));
                this.obf.addVertex(this.centerX + (double)xBlock, this.centerY + tempY, this.centerZ + tempZ);
            }
            this.obf.finishDrawing();
        }
        this.obf.startDrawing(2);
        color.prepareColor();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempY = (double)this.radii.getY() * Math.cos(tempTheta);
            double tempZ = (double)this.radii.getZ() * Math.sin(tempTheta);
            this.obf.addVertex(this.centerX, this.centerY + tempY, this.centerZ + tempZ);
        }
        this.obf.finishDrawing();
    }

    protected void drawXYPlane(LineInfo color) {
        int zRad = (int)Math.floor(this.radii.getZ());
        for (int zBlock = -zRad; zBlock < zRad; ++zBlock) {
            this.obf.startDrawing(2);
            color.prepareColor();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = (double)this.radii.getX() * Math.sin(tempTheta) * Math.sin(Math.acos((float)zBlock / this.radii.getZ()));
                double tempY = (double)this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((float)zBlock / this.radii.getZ()));
                this.obf.addVertex(this.centerX + tempX, this.centerY + tempY, this.centerZ + (double)zBlock);
            }
            this.obf.finishDrawing();
        }
        this.obf.startDrawing(2);
        color.prepareColor();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = (double)this.radii.getX() * Math.cos(tempTheta);
            double tempY = (double)this.radii.getY() * Math.sin(tempTheta);
            this.obf.addVertex(this.centerX + tempX, this.centerY + tempY, this.centerZ);
        }
        this.obf.finishDrawing();
    }
}

