/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.shapes;

import wecui.obfuscation.RenderObfuscation;
import wecui.render.LineColor;
import wecui.render.LineInfo;
import wecui.util.Vector3;

public class Render3DGrid {
    protected RenderObfuscation obf = RenderObfuscation.getInstance();
    protected LineColor color;
    protected Vector3 first;
    protected Vector3 second;

    public Render3DGrid(LineColor color, Vector3 first, Vector3 second) {
        this.color = color;
        this.first = first;
        this.second = second;
    }

    public void render() {
        double x1 = this.first.getX();
        double y1 = this.first.getY();
        double z1 = this.first.getZ();
        double x2 = this.second.getX();
        double y2 = this.second.getY();
        double z2 = this.second.getZ();
        for (LineInfo tempColor : this.color.getColors()) {
            double zoff;
            double xoff;
            double yoff;
            tempColor.prepareRender();
            RenderObfuscation o = RenderObfuscation.getInstance();
            o.startDrawing(1);
            tempColor.prepareColor();
            double offsetSize = 1.0;
            double z = z2;
            double y = y1;
            int msize = 150;
            if (y2 - y / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y <= y2) {
                    o.addVertex(x1, y + yoff, z);
                    o.addVertex(x2, y + yoff, z);
                    yoff += offsetSize;
                }
            }
            z = z1;
            if (y2 - y / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y <= y2) {
                    o.addVertex(x1, y + yoff, z);
                    o.addVertex(x2, y + yoff, z);
                    yoff += offsetSize;
                }
            }
            double x = x1;
            if (y2 - y / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y <= y2) {
                    o.addVertex(x, y + yoff, z1);
                    o.addVertex(x, y + yoff, z2);
                    yoff += offsetSize;
                }
            }
            x = x2;
            if (y2 - y / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y <= y2) {
                    o.addVertex(x, y + yoff, z1);
                    o.addVertex(x, y + yoff, z2);
                    yoff += offsetSize;
                }
            }
            x = x1;
            z = z1;
            if (x2 - x / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x <= x2) {
                    o.addVertex(x + xoff, y1, z);
                    o.addVertex(x + xoff, y2, z);
                    xoff += offsetSize;
                }
            }
            z = z2;
            if (x2 - x / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x <= x2) {
                    o.addVertex(x + xoff, y1, z);
                    o.addVertex(x + xoff, y2, z);
                    xoff += offsetSize;
                }
            }
            y = y2;
            if (x2 - x / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x <= x2) {
                    o.addVertex(x + xoff, y, z1);
                    o.addVertex(x + xoff, y, z2);
                    xoff += offsetSize;
                }
            }
            y = y1;
            if (x2 - x / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x <= x2) {
                    o.addVertex(x + xoff, y, z1);
                    o.addVertex(x + xoff, y, z2);
                    xoff += offsetSize;
                }
            }
            z = z1;
            y = y1;
            if (z2 - z / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z <= z2) {
                    o.addVertex(x1, y, z + zoff);
                    o.addVertex(x2, y, z + zoff);
                    zoff += offsetSize;
                }
            }
            y = y2;
            if (z2 - z / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z <= z2) {
                    o.addVertex(x1, y, z + zoff);
                    o.addVertex(x2, y, z + zoff);
                    zoff += offsetSize;
                }
            }
            x = x2;
            if (z2 - z / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z <= z2) {
                    o.addVertex(x, y1, z + zoff);
                    o.addVertex(x, y2, z + zoff);
                    zoff += offsetSize;
                }
            }
            x = x1;
            if (z2 - z / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z <= z2) {
                    o.addVertex(x, y1, z + zoff);
                    o.addVertex(x, y2, z + zoff);
                    zoff += offsetSize;
                }
            }
            o.finishDrawing();
        }
    }
}

