/*
 * Decompiled with CFR 0.152.
 */
package wecui.fevents;

import wecui.InitializationFactory;
import wecui.WorldEditCUI;
import wecui.exception.InitializationException;
import wecui.fevents.Event;
import wecui.fevents.HandlerList;
import wecui.fevents.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager
implements InitializationFactory {
    protected WorldEditCUI controller;

    public EventManager(WorldEditCUI controller) {
        this.controller = controller;
    }

    public <TEvent extends Event<TEvent>> void callEvent(TEvent event) {
        HandlerList<TEvent> handlerlist = event.getHandlers();
        handlerlist.bake();
        Listener<TEvent>[][] handlers = handlerlist.handlers;
        int[] handlerids = handlerlist.handlerids;
        for (int arrayidx = 0; arrayidx < handlers.length; ++arrayidx) {
            if (event.isCancelled() && (handlerids[arrayidx] & 1) == 0) continue;
            for (int handler = 0; handler < handlers[arrayidx].length; ++handler) {
                try {
                    handlers[arrayidx][handler].onEvent(event);
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("Error while passing event " + event);
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void initialize() throws InitializationException {
    }
}

