/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class myst_AgeController
implements myst_IAgeController {
    private xd world;
    private myst_AgeData agedata;
    private List agesymbols = new ArrayList();
    private myst_AgeSymbol.IBiomeController biomeController;
    private myst_AgeSymbol.ITimeController timeController;
    private myst_AgeSymbol.IWeatherController weatherController;
    private myst_AgeSymbol.IGenerateTerrain genTerrain;
    private myst_AgeSymbol.IGenerateBrightness genBrightness;
    private List forcedBiomes = new ArrayList();
    private List terrainModifiers = new ArrayList();
    private List populateFuncs = new ArrayList();
    private List featureLocators = new ArrayList();
    private List fogModifiers = new ArrayList();
    private List skyModifiers = new ArrayList();
    private List sunsetModifiers = new ArrayList();
    private List creatureAffecters = new ArrayList();
    private List envEffects = new ArrayList();
    private Float cloudHeight;
    private Double horizon;
    private Integer groundlevel;
    private Integer sealevel;
    private int instability;
    private List conflicts = new ArrayList();

    public myst_AgeController(xd worldObj, myst_AgeData age) {
        this.world = worldObj;
        this.agedata = age;
        this.reconstruct();
    }

    private void validate() {
        if (this.agedata.changed) {
            this.agedata.changed = false;
            this.reconstruct();
            if (!this.world.F) {
                this.agedata.a();
            }
        }
    }

    private void reconstruct() {
        long seed = this.agedata.seed;
        Random rand = new Random(seed);
        this.biomeController = null;
        this.timeController = null;
        this.weatherController = null;
        this.genTerrain = null;
        this.genBrightness = null;
        this.forcedBiomes.clear();
        this.terrainModifiers.clear();
        this.populateFuncs.clear();
        this.featureLocators.clear();
        this.fogModifiers.clear();
        this.skyModifiers.clear();
        this.sunsetModifiers.clear();
        this.creatureAffecters.clear();
        this.envEffects.clear();
        this.cloudHeight = null;
        this.horizon = null;
        this.groundlevel = null;
        this.sealevel = null;
        this.instability = 0;
        this.conflicts.clear();
        List symbols = this.agedata.symbols;
        for (String id : symbols) {
            this.addSymbol(myst_AgeSymbolManager.getAgeSymbol(id));
        }
        while (this.forcedBiomes.size() < this.getBiomeController().getMinBiomeCount()) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(rand, myst_AgeSymbol.IBiomeSelector.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 10;
            this.agedata.a();
        }
        rand.setSeed(++seed);
        ArrayList<abn> biomes = new ArrayList<abn>();
        if (this.forcedBiomes != null && this.forcedBiomes.size() > 0) {
            for (myst_AgeSymbol.IBiomeSelector mod : this.forcedBiomes) {
                if (biomes.size() < this.getBiomeController().getMaxBiomeCount()) {
                    biomes.add(mod.getForcedBiome());
                    continue;
                }
                this.instability += 100;
            }
        }
        this.getBiomeController().setBiomes(biomes);
        if (!this.agedata.visited) {
            HashSet additional = new HashSet();
            if (rand.nextInt(3) > 0) {
                this.generateExtra(rand, myst_AgeSymbol.ITerrainModifier.class, this.terrainModifiers, 2, additional);
            }
            rand.setSeed(++seed);
            if (rand.nextInt(3) == 0) {
                this.generateExtra(rand, myst_AgeSymbol.IPopulate.class, this.populateFuncs, 3, additional);
            }
            rand.setSeed(++seed);
            if (rand.nextInt(5) == 0) {
                this.generateExtra(rand, myst_AgeSymbol.ISkyColorProvider.class, this.skyModifiers, 2, additional);
            }
            rand.setSeed(++seed);
            this.generateExtra(rand, myst_AgeSymbol.ICalculateSunset.class, this.sunsetModifiers, 2, additional);
            rand.setSeed(++seed);
            if (rand.nextInt(3) > 0) {
                this.generateExtra(rand, myst_AgeSymbol.IFogModifier.class, this.fogModifiers, 2, additional);
            }
            if (rand.nextInt(3) > 0) {
                this.generateExtra(rand, IEnvironmentalEffect.class, this.envEffects, 2, additional);
            }
            rand.setSeed(++seed);
            this.generateExtra(rand, myst_AgeSymbol.ICreatureListAffecter.class, this.creatureAffecters, 3, additional);
            rand.setSeed(++seed);
            this.addFromList(rand, additional, 0, 4);
        }
        this.generateLightBrightnessTable(this.world.t.f);
        this.getWeatherController().setDataObject(this.agedata.getStorageObject("weather"));
        this.agedata.visited = true;
        if (!this.world.F) {
            this.agedata.a();
        }
    }

    private void generateExtra(Random rand, Class instance, List store, int max, HashSet additional) {
        ArrayList foundsymbols = myst_AgeSymbolManager.findAgeSymbolsImplementing(instance);
        if (foundsymbols != null && foundsymbols.size() > 0) {
            int min = Math.min(rand.nextInt(max + 1), foundsymbols.size());
            if (store.size() < min) {
                additional.addAll(foundsymbols);
            }
        }
    }

    private void addFromList(Random rand, Collection additional, int min, int max) {
        max = Math.min(max, additional.size());
        int count = rand.nextInt(max - min + 1) + min;
        for (int i = 0; i < count; ++i) {
            myst_AgeSymbol symbol = (myst_AgeSymbol)WeightedItemSelector.getRandomItem(rand, additional);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.a();
        }
    }

    private void addSymbol(myst_AgeSymbol symbol) {
        this.agesymbols.add(symbol);
        symbol.instantiate(this);
        this.instability += symbol.instabilityModifier();
    }

    public int getInstabilityScore() {
        if (myst_Mystcraft.decayEnabled) {
            return this.instability + this.agedata.instability;
        }
        return 0;
    }

    public boolean hasConflicts() {
        return this.conflicts.size() > 0;
    }

    public List getConflicts() {
        return new ArrayList(this.conflicts);
    }

    @Override
    public float getCloudHeight() {
        return this.cloudHeight != null ? this.cloudHeight.floatValue() : 128.0f;
    }

    @Override
    public double getHorizon() {
        return this.horizon != null ? this.horizon : 63.0;
    }

    @Override
    public int getAverageGroundLevel() {
        return this.groundlevel != null ? this.groundlevel : 64;
    }

    @Override
    public int getSeaLevel() {
        return this.sealevel != null ? this.sealevel : 63;
    }

    public bo getFogColor(float f, float f1) {
        this.validate();
        if (this.fogModifiers == null || this.fogModifiers.size() == 0) {
            return null;
        }
        bo color = null;
        for (myst_AgeSymbol.IFogModifier mod : this.fogModifiers) {
            bo op2 = mod.getFogColor(f, f1);
            if (op2 == null) continue;
            if (color == null) {
                color = op2;
                continue;
            }
            color.a = (color.a + op2.a) / 2.0;
            color.b = (color.b + op2.b) / 2.0;
            color.c = (color.c + op2.c) / 2.0;
        }
        return color;
    }

    public bo getSkyColor(nn entity, abn biome, float time, float celestial_angle) {
        this.validate();
        if (this.skyModifiers == null || this.skyModifiers.size() == 0) {
            return null;
        }
        bo color = null;
        for (myst_AgeSymbol.ISkyColorProvider mod : this.skyModifiers) {
            bo op2 = mod.getSkyColor(entity, biome, time, celestial_angle);
            if (op2 == null) continue;
            if (color == null) {
                color = op2;
                continue;
            }
            color.a = (color.a + op2.a) / 2.0;
            color.b = (color.b + op2.b) / 2.0;
            color.c = (color.c + op2.c) / 2.0;
        }
        return color;
    }

    public float[] calcSunriseSunsetColors(float f, float f1) {
        this.validate();
        if (this.sunsetModifiers == null || this.sunsetModifiers.size() == 0) {
            return null;
        }
        float[] color = null;
        for (myst_AgeSymbol.ICalculateSunset mod : this.sunsetModifiers) {
            float[] op2 = mod.calcSunriseSunsetColors(f, f1);
            if (op2 == null) continue;
            if (color == null) {
                color = op2;
                continue;
            }
            for (int i = 0; i < color.length; ++i) {
                color[i] = (color[i] + op2[i]) / 2.0f;
            }
        }
        return color;
    }

    public myst_AgeSymbol.IBiomeController getBiomeController() {
        this.validate();
        if (this.biomeController == null) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(new Random(this.agedata.seed), myst_AgeSymbol.IBiomeController.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 10;
            this.agedata.a();
        }
        return this.biomeController;
    }

    public myst_AgeSymbol.IWeatherController getWeatherController() {
        this.validate();
        if (this.weatherController == null) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(new Random(this.agedata.seed), myst_AgeSymbol.IWeatherController.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 10;
            this.agedata.a();
        }
        return this.weatherController;
    }

    public void generateTerrain(int i, int j, byte[] abyte0) {
        this.validate();
        if (this.genTerrain == null) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(new Random(this.agedata.seed), myst_AgeSymbol.IGenerateTerrain.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 10;
            this.agedata.a();
        }
        this.genTerrain.generateTerrain(i, j, abyte0);
    }

    public void modifyTerrain(int i, int j, byte[] abyte0) {
        this.validate();
        if (this.terrainModifiers != null && this.terrainModifiers.size() > 0) {
            for (myst_AgeSymbol.ITerrainModifier mod : this.terrainModifiers) {
                mod.affectTerrain(this.world, i, j, abyte0);
            }
        }
    }

    public void generateLightBrightnessTable(float[] lightBrightnessTable) {
        this.validate();
        if (this.genBrightness == null) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(new Random(this.agedata.seed), myst_AgeSymbol.IGenerateBrightness.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 10;
            this.agedata.a();
        }
        this.genBrightness.generateLightBrightnessTable(lightBrightnessTable);
    }

    public float calculateCelestialAngle(long time, float f1) {
        this.validate();
        if (this.timeController == null) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(new Random(this.agedata.seed), myst_AgeSymbol.ITimeController.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 30;
            this.agedata.a();
        }
        return this.timeController.calculateCelestialAngle(time, f1);
    }

    public int getMoonPhase(long time, float f1) {
        this.validate();
        if (this.timeController == null) {
            myst_AgeSymbol symbol = myst_AgeSymbolManager.findAgeSymbolImplementing(new Random(this.agedata.seed), myst_AgeSymbol.ITimeController.class);
            this.addSymbol(symbol);
            this.agedata.symbols.add(symbol.identifier());
            this.agedata.instability += 30;
            this.agedata.a();
        }
        return this.timeController.getMoonPhase(time, f1);
    }

    public void populate(xd worldObj, Random rand, int i, int j) {
        this.validate();
        if (this.populateFuncs != null && this.populateFuncs.size() > 0) {
            boolean flag = false;
            for (myst_AgeSymbol.IPopulate mod : this.populateFuncs) {
                flag = flag || mod.populate(worldObj, rand, i, j, flag);
            }
        }
        if (this.envEffects != null && this.envEffects.size() > 0) {
            for (IEnvironmentalEffect effect : this.envEffects) {
                effect.onChunkPopulate(worldObj, rand, i, j);
            }
        }
    }

    public void tickBlocksAndAmbiance(ack chunk) {
        this.getWeatherController().tick(this.world, chunk);
        if (this.envEffects != null && this.envEffects.size() > 0) {
            for (IEnvironmentalEffect effect : this.envEffects) {
                effect.tick(this.world, chunk);
            }
        }
    }

    public List affectCreatureList(acf enumcreaturetype, List list, int i, int j, int k) {
        this.validate();
        if (this.creatureAffecters != null && this.creatureAffecters.size() > 0) {
            for (myst_AgeSymbol.ICreatureListAffecter mod : this.creatureAffecters) {
                if (list == null) {
                    list = new ArrayList();
                }
                mod.affectCreatureList(enumcreaturetype, list, i, j, k);
            }
        }
        return list;
    }

    public qo locateTerrainFeature(xd world, String s, int i, int j, int k) {
        this.validate();
        if (this.featureLocators == null || this.featureLocators.size() == 0) {
            return null;
        }
        qo found = null;
        for (myst_AgeSymbol.ITerrainFeatureLocator mod : this.featureLocators) {
            found = mod.locate(world, s, i, j, k);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    public abn getAlternateBiomeForCoords(abn saved, int par1, int par2) {
        abn alt = this.getWeatherController().getAlternateBiomeForCoords(saved, par1, par2);
        return alt == null ? saved : alt;
    }

    public float getTemperatureAtHeight(float temp, int y) {
        return this.getWeatherController().getTemperatureAtHeight(temp, y);
    }

    @Override
    public long getSeed() {
        return this.agedata.seed;
    }

    @Override
    public rs getWorldChunkManager() {
        return this.world.i();
    }

    @Override
    public void setCloudHeight(myst_AgeSymbol agent, float height) {
        this.cloudHeight = this.cloudHeight == null ? Float.valueOf(height) : Float.valueOf((this.cloudHeight.floatValue() + height) / 2.0f);
    }

    @Override
    public void setHorizon(myst_AgeSymbol agent, double height) {
        this.horizon = this.horizon == null ? Double.valueOf(height) : Double.valueOf((this.horizon + height) / 2.0);
    }

    @Override
    public void setAverageGroundLevel(myst_AgeSymbol agent, int height) {
        this.groundlevel = this.groundlevel != null ? Integer.valueOf((this.groundlevel + height) / 2) : Integer.valueOf(height);
    }

    @Override
    public void setSeaLevel(myst_AgeSymbol agent, int height) {
        this.sealevel = this.sealevel != null ? Integer.valueOf((this.sealevel + height) / 2) : Integer.valueOf(height);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IBiomeController controller) {
        if (this.biomeController != null) {
            this.conflicts.add(agent);
            this.instability += 100;
        }
        this.biomeController = controller;
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IGenerateTerrain terrainGen) {
        if (this.genTerrain != null) {
            this.conflicts.add(agent);
            this.instability += 100;
        }
        this.genTerrain = terrainGen;
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IGenerateBrightness reg) {
        if (this.genBrightness != null) {
            this.conflicts.add(agent);
            this.instability += 20;
        }
        this.genBrightness = reg;
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.ITimeController reg) {
        if (this.timeController != null) {
            this.conflicts.add(agent);
            this.instability += 50;
        }
        this.timeController = reg;
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IWeatherController reg) {
        if (this.weatherController != null) {
            this.conflicts.add(agent);
            this.instability += 20;
        }
        this.weatherController = reg;
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IBiomeSelector reg) {
        this.forcedBiomes.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.ITerrainModifier reg) {
        this.terrainModifiers.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IPopulate reg) {
        this.populateFuncs.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.ITerrainFeatureLocator reg) {
        this.featureLocators.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.IFogModifier reg) {
        this.fogModifiers.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.ISkyColorProvider reg) {
        this.skyModifiers.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.ICalculateSunset reg) {
        this.sunsetModifiers.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, myst_AgeSymbol.ICreatureListAffecter reg) {
        this.creatureAffecters.add(reg);
    }

    @Override
    public void registerInterface(myst_AgeSymbol agent, IEnvironmentalEffect reg) {
        this.envEffects.add(reg);
    }
}

