/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.Random;

public class WeightedItemSelector {
    public static float getItemWeight(Object item) {
        if (item instanceof IWeightedItem) {
            return ((IWeightedItem)item).getRarity();
        }
        return 1.0f;
    }

    private static float getTotalWeight(Collection collection) {
        float total = 0.0f;
        for (Object item : collection) {
            total += WeightedItemSelector.getItemWeight(item);
        }
        return total;
    }

    public static Object getRandomItem(Random rand, Collection collection) {
        return WeightedItemSelector.getRandomItem(rand, collection, WeightedItemSelector.getTotalWeight(collection));
    }

    public static Object getRandomItem(Random rand, Collection collection, float max) {
        if (max <= 0.0f) {
            throw new IllegalArgumentException();
        }
        float selection = rand.nextFloat() * max;
        for (Object item : collection) {
            if (!((selection -= WeightedItemSelector.getItemWeight(item)) <= 0.0f)) continue;
            return item;
        }
        return null;
    }
}

