/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.ITerraformingBP;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityElecMachine;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.Platform;

public class TileEntityTerra
extends TileEntityElecMachine {
    public int failedAttempts = 0;
    public int lastX = -1;
    public int lastY = -1;
    public int lastZ = -1;
    public AudioSource audioSource;
    public int inactiveTicks = 0;

    public TileEntityTerra() {
        super(1, 0, 100000, 512);
    }

    @Override
    public String c() {
        return "Terraformer";
    }

    @Override
    public void n_() {
        ITerraformingBP tfbp;
        super.n_();
        boolean newActive = false;
        if (this.inventory[0] != null && this.inventory[0].a() instanceof ITerraformingBP && this.energy >= (tfbp = (ITerraformingBP)this.inventory[0].a()).getConsume()) {
            newActive = true;
            int x = this.j;
            int z = this.l;
            int range = 1;
            if (this.lastY > -1) {
                range = tfbp.getRange() / 10;
                x = this.lastX - this.i.r.nextInt(range + 1) + this.i.r.nextInt(range + 1);
                z = this.lastZ - this.i.r.nextInt(range + 1) + this.i.r.nextInt(range + 1);
            } else {
                if (this.failedAttempts > 4) {
                    this.failedAttempts = 4;
                }
                range = tfbp.getRange() * (this.failedAttempts + 1) / 5;
                x = x - this.i.r.nextInt(range + 1) + this.i.r.nextInt(range + 1);
                z = z - this.i.r.nextInt(range + 1) + this.i.r.nextInt(range + 1);
            }
            if (tfbp.terraform(this.i, x, z, this.k)) {
                this.energy -= tfbp.getConsume();
                this.failedAttempts = 0;
                this.lastX = x;
                this.lastZ = z;
                this.lastY = this.k;
            } else {
                this.energy -= tfbp.getConsume() / 10;
                ++this.failedAttempts;
                this.lastY = -1;
            }
        }
        if (newActive) {
            this.inactiveTicks = 0;
            this.setActive(true);
        } else if (!newActive && this.getActive() && this.inactiveTicks++ > 30) {
            this.setActive(false);
        }
    }

    @Override
    public void h() {
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
        super.h();
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > 512) {
            mod_IC2.explodeMachineAt(this.i, this.j, this.k, this.l);
            return 0;
        }
        if (this.energy + amount > this.maxEnergy) {
            int unused = this.energy + amount - this.maxEnergy;
            this.energy = this.maxEnergy;
            return unused;
        }
        this.energy += amount;
        return 0;
    }

    public boolean ejectBlueprint() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (Platform.isSimulating()) {
            StackUtil.dropAsEntity(this.i, this.j, this.k, this.l, this.inventory[0]);
            this.inventory[0] = null;
        }
        return true;
    }

    public void insertBlueprint(aan tfbp) {
        this.ejectBlueprint();
        this.inventory[0] = tfbp;
    }

    public static int getFirstSolidBlockFrom(xd world, int x, int z, int y) {
        while (y > 0) {
            if (world.g(x, y, z)) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static int getFirstBlockFrom(xd world, int x, int z, int y) {
        while (y > 0) {
            if (world.a(x, y, z) != 0) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static boolean switchGround(xd world, pb from, pb to, int x, int y, int z, boolean upwards) {
        int id;
        if (upwards) {
            int id2;
            int saveY = ++y;
            while ((id2 = world.a(x, y - 1, z)) != 0 && pb.m[id2] == from) {
                --y;
            }
            if (saveY == y) {
                return false;
            }
            world.g(x, y, z, to.bO);
            return true;
        }
        while ((id = world.a(x, y, z)) != 0 && pb.m[id] == to) {
            --y;
        }
        id = world.a(x, y, z);
        if (id == 0 || pb.m[id] != from) {
            return false;
        }
        world.g(x, y, z, to.bO);
        return true;
    }

    public static abn getBiomeAt(xd world, int x, int z) {
        ack chunk = world.c(x, z);
        return Platform.getBiomeAt(chunk, x & 0x10, z & 0x10, world.i());
    }

    public static void setBiomeAt(xd world, int x, int z, abn biome) {
        System.out.println("setting biome at " + x + "," + z);
        ack chunk = world.c(x, z);
        byte[] array = chunk.m();
        array[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.M & 0xFF);
        chunk.a(array);
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = AudioManager.createSource(this, PositionSpec.Center, "Terraformers/TerraformerGenericloop.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

