/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.INetworkItemEventListener;
import ic2.common.ElectricItem;
import ic2.common.EntityMiningLaser;
import ic2.common.ItemElectricTool;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.platform.AudioManager;
import ic2.platform.Keyboard;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;

public class ItemToolMiningLaser
extends ItemElectricTool
implements INetworkItemEventListener {
    private static final int EventShotMining = 0;
    private static final int EventShotLowFocus = 1;
    private static final int EventShotLongRange = 2;
    private static final int EventShotHorizontal = 3;
    private static final int EventShotSuperHeat = 4;
    private static final int EventShotScatter = 5;
    private static final int EventShotExplosive = 6;

    public ItemToolMiningLaser(int id, int sprite) {
        super(id, sprite, uk.a, 100);
        this.maxCharge = 200000;
        this.transferLimit = 120;
        this.tier = 2;
    }

    public aan a(aan itemstack, xd world, yw entityplayer) {
        if (!Platform.isSimulating()) {
            return itemstack;
        }
        ady nbtData = StackUtil.getOrCreateNbtData(itemstack);
        int laserSetting = nbtData.f("laserSetting");
        if (Keyboard.isModeSwitchKeyDown(entityplayer)) {
            laserSetting = (laserSetting + 1) % 7;
            nbtData.a("laserSetting", laserSetting);
            String laser = (new String[]{"Mining", "Low-Focus", "Long-Range", "Horizontal", "Super-Heat", "Scatter", "Explosive"})[laserSetting];
            Platform.messagePlayer(entityplayer, "Laser Mode: " + laser);
        } else {
            int consume = (new int[]{1250, 100, 5000, 0, 2500, 10000, 5000})[laserSetting];
            if (!ElectricItem.use(itemstack, consume, entityplayer)) {
                return itemstack;
            }
            switch (laserSetting) {
                case 0: {
                    world.a((nn)new EntityMiningLaser(world, (acq)entityplayer, Float.POSITIVE_INFINITY, 5.0f, Integer.MAX_VALUE, false));
                    NetworkManager.initiateItemEvent(entityplayer, itemstack, 0, true);
                    break;
                }
                case 1: {
                    world.a((nn)new EntityMiningLaser(world, (acq)entityplayer, 4.0f, 5.0f, 1, false));
                    NetworkManager.initiateItemEvent(entityplayer, itemstack, 1, true);
                    break;
                }
                case 2: {
                    world.a((nn)new EntityMiningLaser(world, (acq)entityplayer, Float.POSITIVE_INFINITY, 20.0f, Integer.MAX_VALUE, false));
                    NetworkManager.initiateItemEvent(entityplayer, itemstack, 2, true);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    world.a((nn)new EntityMiningLaser(world, (acq)entityplayer, Float.POSITIVE_INFINITY, 8.0f, Integer.MAX_VALUE, false, true));
                    NetworkManager.initiateItemEvent(entityplayer, itemstack, 4, true);
                    break;
                }
                case 5: {
                    for (int x = -2; x <= 2; ++x) {
                        for (int y = -2; y <= 2; ++y) {
                            world.a((nn)new EntityMiningLaser(world, (acq)entityplayer, Float.POSITIVE_INFINITY, 12.0f, Integer.MAX_VALUE, false, entityplayer.u + 20.0f * (float)x, entityplayer.v + 20.0f * (float)y));
                        }
                    }
                    NetworkManager.initiateItemEvent(entityplayer, itemstack, 5, true);
                    break;
                }
                case 6: {
                    world.a((nn)new EntityMiningLaser(world, (acq)entityplayer, Float.POSITIVE_INFINITY, 12.0f, Integer.MAX_VALUE, true));
                    NetworkManager.initiateItemEvent(entityplayer, itemstack, 6, true);
                }
            }
        }
        return itemstack;
    }

    public boolean onItemUseFirst(aan itemstack, yw entityPlayer, xd world, int x, int y, int z, int side) {
        if (!Platform.isSimulating()) {
            return false;
        }
        ady nbtData = StackUtil.getOrCreateNbtData(itemstack);
        if (!Keyboard.isModeSwitchKeyDown(entityPlayer) && nbtData.f("laserSetting") == 3) {
            if (Math.abs(entityPlayer.p + (double)entityPlayer.I() - 0.1 - ((double)y + 0.5)) < 1.5) {
                if (ElectricItem.use(itemstack, 3000, entityPlayer)) {
                    world.a((nn)new EntityMiningLaser(world, (acq)entityPlayer, Float.POSITIVE_INFINITY, 5.0f, Integer.MAX_VALUE, false, entityPlayer.u, 0.0, (double)y + 0.5));
                    NetworkManager.initiateItemEvent(entityPlayer, itemstack, 3, true);
                }
            } else {
                Platform.messagePlayer(entityPlayer, "Mining laser aiming angle too steep");
            }
        }
        return false;
    }

    @Override
    public int rarity(aan stack) {
        return 1;
    }

    @Override
    public void onNetworkEvent(int metaData, yw player, int event) {
        switch (event) {
            case 0: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 1: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLowFocus.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 2: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLongRange.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 3: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 4: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 5: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserScatter.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 6: {
                AudioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserExplosive.ogg", true, AudioManager.defaultVolume);
            }
        }
    }
}

