/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.IConnectRedstone;
import forge.ISpecialResistance;
import ic2.api.Direction;
import ic2.api.IPaintableBlock;
import ic2.common.AabbUtil;
import ic2.common.BlockMultiID;
import ic2.common.Ic2Items;
import ic2.common.ItemToolCutter;
import ic2.common.StackUtil;
import ic2.common.TileEntityBlock;
import ic2.common.TileEntityCable;
import ic2.common.TileEntityCableDetector;
import ic2.common.TileEntityCableSplitter;
import ic2.platform.ItemBlockCommon;
import ic2.platform.Platform;
import java.util.ArrayList;

public class BlockCable
extends BlockMultiID
implements IPaintableBlock,
ISpecialResistance,
IConnectRedstone {
    public BlockCable(int i) {
        super(i, acn.f);
        this.c(0.2f);
        this.a(k);
        Ic2Items.copperCableBlock = new aan((pb)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new aan((pb)this, 1, 0);
        Ic2Items.goldCableBlock = new aan((pb)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new aan((pb)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new aan((pb)this, 1, 4);
        Ic2Items.ironCableBlock = new aan((pb)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new aan((pb)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new aan((pb)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new aan((pb)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new aan((pb)this, 1, 9);
        Ic2Items.tinCableBlock = new aan((pb)this, 1, 10);
        Ic2Items.detectorCableBlock = new aan((pb)this, 1, 11);
        Ic2Items.splitterCableBlock = new aan((pb)this, 1, 12);
        ModLoader.registerBlock((pb)this, ItemBlockCommon.class);
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_cable.png";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int d(ali iblockaccess, int x, int y, int z, int side) {
        short cableType;
        int color = 0;
        kw te = iblockaccess.b(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            cableType = (short)iblockaccess.e(x, y, z);
            return cableType * 16 + color;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed != 0) {
            if (cable.foamed != 1) return 208 + cable.foamColor;
            return 178;
        }
        cableType = cable.cableType;
        if (!(te instanceof TileEntityCableDetector) && !(te instanceof TileEntityCableSplitter)) {
            color = cable.color;
            return cableType * 16 + color;
        }
        color = cable.getActive() ? 1 : 0;
        return cableType * 16 + color;
    }

    @Override
    public int a(int side, int meta) {
        return meta * 16;
    }

    public pl a(xd world, int x, int y, int z, bo origin, bo absDirection) {
        kw te = world.b(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        bo direction = bo.a((double)(absDirection.a - origin.a), (double)(absDirection.b - origin.b), (double)(absDirection.c - origin.c));
        double maxLength = direction.d();
        double halfThickness = (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        bo intersection = bo.a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, wu.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.d(origin) <= maxLength) {
            hit = true;
        }
        for (Direction dir : Direction.values()) {
            if (hit) break;
            kw target = dir.applyToTileEntity(tileEntityCable);
            if (!tileEntityCable.canInteractWith(target)) continue;
            wu bbox = null;
            switch (dir) {
                case XN: {
                    bbox = wu.a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case XP: {
                    bbox = wu.a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YN: {
                    bbox = wu.a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YP: {
                    bbox = wu.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case ZN: {
                    bbox = wu.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                    break;
                }
                case ZP: {
                    bbox = wu.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                }
            }
            intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
            if (intersectingDirection == null || !(intersection.d(origin) <= maxLength)) continue;
            hit = true;
        }
        if (hit) {
            return new pl(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public wu getCollisionBoundingBoxFromPool(xd world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        return wu.b((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public wu c(xd world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public wu d(xd world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public wu getCommonBoundingBoxFromPool(xd world, int x, int y, int z, boolean selectionBoundingBox) {
        kw te = world.b(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canInteractWith(world.b(x - 1, y, z))) {
            minX = x;
        }
        if (cable.canInteractWith(world.b(x, y - 1, z))) {
            minY = y;
        }
        if (cable.canInteractWith(world.b(x, y, z - 1))) {
            minZ = z;
        }
        if (cable.canInteractWith(world.b(x + 1, y, z))) {
            maxX = x + 1;
        }
        if (cable.canInteractWith(world.b(x, y + 1, z))) {
            maxY = y + 1;
        }
        if (cable.canInteractWith(world.b(x, y, z + 1))) {
            maxZ = z + 1;
        }
        return wu.b((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isBlockNormalCube(xd world, int x, int y, int z) {
        kw te = world.b(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean b(xd world, int x, int y, int z, yw entityPlayer) {
        aan cur = entityPlayer.av();
        if (cur != null && cur.c == pb.E.bO) {
            if (!Platform.isSimulating()) {
                return true;
            }
            kw te = world.b(x, y, z);
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (cable.foamed == 1 && cable.changeFoam((byte)2)) {
                    --cur.a;
                    if (cur.a <= 0) {
                        entityPlayer.ap.a[entityPlayer.ap.c] = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int getCableColor(ali iblockaccess, int i, int j, int k) {
        kw te = iblockaccess.b(i, j, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    @Override
    public boolean colorBlock(xd world, int i, int j, int k, int color) {
        return ((TileEntityCable)world.b(i, j, k)).changeColor(color);
    }

    public boolean canHarvestBlock(yw player, int md2) {
        return true;
    }

    @Override
    public ArrayList getBlockDropped(xd world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<aan> ret = new ArrayList<aan>();
        kw te = world.b(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            ret.add(new aan(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        } else if (metadata != 13) {
            ret.add(new aan(Ic2Items.insulatedCopperCableItem.c, 1, metadata));
        }
        return ret;
    }

    @Override
    public void b_(xd world, int x, int y, int z) {
        kw te;
        if (world.e(x, y, z) == 13 && (te = world.b(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            StackUtil.dropAsEntity(world, x, y, z, new aan(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        }
    }

    @Override
    public TileEntityBlock getBlockEntity(int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        return new TileEntityCable((short)meta);
    }

    public int getMaxMeta() {
        return 13;
    }

    public boolean b() {
        return false;
    }

    public int d() {
        return mod_IC2.cableRenderId;
    }

    public boolean a() {
        return false;
    }

    public void a(xd world, int i, int j, int k, yw entityplayer) {
        if (entityplayer.av() != null && entityplayer.av().a() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.av(), world, i, j, k);
        }
    }

    public boolean b(ali iblockaccess, int x, int y, int z, int side) {
        kw te = iblockaccess.b(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive();
        }
        return false;
    }

    @Override
    public void addCreativeItems(ArrayList itemList) {
    }

    public float getHardness(int md2) {
        if (md2 == 13) {
            return 3.0f;
        }
        return 0.2f;
    }

    public float getSpecialExplosionResistance(xd world, int x, int y, int z, double src_x, double src_y, double src_z, nn exploder) {
        kw te = world.b(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public boolean canConnectRedstone(ali world, int X, int Y, int Z, int direction) {
        int meta = world.e(X, Y, Z);
        return meta == 11 || meta == 12;
    }
}

