/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.API;
import codechicken.nei.DefaultOverlayRenderer;
import codechicken.nei.GuiCraftingRecipe;
import codechicken.nei.GuiManager;
import codechicken.nei.GuiRecipe;
import codechicken.nei.GuiUsageRecipe;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.IHandleInput;
import codechicken.nei.IRecipeOverlayRenderer;
import codechicken.nei.IUsageHandler;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public abstract class TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    public int cycleticks = Math.abs((int)System.currentTimeMillis());
    public ArrayList arecipes = new ArrayList();
    public LinkedList transferRects = new LinkedList();

    static {
        API.addInputHandler(new RecipeTransferRectInputHandler());
    }

    public TemplateRecipeHandler() {
        this.loadTransferRects();
        RecipeTransferRectInputHandler.registerRectsToGuis(this.getRecipeTransferRectGuis(), this.transferRects);
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((aan)results[0]);
        }
    }

    public void loadCraftingRecipes(aan result) {
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            this.loadUsageRecipes((aan)ingredients[0]);
        }
    }

    public void loadUsageRecipes(aan ingredient) {
    }

    public abstract String getGuiTexture();

    public String getOverlayIdentifier() {
        return "";
    }

    public void drawExtras(GuiManager gui, int recipe) {
    }

    public void drawProgressBar(GuiManager gui, int x, int y2, int tx, int ty, int w, int h, int ticks, int direction) {
        this.drawProgressBar(gui, x, y2, tx, ty, w, h, (float)(this.cycleticks % ticks) / (float)ticks, direction);
    }

    public void drawProgressBar(GuiManager gui, int x, int y2, int tx, int ty, int w, int h, float completion, int direction) {
        if (direction > 3) {
            completion = 1.0f - completion;
            direction %= 4;
        }
        int var = (int)(completion * (float)(direction % 2 == 0 ? w : h));
        switch (direction) {
            case 0: {
                gui.drawTexturedModalRect(x, y2, tx, ty, var, h);
                break;
            }
            case 1: {
                gui.drawTexturedModalRect(x, y2, tx, ty, w, var);
                break;
            }
            case 2: {
                gui.drawTexturedModalRect(x + w - var, y2, tx + w - var, ty, var, h);
                break;
            }
            case 3: {
                gui.drawTexturedModalRect(x, y2 + h - var, tx, ty + h - var, w, var);
            }
        }
    }

    public List getRecipeTransferRectGuis() {
        Class clazz = this.getGuiClass();
        if (clazz != null) {
            LinkedList<Class> list = new LinkedList<Class>();
            list.add(clazz);
            return list;
        }
        return null;
    }

    public Class getGuiClass() {
        return null;
    }

    private TemplateRecipeHandler newInstance() {
        try {
            return (TemplateRecipeHandler)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadCraftingRecipes(outputId, results);
        return handler;
    }

    @Override
    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadUsageRecipes(inputId, ingredients);
        return handler;
    }

    @Override
    public int getNumRecipes() {
        return this.arecipes.size();
    }

    @Override
    public void drawBackground(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 11, 166, 65);
    }

    @Override
    public void drawForeground(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName(this.getGuiTexture());
        this.drawExtras(gui, recipe);
    }

    @Override
    public ArrayList getIngredientStacks(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    @Override
    public ArrayList getOtherStacks(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getOtherStacks();
    }

    @Override
    public void onUpdate() {
        ++this.cycleticks;
    }

    @Override
    public boolean hasOverlay(gb gui, dd container, int recipe) {
        return DefaultOverlayRenderer.getOverlayIdent(gui).equals(this.getOverlayIdentifier());
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(gb gui, int recipe) {
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), gui);
    }

    @Override
    public int getRecipiesPerPage() {
        return 2;
    }

    @Override
    public List handleTooltip(GuiRecipe gui, List currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIConfig.getKeyBinding("recipe")) {
            return this.transferRect(gui, recipe, false);
        }
        if (keyCode == NEIConfig.getKeyBinding("usage")) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0) {
            return this.transferRect(gui, recipe, false);
        }
        if (button == 1) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    private boolean transferRect(GuiRecipe gui, int recipe, boolean usage) {
        Point offset = gui.getRecipePosition(recipe);
        return TemplateRecipeHandler.transferRect(gui, this.transferRects, offset.x, offset.y, usage);
    }

    private static boolean transferRect(gb gui, Collection transferRects, int offsetx, int offsety, boolean usage) {
        Point pos = NEIUtils.getMousePosition();
        Point relMouse = new Point(pos.x - gui.e - offsetx, pos.y - gui.f - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse) || !(usage ? GuiUsageRecipe.openRecipeGui(rect.outputId, rect.results) : GuiCraftingRecipe.openRecipeGui(rect.outputId, rect.results))) continue;
            return true;
        }
        return false;
    }

    public abstract class CachedRecipe {
        final long offset = System.currentTimeMillis();

        public abstract PositionedStack getResult();

        public ArrayList getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getIngredient();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getOtherStack() {
            return null;
        }

        public ArrayList getCycledIngredients(int cycle, ArrayList ingredients) {
            int itemIndex = 0;
            while (itemIndex < ingredients.size()) {
                PositionedStack stack = (PositionedStack)ingredients.get(itemIndex);
                Random rand = new Random((long)(cycle + itemIndex) + this.offset);
                stack.setPermutationToRender(Math.abs(rand.nextInt()) % stack.items.length);
                ++itemIndex;
            }
            return ingredients;
        }

        public void setIngredientPermutation(Collection ingredients, aan ingredient) {
            block0: for (PositionedStack stack : ingredients) {
                int i = 0;
                while (i < stack.items.length) {
                    if (NEIUtils.areStacksSameTypeCrafting(ingredient, stack.items[i])) {
                        stack.item = stack.items[i];
                        stack.item.b(ingredient.i());
                        stack.items = new aan[]{stack.item};
                        stack.setPermutationToRender(0);
                        continue block0;
                    }
                    ++i;
                }
            }
        }

        public boolean contains(Collection ingredients, aan ingredient) {
            for (PositionedStack stack : ingredients) {
                aan[] aanArray = stack.items;
                int n = stack.items.length;
                int n2 = 0;
                while (n2 < n) {
                    aan item = aanArray[n2];
                    if (NEIUtils.areStacksSameTypeCrafting(item, ingredient)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public class RecipeTransferRect {
        Rectangle rect;
        String outputId;
        Object[] results;

        public RecipeTransferRect(Rectangle rectangle, String outputId, Object ... results) {
            this.rect = rectangle;
            this.outputId = outputId;
            this.results = results;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RecipeTransferRect)) {
                return false;
            }
            return this.rect.equals(((RecipeTransferRect)obj).rect);
        }

        public int hashCode() {
            return this.rect.hashCode();
        }
    }

    public static class RecipeTransferRectInputHandler
    implements IHandleInput {
        private static HashMap guiMap = new HashMap();

        public static void registerRectsToGuis(List classes, List rects) {
            if (classes == null) {
                return;
            }
            for (Class clazz : classes) {
                HashSet set = (HashSet)guiMap.get(clazz);
                if (set == null) {
                    set = new HashSet();
                    guiMap.put(clazz, set);
                }
                set.addAll(rects);
            }
        }

        @Override
        public boolean canHandle(Class guiClass) {
            return guiMap.containsKey(guiClass);
        }

        @Override
        public boolean keyTyped(gb gui, char keyChar, int keyCode) {
            if (keyCode == NEIConfig.getKeyBinding("recipe")) {
                return this.transferRect(gui, false);
            }
            if (keyCode == NEIConfig.getKeyBinding("usage")) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        @Override
        public boolean mouseClicked(gb gui, int mousex, int mousey, int button) {
            if (button == 0) {
                return this.transferRect(gui, false);
            }
            if (button == 1) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        private boolean transferRect(gb gui, boolean usage) {
            return TemplateRecipeHandler.transferRect(gui, (Collection)RecipeTransferRectInputHandler.guiMap.get(((Object)((Object)gui)).getClass()), 5, 11, usage);
        }
    }
}

