/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CoreUtils;
import codechicken.core.ICustomPacketHandler;
import codechicken.core.PacketCustom;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemHash;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NEIUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class NEIPacketHandler
implements ICustomPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, adl nethandler, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                this.handleSMPCheck(packet.readUnsignedByte(), mc.f);
                break;
            }
            case 6: {
                NEIConfig.setMagnetMode(packet.readBoolean());
                break;
            }
            case 7: {
                NEIUtils.setCreativeMode(packet.readUnsignedByte());
                break;
            }
            case 10: {
                this.handlePermissableActions(packet);
                break;
            }
            case 11: {
                this.handleBannedBlocks(packet);
                break;
            }
            case 12: {
                this.handleDisabledProperties(packet);
                break;
            }
            case 13: {
                mod_NotEnoughItems.addSMPMagneticItem(packet.readInt(), mc.f);
                break;
            }
            case 21: {
                CoreUtils.openSMPGui((int)packet.readUnsignedByte(), (vp)new GuiEnchantmentModifier(mc.h.ap, mc.f, 0, 0, 0));
                break;
            }
            case 23: {
                CoreUtils.openSMPGui((int)packet.readUnsignedByte(), (vp)new GuiExtendedCreativeInv(new ContainerCreativeInv((yw)mc.h)));
            }
        }
    }

    private void handleDisabledProperties(PacketCustom packet) {
        NEIConfig.resetDisabledProperties();
        int num = packet.readUnsignedByte();
        int i = 0;
        while (i < num) {
            NEIConfig.setPropertyDisabled(packet.readUnsignedByte());
            ++i;
        }
    }

    private void handleBannedBlocks(PacketCustom packet) {
        int num = packet.readInt();
        ArrayList<ItemHash> items = new ArrayList<ItemHash>(num);
        int i = 0;
        while (i < num) {
            items.add(new ItemHash(packet.readUnsignedShort(), packet.readUnsignedShort()));
            ++i;
        }
        NEIConfig.setBannedBlocks(items);
        if (NEIController.window != null) {
            NEIController.window.refresh();
        }
    }

    private void handlePermissableActions(PacketCustom packet) {
        NEIConfig.resetPermissableActions();
        int num = packet.readUnsignedByte();
        int i = 0;
        while (i < num) {
            NEIConfig.addPermissableAction(InterActionMap.values()[packet.readUnsignedByte()]);
            ++i;
        }
        if (NEIController.window != null) {
            NEIController.window.refresh();
        }
    }

    private void handleSMPCheck(int serverprotocol, xd world) {
        if (serverprotocol > 4) {
            NEIUtils.addChatMessage("NEI version mismatch: Outdated Client");
        } else if (serverprotocol < 4) {
            NEIUtils.addChatMessage("NEI version mismatch: Outdated Server");
        } else {
            mod_NotEnoughItems.reset(world);
            NEIConfig.setHasSMPCounterPart(true);
            NEIPacketHandler.sendRequestLoginInfo();
        }
    }

    public static void sendSpawnItem(aan spawnstack, boolean infinite) {
        PacketCustom packet = new PacketCustom(channel, 1);
        packet.writeBoolean(infinite);
        List name = NEIUtils.itemDisplayNameMultiline(spawnstack, false);
        packet.writeByte(name.size());
        for (String s : name) {
            packet.writeString(s);
        }
        packet.writeItemStack(spawnstack);
        packet.writeInt(spawnstack.a);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom(channel, 4);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendStateLoad(aan[] state) {
        NEIPacketHandler.sendDeleteAllItems();
        int slot = 0;
        while (slot < state.length) {
            aan item = state[slot];
            if (item != null) {
                NEIPacketHandler.sendSetSlot(slot, item, false);
            }
            ++slot;
        }
        PacketCustom packet = new PacketCustom(channel, 11);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendSetSlot(int slot, aan stack, boolean container) {
        PacketCustom packet = new PacketCustom(channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom(channel, 10);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom(channel, 6);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom(channel, 7);
        packet.writeByte(hour);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom(channel, 8);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom(channel, 9);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom(channel, 21);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom(channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendSetPropertyDisabled(String name, boolean enable) {
        PacketCustom packet = new PacketCustom(channel, 12);
        packet.writeByte(((Integer)AllowedPropertyMap.nameToIDMap.get(name)).intValue());
        packet.writeBoolean(enable);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendCycleCreativeMode() {
        PacketCustom packet = new PacketCustom(channel, 13);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendOpenCreativeInv() {
        PacketCustom packet = new PacketCustom(channel, 23);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom(channel, 14);
        packet.writeInt(steps);
        CoreUtils.sendPacket((abs)packet.toPacket());
    }
}

