/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DropDownFile;
import codechicken.nei.ItemHash;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ItemVisibilityHash {
    private static boolean[] statesSaved = new boolean[7];
    public TreeMap hiddenitems;

    public ItemVisibilityHash() {
        try {
            this.loadFromCompound(this.getCurrentSaveCompound());
        }
        catch (Exception e) {
            NEIUtils.reportException(e);
        }
    }

    public ady getCurrentSaveCompound() {
        ady hashSave = NEIConfig.saveCompound.m("vis");
        NEIConfig.saveCompound.a("vis", (gh)hashSave);
        ady currentSave = hashSave.m("current");
        hashSave.a("current", currentSave);
        return currentSave;
    }

    public void hideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add((short)-1);
    }

    public void hideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add((short)damage);
    }

    public void hideItem(int item, ady stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        if (!info.compounds.contains(stackTagCompound)) {
            info.compounds.add(stackTagCompound);
        }
    }

    public void hideItem(ItemHash item) {
        if (item.moreinfo != null) {
            this.hideItem((int)item.item, item.moreinfo);
        } else {
            this.hideItem((int)item.item, item.damage);
        }
    }

    public void unhideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        this.hiddenitems.remove(item);
    }

    public void unhideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        if (damage == -1) {
            this.hiddenitems.remove(item);
            return;
        }
        info.damages.remove((short)damage);
    }

    public void unhideItem(int item, ady stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        info.compounds.remove(stackTagCompound);
    }

    public void unhideItem(ItemHash item) {
        if (item.moreinfo != null) {
            this.unhideItem((int)item.item, item.moreinfo);
        } else {
            this.unhideItem((int)item.item, item.damage);
        }
    }

    public boolean isItemHidden(int itemID, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.damages.contains((short)damage) || info.damages.contains((short)-1);
    }

    public boolean isItemHidden(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return false;
        }
        return info.damages.contains((short)-1);
    }

    public boolean isItemHidden(int itemID, ady stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.compounds.contains(stackTagCompound);
    }

    public boolean isItemHidden(ItemHash item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item.item);
        if (info == null) {
            return false;
        }
        if (info.damages.contains(item.damage) || info.damages.contains((short)-1)) {
            return true;
        }
        if (item.moreinfo != null) {
            return info.compounds.contains(item.moreinfo);
        }
        return false;
    }

    private void loadFromCompound(ady readTag) {
        this.hiddenitems = new TreeMap();
        for (Object obj : readTag.d()) {
            int i;
            IDInfo info;
            int itemID;
            if (obj instanceof no) {
                no compoundlist = (no)obj;
                itemID = Integer.parseInt(compoundlist.c().substring(1));
                info = (IDInfo)this.hiddenitems.get(itemID);
                if (info == null) {
                    info = new IDInfo();
                    this.hiddenitems.put(itemID, info);
                }
                i = 0;
                while (i < compoundlist.d()) {
                    info.compounds.add((ady)compoundlist.a(i));
                    ++i;
                }
                continue;
            }
            if (!(obj instanceof zl)) continue;
            zl damagearray = (zl)obj;
            itemID = Integer.parseInt(damagearray.c().substring(1));
            info = (IDInfo)this.hiddenitems.get(itemID);
            if (info == null) {
                info = new IDInfo();
                this.hiddenitems.put(itemID, info);
            }
            i = 0;
            while (i < damagearray.a.length / 2) {
                info.damages.add((short)((damagearray.a[i * 2] << 8) + damagearray.a[i * 2 + 1]));
                ++i;
            }
        }
    }

    public void save() {
        try {
            ady hashSave = NEIConfig.saveCompound.m("vis");
            NEIConfig.saveCompound.a("vis", (gh)hashSave);
            hashSave.a("current", this.constructSaveCompound());
            NEIConfig.saveConfig();
        }
        catch (Exception e) {
            NEIUtils.reportException(e);
        }
    }

    private ady constructSaveCompound() {
        ady savecompound = new ady();
        for (Map.Entry itemEntry : this.hiddenitems.entrySet()) {
            int id = (Integer)itemEntry.getKey();
            IDInfo info = (IDInfo)itemEntry.getValue();
            if (info.compounds.size() > 0) {
                no compoundlist = new no();
                for (ady compound : info.compounds) {
                    compoundlist.a((gh)compound);
                }
                savecompound.a("c" + id, (gh)compoundlist);
            }
            if (info.damages.size() <= 0) continue;
            byte[] damagearray = new byte[info.damages.size() * 2];
            int i = 0;
            Iterator iterator = info.damages.iterator();
            while (iterator.hasNext()) {
                short damage = (Short)iterator.next();
                damagearray[i * 2] = (byte)(damage >> 8);
                damagearray[i * 2 + 1] = (byte)damage;
                ++i;
            }
            savecompound.a("d" + id, damagearray);
        }
        return savecompound;
    }

    public static void loadStates() {
        ady hashSave = NEIConfig.saveCompound.m("vis");
        NEIConfig.saveCompound.a("vis", (gh)hashSave);
        int i = 0;
        while (i < 7) {
            ady statesave = hashSave.m("save" + i);
            if (statesave.d().size() > 0) {
                ItemVisibilityHash.statesSaved[i] = true;
            }
            ++i;
        }
    }

    public void loadState(int i) {
        ady hashSave = NEIConfig.saveCompound.m("vis");
        NEIConfig.saveCompound.a("vis", (gh)hashSave);
        this.loadFromCompound(hashSave.m("save" + i));
        DropDownFile.dropDownInstance.updateState();
        NEIUtils.loadItems();
        NEIConfig.vishash.save();
    }

    public void saveState(int i) {
        ady hashSave = NEIConfig.saveCompound.m("vis");
        NEIConfig.saveCompound.a("vis", (gh)hashSave);
        ady saveCompound = this.getCurrentSaveCompound();
        saveCompound.a("saved", true);
        hashSave.a("save" + i, saveCompound);
        ItemVisibilityHash.statesSaved[i] = true;
        NEIConfig.saveConfig();
    }

    public void clearState(int i) {
        ady hashSave = NEIConfig.saveCompound.m("vis");
        NEIConfig.saveCompound.a("vis", (gh)hashSave);
        hashSave.a("save" + i, new ady("save" + i));
        ItemVisibilityHash.statesSaved[i] = false;
        NEIConfig.saveConfig();
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static class IDInfo {
        public TreeSet damages = new TreeSet();
        public ArrayList compounds = new ArrayList();
    }
}

