/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.GuiManager;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NEIUtils;
import codechicken.nei.Widget;
import java.util.ArrayList;
import java.util.List;

public class ItemPanel
extends Widget {
    public ItemPanelObject hoverItem = null;
    private int marginLeft;
    private int marginTop;
    private int columns;
    private int rows;
    private int itemsPerPage;
    private int page;
    private int numPages = 0;

    @Override
    public void resize() {
        this.marginLeft = this.x + this.width % 18 / 2;
        this.marginTop = this.y + this.height % 18 / 2;
        this.columns = this.width / 18;
        this.rows = this.height / 18;
        this.itemsPerPage = this.rows * this.columns;
        this.numPages = (int)Math.ceil((float)NEIController.visibleitems.size() / (float)this.itemsPerPage);
        this.setPage(this.page);
    }

    @Override
    public void draw(GuiManager gui, int mousex, int mousey) {
        ArrayList visibleitems = NEIController.visibleitems;
        if (visibleitems.size() == 0) {
            return;
        }
        int itemIndex = this.page * this.itemsPerPage;
        int lastIndex = this.itemsPerPage * (this.page + 1) < visibleitems.size() ? this.itemsPerPage * (this.page + 1) : visibleitems.size();
        int colIndex = 0;
        int rowIndex = 0;
        this.hoverItem = null;
        while (itemIndex < lastIndex) {
            ItemPanelObject item = (ItemPanelObject)visibleitems.get(itemIndex);
            int posX = this.marginLeft + colIndex * 18;
            int posY = this.marginTop + rowIndex * 18;
            if (mousex >= posX && mousex < posX + 18 && mousey >= posY && mousey < posY + 18) {
                this.hoverItem = item;
                gui.drawRect(posX - 1, posY - 1, 18, 18, -296397483);
            }
            item.draw(gui, posX, posY);
            ++itemIndex;
            if (++colIndex != this.columns) continue;
            colIndex = 0;
            ++rowIndex;
        }
    }

    @Override
    public boolean handleClick(int i, int j, int k) {
        if (NEIUtils.getHeldItem() != null) {
            if (NEIConfig.isActionPermissable(InterActionMap.DELETE)) {
                if (k == 1) {
                    NEIUtils.decreaseSlotStack(-999);
                } else {
                    NEIUtils.deleteHeldItem();
                }
            } else {
                NEIUtils.dropHeldItem();
            }
            return true;
        }
        if (this.hoverItem != null) {
            this.hoverItem.handleClick(k);
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.scroll(i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == NEIConfig.getKeyBinding("next")) {
            this.scroll(1);
            return true;
        }
        if (keyID == NEIConfig.getKeyBinding("prev")) {
            this.scroll(-1);
            return true;
        }
        return false;
    }

    @Override
    public aan getStackMouseOver(int mousex, int mousey) {
        return this.hoverItem instanceof ItemPanelStack ? ((ItemPanelStack)this.hoverItem).item : null;
    }

    @Override
    public List handleTooltip(int mx, int my, List tooltip) {
        if (this.hoverItem == null) {
            return tooltip;
        }
        return this.hoverItem.handleTooltip(tooltip);
    }

    public void scroll(int i) {
        this.setPage(this.page + i);
    }

    public void setPage(int i) {
        this.page = this.numPages == 0 ? 0 : (i + this.numPages) % this.numPages;
    }

    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public static interface ItemPanelObject {
        public void draw(GuiManager var1, int var2, int var3);

        public void handleClick(int var1);

        public List handleTooltip(List var1);
    }
}

