
// Check for updated .NET Framework install on browser startup
checkCLRVersionString();

function checkCLRVersionString()
{
    var useragentExtrasPref = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService)
                                .getBranch("general.useragent.extra.");

    useragentExtrasPref.QueryInterface(Components.interfaces.nsIPrefBranch2);

    // startup check the registry for the latest version of the CLR added to the IE user agent
    var versions = getInstalledCLRVersions();
    
    var addonPref = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService)
                                .getBranch("microsoft.CLR.");
    addonPref.QueryInterface(Components.interfaces.nsIPrefBranch2);
    var allAddonsInAgent = addonPref.getBoolPref("all_clr_versions_in_useragent");
    // Allow the user to configure whether they want all version of the CLR in their user agent
    // or just the highest.
    if (allAddonsInAgent)
    {
        var appendString = "(";
        for (var i=0; i < versions.length; i++)
        {
            if (i != 0)
            {
                appendString += "; ";
            }
            var localVersion = versions[i];
            appendString += ".NET " + localVersion[0] + " " + localVersion[1];
        }
        appendString += ")";

        useragentExtrasPref.setCharPref("microsoftdotnet", appendString);
    }
    else
    {
        var latestVersion = versions[versions.length-1];
        var appendString = "(.NET " + latestVersion[0] + " " + latestVersion[1] + ")";
        useragentExtrasPref.setCharPref("microsoftdotnet", appendString);
    }
}

function getInstalledCLRVersions()
{
    var wrk = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(Components.interfaces.nsIWindowsRegKey);

    // Enumerate though the CLR version strings that will be appended to the Internet Explorer user agent
    wrk.open(wrk.ROOT_KEY_LOCAL_MACHINE,
             "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\5.0\\User Agent\\Post Platform",
             wrk.ACCESS_READ);

    var clrVersions = new Array();
    for (var i=0; i < wrk.valueCount; i++)
    {
        var name = wrk.getValueName(i);
        var matches = name.match("\.NET (CLR|Client) \(.*\)");
        if (matches && matches.length > 1)
        {
            clrVersions.push([matches[1], matches[2]]);
        }
    }
    wrk.close();

    clrVersions.sort(function(left, right)
    {
        if (left[1] < right[1]) return -1;
        if (left[1] > right[1]) return 1;
        // if version numbers are equal, prefer full CLR over Client sku
        if (left[0] == "Client" && right[0] == "CLR") return -1;
        if (left[0] == "CLR" && right[0] == "Client") return 1;
        return 0;
    });
    return clrVersions;
}


