/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.lcdui;

import com.ibm.weme.examples.golftracker.IGolfGame;
import com.ibm.weme.examples.golftracker.IGolfHole;
import com.ibm.weme.examples.golftracker.lcdui.IView;
import com.ibm.weme.examples.golftracker.lcdui.IViewManager;
import com.ibm.weme.examples.golftracker.model.IGolfScoreTrackerConstants;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;

public final class HoleView
implements IView,
CommandListener,
ItemStateListener {
    private ChoiceGroup scoresGroup;
    private Form form;
    private IViewManager viewManager;
    private StringItem par;
    private StringItem yardage;
    private StringItem total;
    private StringItem played;
    private StringItem projection;
    private Command previous;
    private Command next;
    private Command map;
    private Command newGame;
    private Command exit;
    private IGolfGame game;
    private IGolfHole hole;

    public HoleView(IViewManager viewManager) {
        this.viewManager = viewManager;
        this.buildForm();
    }

    public final Form getForm() {
        this.game = this.viewManager.getGame();
        this.hole = this.game.getCurrentHole();
        this.form.setTitle(String.valueOf(IGolfScoreTrackerConstants.HOLE_LABEL) + ' ' + this.hole.getNumber());
        this.par.setText(Integer.toString(this.hole.getPar()));
        this.yardage.setText(Integer.toString(this.hole.getYardage()));
        this.scoresGroup.deleteAll();
        this.scoresGroup.append(IGolfScoreTrackerConstants.SCORE_NONE_LABEL, null);
        int i = 1;
        while (i <= 12) {
            String label = this.getScoreLabel(i, this.hole.getPar());
            this.scoresGroup.append(label, null);
            ++i;
        }
        if (this.hole.hasScore()) {
            this.scoresGroup.setSelectedIndex(this.hole.getScore(), true);
        } else {
            this.scoresGroup.setSelectedIndex(0, true);
        }
        this.updateTotals();
        return this.form;
    }

    private final String getScoreLabel(int score, int par) {
        String label;
        switch (score - par) {
            case -2: {
                label = IGolfScoreTrackerConstants.SCORE_EAGLE_LABEL;
                break;
            }
            case -1: {
                label = IGolfScoreTrackerConstants.SCORE_BIRDIE_LABEL;
                break;
            }
            case 0: {
                label = IGolfScoreTrackerConstants.SCORE_PAR_LABEL;
                break;
            }
            case 1: {
                label = IGolfScoreTrackerConstants.SCORE_BOGEY_LABEL;
                break;
            }
            case 2: {
                label = IGolfScoreTrackerConstants.SCORE_DOUBLE_BOGEY_LABEL;
                break;
            }
            default: {
                label = Integer.toString(score);
            }
        }
        return label;
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == this.previous) {
            this.previous();
        } else if (command == this.next) {
            this.next();
        } else if (command == this.map) {
            this.map();
        } else if (command == this.newGame) {
            this.newGame();
        } else if (command == this.exit) {
            this.exit();
        }
    }

    public final void itemStateChanged(Item item) {
        if (item == this.scoresGroup) {
            this.scoreSelected();
        }
    }

    public final void cleanup() {
        this.scoresGroup = null;
        this.form = null;
        this.viewManager = null;
        this.par = null;
        this.yardage = null;
        this.total = null;
        this.played = null;
        this.projection = null;
        this.previous = null;
        this.next = null;
        this.map = null;
        this.newGame = null;
        this.game = null;
        this.hole = null;
    }

    private final void buildForm() {
        this.form = new Form(IGolfScoreTrackerConstants.HOLE_LABEL);
        this.par = new StringItem(String.valueOf(IGolfScoreTrackerConstants.PAR_LABEL) + ':', null);
        this.form.append((Item)this.par);
        this.yardage = new StringItem(String.valueOf(IGolfScoreTrackerConstants.YARDAGE_LABEL) + ':', null);
        this.form.append((Item)this.yardage);
        this.scoresGroup = new ChoiceGroup(String.valueOf(IGolfScoreTrackerConstants.SCORE_LABEL) + ':', 4);
        this.form.append((Item)this.scoresGroup);
        this.previous = new Command(IGolfScoreTrackerConstants.PREVIOUS_COMMAND, 1, 1);
        this.form.addCommand(this.previous);
        this.map = new Command(IGolfScoreTrackerConstants.MAP_COMMAND, 1, 1);
        this.form.addCommand(this.map);
        this.next = new Command(IGolfScoreTrackerConstants.NEXT_COMMAND, 1, 1);
        this.form.addCommand(this.next);
        this.newGame = new Command(IGolfScoreTrackerConstants.NEW_GAME_COMMAND, 8, 2);
        this.form.addCommand(this.newGame);
        this.exit = new Command(IGolfScoreTrackerConstants.EXIT_LABEL, 7, 3);
        this.form.addCommand(this.exit);
        this.played = new StringItem(String.valueOf(IGolfScoreTrackerConstants.PLAYED_LABEL) + ':', null);
        this.form.append((Item)this.played);
        this.total = new StringItem(String.valueOf(IGolfScoreTrackerConstants.TOTAL_LABEL) + ':', null);
        this.form.append((Item)this.total);
        this.projection = new StringItem(String.valueOf(IGolfScoreTrackerConstants.PROJECTION_LABEL) + ':', null);
        this.form.append((Item)this.projection);
        this.form.setCommandListener((CommandListener)this);
        this.form.setItemStateListener((ItemStateListener)this);
    }

    private final void previous() {
        this.game.previousHole();
        this.viewManager.showView(1);
    }

    private final void next() {
        this.game.nextHole();
        this.viewManager.showView(1);
    }

    private final void map() {
        this.viewManager.showView(2);
    }

    private final void newGame() {
        this.viewManager.showView(0);
    }

    private final void exit() {
        this.viewManager.exitGame();
    }

    private final void scoreSelected() {
        this.hole.setScore(this.getScore());
        this.updateTotals();
        this.viewManager.saveGame();
    }

    private final int getScore() {
        return this.scoresGroup.getSelectedIndex();
    }

    private final void updateTotals() {
        int holes = this.game.getHolesPlayed();
        if (holes == 0) {
            this.played.setText(IGolfScoreTrackerConstants.NO_HOLES_COMPLETED);
            this.total.setText("");
            this.projection.setText("");
        } else {
            this.played.setText(Integer.toString(holes));
            int score = this.game.getTotalScore();
            int relative = this.game.getTotalRelativeScore();
            String relativeString = this.relativeStringFor(relative);
            StringBuffer buf = new StringBuffer(10);
            buf.append(score);
            buf.append(' ');
            buf.append('(');
            buf.append(relativeString);
            buf.append(')');
            this.total.setText(buf.toString());
            score = this.game.getProjectedTotalScore();
            relative = this.game.getProjectedRelativeScore();
            relativeString = this.relativeStringFor(relative);
            buf = new StringBuffer(10);
            buf.append(score);
            buf.append(' ');
            buf.append('(');
            buf.append(relativeString);
            buf.append(')');
            this.projection.setText(buf.toString());
        }
    }

    private final String relativeStringFor(int relative) {
        if (relative == 0) {
            return IGolfScoreTrackerConstants.SCORE_EVEN;
        }
        StringBuffer buf = new StringBuffer(4);
        if (relative > 0) {
            buf.append('+');
        }
        buf.append(relative);
        return buf.toString();
    }
}

