/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.OpByteCode;

final class OpCodeVar
extends OpByteCode {
    private static final int ALOAD = 25;
    private static final int ALOAD_3 = 45;
    private static final int ASTORE = 58;
    private static final int ASTORE_3 = 78;
    private static final int IINC = 132;
    private static final int ILOAD = 21;
    private static final int ILOAD_0 = 26;
    private static final int ISTORE = 54;
    private static final int ISTORE_0 = 59;
    private static final int RET = 169;
    private static final int WIDE = 196;
    private int op;
    private int type;
    private int index;
    private int incValue;

    private OpCodeVar(int n, int n2, int n3, int n4) {
        this.op = n;
        this.type = n2;
        this.index = n3;
        this.incValue = n4;
    }

    private OpCodeVar(int n, int n2) {
        this.op = n2 > 255 ? 196 : ((n2 & 0xFFFFFFFC) != 0 ? n : (n >= 21 && n <= 25 ? (n - 21 << 2) + n2 + 26 : (n >= 54 && n <= 58 ? (n - 54 << 2) + n2 + 59 : n)));
        this.type = n;
        this.index = n2;
        this.incValue = 0;
    }

    static OpCodeVar decode(int n, InputStream inputStream) throws IOException {
        if (n >= 26 && n <= 45) {
            return new OpCodeVar(n, 21 + (n - 26 >> 2), n - 26 & 3, 0);
        }
        if (n >= 59 && n <= 78) {
            return new OpCodeVar(n, 54 + (n - 59 >> 2), n - 59 & 3, 0);
        }
        int n2 = n;
        if (n == 196) {
            n2 = OpCodeVar.readUnsignedByte(inputStream);
        }
        if (n2 >= 21 && n2 <= 25 || n2 >= 54 && n2 <= 58 || n2 == 132 || n2 == 169) {
            int n3;
            int n4 = n3 = n == 196 ? OpCodeVar.readUnsignedShort(inputStream) : OpCodeVar.readUnsignedByte(inputStream);
            return new OpCodeVar(n, n2, n3, n2 == 132 ? (n == 196 ? (short)OpCodeVar.readShort(inputStream) : (short)OpCodeVar.readByte(inputStream)) : (short)0);
        }
        if (n == 196) {
            throw new BadClassFileException();
        }
        return null;
    }

    static OpCodeVar makeAstoreAload(int n, boolean bl) {
        return new OpCodeVar(bl ? 58 : 25, n);
    }

    static OpCodeVar makeRet(int n) {
        return new OpCodeVar(169, n);
    }

    int getLength(int n) {
        return this.op == 196 ? (this.type == 132 ? 6 : 4) : (this.type == 132 ? 3 : (!(this.op >= 26 && this.op <= 45 || this.op >= 59 && this.op <= 78) ? 2 : 1));
    }

    void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.op);
        if (this.op == 196) {
            outputStream.write(this.type);
            OpCodeVar.writeShort(outputStream, this.index);
            if (this.type == 132) {
                OpCodeVar.writeShort(outputStream, this.incValue);
            }
        } else if (!(this.op >= 26 && this.op <= 45 || this.op >= 59 && this.op <= 78)) {
            outputStream.write(this.index);
            if (this.type == 132) {
                outputStream.write(this.incValue);
            }
        }
    }

    boolean isEqualTo(OpByteCode opByteCode, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Hashtable hashtable) {
        if (!(opByteCode instanceof OpCodeVar)) {
            return false;
        }
        OpCodeVar opCodeVar = (OpCodeVar)opByteCode;
        if (this.type != opCodeVar.type || this.incValue != opCodeVar.incValue) {
            return false;
        }
        int n5 = this.getVarIndex();
        int n6 = opCodeVar.getVarIndex() - n5;
        if (n6 != 0) {
            if (nArray2[0] != n6) {
                if (nArray2[0] != 0) {
                    return false;
                }
                nArray2[0] = n6;
            }
            if (n5 < n4 || n5 + n6 < n4) {
                return false;
            }
            if (this.type >= 54 && this.type <= 58) {
                hashtable.put(new Integer(n5), "");
            } else if (hashtable.get(new Integer(n5)) == null) {
                return false;
            }
        }
        return true;
    }

    boolean isAstoreAload(boolean bl) {
        return bl ? this.type == 58 : this.type == 25;
    }

    boolean isRetXLoad(boolean bl) {
        return bl ? this.type == 169 : this.type >= 21 && this.type <= 25;
    }

    int getVarIndex() {
        return this.index;
    }

    boolean isUncondBranch() {
        return this.type == 169;
    }
}

