/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import net.sf.jadretro.AttrCodeContent;
import net.sf.jadretro.AttrLocalVarsContent;
import net.sf.jadretro.AttributeEntry;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassEntity;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassOverflowException;
import net.sf.jadretro.CodeAbsLabel;
import net.sf.jadretro.ConstantPoolEntry;
import net.sf.jadretro.ConstantRef;
import net.sf.jadretro.ExceptionCatch;
import net.sf.jadretro.FieldMethodEntry;
import net.sf.jadretro.LocalVariableDesc;

public final class Main {
    private Main() {
    }

    private static void showHelp() {
        System.out.println("JadRetro v1.6 - a Java decompiler helper");
        System.out.println("Copyright (C) 2007-2008 Ivan Maidanski <ivmai@mail.ru>");
        System.out.println("This is free software. All rights reserved. No warranties.");
        System.out.println();
        System.out.println("Usage arguments: [options] <class_file_or_dir> [<class_file_or_dir2> ...]");
        System.out.println("Options:");
        System.out.println(" -b  Keep all (do not process) Java bridge methods");
        System.out.println(" -l  Do not adjust local class names");
        System.out.println(" -c  Change class version to Java 1.3 if greater");
        System.out.println(" -d <directory>  Specify output base folder for the modified class files");
        System.out.println("");
        System.out.println("  JadRetro is a command-line utility that could help You to successfully");
        System.out.println("decompile Java classes created by the modern Java compilers (of Java 1.4,");
        System.out.println("Java 1.5 or later).");
        System.out.println("  JadRetro operates by transforming the specified Java class files");
        System.out.println("(if needed) into ones which could be processed correctly by an old Java");
        System.out.println("decompiler (designed to work with classes of Java 1.3 or earlier).");
        System.out.println("  JadRetro is not a decompiler itself, it is a class transformer helping");
        System.out.println("some old (but good) Java decompilers to convert more class files and/or");
        System.out.println("generate more correct source code.");
        System.out.println("  See \"jadretro.txt\" file for more details.");
    }

    public static final void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equals("-h") || stringArray[0].equals("-help")) {
            Main.showHelp();
        } else {
            int n = Main.intMain(stringArray);
            if (n != 0) {
                System.exit(n);
            }
        }
    }

    private static int intMain(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        File file = null;
        do {
            if (stringArray[n].equals("-b")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-l")) {
                bl2 = true;
                continue;
            }
            if (stringArray[n].equals("-c")) {
                bl3 = true;
                continue;
            }
            if (!stringArray[n].equals("-d") || stringArray.length - 1 == n || file != null) break;
            file = new File(stringArray[++n]);
        } while (++n < stringArray.length);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = file != null ? new Hashtable<String, String>() : null;
        int n2 = 0;
        File file2 = null;
        try {
            while (n < stringArray.length) {
                File file3 = new File(stringArray[n]);
                if (hashtable.put(file3.getPath(), "") == null) {
                    Object object;
                    if (file3.isDirectory()) {
                        object = file3.list();
                        if (object == null) break;
                        if (((String[])object).length > ++n) {
                            String[] stringArray2 = new String[((String[])object).length + stringArray.length - n];
                            System.arraycopy(stringArray, n, stringArray2, ((Object)object).length, stringArray.length - n);
                            stringArray = stringArray2;
                            n = 0;
                        } else {
                            n -= ((String[])object).length;
                        }
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            stringArray[n + i] = new File(file3, (String)object[i]).getPath();
                        }
                        --n;
                    } else {
                        object = new FileInputStream(file3);
                        if (stringArray[n].endsWith(".class") || stringArray[n].endsWith(".CLA")) {
                            String string;
                            ++n2;
                            ClassFile classFile = new ClassFile(new BufferedInputStream((InputStream)object));
                            ((FileInputStream)object).close();
                            boolean bl4 = false;
                            String string2 = classFile.className();
                            if (hashtable2 == null || hashtable2.put(string2, "") == null) {
                                bl4 = true;
                            }
                            boolean bl5 = false;
                            boolean bl6 = false;
                            if (!bl2 && Main.fixLocalClassNames(classFile)) {
                                bl5 = true;
                                string = classFile.className();
                                if (!string.equals(string2)) {
                                    bl6 = true;
                                    string2 = string;
                                    if (bl4 && hashtable2 != null && hashtable2.get(string2) != null) {
                                        bl4 = false;
                                    }
                                }
                            }
                            if ((!bl6 || bl4) && (Main.process(classFile, bl3, bl) || bl5)) {
                                if (bl4) {
                                    String string3;
                                    file2 = file3;
                                    if (file != null) {
                                        file2 = new File(file, string2.replace('/', File.separatorChar) + ".class");
                                    } else if (bl6) {
                                        string = file3.getPath();
                                        int n3 = string.lastIndexOf(46);
                                        if (string.lastIndexOf(File.separatorChar) >= n3) {
                                            n3 = string.length();
                                        }
                                        file2 = new File((string3 = file3.getParent()) != null ? new File(string3) : new File(file3, ".."), string2.substring(string2.lastIndexOf(47) + 1) + string.substring(n3));
                                    }
                                    string = string2.replace('/', '.');
                                    try {
                                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                        classFile.writeTo(byteArrayOutputStream);
                                        System.out.println("Class transformed: " + string);
                                        string3 = file2.getParent();
                                        if (string3 != null) {
                                            new File(string3).mkdirs();
                                        }
                                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                                        byteArrayOutputStream.writeTo(fileOutputStream);
                                        fileOutputStream.close();
                                        if (bl6 && file == null && !file3.equals(file2)) {
                                            file3.delete();
                                        }
                                    }
                                    catch (ClassOverflowException classOverflowException) {
                                        System.err.println("Too big class ignored: " + string);
                                    }
                                    file2 = null;
                                } else {
                                    System.err.println("Duplicate class file ignored: " + stringArray[n]);
                                }
                            }
                        } else {
                            ((FileInputStream)object).close();
                            System.err.println("Ignoring file: " + stringArray[n]);
                        }
                    }
                }
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file2 != null) {
                System.err.println("Error: cannot open file for writing: " + file2.getPath());
                return 6;
            }
            System.err.println("Error: file not found: " + stringArray[n]);
            return 2;
        }
        catch (BadClassFileException badClassFileException) {
            System.err.println("Error: invalid class file: " + stringArray[n]);
            return 5;
        }
        catch (EOFException eOFException) {
            System.err.println("Error: unexpected end of file: " + stringArray[n]);
            return 4;
        }
        catch (IOException iOException) {
            if (file2 != null) {
                System.err.println("Error: cannot write file: " + file2.getPath());
                return 7;
            }
            System.err.println("Error: cannot read file: " + stringArray[n]);
            return 3;
        }
        if (n < stringArray.length) {
            System.err.println("Error: cannot list directory: " + stringArray[n]);
            return 1;
        }
        if (n2 != 0) {
            System.out.println("Done.");
        } else {
            System.err.println("Error: no files processed!");
        }
        return 0;
    }

    private static boolean fixLocalClassNames(ClassFile classFile) throws BadClassFileException {
        Object object;
        ClassEntity classEntity;
        int n;
        boolean bl = false;
        for (n = classFile.getConstantPoolCount() - 1; n > 0; --n) {
            classEntity = classFile.getConstantAt(n);
            if (((ConstantPoolEntry)classEntity).isClassConst()) {
                object = Main.adjustLocalClassName(((ConstantPoolEntry)classEntity).content().classOrName().utfValue());
                if (object == null) continue;
                classFile.changeClassConstAt(n, (String)object);
                bl = true;
                continue;
            }
            if (!((ConstantPoolEntry)classEntity).isNameAndType() || (object = Main.adjustLocClassInDescriptor(((ConstantPoolEntry)classEntity).content().descriptor().utfValue())) == null) continue;
            classFile.changeNameAndTypeConstAt(n, (String)object);
            bl = true;
        }
        for (n = classFile.getFieldsCount() - 1; n >= 0; --n) {
            if (!Main.adjustLocClassInFieldMethod(classFile.getFieldAt(n), classFile)) continue;
            bl = true;
        }
        for (n = classFile.getMethodsCount() - 1; n >= 0; --n) {
            classEntity = classFile.getMethodAt(n);
            if (Main.adjustLocClassInFieldMethod((FieldMethodEntry)classEntity, classFile)) {
                bl = true;
            }
            if ((object = ((FieldMethodEntry)classEntity).findCode()) == null) continue;
            for (int i = ((AttrCodeContent)object).getAttributesCount() - 1; i >= 0; --i) {
                AttributeEntry attributeEntry = ((AttrCodeContent)object).getAttributeAt(i);
                if (!attributeEntry.getNameValue().equals(AttrLocalVarsContent.nameValue()) || !Main.adjustLocClassInLocalVars((AttrLocalVarsContent)attributeEntry.content(), classFile)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private static boolean adjustLocClassInFieldMethod(FieldMethodEntry fieldMethodEntry, ClassFile classFile) throws BadClassFileException {
        String string = Main.adjustLocClassInDescriptor(fieldMethodEntry.descriptor().utfValue());
        if (string == null) {
            return false;
        }
        fieldMethodEntry.changeDescriptor(classFile.addUtfConst(string));
        return true;
    }

    private static boolean adjustLocClassInLocalVars(AttrLocalVarsContent attrLocalVarsContent, ClassFile classFile) throws BadClassFileException {
        boolean bl = false;
        for (int i = attrLocalVarsContent.getVarsCount() - 1; i >= 0; --i) {
            LocalVariableDesc localVariableDesc = attrLocalVarsContent.getVarDescAt(i);
            String string = Main.adjustLocClassInDescriptor(localVariableDesc.descriptor().utfValue());
            if (string == null) continue;
            localVariableDesc.changeDescriptor(classFile.addUtfConst(string));
            bl = true;
        }
        return bl;
    }

    private static String adjustLocClassInDescriptor(String string) {
        int n;
        boolean bl = false;
        int n2 = -1;
        while ((n2 = string.indexOf(76, n2 + 1)) >= 0 && (n2 = string.indexOf(59, n = n2 + 1)) >= 0) {
            String string2 = Main.adjustLocalClassName(string.substring(n, n2));
            if (string2 == null) continue;
            string = string.substring(0, n) + string2 + string.substring(n2);
            n2 = n + string2.length();
            bl = true;
        }
        return bl ? string : null;
    }

    private static String adjustLocalClassName(String string) {
        int n = string.lastIndexOf(47) + 1;
        boolean bl = false;
        while ((n = string.indexOf(36, n + 1)) >= 0) {
            char c;
            int n2 = string.length();
            while (++n < n2 && (Main.isAsciiDigit(c = string.charAt(n)) || c == '$')) {
            }
            if (n == n2) break;
            if (string.charAt(n - 1) == '$') continue;
            string = string.substring(0, n) + "$" + string.substring(n);
            bl = true;
            ++n;
        }
        return bl ? string : null;
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean process(ClassFile classFile, boolean bl, boolean bl2) throws BadClassFileException {
        int n;
        boolean bl3 = false;
        int n2 = classFile.getJavaVer();
        if (bl && n2 > 3) {
            n2 = 3;
            classFile.setJavaVer(n2);
            bl3 = true;
        }
        String string = classFile.className();
        String string2 = null;
        int n3 = -1;
        Hashtable hashtable = null;
        boolean bl4 = false;
        int n4 = string.lastIndexOf(36, string.length() - 2);
        if (n4 >= 0 && string.lastIndexOf(47) + 1 < n4) {
            int n5 = string.length();
            while (--n5 > n4 && Main.isAsciiDigit(string.charAt(n5))) {
            }
            if (n4 == n5) {
                bl4 = true;
            }
            string2 = classFile.getSuperClassName();
            n3 = classFile.findField("$assertionsDisabled", "Z", true);
            if (n3 >= 0 && !classFile.getFieldAt(n3).accessFlags().isFinal()) {
                n3 = -1;
            }
        } else {
            hashtable = new Hashtable((classFile.getFieldsCount() << 1) + 1);
        }
        String string3 = null;
        for (n = classFile.getMethodsCount() - 1; n >= 0; --n) {
            String string4;
            int n6;
            FieldMethodEntry fieldMethodEntry = classFile.getMethodAt(n);
            AttrCodeContent attrCodeContent = fieldMethodEntry.findCode();
            String string5 = fieldMethodEntry.name().utfValue();
            boolean bl5 = false;
            if (!bl2 && fieldMethodEntry.accessFlags().clearVolatile()) {
                bl3 = true;
                if (attrCodeContent != null && Main.isBridgeNoCastMethod(attrCodeContent, string5)) {
                    classFile.removeMethodAt(n);
                    bl5 = true;
                }
            }
            if (bl5) continue;
            if (Main.fixSyntheticFieldMethod(fieldMethodEntry, classFile, false)) {
                bl3 = true;
            }
            if (fieldMethodEntry.accessFlags().clearTransient()) {
                bl3 = true;
            }
            if (attrCodeContent == null) continue;
            if (string5.equals("class$") && fieldMethodEntry.accessFlags().isStatic() && fieldMethodEntry.hasExceptionsSynthetic(false) && fieldMethodEntry.descriptor().utfValue().equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
                if (Main.fixClassSpecMethod(attrCodeContent, classFile)) {
                    bl3 = true;
                }
                if (hashtable == null && classFile.getMethodsCount() - 1 == n) {
                    hashtable = new Hashtable();
                }
            }
            if (Main.fixDualCasts(attrCodeContent)) {
                bl3 = true;
            }
            if ((n6 = fieldMethodEntry.getArgSlotsCount()) > attrCodeContent.maxLocals()) {
                throw new BadClassFileException();
            }
            Hashtable hashtable2 = new Hashtable((attrCodeContent.getCatchesCount() << 1) + 1);
            int n7 = attrCodeContent.getCatchesCount();
            for (int i = 0; i < n7; ++i) {
                if (!Main.fixFinallyBlocks(attrCodeContent, n6, attrCodeContent.getCatch(i), hashtable2)) continue;
                int n8 = attrCodeContent.getCatchesCount();
                if (n7 > n8 && (i -= n7 - n8 + 1) < 0) {
                    i = -1;
                }
                n7 = n8;
                bl3 = true;
            }
            if (Main.fixExcCatches(attrCodeContent, fieldMethodEntry.isVoidRetType(), n2)) {
                bl3 = true;
            }
            if (string2 != null) {
                if (string5.equals("<init>")) {
                    if (Main.fixInnerInitMethod(attrCodeContent, string2)) {
                        bl3 = true;
                    }
                    if (bl4 && Main.fixInnerZeroInit(attrCodeContent, classFile, string2)) {
                        bl3 = true;
                    }
                }
                if (n3 >= 0) {
                    if (string5.equals("<clinit>") && !Main.fixInnerSetAssertDisabled(attrCodeContent, string)) {
                        n3 = -1;
                    }
                    if (Main.fixGetAssertionsDisabled(attrCodeContent, string)) {
                        bl3 = true;
                    }
                }
            }
            if ((string4 = Main.fixOuterClassLiteral(attrCodeContent, classFile)) != null) {
                string3 = string4;
            }
            if (Main.fixLdcClassConst(attrCodeContent, classFile)) {
                bl3 = true;
            }
            if (hashtable == null) continue;
            Main.collectUsedStaticFieldNames(hashtable, attrCodeContent, string);
        }
        if (string3 != null) {
            bl3 = true;
            n = string3.lastIndexOf(36) + 1;
            if (n > 0 && string3.length() > n && string3.lastIndexOf(47) < n - 2 && Main.isAsciiDigit(string3.charAt(n))) {
                classFile.removeStaticAnonInnerClassInfo(string3);
            }
        }
        if (n3 >= 0) {
            classFile.removeFieldAt(n3);
            bl3 = true;
        }
        if (hashtable != null && Main.removeUnusedClassSpecFields(classFile, hashtable)) {
            bl3 = true;
        }
        n = string2 != null ? 1 : 0;
        for (int i = classFile.getFieldsCount() - 1; i >= 0; --i) {
            if (!Main.fixSyntheticFieldMethod(classFile.getFieldAt(i), classFile, n != 0)) continue;
            bl3 = true;
        }
        return bl3;
    }

    private static boolean fixSyntheticFieldMethod(FieldMethodEntry fieldMethodEntry, ClassFile classFile, boolean bl) throws BadClassFileException {
        if (!fieldMethodEntry.accessFlags().isSynthetic() || fieldMethodEntry.hasExceptionsSynthetic(false) || bl && fieldMethodEntry.accessFlags().isStatic() && fieldMethodEntry.accessFlags().isFinal()) {
            return false;
        }
        fieldMethodEntry.addAttribute(classFile.makeSyntheticAttribute());
        return true;
    }

    private static boolean isBridgeNoCastMethod(AttrCodeContent attrCodeContent, String string) throws BadClassFileException {
        if (attrCodeContent.getAstoreAloadVarAt(0, false) != 0) {
            return false;
        }
        int n = 1;
        while (attrCodeContent.isXLoadAt(n)) {
            ++n;
        }
        ConstantRef constantRef = attrCodeContent.getInvokevirtualRefAt(n);
        return constantRef != null && string.equals(constantRef.descriptor().classOrName().utfValue()) && attrCodeContent.isXReturnAt(attrCodeContent.getOpCodesCount() - 1);
    }

    private static boolean fixClassSpecMethod(AttrCodeContent attrCodeContent, ClassFile classFile) throws BadClassFileException {
        int n = attrCodeContent.getOpCodesCount() - 1;
        ConstantRef constantRef = attrCodeContent.getInvokevirtualRefAt(n - 1);
        if (constantRef == null || !attrCodeContent.isAthrowAt(n)) {
            return false;
        }
        ConstantRef constantRef2 = attrCodeContent.getConstRefAt(attrCodeContent.findPutGetstatic(0));
        if (constantRef2 != null && constantRef2.descriptor().classOrName().utfValue().equals("cl$")) {
            attrCodeContent.removeCodeAt(0, n + 1);
            Main.setClassSpecMethodCode(attrCodeContent, classFile);
        } else {
            ConstantRef constantRef3 = constantRef.descriptor();
            if (!constantRef3.classOrName().utfValue().equals("initCause") || !constantRef3.descriptor().utfValue().equals("(Ljava/lang/Throwable;)Ljava/lang/Throwable;")) {
                return false;
            }
            attrCodeContent.insertCodeNopsAt(n, 1);
            ConstantRef constantRef4 = constantRef.classOrName();
            attrCodeContent.putNewCheckcastAt(n, constantRef4.classOrName().utfValue().equals("java/lang/Throwable") ? classFile.addClassStringConst("java/lang/Error", true) : constantRef4, false);
        }
        return true;
    }

    private static boolean fixDualCasts(AttrCodeContent attrCodeContent) {
        int n = attrCodeContent.findCheckcast(0);
        boolean bl = false;
        if (n >= 0) {
            while (true) {
                int n2;
                if ((n2 = attrCodeContent.findCheckcast(n + 1)) - 1 == n && attrCodeContent.getConstRefAt(n2).isEqualTo(attrCodeContent.getConstRefAt(n))) {
                    attrCodeContent.removeCodeAt(n, 1);
                    bl = true;
                    continue;
                }
                if (n2 < 0) break;
                n = n2;
            }
        }
        return bl;
    }

    private static boolean fixFinallyBlocks(AttrCodeContent attrCodeContent, int n, ExceptionCatch exceptionCatch, Hashtable hashtable) {
        boolean bl = false;
        if (hashtable.get(exceptionCatch) == null) {
            int n2 = exceptionCatch.end().getIndex();
            if (exceptionCatch.handler().getIndex() > n2 && exceptionCatch.isAnyType()) {
                int n3 = exceptionCatch.start().getIndex();
                int n4 = attrCodeContent.getCatchesCount();
                for (int i = 0; i < n4; ++i) {
                    ExceptionCatch exceptionCatch2 = attrCodeContent.getCatch(i);
                    if (exceptionCatch2.end().getIndex() > n3 || exceptionCatch2.handler().getIndex() < n2 || !Main.fixFinallyBlocks(attrCodeContent, n, exceptionCatch2, hashtable)) continue;
                    if (attrCodeContent.getCatchesCount() != n4) {
                        return true;
                    }
                    n3 = exceptionCatch.start().getIndex();
                    n2 = exceptionCatch.end().getIndex();
                    bl = true;
                }
                hashtable.put(exceptionCatch, "");
                if (Main.fixFinallyBlocksFor(attrCodeContent, n, n2, exceptionCatch.handler().getIndex())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static boolean fixFinallyBlocksFor(AttrCodeContent attrCodeContent, int n, int n2, int n3) {
        int n4;
        int n5 = attrCodeContent.getAstoreAloadVarAt(n3, true);
        if (attrCodeContent.isMonitorexitAt(n3 + (n5 >= 0 ? 2 : 1))) {
            int n6;
            int n7;
            if (n3 - n2 == 1 && !attrCodeContent.isXReturnAt(n2) || !attrCodeContent.isMonitorexitAt(n2 - 1) || attrCodeContent.hasBranchesOutsideIntoCode(n2 - 1, 1)) {
                return false;
            }
            if (n5 >= 0) {
                if (attrCodeContent.getAstoreAloadVarAt(n3 + 3, false) != n5) {
                    return false;
                }
                n7 = attrCodeContent.getAstoreAloadVarAt(n3 + 1, false);
                n6 = n3 + 5;
            } else {
                n7 = attrCodeContent.getAstoreAloadVarAt(n3, false);
                n6 = n3 + 3;
            }
            if (n7 < 0 || !attrCodeContent.isAthrowAt(n6 - 1) || attrCodeContent.getAstoreAloadVarAt(n2 - 2, false) != n7) {
                return false;
            }
            int n8 = attrCodeContent.getAstoreAloadVarAt(n6, true);
            if (n8 < 0 || attrCodeContent.getAstoreAloadVarAt(n6 + 1, false) != n7 || !attrCodeContent.isMonitorexitAt(n6 + 2) || !attrCodeContent.isRetAt(n6 + 3, n8)) {
                if (n5 >= 0 && !attrCodeContent.hasBranchesOutsideIntoCode(n3 + 1, 3)) {
                    if (attrCodeContent.maxStack() < 2) {
                        attrCodeContent.setMaxStack(2);
                    }
                    attrCodeContent.putAstoreAloadAt(n3, n7, false);
                    attrCodeContent.putMonitorexitAt(n3 + 1);
                    attrCodeContent.removeCodeAt(n3 + 2, 2);
                    n6 = n3 + 3;
                }
                n8 = attrCodeContent.maxLocals();
                attrCodeContent.setMaxLocals(n8 + 1);
                attrCodeContent.insertCodeNopsAt(n6, 4);
                attrCodeContent.putAstoreAloadAt(n6, n8, true);
                attrCodeContent.putAstoreAloadAt(n6 + 1, n7, false);
                attrCodeContent.putMonitorexitAt(n6 + 2);
                attrCodeContent.putRetAt(n6 + 3, n8);
            }
            attrCodeContent.removeCodeAt(n2 - 1, 1);
            attrCodeContent.putJsrGotoAt(n2 - 2, n6 - 1, true);
            return true;
        }
        int[] nArray = new int[1];
        boolean bl = false;
        do {
            int n9;
            nArray[0] = -1;
            int n10 = attrCodeContent.getJsrGotoTargetIndexAt(n3 + 1, true);
            if (n3 + 4 != n10) {
                n9 = attrCodeContent.findRetAload(n3 + 1, n5, false);
                n4 = n9 - n3 - 1;
                if (!attrCodeContent.isAthrowAt(n9 + 1) || !attrCodeContent.isSameCodeRegions(n2, n3 + 1, n9, n, nArray) || attrCodeContent.hasBranchesOutsideIntoCode(n2 + 1, n4 - 1) || attrCodeContent.hasBranchesOutsideIntoCode(n3 + 1, n4 + 2)) break;
                int n11 = attrCodeContent.maxLocals();
                attrCodeContent.setMaxLocals(n11 + 1);
                attrCodeContent.putRetAt(n9, n11);
                attrCodeContent.removeCodeAt(n9 + 1, 1);
                attrCodeContent.insertCodeNopsAt(n3 + 1, 4);
                n10 = n3 + 4;
                attrCodeContent.putJsrGotoAt(n3 + 1, n10, true);
                attrCodeContent.putAstoreAloadAt(n3 + 2, n5, false);
                attrCodeContent.putAthrowAt(n3 + 3);
                attrCodeContent.putAstoreAloadAt(n10, n11, true);
                if (nArray[0] > n3) {
                    nArray[0] = nArray[0] + 3;
                }
            } else if (n5 < 0 || attrCodeContent.getAstoreAloadVarAt(n10 - 2, false) != n5 || !attrCodeContent.isAthrowAt(n10 - 1) || ((n4 = (n9 = attrCodeContent.findRetAload(n10 + 1, attrCodeContent.getAstoreAloadVarAt(n10, true), true)) - n10 - 1) != 0 ? !attrCodeContent.isSameCodeRegions(n2, n10 + 1, n9, n, nArray) || attrCodeContent.hasBranchesOutsideIntoCode(n2 + 1, n4 - 1) : attrCodeContent.getJsrGotoTargetIndexAt(n2, false) < 0 && !attrCodeContent.isXReturnAt(n2 + (attrCodeContent.isXLoadAt(n2) ? 1 : 0)))) break;
            attrCodeContent.removeCodeAt(n2 + 1, n4 - 1);
            attrCodeContent.putJsrGotoAt(n2, n10 - n4 + 1, true);
            bl = true;
            ++n2;
            if (nArray[0] >= 0) {
                attrCodeContent.insertCodeNopsAt(n2, 1);
                if (nArray[0] >= n2) {
                    nArray[0] = nArray[0] - (n4 - 2);
                }
                attrCodeContent.putJsrGotoAt(n2, nArray[0], false);
                ++n3;
            }
            while (true) {
                if (attrCodeContent.getJsrGotoTargetIndexAt(n2, true) <= n2) {
                    if (!attrCodeContent.isMonitorexitAt(n2 + 1) || attrCodeContent.getAstoreAloadVarAt(n2, false) < 0) break;
                    ++n2;
                }
                ++n2;
            }
            if (attrCodeContent.getJsrGotoTargetIndexAt(n2, false) >= 0) continue;
            if (attrCodeContent.isXLoadAt(n2)) {
                ++n2;
            }
            if (!attrCodeContent.isXReturnAt(n2)) break;
        } while (++n2 < (n3 -= n4 - 1));
        return bl;
    }

    private static boolean fixExcCatches(AttrCodeContent attrCodeContent, boolean bl, int n) {
        int n2;
        int n3;
        CodeAbsLabel codeAbsLabel;
        ExceptionCatch exceptionCatch;
        int n4;
        boolean bl2 = false;
        for (n4 = attrCodeContent.getCatchesCount() - 1; n4 >= 0; --n4) {
            int n5;
            int n6;
            int n7;
            int n8;
            block18: {
                block16: {
                    block17: {
                        exceptionCatch = attrCodeContent.getCatch(n4);
                        codeAbsLabel = exceptionCatch.end();
                        n3 = codeAbsLabel.getIndex();
                        if (n3 >= (n2 = exceptionCatch.handler().getIndex())) continue;
                        n8 = n3;
                        n7 = 0;
                        if (!exceptionCatch.isAnyType()) break block16;
                        n8 = n2;
                        n6 = n2 - n3;
                        if (n6 != 2 ? n6 != 1 && n6 != 3 || attrCodeContent.getAstoreAloadVarAt(n2 - 3, false) < 0 || !attrCodeContent.isMonitorexitAt(n2 - 2) : attrCodeContent.getJsrGotoTargetIndexAt(n3, true) <= n2) break block17;
                        if (attrCodeContent.isXReturnAt(n2 - 1) || attrCodeContent.getJsrGotoTargetIndexAt(n2 - 1, false) >= 0) break block18;
                    }
                    n7 = 1;
                    break block18;
                }
                n6 = 0;
                while (true) {
                    n5 = n8;
                    while (attrCodeContent.getJsrGotoTargetIndexAt(n5, true) > n2) {
                        ++n5;
                    }
                    if (n5 - n8 > 1) {
                        n6 = 1;
                    }
                    if (attrCodeContent.getJsrGotoTargetIndexAt(n5, false) < 0) {
                        if (attrCodeContent.isXLoadAt(n5)) {
                            ++n5;
                        }
                        if (attrCodeContent.isXReturnAt(n5)) {
                            if (n5 != n8 || n <= 3 && !bl) {
                                n6 = 1;
                            }
                        } else {
                            if (!attrCodeContent.isMonitorexitAt(n5) || attrCodeContent.getAstoreAloadVarAt(n5 - 1, false) < 0) break;
                            n6 = 1;
                        }
                    }
                    n7 = n6;
                    n8 = n5 + 1;
                    n6 = 1;
                }
            }
            if (n8 == n3) continue;
            n6 = 0;
            for (n5 = attrCodeContent.getCatchesCount() - 1; n5 >= 0; --n5) {
                ExceptionCatch exceptionCatch2;
                int n9;
                if (n5 == n4 || n3 >= (n9 = (exceptionCatch2 = attrCodeContent.getCatch(n5)).start().getIndex()) || n9 > n8 || exceptionCatch2.handler().getIndex() != n2 || n9 >= n2 || !exceptionCatch2.isSameCatchType(exceptionCatch)) continue;
                int n10 = exceptionCatch2.end().getIndex();
                attrCodeContent.removeCatch(n5);
                bl2 = true;
                if (n5 < n4) {
                    --n4;
                }
                if (n8 > n10) continue;
                n8 = n10;
                n6 = 1;
            }
            if (n6 != 0) {
                n7 = 1;
                ++n4;
            }
            if (n7 == 0) continue;
            codeAbsLabel.setNewIndex(n8);
            bl2 = true;
        }
        for (n4 = attrCodeContent.getCatchesCount() - 1; n4 >= 0; --n4) {
            exceptionCatch = attrCodeContent.getCatch(n4);
            codeAbsLabel = exceptionCatch.end();
            n3 = exceptionCatch.handler().getIndex();
            if (codeAbsLabel.getIndex() <= n3) continue;
            n2 = exceptionCatch.start().getIndex();
            if (n2 < n3) {
                codeAbsLabel.setNewIndex(n3);
                bl2 = true;
                continue;
            }
            if (n2 != n3) continue;
            attrCodeContent.removeCatch(n4);
            bl2 = true;
        }
        return bl2;
    }

    private static boolean fixInnerInitMethod(AttrCodeContent attrCodeContent, String string) throws BadClassFileException {
        Object object;
        ConstantRef constantRef;
        int n = 0;
        while (attrCodeContent.getAstoreAloadVarAt(n, false) == 0 && attrCodeContent.isXLoadAt(n + 1) && (constantRef = attrCodeContent.getPutfieldRefAt(n + 2)) != null && (((String)(object = constantRef.descriptor().classOrName().utfValue())).startsWith("this$") || ((String)object).startsWith("val$"))) {
            n += 3;
        }
        if (n == 0 || attrCodeContent.hasBranchesOutsideIntoCode(1, n - 1)) {
            return false;
        }
        int n2 = n;
        while (true) {
            if ((n2 = attrCodeContent.findInvokestaticSpecial(n2, false)) < 0) {
                return false;
            }
            object = attrCodeContent.getConstRefAt(n2);
            if (((ConstantRef)object).descriptor().classOrName().utfValue().equals("<init>") && ((ConstantRef)object).getEntityClassNameValue().equals(string)) break;
            ++n2;
        }
        attrCodeContent.moveCodeBlockAt(0, n, n2 + 1);
        return true;
    }

    private static boolean fixInnerZeroInit(AttrCodeContent attrCodeContent, ClassFile classFile, String string) throws BadClassFileException {
        int n;
        if (attrCodeContent.getAstoreAloadVarAt(0, false) != 0) {
            return false;
        }
        int n2 = attrCodeContent.findInvokestaticSpecial(1, false);
        if (n2 < 0) {
            return false;
        }
        ConstantRef constantRef = attrCodeContent.getConstRefAt(n2);
        if (!constantRef.descriptor().classOrName().utfValue().equals("<init>") || !constantRef.getEntityClassNameValue().equals(string)) {
            return false;
        }
        for (n = n2 - 1; n > 0; --n) {
            if (attrCodeContent.isXLoadAt(n)) continue;
            return false;
        }
        n = attrCodeContent.getOpCodesCount();
        for (int i = n2 + 1; i < n; ++i) {
            if (!attrCodeContent.isTargetInRangeAt(i, 0, i - 1)) continue;
            return false;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        String string2 = classFile.className();
        while (++n2 < n && !attrCodeContent.isInvokeMethodAt(n2)) {
            int n3;
            ConstantRef constantRef2;
            String string3;
            ConstantRef constantRef3 = attrCodeContent.getPutfieldRefAt(n2);
            if (constantRef3 == null || hashtable.put(string3 = (constantRef2 = constantRef3.descriptor()).classOrName().utfValue(), "") != null || attrCodeContent.getAstoreAloadVarAt(n2 - 2, false) != 0 || !attrCodeContent.isXConstZeroAt(n2 - 1) || !string2.equals(constantRef3.getEntityClassNameValue()) || (n3 = classFile.findField(string3, constantRef2.descriptor().utfValue(), false)) < 0 || classFile.getFieldAt(n3).accessFlags().isFinal() || attrCodeContent.hasBranchesOutsideIntoCode(n2 - 1, 2)) continue;
            n -= 3;
            attrCodeContent.removeCodeAt((n2 -= 3) + 1, 3);
            bl = true;
        }
        return bl;
    }

    private static boolean fixInnerSetAssertDisabled(AttrCodeContent attrCodeContent, String string) throws BadClassFileException {
        ConstantRef constantRef;
        ConstantRef constantRef2;
        int n = 5;
        while ((n = attrCodeContent.findPutGetstatic(n + 1)) >= 0 && !Main.isAssertionsDisabledField(attrCodeContent.getPutGetstaticRefAt(n, true), string)) {
        }
        if (n < 0) {
            return true;
        }
        int n2 = n - 6;
        if (attrCodeContent.findLdcClass(n2, n2 + 1) < 0) {
            constantRef2 = attrCodeContent.getPutGetstaticRefAt(n2 -= 7, false);
            if (constantRef2 == null) {
                return false;
            }
            constantRef = constantRef2.descriptor();
            if (!(constantRef.classOrName().utfValue().startsWith("class$") && constantRef.descriptor().utfValue().equals("Ljava/lang/Class;") && constantRef2.isEqualTo(attrCodeContent.getConstRefAt(n2 + 7)))) {
                return false;
            }
        }
        if ((constantRef2 = attrCodeContent.getInvokevirtualRefAt(n - 5)) == null) {
            return false;
        }
        constantRef = constantRef2.descriptor();
        if (!constantRef.descriptor().utfValue().equals("()Z") || attrCodeContent.getJsrGotoTargetIndexAt(n - 2, false) != n || attrCodeContent.hasBranchesOutsideIntoCode(n2 + 1, n - n2)) {
            return false;
        }
        attrCodeContent.removeCodeAt(n2, n - n2 + 1);
        return true;
    }

    private static boolean isAssertionsDisabledField(ConstantRef constantRef, String string) throws BadClassFileException {
        return constantRef != null && constantRef.descriptor().classOrName().utfValue().equals("$assertionsDisabled") && string.equals(constantRef.getEntityClassNameValue());
    }

    private static boolean fixGetAssertionsDisabled(AttrCodeContent attrCodeContent, String string) throws BadClassFileException {
        int n = -1;
        boolean bl = false;
        while ((n = attrCodeContent.findPutGetstatic(n + 1)) >= 0) {
            if (!Main.isAssertionsDisabledField(attrCodeContent.getPutGetstaticRefAt(n, false), string)) continue;
            attrCodeContent.putIconstZeroAt(n);
            bl = true;
        }
        return bl;
    }

    private static String fixOuterClassLiteral(AttrCodeContent attrCodeContent, ClassFile classFile) throws BadClassFileException {
        ConstantRef constantRef;
        String string = classFile.className();
        int n = Main.findInvokeOuterClassSpec(attrCodeContent, 0, string);
        String string2 = null;
        if (n >= 0 && (constantRef = Main.addClassSpecMethod(classFile)) != null) {
            do {
                ConstantRef constantRef2;
                ConstantRef constantRef3;
                String string3;
                attrCodeContent.putInvokestaticAt(n, constantRef);
                ConstantRef constantRef4 = attrCodeContent.getPutGetstaticRefAt(n + 2, true);
                if (constantRef4 == null || !(string3 = (constantRef3 = constantRef4.descriptor()).classOrName().utfValue()).startsWith("class$") && !string3.startsWith("array$") || !constantRef3.descriptor().utfValue().equals("Ljava/lang/Class;") || (constantRef2 = classFile.addStaticField(string3, "Ljava/lang/Class;")) == null) continue;
                string2 = constantRef4.getEntityClassNameValue();
                attrCodeContent.putPutGetstaticAt(n + 2, constantRef2, true);
                if (constantRef4.isEqualTo(attrCodeContent.getPutGetstaticRefAt(n - 3, false))) {
                    attrCodeContent.putPutGetstaticAt(n - 3, constantRef2, false);
                    if (!constantRef4.isEqualTo(attrCodeContent.getPutGetstaticRefAt(n + 4, false))) continue;
                    attrCodeContent.putPutGetstaticAt(n + 4, constantRef2, false);
                    continue;
                }
                if (!constantRef4.isEqualTo(attrCodeContent.getPutGetstaticRefAt(n - 5, false))) continue;
                attrCodeContent.putPutGetstaticAt(n - 5, constantRef2, false);
            } while ((n = Main.findInvokeOuterClassSpec(attrCodeContent, n + 1, string)) >= 0);
        }
        return string2;
    }

    private static int findInvokeOuterClassSpec(AttrCodeContent attrCodeContent, int n, String string) throws BadClassFileException {
        ConstantRef constantRef;
        ConstantRef constantRef2;
        while (!((n = attrCodeContent.findInvokestaticSpecial(n, true)) < 0 || (constantRef2 = (constantRef = attrCodeContent.getConstRefAt(n)).descriptor()).classOrName().utfValue().equals("class$") && constantRef2.descriptor().utfValue().equals("(Ljava/lang/String;)Ljava/lang/Class;") && !string.equals(constantRef.getEntityClassNameValue()))) {
            ++n;
        }
        return n;
    }

    private static ConstantRef addClassSpecMethod(ClassFile classFile) throws BadClassFileException {
        int n = classFile.addStaticMethodNoExc("class$", "(Ljava/lang/String;)Ljava/lang/Class;");
        if (n < 0) {
            return null;
        }
        AttrCodeContent attrCodeContent = classFile.getMethodAt(n).findCode();
        if (attrCodeContent == null) {
            return null;
        }
        if (attrCodeContent.getOpCodesCount() == 0) {
            Main.setClassSpecMethodCode(attrCodeContent, classFile);
        }
        return classFile.addNormMethodConstFor(n);
    }

    private static void setClassSpecMethodCode(AttrCodeContent attrCodeContent, ClassFile classFile) {
        attrCodeContent.setMaxStack(3);
        attrCodeContent.setMaxLocals(2);
        attrCodeContent.insertCodeNopsAt(0, 10);
        attrCodeContent.putAstoreAloadAt(0, 0, false);
        attrCodeContent.putInvokestaticAt(1, classFile.addNormMethodConst(classFile.addClassStringConst("java/lang/Class", true), "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
        attrCodeContent.putAreturnAt(2);
        attrCodeContent.putAstoreAloadAt(3, 1, true);
        ConstantRef constantRef = classFile.addClassStringConst("java/lang/NoClassDefFoundError", true);
        attrCodeContent.putNewCheckcastAt(4, constantRef, true);
        attrCodeContent.putDupAt(5);
        attrCodeContent.putAstoreAloadAt(6, 1, false);
        ConstantRef constantRef2 = classFile.addClassStringConst("java/lang/ClassNotFoundException", true);
        attrCodeContent.putInvokevirtualSpecialAt(7, constantRef2, "getMessage", "()Ljava/lang/String;", true, classFile);
        attrCodeContent.putInvokevirtualSpecialAt(8, constantRef, "<init>", "(Ljava/lang/String;)V", false, classFile);
        attrCodeContent.putAthrowAt(9);
        attrCodeContent.addCatch(0, 3, 3, constantRef2);
    }

    private static boolean fixLdcClassConst(AttrCodeContent attrCodeContent, ClassFile classFile) throws BadClassFileException {
        int n = attrCodeContent.findLdcClass(0, attrCodeContent.getOpCodesCount());
        if (n < 0) {
            return false;
        }
        ConstantRef constantRef = Main.addClassSpecMethod(classFile);
        boolean bl = false;
        if (constantRef != null) {
            do {
                String string;
                ConstantRef constantRef2;
                if ((constantRef2 = classFile.addStaticField(((string = attrCodeContent.getConstRefAt(n).classOrName().utfValue().replace('/', '.')).startsWith("[") ? "array" : "class$") + (string.endsWith(";") ? string.substring(0, string.length() - 1) : string).replace('.', '$').replace('[', '$'), "Ljava/lang/Class;")) == null) continue;
                if (!bl) {
                    attrCodeContent.setMaxStack(attrCodeContent.maxStack() + 1);
                    bl = true;
                }
                attrCodeContent.putPutGetstaticAt(n, constantRef2, false);
                attrCodeContent.insertCodeNopsAt(n + 1, 7);
                attrCodeContent.putIfnonnullAt(n + 1, n + 7);
                attrCodeContent.putLdcClassStringAt(n + 2, string, false, classFile);
                attrCodeContent.putInvokestaticAt(n + 3, constantRef);
                attrCodeContent.putDupAt(n + 4);
                attrCodeContent.putPutGetstaticAt(n + 5, constantRef2, true);
                attrCodeContent.putJsrGotoAt(n + 6, n + 8, false);
                attrCodeContent.putPutGetstaticAt(n += 7, constantRef2, false);
            } while ((n = attrCodeContent.findLdcClass(n + 1, attrCodeContent.getOpCodesCount())) >= 0);
        }
        return bl;
    }

    private static void collectUsedStaticFieldNames(Hashtable hashtable, AttrCodeContent attrCodeContent, String string) throws BadClassFileException {
        int n = -1;
        while ((n = attrCodeContent.findPutGetstatic(n + 1)) >= 0) {
            ConstantRef constantRef = attrCodeContent.getConstRefAt(n);
            if (!string.equals(constantRef.getEntityClassNameValue())) continue;
            hashtable.put(constantRef.descriptor().classOrName().utfValue(), "");
        }
    }

    private static boolean removeUnusedClassSpecFields(ClassFile classFile, Hashtable hashtable) throws BadClassFileException {
        boolean bl = false;
        for (int i = classFile.getFieldsCount() - 1; i >= 0; --i) {
            String string;
            FieldMethodEntry fieldMethodEntry = classFile.getFieldAt(i);
            if (!fieldMethodEntry.accessFlags().isStatic() || hashtable.get(string = fieldMethodEntry.name().utfValue()) != null || !fieldMethodEntry.hasExceptionsSynthetic(false) || !(string.equals("cl$") ? fieldMethodEntry.descriptor().utfValue().equals("Ljava/lang/ClassLoader;") : (string.startsWith("class$") || string.startsWith("array$")) && fieldMethodEntry.descriptor().utfValue().equals("Ljava/lang/Class;"))) continue;
            classFile.removeFieldAt(i);
            bl = true;
        }
        return bl;
    }
}

