/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassLabeledEntity;
import net.sf.jadretro.CodeAbsLabel;
import net.sf.jadretro.ConstantRef;

final class ExceptionCatch
extends ClassLabeledEntity {
    private CodeAbsLabel start;
    private CodeAbsLabel end;
    private CodeAbsLabel handler;
    private ConstantRef catchType;

    ExceptionCatch(int n, int n2, int n3, ConstantRef constantRef) {
        this.start = new CodeAbsLabel();
        this.start.setNewIndex(n);
        this.end = new CodeAbsLabel();
        this.end.setNewIndex(n2);
        this.handler = new CodeAbsLabel();
        this.handler.setNewIndex(n3);
        this.catchType = constantRef;
    }

    ExceptionCatch(InputStream inputStream, ClassFile classFile) throws IOException {
        this.start = new CodeAbsLabel(inputStream, null);
        this.end = new CodeAbsLabel(inputStream, null);
        this.handler = new CodeAbsLabel(inputStream, null);
        this.catchType = new ConstantRef(inputStream, classFile, true);
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        this.start.mapLabelsPc(nArray, false);
        this.end.mapLabelsPc(nArray, true);
        if (this.start.getIndex() >= this.end.getIndex()) {
            throw new BadClassFileException();
        }
        this.handler.mapLabelsPc(nArray, false);
    }

    boolean removeLabelsInRange(int n, int n2) {
        if (this.handler.isInRange(n, n2)) {
            return true;
        }
        if (this.start.isInRange(n, n2)) {
            if (this.end.isInRange(n, n2 + 1)) {
                return true;
            }
            this.start.setNewIndex(n2);
        } else if (this.end.isInRange(n, n2)) {
            this.end.setNewIndex(n2);
        }
        return false;
    }

    void incLabelIndices(int n, int n2) {
        this.start.incLabelIndices(n, n2);
        this.end.incLabelIndices(n, n2);
        this.handler.incLabelIndices(n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        this.start.rebuildLabelsPc(nArray);
        this.end.rebuildLabelsPc(nArray);
        this.handler.rebuildLabelsPc(nArray);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.start.writeTo(outputStream);
        this.end.writeTo(outputStream);
        this.handler.writeTo(outputStream);
        this.catchType.writeTo(outputStream);
    }

    CodeAbsLabel start() {
        return this.start;
    }

    CodeAbsLabel end() {
        return this.end;
    }

    CodeAbsLabel handler() {
        return this.handler;
    }

    boolean isAnyType() {
        return this.catchType.isZero();
    }

    boolean isSameCatchType(ExceptionCatch exceptionCatch) {
        return this.catchType.isEqualTo(exceptionCatch.catchType);
    }
}

