/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassEntity;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassOverflowException;
import net.sf.jadretro.ConstantPoolEntry;

final class ConstantRef
extends ClassEntity {
    private int index;
    private ClassFile classFile;

    ConstantRef(int n, ClassFile classFile) {
        this.index = n;
        this.classFile = classFile;
    }

    ConstantRef(InputStream inputStream, ClassFile classFile, boolean bl) throws IOException {
        this.classFile = classFile;
        this.index = ConstantRef.readUnsignedShort(inputStream);
        if (!bl && this.index == 0 || classFile.getConstantPoolCount() <= this.index) {
            throw new BadClassFileException();
        }
    }

    static ConstantRef readAsByteFrom(InputStream inputStream, ClassFile classFile) throws IOException {
        int n = ConstantRef.readUnsignedByte(inputStream);
        if (n == 0 || classFile.getConstantPoolCount() <= n) {
            throw new BadClassFileException();
        }
        return new ConstantRef(n, classFile);
    }

    boolean isWide() {
        return (this.index & 0xFFFFFF00) != 0;
    }

    void writeAsByteTo(OutputStream outputStream) throws IOException {
        if (this.isWide()) {
            throw new ClassOverflowException();
        }
        outputStream.write(this.index);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        ConstantRef.writeShort(outputStream, this.index);
    }

    private ConstantPoolEntry getConstantEntry() {
        return this.classFile.getConstantAt(this.index);
    }

    boolean isClassConst() {
        return this.getConstantEntry().isClassConst();
    }

    ConstantRef classOrName() throws BadClassFileException {
        return this.getConstantEntry().content().classOrName();
    }

    ConstantRef descriptor() throws BadClassFileException {
        return this.getConstantEntry().content().descriptor();
    }

    String utfValue() throws BadClassFileException {
        return this.getConstantEntry().content().utfValue();
    }

    String getEntityClassNameValue() throws BadClassFileException {
        return this.classOrName().classOrName().utfValue();
    }

    boolean isZero() {
        return this.index == 0;
    }

    boolean isEqualTo(ConstantRef constantRef) {
        return constantRef.index == this.index;
    }
}

