/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.util.Stack;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.model.ModelMessages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestRunHandler
extends DefaultHandler {
    private int fId;
    private TestRunSession fTestRunSession;
    private TestSuiteElement fTestSuite;
    private TestCaseElement fTestCase;
    private Stack fNotRun = new Stack();
    private StringBuffer fFailureBuffer;
    private boolean fInExpected;
    private boolean fInActual;
    private StringBuffer fExpectedBuffer;
    private StringBuffer fActualBuffer;
    private Locator fLocator;
    private TestElement.Status fStatus;
    private IProgressMonitor fMonitor;
    private int fLastReportedLine;

    public TestRunHandler() {
    }

    public TestRunHandler(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    public TestRunHandler(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int line;
        if (this.fLocator != null && this.fMonitor != null && (line = this.fLocator.getLineNumber()) - 20 >= this.fLastReportedLine) {
            line -= line % 20;
            this.fLastReportedLine = line;
            this.fMonitor.subTask(NLS.bind((String)ModelMessages.TestRunHandler_lines_read, (Object)new Integer(line)));
        }
        if (Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        if (qName.equals("testrun")) {
            if (this.fTestRunSession == null) {
                IJavaModel javaModel;
                String name = attributes.getValue("name");
                String project = attributes.getValue("project");
                IJavaProject javaProject = null;
                if (project != null && !(javaProject = (javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot())).getJavaProject(project)).exists()) {
                    javaProject = null;
                }
                this.fTestRunSession = new TestRunSession(name, javaProject);
            } else {
                this.fTestRunSession.reset();
            }
            this.fTestSuite = this.fTestRunSession.getTestRoot();
        } else if (!qName.equals("testsuites")) {
            if (qName.equals("testsuite")) {
                String pack;
                String name = attributes.getValue("name");
                if (this.fTestRunSession == null) {
                    this.fTestRunSession = new TestRunSession(name, null);
                    this.fTestSuite = this.fTestRunSession.getTestRoot();
                }
                String suiteName = (pack = attributes.getValue("package")) == null ? name : String.valueOf(pack) + "." + name;
                this.fTestSuite = (TestSuiteElement)this.fTestRunSession.createTestElement(this.fTestSuite, this.getNextId(), suiteName, true, 0);
                this.readTime(this.fTestSuite, attributes);
                this.fNotRun.push(Boolean.valueOf(attributes.getValue("incomplete")));
            } else if (!qName.equals("properties") && !qName.equals("property")) {
                if (qName.equals("testcase")) {
                    String name = attributes.getValue("name");
                    String classname = attributes.getValue("classname");
                    this.fTestCase = (TestCaseElement)this.fTestRunSession.createTestElement(this.fTestSuite, this.getNextId(), String.valueOf(name) + '(' + classname + ')', false, 0);
                    this.fNotRun.push(Boolean.valueOf(attributes.getValue("incomplete")));
                    this.fTestCase.setIgnored(Boolean.valueOf(attributes.getValue("ignored")));
                    this.readTime(this.fTestCase, attributes);
                } else if (qName.equals("error")) {
                    this.fStatus = TestElement.Status.ERROR;
                    this.fFailureBuffer = new StringBuffer();
                } else if (qName.equals("failure")) {
                    this.fStatus = TestElement.Status.FAILURE;
                    this.fFailureBuffer = new StringBuffer();
                } else if (qName.equals("expected")) {
                    this.fInExpected = true;
                    this.fExpectedBuffer = new StringBuffer();
                } else if (qName.equals("actual")) {
                    this.fInActual = true;
                    this.fActualBuffer = new StringBuffer();
                } else if (!qName.equals("system-out") && !qName.equals("system-err")) {
                    if (qName.equals("skipped")) {
                        this.fTestCase.setIgnored(true);
                    } else {
                        throw new SAXParseException("unknown node '" + qName + "'", this.fLocator);
                    }
                }
            }
        }
    }

    private void readTime(TestElement testElement, Attributes attributes) {
        String timeString = attributes.getValue("time");
        if (timeString != null) {
            try {
                testElement.setElapsedTimeInSeconds(Double.parseDouble(timeString));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fInExpected) {
            this.fExpectedBuffer.append(ch, start, length);
        } else if (this.fInActual) {
            this.fActualBuffer.append(ch, start, length);
        } else if (this.fFailureBuffer != null) {
            this.fFailureBuffer.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!qName.equals("testrun") && !qName.equals("testsuites")) {
            if (qName.equals("testsuite")) {
                this.handleTestElementEnd(this.fTestSuite);
                this.fTestSuite = this.fTestSuite.getParent();
            } else if (!qName.equals("properties") && !qName.equals("property")) {
                if (qName.equals("testcase")) {
                    this.handleTestElementEnd(this.fTestCase);
                    this.fTestCase = null;
                } else if (qName.equals("failure") || qName.equals("error")) {
                    TestElement testElement = this.fTestCase;
                    if (testElement == null) {
                        testElement = this.fTestSuite;
                    }
                    this.handleFailure(testElement);
                } else if (qName.equals("expected")) {
                    this.fInExpected = false;
                    if (this.fFailureBuffer != null) {
                        this.fFailureBuffer.setLength(0);
                    }
                } else if (qName.equals("actual")) {
                    this.fInActual = false;
                    if (this.fFailureBuffer != null) {
                        this.fFailureBuffer.setLength(0);
                    }
                } else if (!(qName.equals("system-out") || qName.equals("system-err") || qName.equals("skipped"))) {
                    this.handleUnknownNode(qName);
                }
            }
        }
    }

    private void handleTestElementEnd(TestElement testElement) {
        boolean completed = this.fNotRun.pop() != Boolean.TRUE;
        this.fTestRunSession.registerTestEnded(testElement, completed);
    }

    private void handleFailure(TestElement testElement) {
        if (this.fFailureBuffer != null) {
            this.fTestRunSession.registerTestFailureStatus(testElement, this.fStatus, this.fFailureBuffer.toString(), this.toString(this.fExpectedBuffer), this.toString(this.fActualBuffer));
            this.fFailureBuffer = null;
            this.fExpectedBuffer = null;
            this.fActualBuffer = null;
            this.fStatus = null;
        }
    }

    private String toString(StringBuffer buffer) {
        return buffer != null ? buffer.toString() : null;
    }

    private void handleUnknownNode(String qName) throws SAXException {
        String msg = "unknown node '" + qName + "'";
        if (this.fLocator != null) {
            msg = String.valueOf(msg) + " at line " + this.fLocator.getLineNumber() + ", column " + this.fLocator.getColumnNumber();
        }
        throw new SAXException(msg);
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    private String getNextId() {
        return Integer.toString(this.fId++);
    }

    public TestRunSession getTestRunSession() {
        return this.fTestRunSession;
    }
}

