/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.LinkHelperService;
import org.eclipse.ui.progress.UIJob;

public class LinkEditorAction
extends Action
implements ISelectionChangedListener,
IPropertyListener {
    private IPartListener partListener;
    private final CommonNavigator commonNavigator;
    private final CommonViewer commonViewer;
    private final LinkHelperService linkService;
    private boolean ignoreSelectionChanged;
    private boolean ignoreEditorActivation;
    private UIJob activateEditorJob = new UIJob(CommonNavigatorMessages.Link_With_Editor_Job_){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ILinkHelper[] helpers;
            IStructuredSelection sSelection;
            ISelection selection;
            if (!LinkEditorAction.this.commonViewer.getControl().isDisposed() && (selection = LinkEditorAction.this.commonViewer.getSelection()) != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1 && (helpers = LinkEditorAction.this.linkService.getLinkHelpersFor(sSelection.getFirstElement())).length > 0) {
                LinkEditorAction.this.ignoreEditorActivation = true;
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this, helpers, sSelection){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ILinkHelper[] val$helpers;
                    private final /* synthetic */ IStructuredSelection val$sSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$helpers = iLinkHelperArray;
                        this.val$sSelection = iStructuredSelection;
                    }

                    public void run() throws Exception {
                        this.val$helpers[0].activateEditor(LinkEditorAction.access$3(1.access$0(this.this$1)).getSite().getPage(), this.val$sSelection);
                    }
                });
                LinkEditorAction.this.ignoreEditorActivation = false;
            }
            return Status.OK_STATUS;
        }

        static /* synthetic */ LinkEditorAction access$0(1 var0) {
            return var0.LinkEditorAction.this;
        }
    };
    private UIJob updateSelectionJob = new UIJob(CommonNavigatorMessages.Link_With_Editor_Job_){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!LinkEditorAction.this.commonNavigator.getCommonViewer().getControl().isDisposed()) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() throws Exception {
                        IEditorPart editor;
                        IWorkbenchPage page = LinkEditorAction.access$3(3.access$0(this.this$1)).getSite().getPage();
                        if (page != null && (editor = page.getActiveEditor()) != null) {
                            IEditorInput input = editor.getEditorInput();
                            IStructuredSelection newSelection = LinkEditorAction.access$1(3.access$0(this.this$1)).getSelectionFor(input);
                            if (!newSelection.isEmpty()) {
                                LinkEditorAction.access$4(3.access$0(this.this$1), true);
                                LinkEditorAction.access$3(3.access$0(this.this$1)).selectReveal((ISelection)newSelection);
                                LinkEditorAction.access$4(3.access$0(this.this$1), false);
                            }
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }

        static /* synthetic */ LinkEditorAction access$0(3 var0) {
            return var0.LinkEditorAction.this;
        }
    };

    public LinkEditorAction(CommonNavigator aNavigator, CommonViewer aViewer, LinkHelperService linkHelperService) {
        super(CommonNavigatorMessages.LinkEditorActionDelegate_0);
        this.linkService = linkHelperService;
        this.setToolTipText(CommonNavigatorMessages.LinkEditorActionDelegate_1);
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        this.init();
    }

    protected void init() {
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart && !LinkEditorAction.this.ignoreEditorActivation) {
                    LinkEditorAction.this.updateSelectionJob.schedule(120L);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof IEditorPart && !LinkEditorAction.this.ignoreEditorActivation) {
                    LinkEditorAction.this.updateSelectionJob.schedule(120L);
                }
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.updateLinkingEnabled(this.commonNavigator.isLinkingEnabled());
        this.commonNavigator.addPropertyListener(this);
    }

    public void dispose() {
        this.commonNavigator.removePropertyListener(this);
        if (this.isChecked()) {
            this.commonViewer.removePostSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }

    public void run() {
        this.commonNavigator.setLinkingEnabled(!this.commonNavigator.isLinkingEnabled());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.commonNavigator.isLinkingEnabled() && !this.ignoreSelectionChanged) {
            this.activateEditor();
        }
    }

    protected void activateEditor() {
        ISelection selection = this.commonViewer.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.activateEditorJob.schedule(120L);
        }
    }

    public void propertyChanged(Object aSource, int aPropertyId) {
        switch (aPropertyId) {
            case 65536: {
                this.updateLinkingEnabled(((CommonNavigator)((Object)aSource)).isLinkingEnabled());
            }
        }
    }

    private void updateLinkingEnabled(boolean toEnableLinking) {
        this.setChecked(toEnableLinking);
        if (toEnableLinking) {
            this.updateSelectionJob.schedule(120L);
            this.commonViewer.addPostSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().addPartListener(this.partListener);
        } else {
            this.commonViewer.removePostSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }

    static /* synthetic */ void access$4(LinkEditorAction linkEditorAction, boolean bl) {
        linkEditorAction.ignoreSelectionChanged = bl;
    }
}

