/*****************************************************************************

  JEP 2.4.1, Extensions 1.1.1
       April 30 2007
       (c) Copyright 2007, Nathan Funk and Richard Morris
       See LICENSE-*.txt for license information.

 *****************************************************************************/

package org.nfunk.jep.function;


import java.util.Stack;

import net.minecraft.src.weasel.Calculator;

import org.nfunk.jep.ParseException;


/**
 * Build byte of bits
 */
public class Trilobyte extends PostfixMathCommand {
	private Add addFun = new Add();

	/**
	 * Constructor.
	 */
	public Trilobyte() {
		// Use a variable number of arguments
		numberOfParameters = -1;
	}
	
	private int pow(int what) {
		if(what == 0) return 1;
		int out = 2;
		what--;
		int p = 2;
		
		while(what > 0) {
			out += p;
			p *= 2;
			what--;
		}
		return out;
	}

	/**
	 * Calculates the result of summing up all parameters, which are assumed to
	 * be of the Double type.
	 */
	@Override
	public void run(Stack stack) throws ParseException {
		checkStack(stack);// check the stack

		if (curNumberOfParameters < 1) throw new ParseException("No arguments for Trilobyte");

		int exponent = curNumberOfParameters-1;
		
		// initialize the result to the first argument
		Object sum = stack.pop();
		
		int byteout = Calculator.toBoolean(sum)?1:0;
		
		Object param;
		int i = 1;

		// repeat summation for each one of the current parameters
		while (i < curNumberOfParameters) {
			// get the parameter from the stack
			param = stack.pop();
			
			boolean bit = Calculator.toBoolean(param);

			// add it to the sum (order is important for String arguments)
			if(bit) sum = addFun.add(pow(i), sum);

			i++;
		}

		System.out.println("trilobyte = "+sum);
		
		// push the result on the inStack
		stack.push(sum);
	}
}
