/*****************************************************************************

 JEP 2.4.1, Extensions 1.1.1
      April 30 2007
      (c) Copyright 2007, Nathan Funk and Richard Morris
      See LICENSE-*.txt for license information.

 *****************************************************************************/
/* Generated By:JJTree: Do not edit this line. SimpleNode.java */
package org.nfunk.jep;


/*
 * The parent class for all AST node classes. Contains basic tree node methods
 * for traversal, adding and removing children and parent nodes, and other
 * methods.
 */
public class SimpleNode implements Node {
	protected Node parent;
	protected Node[] children;
	protected int id;
	protected Parser parser;

	public SimpleNode(int i) {
		id = i;
	}

	public SimpleNode(Parser p, int i) {
		this(i);
		parser = p;
	}

	@Override
	public void jjtOpen() {}

	@Override
	public void jjtClose() {}

	@Override
	public void jjtSetParent(Node n) {
		parent = n;
	}

	@Override
	public Node jjtGetParent() {
		return parent;
	}

	@Override
	public void jjtAddChild(Node n, int i) {
		if (children == null) {
			children = new Node[i + 1];
		} else if (i >= children.length) {
			Node c[] = new Node[i + 1];
			System.arraycopy(children, 0, c, 0, children.length);
			children = c;
		}
		children[i] = n;
	}

	@Override
	public Node jjtGetChild(int i) {
		return children[i];
	}

	@Override
	public int jjtGetNumChildren() {
		return (children == null) ? 0 : children.length;
	}

	/** Accept the visitor. **/
	@Override
	public Object jjtAccept(ParserVisitor visitor, Object data) throws ParseException {
		return visitor.visit(this, data);
	}

	/** Accept the visitor. **/
	public Object childrenAccept(ParserVisitor visitor, Object data) throws ParseException {
		if (children != null) {
			for (int i = 0; i < children.length; ++i) {
				children[i].jjtAccept(visitor, data);
			}
		}
		return data;
	}

	/* You can override these two methods in subclasses of SimpleNode to
	customize the way the node appears when the tree is dumped.  If
	your output uses more than one line you should override
	toString(String), otherwise overriding toString() is probably all
	you need to do. */

	@Override
	public String toString() {
		return ParserTreeConstants.jjtNodeName[id];
	}

	public String toString(String prefix) {
		return prefix + toString();
	}

	/* Override this method if you want to customize how the node dumps
	out its children. */

	public void dump(String prefix) {
		System.out.println(toString(prefix));
		if (children != null) {
			for (int i = 0; i < children.length; ++i) {
				SimpleNode n = (SimpleNode) children[i];
				if (n != null) {
					n.dump(prefix + " ");
				}
			}
		}
	}

	/**
	 * Returns the id of the node (for simpler identification).
	 */
	public int getId() {
		return id;
	}
}
