/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.SourceJavaSound;

public class LibraryJavaSound
extends Library {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private final int maxClipSize = 0x100000;
    private static Mixer myMixer = null;
    private static LibraryJavaSound instance = null;

    public LibraryJavaSound() {
        instance = this;
    }

    public void init() {
        if (myMixer == null) {
            myMixer = AudioSystem.getMixer(null);
        }
        if (myMixer == null) {
            this.importantMessage("\"Java Sound Audio Engine\" was not found!");
            super.init();
            throw new SoundSystemException("\"Java Sound Audio Engine\" was not found in the list of available mixers.", 14);
        }
        this.setMasterVolume(1.0f);
        this.message("JavaSound initialized.");
        super.init();
    }

    public static boolean libraryCompatible() {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equals("Java Sound Audio Engine")) continue;
            return true;
        }
        return false;
    }

    protected Channel createChannel(int n) {
        return new ChannelJavaSound(n, myMixer);
    }

    public void cleanup() {
        super.cleanup();
        instance = null;
        myMixer = null;
    }

    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec(filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (soundBuffer != null) {
            this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    public void setMasterVolume(float f) {
        super.setMasterVolume(f);
        Set set = this.sourceMap.keySet();
        for (String string : set) {
            Source source = (Source)this.sourceMap.get(string);
            if (source == null) continue;
            source.positionChanged();
        }
    }

    public void newSource(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f, float f2, float f3, int n, float f4) {
        SoundBuffer soundBuffer = null;
        if (!bl2) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl2 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl, bl2, bl3, string, filenameURL, soundBuffer, f, f2, f3, n, f4, false));
    }

    public void rawDataStream(AudioFormat audioFormat, boolean bl, String string, float f, float f2, float f3, int n, float f4) {
        this.sourceMap.put(string, new SourceJavaSound(this.listener, audioFormat, bl, string, f, f2, f3, n, f4));
    }

    public void quickPlay(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f, float f2, float f3, int n, float f4, boolean bl4) {
        SoundBuffer soundBuffer = null;
        if (!bl2) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl2 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl, bl2, bl3, string, filenameURL, soundBuffer, f, f2, f3, n, f4, bl4));
    }

    public void copySources(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Source source = (Source)hashMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer != null) {
                soundBuffer.trimData(0x100000);
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceJavaSound(this.listener, source, soundBuffer));
        }
    }

    public static Mixer getMixer() {
        return LibraryJavaSound.mixer(false, null);
    }

    public static void setMixer(Mixer mixer) {
        LibraryJavaSound.mixer(true, mixer);
        SoundSystemException soundSystemException = SoundSystem.getLastException();
        SoundSystem.setException(null);
        if (soundSystemException != null) {
            throw soundSystemException;
        }
    }

    private static synchronized Mixer mixer(boolean bl, Mixer mixer) {
        if (bl) {
            myMixer = mixer;
            if (instance != null) {
                ChannelJavaSound channelJavaSound;
                ListIterator listIterator = LibraryJavaSound.instance.normalChannels.listIterator();
                SoundSystem.setException(null);
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
                listIterator = LibraryJavaSound.instance.streamingChannels.listIterator();
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
            }
        }
        return myMixer;
    }

    public static String getTitle() {
        return "Java Sound";
    }

    public static String getDescription() {
        return "The Java Sound API.  For more information, see http://java.sun.com/products/java-media/sound/";
    }

    public String getClassName() {
        return "LibraryJavaSound";
    }
}

