/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EnumOS1;
import net.minecraft.src.IsoImageBuffer;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.TerrainTextureManager;
import net.minecraft.src.ThreadRunIsoClient;
import net.minecraft.src.World;
import net.minecraft.src.WorldSettings;
import net.minecraft.src.WorldType;

public class CanvasIsomPreview
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener,
Runnable {
    private int field_1793_a = 0;
    private int field_1792_b = 2;
    private boolean field_1791_c = true;
    private World field_1790_d;
    private File field_1789_e;
    private boolean field_1788_f = true;
    private List field_1787_g = Collections.synchronizedList(new LinkedList());
    private IsoImageBuffer[][] field_1786_h = new IsoImageBuffer[64][64];
    private int field_1785_i;
    private int field_1784_j;
    private int field_1783_k;
    private int field_1782_l;

    public File func_1263_a() {
        if (this.field_1789_e == null) {
            this.field_1789_e = this.func_1264_a("minecraft");
        }
        return this.field_1789_e;
    }

    public File func_1264_a(String p_1264_1_) {
        File file;
        String string = System.getProperty("user.home", ".");
        switch (CanvasIsomPreview.func_1269_e()) {
            case linux: 
            case solaris: {
                file = new File(string, '.' + p_1264_1_ + '/');
                break;
            }
            case windows: {
                String string2 = System.getenv("APPDATA");
                if (string2 != null) {
                    file = new File(string2, "." + p_1264_1_ + '/');
                    break;
                }
                file = new File(string, '.' + p_1264_1_ + '/');
                break;
            }
            case macos: {
                file = new File(string, "Library/Application Support/" + p_1264_1_);
                break;
            }
            default: {
                file = new File(string, p_1264_1_ + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS1 func_1269_e() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("win")) {
            return EnumOS1.windows;
        }
        if (string.contains("mac")) {
            return EnumOS1.macos;
        }
        if (string.contains("solaris")) {
            return EnumOS1.solaris;
        }
        if (string.contains("sunos")) {
            return EnumOS1.solaris;
        }
        if (string.contains("linux")) {
            return EnumOS1.linux;
        }
        if (string.contains("unix")) {
            return EnumOS1.linux;
        }
        return EnumOS1.unknown;
    }

    public CanvasIsomPreview() {
        this.field_1789_e = this.func_1263_a();
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.field_1786_h[i][j] = new IsoImageBuffer(null, i, j);
            }
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.setBackground(Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_1270_b(String p_1270_1_) {
        this.field_1784_j = 0;
        this.field_1785_i = 0;
        this.field_1790_d = new World(new SaveHandler(new File(this.field_1789_e, "saves"), p_1270_1_, false), p_1270_1_, new WorldSettings(new Random().nextLong(), 0, true, false, WorldType.field_48635_b));
        this.field_1790_d.field_1046_e = 0;
        List list = this.field_1787_g;
        synchronized (list) {
            this.field_1787_g.clear();
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    this.field_1786_h[i][j].func_888_a(this.field_1790_d, i, j);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_1266_a(int p_1266_1_) {
        List list = this.field_1787_g;
        synchronized (list) {
            this.field_1790_d.field_1046_e = p_1266_1_;
            this.field_1787_g.clear();
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    this.field_1786_h[i][j].func_888_a(this.field_1790_d, i, j);
                }
            }
        }
    }

    public void func_1272_b() {
        new ThreadRunIsoClient(this).start();
        for (int i = 0; i < 8; ++i) {
            new Thread(this).start();
        }
    }

    public void func_1273_c() {
        this.field_1788_f = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsoImageBuffer func_1267_a(int p_1267_1_, int p_1267_2_) {
        int n = p_1267_1_ & 0x3F;
        int n2 = p_1267_2_ & 0x3F;
        IsoImageBuffer isoImageBuffer = this.field_1786_h[n][n2];
        if (isoImageBuffer.field_1354_c == p_1267_1_ && isoImageBuffer.field_1353_d == p_1267_2_) {
            return isoImageBuffer;
        }
        List list = this.field_1787_g;
        synchronized (list) {
            this.field_1787_g.remove(isoImageBuffer);
        }
        isoImageBuffer.func_889_a(p_1267_1_, p_1267_2_);
        return isoImageBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TerrainTextureManager terrainTextureManager = new TerrainTextureManager();
        while (this.field_1788_f) {
            IsoImageBuffer isoImageBuffer = null;
            List list = this.field_1787_g;
            synchronized (list) {
                if (this.field_1787_g.size() > 0) {
                    isoImageBuffer = (IsoImageBuffer)this.field_1787_g.remove(0);
                }
            }
            if (isoImageBuffer != null) {
                if (this.field_1793_a - isoImageBuffer.field_1350_g < 2) {
                    terrainTextureManager.func_799_a(isoImageBuffer);
                    this.repaint();
                } else {
                    isoImageBuffer.field_1349_h = false;
                }
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void update(Graphics p_update_1_) {
    }

    public void paint(Graphics p_paint_1_) {
    }

    public void func_1265_d() {
        BufferStrategy bufferStrategy = this.getBufferStrategy();
        if (bufferStrategy == null) {
            this.createBufferStrategy(2);
            return;
        }
        this.func_1268_a((Graphics2D)bufferStrategy.getDrawGraphics());
        bufferStrategy.show();
    }

    public void func_1268_a(Graphics2D p_1268_1_) {
        int n;
        Object object;
        ++this.field_1793_a;
        AffineTransform affineTransform = p_1268_1_.getTransform();
        p_1268_1_.setClip(0, 0, this.getWidth(), this.getHeight());
        p_1268_1_.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        p_1268_1_.translate(this.getWidth() / 2, this.getHeight() / 2);
        p_1268_1_.scale(this.field_1792_b, this.field_1792_b);
        p_1268_1_.translate(this.field_1785_i, this.field_1784_j);
        if (this.field_1790_d != null) {
            object = this.field_1790_d.func_22137_s();
            p_1268_1_.translate(-(((ChunkCoordinates)object).field_22395_a + ((ChunkCoordinates)object).field_22396_c), -(-((ChunkCoordinates)object).field_22395_a + ((ChunkCoordinates)object).field_22396_c) + 64);
        }
        object = p_1268_1_.getClipBounds();
        p_1268_1_.setColor(new Color(-15724512));
        p_1268_1_.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        int n2 = 16;
        int n3 = 3;
        int n4 = ((Rectangle)object).x / n2 / 2 - 2 - n3;
        int n5 = (((Rectangle)object).x + ((Rectangle)object).width) / n2 / 2 + 1 + n3;
        int n6 = ((Rectangle)object).y / n2 - 1 - n3 * 2;
        int n7 = (((Rectangle)object).y + ((Rectangle)object).height + 16 + 128) / n2 + 1 + n3 * 2;
        for (n = n6; n <= n7; ++n) {
            for (int i = n4; i <= n5; ++i) {
                int n8 = i - (n >> 1);
                int n9 = i + (n + 1 >> 1);
                IsoImageBuffer isoImageBuffer = this.func_1267_a(n8, n9);
                isoImageBuffer.field_1350_g = this.field_1793_a;
                if (!isoImageBuffer.field_1352_e) {
                    if (isoImageBuffer.field_1349_h) continue;
                    isoImageBuffer.field_1349_h = true;
                    this.field_1787_g.add(isoImageBuffer);
                    continue;
                }
                isoImageBuffer.field_1349_h = false;
                if (isoImageBuffer.field_1351_f) continue;
                int n10 = i * n2 * 2 + (n & 1) * n2;
                int n11 = n * n2 - 128 - 16;
                p_1268_1_.drawImage((Image)isoImageBuffer.field_1348_a, n10, n11, null);
            }
        }
        if (this.field_1791_c) {
            p_1268_1_.setTransform(affineTransform);
            n = this.getHeight() - 32 - 4;
            p_1268_1_.setColor(new Color(Integer.MIN_VALUE, true));
            p_1268_1_.fillRect(4, this.getHeight() - 32 - 4, this.getWidth() - 8, 32);
            p_1268_1_.setColor(Color.WHITE);
            String string = "F1 - F5: load levels   |   0-9: Set time of day   |   Space: return to spawn   |   Double click: zoom   |   Escape: hide this text";
            p_1268_1_.drawString(string, this.getWidth() / 2 - p_1268_1_.getFontMetrics().stringWidth(string) / 2, n + 20);
        }
        p_1268_1_.dispose();
    }

    public void mouseDragged(MouseEvent p_mouseDragged_1_) {
        int n = p_mouseDragged_1_.getX() / this.field_1792_b;
        int n2 = p_mouseDragged_1_.getY() / this.field_1792_b;
        this.field_1785_i += n - this.field_1783_k;
        this.field_1784_j += n2 - this.field_1782_l;
        this.field_1783_k = n;
        this.field_1782_l = n2;
        this.repaint();
    }

    public void mouseMoved(MouseEvent p_mouseMoved_1_) {
    }

    public void mouseClicked(MouseEvent p_mouseClicked_1_) {
        if (p_mouseClicked_1_.getClickCount() == 2) {
            this.field_1792_b = 3 - this.field_1792_b;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent p_mouseEntered_1_) {
    }

    public void mouseExited(MouseEvent p_mouseExited_1_) {
    }

    public void mousePressed(MouseEvent p_mousePressed_1_) {
        int n = p_mousePressed_1_.getX() / this.field_1792_b;
        int n2 = p_mousePressed_1_.getY() / this.field_1792_b;
        this.field_1783_k = n;
        this.field_1782_l = n2;
    }

    public void mouseReleased(MouseEvent p_mouseReleased_1_) {
    }

    public void keyPressed(KeyEvent p_keyPressed_1_) {
        if (p_keyPressed_1_.getKeyCode() == 48) {
            this.func_1266_a(11);
        }
        if (p_keyPressed_1_.getKeyCode() == 49) {
            this.func_1266_a(10);
        }
        if (p_keyPressed_1_.getKeyCode() == 50) {
            this.func_1266_a(9);
        }
        if (p_keyPressed_1_.getKeyCode() == 51) {
            this.func_1266_a(7);
        }
        if (p_keyPressed_1_.getKeyCode() == 52) {
            this.func_1266_a(6);
        }
        if (p_keyPressed_1_.getKeyCode() == 53) {
            this.func_1266_a(5);
        }
        if (p_keyPressed_1_.getKeyCode() == 54) {
            this.func_1266_a(3);
        }
        if (p_keyPressed_1_.getKeyCode() == 55) {
            this.func_1266_a(2);
        }
        if (p_keyPressed_1_.getKeyCode() == 56) {
            this.func_1266_a(1);
        }
        if (p_keyPressed_1_.getKeyCode() == 57) {
            this.func_1266_a(0);
        }
        if (p_keyPressed_1_.getKeyCode() == 112) {
            this.func_1270_b("World1");
        }
        if (p_keyPressed_1_.getKeyCode() == 113) {
            this.func_1270_b("World2");
        }
        if (p_keyPressed_1_.getKeyCode() == 114) {
            this.func_1270_b("World3");
        }
        if (p_keyPressed_1_.getKeyCode() == 115) {
            this.func_1270_b("World4");
        }
        if (p_keyPressed_1_.getKeyCode() == 116) {
            this.func_1270_b("World5");
        }
        if (p_keyPressed_1_.getKeyCode() == 32) {
            this.field_1784_j = 0;
            this.field_1785_i = 0;
        }
        if (p_keyPressed_1_.getKeyCode() == 27) {
            this.field_1791_c = !this.field_1791_c;
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent p_keyReleased_1_) {
    }

    public void keyTyped(KeyEvent p_keyTyped_1_) {
    }

    static /* synthetic */ boolean func_1271_a(CanvasIsomPreview p_1271_0_) {
        return p_1271_0_.field_1788_f;
    }
}

