/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.AnvilConverterData;
import net.minecraft.src.AnvilSaveConverterFileFilter;
import net.minecraft.src.AnvilSaveHandler;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkLoader;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.RegionFile;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveFormatOld;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldInfo;
import net.minecraft.src.WorldType;

public class AnvilSaveConverter
extends SaveFormatOld {
    public AnvilSaveConverter(File p_i1034_1_) {
        super(p_i1034_1_);
    }

    public String func_22178_a() {
        return "Anvil";
    }

    public List func_22176_b() {
        File[] fileArray;
        ArrayList<SaveFormatComparator> arrayList = new ArrayList<SaveFormatComparator>();
        for (File file : fileArray = this.field_22180_a.listFiles()) {
            String string;
            WorldInfo worldInfo;
            if (!file.isDirectory() || (worldInfo = this.func_22173_b(string = file.getName())) == null || worldInfo.func_22296_k() != 19132 && worldInfo.func_22296_k() != 19133) continue;
            boolean bl = worldInfo.func_22296_k() != this.func_48431_c();
            String string2 = worldInfo.func_22302_j();
            if (string2 == null || MathHelper.func_22282_a(string2)) {
                string2 = string;
            }
            long l = 0L;
            arrayList.add(new SaveFormatComparator(string, string2, worldInfo.func_22301_l(), l, worldInfo.func_35918_q(), bl, worldInfo.func_40724_s()));
        }
        return arrayList;
    }

    protected int func_48431_c() {
        return 19133;
    }

    public void func_22177_c() {
        RegionFileCache.func_22192_a();
    }

    public ISaveHandler func_22174_a(String p_22174_1_, boolean p_22174_2_) {
        return new AnvilSaveHandler(this.field_22180_a, p_22174_1_, p_22174_2_);
    }

    public boolean func_22175_a(String p_22175_1_) {
        WorldInfo worldInfo = this.func_22173_b(p_22175_1_);
        return worldInfo != null && worldInfo.func_22296_k() != this.func_48431_c();
    }

    public boolean func_22171_a(String p_22171_1_, IProgressUpdate p_22171_2_) {
        p_22171_2_.func_593_a(0);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        File file = new File(this.field_22180_a, p_22171_1_);
        File file2 = new File(file, "DIM-1");
        File file3 = new File(file, "DIM1");
        System.out.println("Scanning folders...");
        this.func_48432_a(file, arrayList);
        if (file2.exists()) {
            this.func_48432_a(file2, arrayList2);
        }
        if (file3.exists()) {
            this.func_48432_a(file3, arrayList3);
        }
        int n = arrayList.size() + arrayList2.size() + arrayList3.size();
        System.out.println("Total conversion count is " + n);
        WorldInfo worldInfo = this.func_22173_b(p_22171_1_);
        WorldChunkManager worldChunkManager = null;
        worldChunkManager = worldInfo.func_46133_t() == WorldType.field_48636_c ? new WorldChunkManagerHell(BiomeGenBase.field_35485_c, 0.5f, 0.5f) : new WorldChunkManager(worldInfo.func_22288_b(), worldInfo.func_46133_t());
        this.func_48428_a(new File(file, "region"), arrayList, worldChunkManager, 0, n, p_22171_2_);
        this.func_48428_a(new File(file2, "region"), arrayList2, new WorldChunkManagerHell(BiomeGenBase.field_4245_l, 1.0f, 0.0f), arrayList.size(), n, p_22171_2_);
        this.func_48428_a(new File(file3, "region"), arrayList3, new WorldChunkManagerHell(BiomeGenBase.field_28057_m, 0.5f, 0.0f), arrayList.size() + arrayList2.size(), n, p_22171_2_);
        worldInfo.func_22289_d(19133);
        if (worldInfo.func_46133_t() == WorldType.field_48634_d) {
            worldInfo.func_48619_a(WorldType.field_48635_b);
        }
        this.func_48429_d(p_22171_1_);
        ISaveHandler iSaveHandler = this.func_22174_a(p_22171_1_, false);
        iSaveHandler.func_22152_a(worldInfo);
        return true;
    }

    private void func_48429_d(String p_48429_1_) {
        File file = new File(this.field_22180_a, p_48429_1_);
        if (!file.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file2 = new File(file, "level.dat");
        if (!file2.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file3 = new File(file, "level.dat_mcr");
        if (!file2.renameTo(file3)) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
        }
    }

    private void func_48428_a(File p_48428_1_, ArrayList p_48428_2_, WorldChunkManager p_48428_3_, int p_48428_4_, int p_48428_5_, IProgressUpdate p_48428_6_) {
        for (File file : p_48428_2_) {
            this.func_48430_a(p_48428_1_, file, p_48428_3_, p_48428_4_, p_48428_5_, p_48428_6_);
            int n = (int)Math.round(100.0 * (double)(++p_48428_4_) / (double)p_48428_5_);
            p_48428_6_.func_593_a(n);
        }
    }

    private void func_48430_a(File p_48430_1_, File p_48430_2_, WorldChunkManager p_48430_3_, int p_48430_4_, int p_48430_5_, IProgressUpdate p_48430_6_) {
        try {
            String string = p_48430_2_.getName();
            RegionFile regionFile = new RegionFile(p_48430_2_);
            RegionFile regionFile2 = new RegionFile(new File(p_48430_1_, string.substring(0, string.length() - ".mcr".length()) + ".mca"));
            for (int i = 0; i < 32; ++i) {
                int n;
                for (n = 0; n < 32; ++n) {
                    if (!regionFile.func_22202_c(i, n) || regionFile2.func_22202_c(i, n)) continue;
                    DataInputStream dataInputStream = regionFile.func_22210_a(i, n);
                    if (dataInputStream == null) {
                        System.out.println("Failed to fetch input stream");
                        continue;
                    }
                    NBTTagCompound nBTTagCompound = CompressedStreamTools.func_1141_a(dataInputStream);
                    dataInputStream.close();
                    NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_743_k("Level");
                    AnvilConverterData anvilConverterData = ChunkLoader.func_48485_a(nBTTagCompound2);
                    NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                    NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
                    nBTTagCompound3.func_762_a("Level", nBTTagCompound4);
                    ChunkLoader.func_48486_a(anvilConverterData, nBTTagCompound4, p_48430_3_);
                    DataOutputStream dataOutputStream = regionFile2.func_22205_b(i, n);
                    CompressedStreamTools.func_1139_a(nBTTagCompound3, dataOutputStream);
                    dataOutputStream.close();
                }
                n = (int)Math.round(100.0 * (double)(p_48430_4_ * 1024) / (double)(p_48430_5_ * 1024));
                int n2 = (int)Math.round(100.0 * (double)((i + 1) * 32 + p_48430_4_ * 1024) / (double)(p_48430_5_ * 1024));
                if (n2 <= n) continue;
                p_48430_6_.func_593_a(n2);
            }
            regionFile.func_22196_b();
            regionFile2.func_22196_b();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_48432_a(File p_48432_1_, ArrayList p_48432_2_) {
        File file = new File(p_48432_1_, "region");
        File[] fileArray = file.listFiles(new AnvilSaveConverterFileFilter(this));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                p_48432_2_.add(file2);
            }
        }
    }
}

