/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.LocalVariableTypeInfo;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalVariableTypeTableAttrInfo
extends AttrInfo {
    private List<LocalVariableTypeInfo> localVariableTypeTable;

    protected LocalVariableTypeTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "LocalVariableTypeTable";
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (LocalVariableTypeInfo lvt : this.localVariableTypeTable) {
            lvt.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2localVariableTypeTableLength = din.readUnsignedShort();
        this.localVariableTypeTable = new ArrayList<LocalVariableTypeInfo>(u2localVariableTypeTableLength);
        for (int i = 0; i < u2localVariableTypeTableLength; ++i) {
            this.localVariableTypeTable.add(LocalVariableTypeInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.localVariableTypeTable.size());
        for (LocalVariableTypeInfo lvt : this.localVariableTypeTable) {
            lvt.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (LocalVariableTypeInfo lvt : this.localVariableTypeTable) {
            lvt.remap(cf, nm);
        }
    }
}

