/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.IsoImageBuffer;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class TerrainTextureManager {
    private float[] field_1181_a = new float[768];
    private int[] field_1180_b = new int[17408];
    private int[] field_1186_c = new int[17408];
    private int[] field_1185_d = new int[17408];
    private int[] field_1184_e = new int[17408];
    private int[] field_1183_f = new int[34];
    private int[] field_1182_g = new int[768];

    public TerrainTextureManager() {
        try {
            BufferedImage bufferedImage = ImageIO.read(TerrainTextureManager.class.getResource("/terrain.png"));
            int[] nArray = new int[65536];
            bufferedImage.getRGB(0, 0, 256, 256, nArray, 0, 256);
            for (int i = 0; i < 256; ++i) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = i % 16 * 16;
                int n5 = i / 16 * 16;
                int n6 = 0;
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        int n7 = nArray[k + n4 + (j + n5) * 256];
                        int n8 = n7 >> 24 & 0xFF;
                        if (n8 <= 128) continue;
                        n += n7 >> 16 & 0xFF;
                        n2 += n7 >> 8 & 0xFF;
                        n3 += n7 & 0xFF;
                        ++n6;
                    }
                    if (n6 == 0) {
                        ++n6;
                    }
                    this.field_1181_a[i * 3 + 0] = n / n6;
                    this.field_1181_a[i * 3 + 1] = n2 / n6;
                    this.field_1181_a[i * 3 + 2] = n3 / n6;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = 0; i < 4096; ++i) {
            if (Block.field_345_n[i] == null) continue;
            this.field_1182_g[i * 3 + 0] = Block.field_345_n[i].func_218_a(1);
            this.field_1182_g[i * 3 + 1] = Block.field_345_n[i].func_218_a(2);
            this.field_1182_g[i * 3 + 2] = Block.field_345_n[i].func_218_a(3);
        }
    }

    public void func_799_a(IsoImageBuffer isoImageBuffer) {
        World world = isoImageBuffer.field_1347_b;
        if (world == null) {
            isoImageBuffer.field_1351_f = true;
            isoImageBuffer.field_1352_e = true;
            return;
        }
        int n = isoImageBuffer.field_1354_c * 16;
        int n2 = isoImageBuffer.field_1353_d * 16;
        int n3 = n + 16;
        int n4 = n2 + 16;
        Chunk chunk = world.func_704_b(isoImageBuffer.field_1354_c, isoImageBuffer.field_1353_d);
        if (chunk.func_21167_h()) {
            isoImageBuffer.field_1351_f = true;
            isoImageBuffer.field_1352_e = true;
            return;
        }
        isoImageBuffer.field_1351_f = false;
        Arrays.fill(this.field_1186_c, 0);
        Arrays.fill(this.field_1185_d, 0);
        Arrays.fill(this.field_1183_f, 544);
        for (int i = n4 - 1; i >= n2; --i) {
            for (int j = n3 - 1; j >= n; --j) {
                int n5 = j - n;
                int n6 = i - n2;
                int n7 = n5 + n6;
                boolean bl = true;
                for (int k = 0; k < 128; ++k) {
                    float f;
                    float f2;
                    int n8;
                    int n9 = n6 - n5 - k + 544 - 16;
                    if (n9 >= this.field_1183_f[n7] && n9 >= this.field_1183_f[n7 + 1]) continue;
                    Block block = Block.field_345_n[world.func_600_a(j, k, i)];
                    if (block == null) {
                        bl = false;
                        continue;
                    }
                    if (block.field_356_bn == Material.field_1332_f) {
                        int n10 = world.func_600_a(j, k + 1, i);
                        if (n10 != 0 && Block.field_345_n[n10].field_356_bn == Material.field_1332_f) continue;
                        float f3 = (float)k / 127.0f * 0.6f + 0.4f;
                        float f4 = world.func_598_c(j, k + 1, i) * f3;
                        if (n9 < 0 || n9 >= 544) continue;
                        int n11 = n7 + n9 * 32;
                        if (n7 >= 0 && n7 <= 32 && this.field_1185_d[n11] <= k) {
                            this.field_1185_d[n11] = k;
                            this.field_1184_e[n11] = (int)(f4 * 127.0f);
                        }
                        if (n7 >= -1 && n7 <= 31 && this.field_1185_d[n11 + 1] <= k) {
                            this.field_1185_d[n11 + 1] = k;
                            this.field_1184_e[n11 + 1] = (int)(f4 * 127.0f);
                        }
                        bl = false;
                        continue;
                    }
                    if (bl) {
                        if (n9 < this.field_1183_f[n7]) {
                            this.field_1183_f[n7] = n9;
                        }
                        if (n9 < this.field_1183_f[n7 + 1]) {
                            this.field_1183_f[n7 + 1] = n9;
                        }
                    }
                    float f5 = (float)k / 127.0f * 0.6f + 0.4f;
                    if (n9 >= 0 && n9 < 544) {
                        int n12 = n7 + n9 * 32;
                        int n13 = this.field_1182_g[block.field_376_bc * 3 + 0];
                        float f6 = (world.func_598_c(j, k + 1, i) * 0.8f + 0.2f) * f5;
                        n8 = n13;
                        if (n7 >= 0) {
                            f2 = f6;
                            if (this.field_1186_c[n12] <= k) {
                                this.field_1186_c[n12] = k;
                                this.field_1180_b[n12] = 0xFF000000 | (int)(this.field_1181_a[n8 * 3 + 0] * f2) << 16 | (int)(this.field_1181_a[n8 * 3 + 1] * f2) << 8 | (int)(this.field_1181_a[n8 * 3 + 2] * f2);
                            }
                        }
                        if (n7 < 31) {
                            f2 = f6 * 0.9f;
                            if (this.field_1186_c[n12 + 1] <= k) {
                                this.field_1186_c[n12 + 1] = k;
                                this.field_1180_b[n12 + 1] = 0xFF000000 | (int)(this.field_1181_a[n8 * 3 + 0] * f2) << 16 | (int)(this.field_1181_a[n8 * 3 + 1] * f2) << 8 | (int)(this.field_1181_a[n8 * 3 + 2] * f2);
                            }
                        }
                    }
                    if (n9 < -1 || n9 >= 543) continue;
                    int n14 = n7 + (n9 + 1) * 32;
                    int n15 = this.field_1182_g[block.field_376_bc * 3 + 1];
                    float f7 = world.func_598_c(j - 1, k, i) * 0.8f + 0.2f;
                    n8 = this.field_1182_g[block.field_376_bc * 3 + 2];
                    f2 = world.func_598_c(j, k, i + 1) * 0.8f + 0.2f;
                    if (n7 >= 0) {
                        f = f7 * f5 * 0.6f;
                        if (this.field_1186_c[n14] <= k - 1) {
                            this.field_1186_c[n14] = k - 1;
                            this.field_1180_b[n14] = 0xFF000000 | (int)(this.field_1181_a[n15 * 3 + 0] * f) << 16 | (int)(this.field_1181_a[n15 * 3 + 1] * f) << 8 | (int)(this.field_1181_a[n15 * 3 + 2] * f);
                        }
                    }
                    if (n7 >= 31) continue;
                    f = f2 * 0.9f * f5 * 0.4f;
                    if (this.field_1186_c[n14 + 1] > k - 1) continue;
                    this.field_1186_c[n14 + 1] = k - 1;
                    this.field_1180_b[n14 + 1] = 0xFF000000 | (int)(this.field_1181_a[n8 * 3 + 0] * f) << 16 | (int)(this.field_1181_a[n8 * 3 + 1] * f) << 8 | (int)(this.field_1181_a[n8 * 3 + 2] * f);
                }
            }
        }
        this.func_800_a();
        if (isoImageBuffer.field_1348_a == null) {
            isoImageBuffer.field_1348_a = new BufferedImage(32, 544, 2);
        }
        isoImageBuffer.field_1348_a.setRGB(0, 0, 32, 544, this.field_1180_b, 0, 32);
        isoImageBuffer.field_1352_e = true;
    }

    private void func_800_a() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 544; ++j) {
                int n = i + j * 32;
                if (this.field_1186_c[n] == 0) {
                    this.field_1180_b[n] = 0;
                }
                if (this.field_1185_d[n] <= this.field_1186_c[n]) continue;
                int n2 = this.field_1180_b[n] >> 24 & 0xFF;
                this.field_1180_b[n] = ((this.field_1180_b[n] & 0xFEFEFE) >> 1) + this.field_1184_e[n];
                if (n2 < 128) {
                    this.field_1180_b[n] = Integer.MIN_VALUE + this.field_1184_e[n] * 2;
                    continue;
                }
                int n3 = n;
                this.field_1180_b[n3] = this.field_1180_b[n3] | 0xFF000000;
            }
        }
    }
}

