/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.ImageBuffer;
import net.minecraft.src.IntHashMap;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.ThreadDownloadImageData;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public static boolean field_1609_a = false;
    private HashMap field_6528_b = new HashMap();
    private HashMap field_28151_c = new HashMap();
    private IntHashMap field_1607_c = new IntHashMap();
    private IntBuffer field_1606_d = GLAllocation.func_1125_c(1);
    private ByteBuffer field_1605_e = GLAllocation.func_1127_b(0x1000000);
    private List field_1604_f = new ArrayList();
    private Map field_1603_g = new HashMap();
    private GameSettings field_1602_h;
    public boolean field_4281_i = false;
    public boolean field_4280_j = false;
    private TexturePackList field_6527_k;
    private BufferedImage field_25189_l = new BufferedImage(64, 64, 2);
    private int field_48512_n = 16;

    public RenderEngine(TexturePackList texturePackList, GameSettings gameSettings) {
        this.field_6527_k = texturePackList;
        this.field_1602_h = gameSettings;
        Graphics graphics = this.field_25189_l.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(Color.BLACK);
        graphics.drawString("missingtex", 1, 10);
        graphics.dispose();
    }

    public int[] func_28149_a(String string) {
        TexturePackBase texturePackBase = this.field_6527_k.field_6534_a;
        int[] nArray = (int[])this.field_28151_c.get(string);
        if (nArray != null) {
            return nArray;
        }
        try {
            nArray = null;
            if (string.startsWith("##")) {
                nArray = this.func_28148_b(this.func_1069_b(this.func_6526_a(texturePackBase.func_6481_a(string.substring(2)))));
            } else if (string.startsWith("%clamp%")) {
                this.field_4281_i = true;
                nArray = this.func_28148_b(this.func_6526_a(texturePackBase.func_6481_a(string.substring(7))));
                this.field_4281_i = false;
            } else if (string.startsWith("%blur%")) {
                this.field_4280_j = true;
                this.field_4281_i = true;
                nArray = this.func_28148_b(this.func_6526_a(texturePackBase.func_6481_a(string.substring(6))));
                this.field_4281_i = false;
                this.field_4280_j = false;
            } else {
                InputStream inputStream = texturePackBase.func_6481_a(string);
                nArray = inputStream == null ? this.func_28148_b(this.field_25189_l) : this.func_28148_b(this.func_6526_a(inputStream));
            }
            this.field_28151_c.put(string, nArray);
            return nArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            int[] nArray2 = this.func_28148_b(this.field_25189_l);
            this.field_28151_c.put(string, nArray2);
            return nArray2;
        }
    }

    private int[] func_28148_b(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        return nArray;
    }

    private int[] func_28147_a(BufferedImage bufferedImage, int[] nArray) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        return nArray;
    }

    public int func_1070_a(String string) {
        TexturePackBase texturePackBase = this.field_6527_k.field_6534_a;
        Integer n = (Integer)this.field_6528_b.get(string);
        if (n != null) {
            return n;
        }
        try {
            this.field_1606_d.clear();
            GLAllocation.func_1128_a(this.field_1606_d);
            int n2 = this.field_1606_d.get(0);
            if (string.startsWith("##")) {
                this.func_1068_a(this.func_1069_b(this.func_6526_a(texturePackBase.func_6481_a(string.substring(2)))), n2);
            } else if (string.startsWith("%clamp%")) {
                this.field_4281_i = true;
                this.func_1068_a(this.func_6526_a(texturePackBase.func_6481_a(string.substring(7))), n2);
                this.field_4281_i = false;
            } else if (string.startsWith("%blur%")) {
                this.field_4280_j = true;
                this.func_1068_a(this.func_6526_a(texturePackBase.func_6481_a(string.substring(6))), n2);
                this.field_4280_j = false;
            } else if (string.startsWith("%blurclamp%")) {
                this.field_4280_j = true;
                this.field_4281_i = true;
                this.func_1068_a(this.func_6526_a(texturePackBase.func_6481_a(string.substring(11))), n2);
                this.field_4280_j = false;
                this.field_4281_i = false;
            } else {
                InputStream inputStream = texturePackBase.func_6481_a(string);
                if (inputStream == null) {
                    this.func_1068_a(this.field_25189_l, n2);
                } else {
                    this.func_1068_a(this.func_6526_a(inputStream), n2);
                }
            }
            this.field_6528_b.put(string, n2);
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GLAllocation.func_1128_a(this.field_1606_d);
            int n3 = this.field_1606_d.get(0);
            this.func_1068_a(this.field_25189_l, n3);
            this.field_6528_b.put(string, n3);
            return n3;
        }
    }

    private BufferedImage func_1069_b(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth() / 16;
        BufferedImage bufferedImage2 = new BufferedImage(16, bufferedImage.getHeight() * n, 2);
        Graphics graphics = bufferedImage2.getGraphics();
        for (int i = 0; i < n; ++i) {
            graphics.drawImage(bufferedImage, -i * 16, i * bufferedImage.getHeight(), null);
        }
        graphics.dispose();
        return bufferedImage2;
    }

    public int func_1074_a(BufferedImage bufferedImage) {
        this.field_1606_d.clear();
        GLAllocation.func_1128_a(this.field_1606_d);
        int n = this.field_1606_d.get(0);
        this.func_1068_a(bufferedImage, n);
        this.field_1607_c.func_1061_a(n, bufferedImage);
        return n;
    }

    public void func_1068_a(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        GL11.glBindTexture((int)3553, (int)n);
        if (field_1609_a) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.field_4280_j) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.field_4281_i) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int n10 = bufferedImage.getWidth();
        int n11 = bufferedImage.getHeight();
        int[] nArray = new int[n10 * n11];
        byte[] byArray = new byte[n10 * n11 * 4];
        bufferedImage.getRGB(0, 0, n10, n11, nArray, 0, n10);
        for (n9 = 0; n9 < nArray.length; ++n9) {
            n8 = nArray[n9] >> 24 & 0xFF;
            n7 = nArray[n9] >> 16 & 0xFF;
            n6 = nArray[n9] >> 8 & 0xFF;
            n5 = nArray[n9] & 0xFF;
            if (this.field_1602_h != null && this.field_1602_h.field_1578_g) {
                n4 = (n7 * 30 + n6 * 59 + n5 * 11) / 100;
                n3 = (n7 * 30 + n6 * 70) / 100;
                n2 = (n7 * 30 + n5 * 70) / 100;
                n7 = n4;
                n6 = n3;
                n5 = n2;
            }
            byArray[n9 * 4 + 0] = (byte)n7;
            byArray[n9 * 4 + 1] = (byte)n6;
            byArray[n9 * 4 + 2] = (byte)n5;
            byArray[n9 * 4 + 3] = (byte)n8;
        }
        this.field_1605_e.clear();
        this.field_1605_e.put(byArray);
        this.field_1605_e.position(0).limit(byArray.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)n10, (int)n11, (int)0, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
        if (field_1609_a) {
            for (n9 = 1; n9 <= 4; ++n9) {
                n8 = n10 >> n9 - 1;
                n7 = n10 >> n9;
                n6 = n11 >> n9;
                for (n5 = 0; n5 < n7; ++n5) {
                    for (n4 = 0; n4 < n6; ++n4) {
                        n3 = this.field_1605_e.getInt((n5 * 2 + 0 + (n4 * 2 + 0) * n8) * 4);
                        n2 = this.field_1605_e.getInt((n5 * 2 + 1 + (n4 * 2 + 0) * n8) * 4);
                        int n12 = this.field_1605_e.getInt((n5 * 2 + 1 + (n4 * 2 + 1) * n8) * 4);
                        int n13 = this.field_1605_e.getInt((n5 * 2 + 0 + (n4 * 2 + 1) * n8) * 4);
                        int n14 = this.func_1077_b(this.func_1077_b(n3, n2), this.func_1077_b(n12, n13));
                        this.field_1605_e.putInt((n5 + n4 * n7) * 4, n14);
                    }
                }
                GL11.glTexImage2D((int)3553, (int)n9, (int)6408, (int)n7, (int)n6, (int)0, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
            }
        }
    }

    public void func_28150_a(int[] nArray, int n, int n2, int n3) {
        GL11.glBindTexture((int)3553, (int)n3);
        if (field_1609_a) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.field_4280_j) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.field_4281_i) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        byte[] byArray = new byte[n * n2 * 4];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i] >> 24 & 0xFF;
            int n5 = nArray[i] >> 16 & 0xFF;
            int n6 = nArray[i] >> 8 & 0xFF;
            int n7 = nArray[i] & 0xFF;
            if (this.field_1602_h != null && this.field_1602_h.field_1578_g) {
                int n8 = (n5 * 30 + n6 * 59 + n7 * 11) / 100;
                int n9 = (n5 * 30 + n6 * 70) / 100;
                int n10 = (n5 * 30 + n7 * 70) / 100;
                n5 = n8;
                n6 = n9;
                n7 = n10;
            }
            byArray[i * 4 + 0] = (byte)n5;
            byArray[i * 4 + 1] = (byte)n6;
            byArray[i * 4 + 2] = (byte)n7;
            byArray[i * 4 + 3] = (byte)n4;
        }
        this.field_1605_e.clear();
        this.field_1605_e.put(byArray);
        this.field_1605_e.position(0).limit(byArray.length);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
    }

    public void func_1078_a(int n) {
        this.field_1607_c.func_1052_b(n);
        this.field_1606_d.clear();
        this.field_1606_d.put(n);
        this.field_1606_d.flip();
        GL11.glDeleteTextures((IntBuffer)this.field_1606_d);
    }

    public int func_1071_a(String string, String string2) {
        ThreadDownloadImageData threadDownloadImageData = (ThreadDownloadImageData)this.field_1603_g.get(string);
        if (threadDownloadImageData != null && threadDownloadImageData.field_1706_a != null && !threadDownloadImageData.field_1707_d) {
            if (threadDownloadImageData.field_1708_c < 0) {
                threadDownloadImageData.field_1708_c = this.func_1074_a(threadDownloadImageData.field_1706_a);
            } else {
                this.func_1068_a(threadDownloadImageData.field_1706_a, threadDownloadImageData.field_1708_c);
            }
            threadDownloadImageData.field_1707_d = true;
        }
        if (threadDownloadImageData == null || threadDownloadImageData.field_1708_c < 0) {
            if (string2 == null) {
                return -1;
            }
            return this.func_1070_a(string2);
        }
        return threadDownloadImageData.field_1708_c;
    }

    public ThreadDownloadImageData func_1075_a(String string, ImageBuffer imageBuffer) {
        ThreadDownloadImageData threadDownloadImageData = (ThreadDownloadImageData)this.field_1603_g.get(string);
        if (threadDownloadImageData == null) {
            this.field_1603_g.put(string, new ThreadDownloadImageData(string, imageBuffer));
        } else {
            ++threadDownloadImageData.field_1705_b;
        }
        return threadDownloadImageData;
    }

    public void func_1073_b(String string) {
        ThreadDownloadImageData threadDownloadImageData = (ThreadDownloadImageData)this.field_1603_g.get(string);
        if (threadDownloadImageData != null) {
            --threadDownloadImageData.field_1705_b;
            if (threadDownloadImageData.field_1705_b == 0) {
                if (threadDownloadImageData.field_1708_c >= 0) {
                    this.func_1078_a(threadDownloadImageData.field_1708_c);
                }
                this.field_1603_g.remove(string);
            }
        }
    }

    public void func_1066_a(TextureFX textureFX) {
        this.field_1604_f.add(textureFX);
        textureFX.func_783_a();
    }

    public void func_1067_a() {
        int n = -1;
        for (int i = 0; i < this.field_1604_f.size(); ++i) {
            TextureFX textureFX = (TextureFX)this.field_1604_f.get(i);
            textureFX.field_1131_c = this.field_1602_h.field_1578_g;
            textureFX.func_783_a();
            this.field_1605_e.clear();
            this.field_1605_e.put(textureFX.field_1127_a);
            this.field_1605_e.position(0).limit(textureFX.field_1127_a.length);
            if (textureFX.field_1126_b != n) {
                textureFX.func_782_a(this);
                n = textureFX.field_1126_b;
            }
            for (int j = 0; j < textureFX.field_1129_e; ++j) {
                for (int k = 0; k < textureFX.field_1129_e; ++k) {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)(textureFX.field_1126_b % 16 * 16 + j * 16), (int)(textureFX.field_1126_b / 16 * 16 + k * 16), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                }
            }
        }
    }

    private int func_1077_b(int n, int n2) {
        int n3 = (n & 0xFF000000) >> 24 & 0xFF;
        int n4 = (n2 & 0xFF000000) >> 24 & 0xFF;
        int n5 = 255;
        if (n3 + n4 < 255) {
            n5 = 0;
            n3 = 1;
            n4 = 1;
        } else if (n3 > n4) {
            n3 = 255;
            n4 = 1;
        } else {
            n3 = 1;
            n4 = 255;
        }
        int n6 = (n >> 16 & 0xFF) * n3;
        int n7 = (n >> 8 & 0xFF) * n3;
        int n8 = (n & 0xFF) * n3;
        int n9 = (n2 >> 16 & 0xFF) * n4;
        int n10 = (n2 >> 8 & 0xFF) * n4;
        int n11 = (n2 & 0xFF) * n4;
        int n12 = (n6 + n9) / (n3 + n4);
        int n13 = (n7 + n10) / (n3 + n4);
        int n14 = (n8 + n11) / (n3 + n4);
        return n5 << 24 | n12 << 16 | n13 << 8 | n14;
    }

    public void func_1065_b() {
        BufferedImage bufferedImage;
        TexturePackBase texturePackBase = this.field_6527_k.field_6534_a;
        Iterator<Object> iterator = this.field_1607_c.func_35860_b().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            bufferedImage = (BufferedImage)this.field_1607_c.func_1057_a(n);
            this.func_1068_a(bufferedImage, n);
        }
        for (ThreadDownloadImageData threadDownloadImageData : this.field_1603_g.values()) {
            threadDownloadImageData.field_1707_d = false;
        }
        for (String string : this.field_6528_b.keySet()) {
            try {
                if (string.startsWith("##")) {
                    bufferedImage = this.func_1069_b(this.func_6526_a(texturePackBase.func_6481_a(string.substring(2))));
                } else if (string.startsWith("%clamp%")) {
                    this.field_4281_i = true;
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string.substring(7)));
                } else if (string.startsWith("%blur%")) {
                    this.field_4280_j = true;
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string.substring(6)));
                } else if (string.startsWith("%blurclamp%")) {
                    this.field_4280_j = true;
                    this.field_4281_i = true;
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string.substring(11)));
                } else {
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string));
                }
                int n = (Integer)this.field_6528_b.get(string);
                this.func_1068_a(bufferedImage, n);
                this.field_4280_j = false;
                this.field_4281_i = false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        for (String string : this.field_28151_c.keySet()) {
            try {
                if (string.startsWith("##")) {
                    bufferedImage = this.func_1069_b(this.func_6526_a(texturePackBase.func_6481_a(string.substring(2))));
                } else if (string.startsWith("%clamp%")) {
                    this.field_4281_i = true;
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string.substring(7)));
                } else if (string.startsWith("%blur%")) {
                    this.field_4280_j = true;
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string.substring(6)));
                } else {
                    bufferedImage = this.func_6526_a(texturePackBase.func_6481_a(string));
                }
                this.func_28147_a(bufferedImage, (int[])this.field_28151_c.get(string));
                this.field_4280_j = false;
                this.field_4281_i = false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private BufferedImage func_6526_a(InputStream inputStream) {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        inputStream.close();
        return bufferedImage;
    }

    public void func_1076_b(int n) {
        if (n < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)n);
    }
}

