/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.src.RegionFileChunkBuffer;

public class RegionFile {
    private static final byte[] field_22213_a = new byte[4096];
    private final File field_22212_b;
    private RandomAccessFile field_22219_c;
    private final int[] field_22218_d = new int[1024];
    private final int[] field_22217_e = new int[1024];
    private ArrayList field_22216_f;
    private int field_22215_g;
    private long field_22214_h = 0L;

    public RegionFile(File file) {
        this.field_22212_b = file;
        this.func_22204_b("REGION LOAD " + this.field_22212_b);
        this.field_22215_g = 0;
        try {
            int n;
            int n2;
            int n3;
            if (file.exists()) {
                this.field_22214_h = file.lastModified();
            }
            this.field_22219_c = new RandomAccessFile(file, "rw");
            if (this.field_22219_c.length() < 4096L) {
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.field_22219_c.writeInt(0);
                }
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.field_22219_c.writeInt(0);
                }
                this.field_22215_g += 8192;
            }
            if ((this.field_22219_c.length() & 0xFFFL) != 0L) {
                n3 = 0;
                while ((long)n3 < (this.field_22219_c.length() & 0xFFFL)) {
                    this.field_22219_c.write(0);
                    ++n3;
                }
            }
            n3 = (int)this.field_22219_c.length() / 4096;
            this.field_22216_f = new ArrayList(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.field_22216_f.add(true);
            }
            this.field_22216_f.set(0, false);
            this.field_22216_f.set(1, false);
            this.field_22219_c.seek(0L);
            for (n2 = 0; n2 < 1024; ++n2) {
                this.field_22218_d[n2] = n = this.field_22219_c.readInt();
                if (n == 0 || (n >> 8) + (n & 0xFF) > this.field_22216_f.size()) continue;
                for (int i = 0; i < (n & 0xFF); ++i) {
                    this.field_22216_f.set((n >> 8) + i, false);
                }
            }
            for (n2 = 0; n2 < 1024; ++n2) {
                this.field_22217_e[n2] = n = this.field_22219_c.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_22211_a(String string) {
    }

    private void func_22204_b(String string) {
        this.func_22211_a(string + "\n");
    }

    private void func_22199_a(String string, int n, int n2, String string2) {
        this.func_22211_a("REGION " + string + " " + this.field_22212_b.getName() + "[" + n + "," + n2 + "] = " + string2);
    }

    private void func_22197_a(String string, int n, int n2, int n3, String string2) {
        this.func_22211_a("REGION " + string + " " + this.field_22212_b.getName() + "[" + n + "," + n2 + "] " + n3 + "B = " + string2);
    }

    private void func_22201_b(String string, int n, int n2, String string2) {
        this.func_22199_a(string, n, n2, string2 + "\n");
    }

    public synchronized DataInputStream func_22210_a(int n, int n2) {
        if (this.func_22206_d(n, n2)) {
            this.func_22201_b("READ", n, n2, "out of bounds");
            return null;
        }
        try {
            int n3 = this.func_22207_e(n, n2);
            if (n3 == 0) {
                return null;
            }
            int n4 = n3 >> 8;
            int n5 = n3 & 0xFF;
            if (n4 + n5 > this.field_22216_f.size()) {
                this.func_22201_b("READ", n, n2, "invalid sector");
                return null;
            }
            this.field_22219_c.seek(n4 * 4096);
            int n6 = this.field_22219_c.readInt();
            if (n6 > 4096 * n5) {
                this.func_22201_b("READ", n, n2, "invalid length: " + n6 + " > 4096 * " + n5);
                return null;
            }
            if (n6 <= 0) {
                this.func_22201_b("READ", n, n2, "invalid length: " + n6 + " < 1");
                return null;
            }
            byte by = this.field_22219_c.readByte();
            if (by == 1) {
                byte[] byArray = new byte[n6 - 1];
                this.field_22219_c.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
                return dataInputStream;
            }
            if (by == 2) {
                byte[] byArray = new byte[n6 - 1];
                this.field_22219_c.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray))));
                return dataInputStream;
            }
            this.func_22201_b("READ", n, n2, "unknown version " + by);
            return null;
        }
        catch (IOException iOException) {
            this.func_22201_b("READ", n, n2, "exception");
            return null;
        }
    }

    public DataOutputStream func_22205_b(int n, int n2) {
        if (this.func_22206_d(n, n2)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, n, n2)));
    }

    protected synchronized void func_22203_a(int n, int n2, byte[] byArray, int n3) {
        try {
            int n4 = this.func_22207_e(n, n2);
            int n5 = n4 >> 8;
            int n6 = n4 & 0xFF;
            int n7 = (n3 + 5) / 4096 + 1;
            if (n7 >= 256) {
                return;
            }
            if (n5 != 0 && n6 == n7) {
                this.func_22197_a("SAVE", n, n2, n3, "rewrite");
                this.func_22200_a(n5, byArray, n3);
            } else {
                int n8;
                int n9;
                for (n9 = 0; n9 < n6; ++n9) {
                    this.field_22216_f.set(n5 + n9, true);
                }
                n9 = this.field_22216_f.indexOf(true);
                int n10 = 0;
                if (n9 != -1) {
                    for (n8 = n9; n8 < this.field_22216_f.size(); ++n8) {
                        if (n10 != 0) {
                            n10 = ((Boolean)this.field_22216_f.get(n8)).booleanValue() ? ++n10 : 0;
                        } else if (((Boolean)this.field_22216_f.get(n8)).booleanValue()) {
                            n9 = n8;
                            n10 = 1;
                        }
                        if (n10 >= n7) break;
                    }
                }
                if (n10 >= n7) {
                    this.func_22197_a("SAVE", n, n2, n3, "reuse");
                    n5 = n9;
                    this.func_22198_a(n, n2, n5 << 8 | n7);
                    for (n8 = 0; n8 < n7; ++n8) {
                        this.field_22216_f.set(n5 + n8, false);
                    }
                    this.func_22200_a(n5, byArray, n3);
                } else {
                    this.func_22197_a("SAVE", n, n2, n3, "grow");
                    this.field_22219_c.seek(this.field_22219_c.length());
                    n5 = this.field_22216_f.size();
                    for (n8 = 0; n8 < n7; ++n8) {
                        this.field_22219_c.write(field_22213_a);
                        this.field_22216_f.add(false);
                    }
                    this.field_22215_g += 4096 * n7;
                    this.func_22200_a(n5, byArray, n3);
                    this.func_22198_a(n, n2, n5 << 8 | n7);
                }
            }
            this.func_22208_b(n, n2, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_22200_a(int n, byte[] byArray, int n2) {
        this.func_22204_b(" " + n);
        this.field_22219_c.seek(n * 4096);
        this.field_22219_c.writeInt(n2 + 1);
        this.field_22219_c.writeByte(2);
        this.field_22219_c.write(byArray, 0, n2);
    }

    private boolean func_22206_d(int n, int n2) {
        return n < 0 || n >= 32 || n2 < 0 || n2 >= 32;
    }

    private int func_22207_e(int n, int n2) {
        return this.field_22218_d[n + n2 * 32];
    }

    public boolean func_22202_c(int n, int n2) {
        return this.func_22207_e(n, n2) != 0;
    }

    private void func_22198_a(int n, int n2, int n3) {
        this.field_22218_d[n + n2 * 32] = n3;
        this.field_22219_c.seek((n + n2 * 32) * 4);
        this.field_22219_c.writeInt(n3);
    }

    private void func_22208_b(int n, int n2, int n3) {
        this.field_22217_e[n + n2 * 32] = n3;
        this.field_22219_c.seek(4096 + (n + n2 * 32) * 4);
        this.field_22219_c.writeInt(n3);
    }

    public void func_22196_b() {
        this.field_22219_c.close();
    }
}

