/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IntHashMap;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet0KeepAlive;
import net.minecraft.src.Packet100OpenWindow;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet102WindowClick;
import net.minecraft.src.Packet103SetSlot;
import net.minecraft.src.Packet104WindowItems;
import net.minecraft.src.Packet105UpdateProgressbar;
import net.minecraft.src.Packet106Transaction;
import net.minecraft.src.Packet107CreativeSetSlot;
import net.minecraft.src.Packet108EnchantItem;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet11PlayerPosition;
import net.minecraft.src.Packet12PlayerLook;
import net.minecraft.src.Packet130UpdateSign;
import net.minecraft.src.Packet131MapData;
import net.minecraft.src.Packet132TileEntityData;
import net.minecraft.src.Packet13PlayerLookMove;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet17Sleep;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet19EntityAction;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet200Statistic;
import net.minecraft.src.Packet201PlayerInfo;
import net.minecraft.src.Packet202PlayerAbilities;
import net.minecraft.src.Packet20NamedEntitySpawn;
import net.minecraft.src.Packet21PickupSpawn;
import net.minecraft.src.Packet22Collect;
import net.minecraft.src.Packet23VehicleSpawn;
import net.minecraft.src.Packet24MobSpawn;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.Packet254ServerPing;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet25EntityPainting;
import net.minecraft.src.Packet26EntityExpOrb;
import net.minecraft.src.Packet28EntityVelocity;
import net.minecraft.src.Packet29DestroyEntity;
import net.minecraft.src.Packet2Handshake;
import net.minecraft.src.Packet30Entity;
import net.minecraft.src.Packet31RelEntityMove;
import net.minecraft.src.Packet32EntityLook;
import net.minecraft.src.Packet33RelEntityMoveLook;
import net.minecraft.src.Packet34EntityTeleport;
import net.minecraft.src.Packet35EntityHeadRotation;
import net.minecraft.src.Packet38EntityStatus;
import net.minecraft.src.Packet39AttachEntity;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet40EntityMetadata;
import net.minecraft.src.Packet41EntityEffect;
import net.minecraft.src.Packet42RemoveEntityEffect;
import net.minecraft.src.Packet43Experience;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet50PreChunk;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet52MultiBlockChange;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.Packet54PlayNoteBlock;
import net.minecraft.src.Packet5PlayerInventory;
import net.minecraft.src.Packet60Explosion;
import net.minecraft.src.Packet61DoorChange;
import net.minecraft.src.Packet6SpawnPosition;
import net.minecraft.src.Packet70Bed;
import net.minecraft.src.Packet71Weather;
import net.minecraft.src.Packet7UseEntity;
import net.minecraft.src.Packet8UpdateHealth;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.PacketCount;

public abstract class Packet {
    public static IntHashMap field_471_a = new IntHashMap();
    private static Map field_470_b = new HashMap();
    private static Set field_26906_c = new HashSet();
    private static Set field_26905_d = new HashSet();
    public final long field_20018_j = System.currentTimeMillis();
    public static long field_48158_m;
    public static long field_48156_n;
    public static long field_48157_o;
    public static long field_48155_p;
    public boolean field_472_j = false;

    static void func_321_a(int n, boolean bl, boolean bl2, Class clazz) {
        if (field_471_a.func_35858_b(n)) {
            throw new IllegalArgumentException("Duplicate packet id:" + n);
        }
        if (field_470_b.containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate packet class:" + clazz);
        }
        field_471_a.func_1061_a(n, clazz);
        field_470_b.put(clazz, n);
        if (bl) {
            field_26906_c.add(n);
        }
        if (bl2) {
            field_26905_d.add(n);
        }
    }

    public static Packet func_325_a(int n) {
        try {
            Class clazz = (Class)field_471_a.func_1057_a(n);
            if (clazz == null) {
                return null;
            }
            return (Packet)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Skipping packet with id " + n);
            return null;
        }
    }

    public final int func_326_b() {
        return (Integer)field_470_b.get(this.getClass());
    }

    public static Packet func_324_b(DataInputStream dataInputStream, boolean bl) {
        int n = 0;
        Packet packet = null;
        try {
            n = dataInputStream.read();
            if (n == -1) {
                return null;
            }
            if (bl && !field_26905_d.contains(n) || !bl && !field_26906_c.contains(n)) {
                throw new IOException("Bad packet id " + n);
            }
            packet = Packet.func_325_a(n);
            if (packet == null) {
                throw new IOException("Bad packet id " + n);
            }
            packet.func_327_a(dataInputStream);
            ++field_48158_m;
            field_48156_n += (long)packet.func_329_a();
        }
        catch (EOFException eOFException) {
            System.out.println("Reached end of stream");
            return null;
        }
        PacketCount.func_40561_a(n, packet.func_329_a());
        ++field_48158_m;
        field_48156_n += (long)packet.func_329_a();
        return packet;
    }

    public static void func_328_a(Packet packet, DataOutputStream dataOutputStream) {
        dataOutputStream.write(packet.func_326_b());
        packet.func_322_a(dataOutputStream);
        ++field_48157_o;
        field_48155_p += (long)packet.func_329_a();
    }

    public static void func_27049_a(String string, DataOutputStream dataOutputStream) {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataOutputStream.writeShort(string.length());
        dataOutputStream.writeChars(string);
    }

    public static String func_27048_a(DataInputStream dataInputStream, int n) {
        int n2 = dataInputStream.readShort();
        if (n2 > n) {
            throw new IOException("Received string length longer than maximum allowed (" + n2 + " > " + n + ")");
        }
        if (n2 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(dataInputStream.readChar());
        }
        return stringBuilder.toString();
    }

    public abstract void func_327_a(DataInputStream var1);

    public abstract void func_322_a(DataOutputStream var1);

    public abstract void func_323_a(NetHandler var1);

    public abstract int func_329_a();

    protected ItemStack func_40187_b(DataInputStream dataInputStream) {
        ItemStack itemStack = null;
        short s = dataInputStream.readShort();
        if (s >= 0) {
            byte by = dataInputStream.readByte();
            short s2 = dataInputStream.readShort();
            itemStack = new ItemStack(s, (int)by, (int)s2);
            if (Item.field_233_c[s].func_25007_g() || Item.field_233_c[s].func_46056_k()) {
                itemStack.field_40715_d = this.func_40186_c(dataInputStream);
            }
        }
        return itemStack;
    }

    protected void func_40188_a(ItemStack itemStack, DataOutputStream dataOutputStream) {
        if (itemStack == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(itemStack.field_1617_c);
            dataOutputStream.writeByte(itemStack.field_1615_a);
            dataOutputStream.writeShort(itemStack.func_21181_i());
            if (itemStack.func_1091_a().func_25007_g() || itemStack.func_1091_a().func_46056_k()) {
                this.func_40189_a(itemStack.field_40715_d, dataOutputStream);
            }
        }
    }

    protected NBTTagCompound func_40186_c(DataInputStream dataInputStream) {
        short s = dataInputStream.readShort();
        if (s < 0) {
            return null;
        }
        byte[] byArray = new byte[s];
        dataInputStream.readFully(byArray);
        return CompressedStreamTools.func_40592_a(byArray);
    }

    protected void func_40189_a(NBTTagCompound nBTTagCompound, DataOutputStream dataOutputStream) {
        if (nBTTagCompound == null) {
            dataOutputStream.writeShort(-1);
        } else {
            byte[] byArray = CompressedStreamTools.func_40591_a(nBTTagCompound);
            dataOutputStream.writeShort((short)byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    static {
        Packet.func_321_a(0, true, true, Packet0KeepAlive.class);
        Packet.func_321_a(1, true, true, Packet1Login.class);
        Packet.func_321_a(2, true, true, Packet2Handshake.class);
        Packet.func_321_a(3, true, true, Packet3Chat.class);
        Packet.func_321_a(4, true, false, Packet4UpdateTime.class);
        Packet.func_321_a(5, true, false, Packet5PlayerInventory.class);
        Packet.func_321_a(6, true, false, Packet6SpawnPosition.class);
        Packet.func_321_a(7, false, true, Packet7UseEntity.class);
        Packet.func_321_a(8, true, false, Packet8UpdateHealth.class);
        Packet.func_321_a(9, true, true, Packet9Respawn.class);
        Packet.func_321_a(10, true, true, Packet10Flying.class);
        Packet.func_321_a(11, true, true, Packet11PlayerPosition.class);
        Packet.func_321_a(12, true, true, Packet12PlayerLook.class);
        Packet.func_321_a(13, true, true, Packet13PlayerLookMove.class);
        Packet.func_321_a(14, false, true, Packet14BlockDig.class);
        Packet.func_321_a(15, false, true, Packet15Place.class);
        Packet.func_321_a(16, false, true, Packet16BlockItemSwitch.class);
        Packet.func_321_a(17, true, false, Packet17Sleep.class);
        Packet.func_321_a(18, true, true, Packet18Animation.class);
        Packet.func_321_a(19, false, true, Packet19EntityAction.class);
        Packet.func_321_a(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.func_321_a(21, true, false, Packet21PickupSpawn.class);
        Packet.func_321_a(22, true, false, Packet22Collect.class);
        Packet.func_321_a(23, true, false, Packet23VehicleSpawn.class);
        Packet.func_321_a(24, true, false, Packet24MobSpawn.class);
        Packet.func_321_a(25, true, false, Packet25EntityPainting.class);
        Packet.func_321_a(26, true, false, Packet26EntityExpOrb.class);
        Packet.func_321_a(28, true, false, Packet28EntityVelocity.class);
        Packet.func_321_a(29, true, false, Packet29DestroyEntity.class);
        Packet.func_321_a(30, true, false, Packet30Entity.class);
        Packet.func_321_a(31, true, false, Packet31RelEntityMove.class);
        Packet.func_321_a(32, true, false, Packet32EntityLook.class);
        Packet.func_321_a(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.func_321_a(34, true, false, Packet34EntityTeleport.class);
        Packet.func_321_a(35, true, false, Packet35EntityHeadRotation.class);
        Packet.func_321_a(38, true, false, Packet38EntityStatus.class);
        Packet.func_321_a(39, true, false, Packet39AttachEntity.class);
        Packet.func_321_a(40, true, false, Packet40EntityMetadata.class);
        Packet.func_321_a(41, true, false, Packet41EntityEffect.class);
        Packet.func_321_a(42, true, false, Packet42RemoveEntityEffect.class);
        Packet.func_321_a(43, true, false, Packet43Experience.class);
        Packet.func_321_a(50, true, false, Packet50PreChunk.class);
        Packet.func_321_a(51, true, false, Packet51MapChunk.class);
        Packet.func_321_a(52, true, false, Packet52MultiBlockChange.class);
        Packet.func_321_a(53, true, false, Packet53BlockChange.class);
        Packet.func_321_a(54, true, false, Packet54PlayNoteBlock.class);
        Packet.func_321_a(60, true, false, Packet60Explosion.class);
        Packet.func_321_a(61, true, false, Packet61DoorChange.class);
        Packet.func_321_a(70, true, false, Packet70Bed.class);
        Packet.func_321_a(71, true, false, Packet71Weather.class);
        Packet.func_321_a(100, true, false, Packet100OpenWindow.class);
        Packet.func_321_a(101, true, true, Packet101CloseWindow.class);
        Packet.func_321_a(102, false, true, Packet102WindowClick.class);
        Packet.func_321_a(103, true, false, Packet103SetSlot.class);
        Packet.func_321_a(104, true, false, Packet104WindowItems.class);
        Packet.func_321_a(105, true, false, Packet105UpdateProgressbar.class);
        Packet.func_321_a(106, true, true, Packet106Transaction.class);
        Packet.func_321_a(107, true, true, Packet107CreativeSetSlot.class);
        Packet.func_321_a(108, false, true, Packet108EnchantItem.class);
        Packet.func_321_a(130, true, true, Packet130UpdateSign.class);
        Packet.func_321_a(131, true, false, Packet131MapData.class);
        Packet.func_321_a(132, true, false, Packet132TileEntityData.class);
        Packet.func_321_a(200, true, false, Packet200Statistic.class);
        Packet.func_321_a(201, true, false, Packet201PlayerInfo.class);
        Packet.func_321_a(202, true, true, Packet202PlayerAbilities.class);
        Packet.func_321_a(250, true, true, Packet250CustomPayload.class);
        Packet.func_321_a(254, false, true, Packet254ServerPing.class);
        Packet.func_321_a(255, true, true, Packet255KickDisconnect.class);
    }
}

