/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GameSettings;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private static final Pattern field_52015_r = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private int[] field_1307_b = new int[256];
    public int field_1308_a = 0;
    public int field_41063_b = 8;
    public Random field_41064_c = new Random();
    private byte[] field_44036_e = new byte[65536];
    private final int[] field_44034_f = new int[256];
    private int[] field_44035_g = new int[32];
    private int field_44038_h;
    private final RenderEngine field_44039_i;
    private float field_46126_j;
    private float field_46127_k;
    private boolean field_44037_j;
    private boolean field_46125_m;
    private float field_50115_n;
    private float field_50116_o;
    private float field_50118_p;
    private float field_50117_q;

    FontRenderer() {
        this.field_44039_i = null;
    }

    public FontRenderer(GameSettings gameSettings, String string, RenderEngine renderEngine, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        BufferedImage bufferedImage;
        this.field_44039_i = renderEngine;
        this.field_44037_j = bl;
        try {
            bufferedImage = ImageIO.read(RenderEngine.class.getResourceAsStream(string));
            InputStream inputStream = RenderEngine.class.getResourceAsStream("/font/glyph_sizes.bin");
            inputStream.read(this.field_44036_e);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n9 = bufferedImage.getWidth();
        int n10 = bufferedImage.getHeight();
        int[] nArray = new int[n9 * n10];
        bufferedImage.getRGB(0, 0, n9, n10, nArray, 0, n9);
        for (n8 = 0; n8 < 256; ++n8) {
            n7 = n8 % 16;
            n6 = n8 / 16;
            for (n5 = 7; n5 >= 0; --n5) {
                n4 = n7 * 8 + n5;
                n3 = 1;
                for (n2 = 0; n2 < 8 && n3 != 0; ++n2) {
                    n = (n6 * 8 + n2) * n9;
                    int n11 = nArray[n4 + n] & 0xFF;
                    if (n11 <= 0) continue;
                    n3 = 0;
                }
                if (n3 == 0) break;
            }
            if (n8 == 32) {
                n5 = 2;
            }
            this.field_1307_b[n8] = n5 + 2;
        }
        this.field_1308_a = renderEngine.func_1074_a(bufferedImage);
        for (n8 = 0; n8 < 32; ++n8) {
            n7 = (n8 >> 3 & 1) * 85;
            n6 = (n8 >> 2 & 1) * 170 + n7;
            n5 = (n8 >> 1 & 1) * 170 + n7;
            n4 = (n8 >> 0 & 1) * 170 + n7;
            if (n8 == 6) {
                n6 += 85;
            }
            if (gameSettings.field_1578_g) {
                n3 = (n6 * 30 + n5 * 59 + n4 * 11) / 100;
                n2 = (n6 * 30 + n5 * 70) / 100;
                n = (n6 * 30 + n4 * 70) / 100;
                n6 = n3;
                n5 = n2;
                n4 = n;
            }
            if (n8 >= 16) {
                n6 /= 4;
                n5 /= 4;
                n4 /= 4;
            }
            this.field_44035_g[n8] = (n6 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n4 & 0xFF;
        }
    }

    private float func_50112_a(int n, char c, boolean bl) {
        if (c == ' ') {
            return 4.0f;
        }
        if (n > 0 && !this.field_44037_j) {
            return this.func_50106_a(n + 32, bl);
        }
        return this.func_50111_a(c, bl);
    }

    private float func_50106_a(int n, boolean bl) {
        float f;
        float f2 = n % 16 * 8;
        float f3 = n / 16 * 8;
        float f4 = f = bl ? 1.0f : 0.0f;
        if (this.field_44038_h != this.field_1308_a) {
            GL11.glBindTexture((int)3553, (int)this.field_1308_a);
            this.field_44038_h = this.field_1308_a;
        }
        float f5 = (float)this.field_1307_b[n] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 128.0f), (float)(f3 / 128.0f));
        GL11.glVertex3f((float)(this.field_46126_j + f), (float)this.field_46127_k, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 128.0f), (float)((f3 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.field_46126_j - f), (float)(this.field_46127_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f5) / 128.0f), (float)(f3 / 128.0f));
        GL11.glVertex3f((float)(this.field_46126_j + f5 + f), (float)this.field_46127_k, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f5) / 128.0f), (float)((f3 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.field_46126_j + f5 - f), (float)(this.field_46127_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.field_1307_b[n];
    }

    private void func_44030_b(int n) {
        BufferedImage bufferedImage;
        String string = String.format("/font/glyph_%02X.png", n);
        try {
            bufferedImage = ImageIO.read(RenderEngine.class.getResourceAsStream(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_44034_f[n] = this.field_44039_i.func_1074_a(bufferedImage);
        this.field_44038_h = this.field_44034_f[n];
    }

    private float func_50111_a(char c, boolean bl) {
        if (this.field_44036_e[c] == 0) {
            return 0.0f;
        }
        int n = c / 256;
        if (this.field_44034_f[n] == 0) {
            this.func_44030_b(n);
        }
        if (this.field_44038_h != this.field_44034_f[n]) {
            GL11.glBindTexture((int)3553, (int)this.field_44034_f[n]);
            this.field_44038_h = this.field_44034_f[n];
        }
        int n2 = this.field_44036_e[c] >>> 4;
        int n3 = this.field_44036_e[c] & 0xF;
        float f = n2;
        float f2 = n3 + 1;
        float f3 = (float)(c % 16 * 16) + f;
        float f4 = (c & 0xFF) / 16 * 16;
        float f5 = f2 - f - 0.02f;
        float f6 = bl ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f3 / 256.0f), (float)(f4 / 256.0f));
        GL11.glVertex3f((float)(this.field_46126_j + f6), (float)this.field_46127_k, (float)0.0f);
        GL11.glTexCoord2f((float)(f3 / 256.0f), (float)((f4 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_46126_j - f6), (float)(this.field_46127_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f3 + f5) / 256.0f), (float)(f4 / 256.0f));
        GL11.glVertex3f((float)(this.field_46126_j + f5 / 2.0f + f6), (float)this.field_46127_k, (float)0.0f);
        GL11.glTexCoord2f((float)((f3 + f5) / 256.0f), (float)((f4 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_46126_j + f5 / 2.0f - f6), (float)(this.field_46127_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f2 - f) / 2.0f + 1.0f;
    }

    public int func_50103_a(String string, int n, int n2, int n3) {
        if (this.field_46125_m) {
            string = this.func_46121_b(string);
        }
        int n4 = this.func_50101_a(string, n + 1, n2 + 1, n3, true);
        n4 = Math.max(n4, this.func_50101_a(string, n, n2, n3, false));
        return n4;
    }

    public void func_873_b(String string, int n, int n2, int n3) {
        if (this.field_46125_m) {
            string = this.func_46121_b(string);
        }
        this.func_50101_a(string, n, n2, n3, false);
    }

    private String func_46121_b(String string) {
        int n;
        int n2;
        if (string == null || !Bidi.requiresBidi(string.toCharArray(), 0, string.length())) {
            return string;
        }
        Bidi bidi = new Bidi(string, -2);
        byte[] byArray = new byte[bidi.getRunCount()];
        Object[] objectArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = bidi.getRunStart(i);
            n2 = bidi.getRunLimit(i);
            n = bidi.getRunLevel(i);
            String string2 = string.substring(n3, n2);
            byArray[i] = (byte)n;
            objectArray[i] = string2;
        }
        String[] stringArray = (String[])objectArray.clone();
        Bidi.reorderVisually(byArray, 0, objectArray, 0, byArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            int n4;
            n = byArray[n2];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (!stringArray[n4].equals(objectArray[n2])) continue;
                n = byArray[n4];
                break;
            }
            if ((n & 1) == 0) {
                stringBuilder.append((String)objectArray[n2]);
                continue;
            }
            for (n4 = ((String)objectArray[n2]).length() - 1; n4 >= 0; --n4) {
                char c = ((String)objectArray[n2]).charAt(n4);
                if (c == '(') {
                    c = ')';
                } else if (c == ')') {
                    c = '(';
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    private void func_44029_a(String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < string.length(); ++i) {
            Tessellator tessellator;
            int n;
            int n2;
            char c = string.charAt(i);
            if (c == '\u00a7' && i + 1 < string.length()) {
                n2 = "0123456789abcdefklmnor".indexOf(string.toLowerCase().charAt(i + 1));
                if (n2 < 16) {
                    bl2 = false;
                    bl3 = false;
                    bl6 = false;
                    bl5 = false;
                    bl4 = false;
                    if (n2 < 0 || n2 > 15) {
                        n2 = 15;
                    }
                    if (bl) {
                        n2 += 16;
                    }
                    n = this.field_44035_g[n2];
                    GL11.glColor3f((float)((float)(n >> 16) / 255.0f), (float)((float)(n >> 8 & 0xFF) / 255.0f), (float)((float)(n & 0xFF) / 255.0f));
                } else if (n2 == 16) {
                    bl2 = true;
                } else if (n2 == 17) {
                    bl3 = true;
                } else if (n2 == 18) {
                    bl6 = true;
                } else if (n2 == 19) {
                    bl5 = true;
                } else if (n2 == 20) {
                    bl4 = true;
                } else if (n2 == 21) {
                    bl2 = false;
                    bl3 = false;
                    bl6 = false;
                    bl5 = false;
                    bl4 = false;
                    GL11.glColor4f((float)this.field_50115_n, (float)this.field_50116_o, (float)this.field_50118_p, (float)this.field_50117_q);
                }
                ++i;
                continue;
            }
            n2 = ChatAllowedCharacters.field_20157_a.indexOf(c);
            if (bl2 && n2 > 0) {
                while (this.field_1307_b[n2 + 32] != this.field_1307_b[(n = this.field_41064_c.nextInt(ChatAllowedCharacters.field_20157_a.length())) + 32]) {
                }
                n2 = n;
            }
            float f = this.func_50112_a(n2, c, bl4);
            if (bl3) {
                this.field_46126_j += 1.0f;
                this.func_50112_a(n2, c, bl4);
                this.field_46126_j -= 1.0f;
                f += 1.0f;
            }
            if (bl6) {
                tessellator = Tessellator.field_1512_a;
                GL11.glDisable((int)3553);
                tessellator.func_977_b();
                tessellator.func_991_a(this.field_46126_j, this.field_46127_k + (float)(this.field_41063_b / 2), 0.0);
                tessellator.func_991_a(this.field_46126_j + f, this.field_46127_k + (float)(this.field_41063_b / 2), 0.0);
                tessellator.func_991_a(this.field_46126_j + f, this.field_46127_k + (float)(this.field_41063_b / 2) - 1.0f, 0.0);
                tessellator.func_991_a(this.field_46126_j, this.field_46127_k + (float)(this.field_41063_b / 2) - 1.0f, 0.0);
                tessellator.func_982_a();
                GL11.glEnable((int)3553);
            }
            if (bl5) {
                tessellator = Tessellator.field_1512_a;
                GL11.glDisable((int)3553);
                tessellator.func_977_b();
                int n3 = bl5 ? -1 : 0;
                tessellator.func_991_a(this.field_46126_j + (float)n3, this.field_46127_k + (float)this.field_41063_b, 0.0);
                tessellator.func_991_a(this.field_46126_j + f, this.field_46127_k + (float)this.field_41063_b, 0.0);
                tessellator.func_991_a(this.field_46126_j + f, this.field_46127_k + (float)this.field_41063_b - 1.0f, 0.0);
                tessellator.func_991_a(this.field_46126_j + (float)n3, this.field_46127_k + (float)this.field_41063_b - 1.0f, 0.0);
                tessellator.func_982_a();
                GL11.glEnable((int)3553);
            }
            this.field_46126_j += f;
        }
    }

    public int func_50101_a(String string, int n, int n2, int n3, boolean bl) {
        if (string != null) {
            this.field_44038_h = 0;
            if ((n3 & 0xFC000000) == 0) {
                n3 |= 0xFF000000;
            }
            if (bl) {
                n3 = (n3 & 0xFCFCFC) >> 2 | n3 & 0xFF000000;
            }
            this.field_50115_n = (float)(n3 >> 16 & 0xFF) / 255.0f;
            this.field_50116_o = (float)(n3 >> 8 & 0xFF) / 255.0f;
            this.field_50118_p = (float)(n3 & 0xFF) / 255.0f;
            this.field_50117_q = (float)(n3 >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)this.field_50115_n, (float)this.field_50116_o, (float)this.field_50118_p, (float)this.field_50117_q);
            this.field_46126_j = n;
            this.field_46127_k = n2;
            this.func_44029_a(string, bl);
            return (int)this.field_46126_j;
        }
        return 0;
    }

    public int func_871_a(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n2 = this.func_50105_a(c);
            if (n2 < 0 && i < string.length() - 1) {
                if ((c = string.charAt(++i)) == 'l' || c == 'L') {
                    bl = true;
                } else if (c == 'r' || c == 'R') {
                    bl = false;
                }
                n2 = this.func_50105_a(c);
            }
            n += n2;
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public int func_50105_a(char c) {
        if (c == '\u00a7') {
            return -1;
        }
        int n = ChatAllowedCharacters.field_20157_a.indexOf(c);
        if (n >= 0 && !this.field_44037_j) {
            return this.field_1307_b[n + 32];
        }
        if (this.field_44036_e[c] != 0) {
            int n2 = this.field_44036_e[c] >> 4;
            int n3 = this.field_44036_e[c] & 0xF;
            if (n3 > 7) {
                n3 = 15;
                n2 = 0;
            }
            return (++n3 - n2) / 2 + 1;
        }
        return 0;
    }

    public String func_50107_a(String string, int n) {
        return this.func_50104_a(string, n, false);
    }

    public String func_50104_a(String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = bl ? string.length() - 1 : 0;
        int n4 = bl ? -1 : 1;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = n3; i >= 0 && i < string.length() && n2 < n; i += n4) {
            char c = string.charAt(i);
            int n5 = this.func_50105_a(c);
            if (bl2) {
                bl2 = false;
                if (c == 'l' || c == 'L') {
                    bl3 = true;
                } else if (c == 'r' || c == 'R') {
                    bl3 = false;
                }
            } else if (n5 < 0) {
                bl2 = true;
            } else {
                n2 += n5;
                if (bl3) {
                    ++n2;
                }
            }
            if (n2 > n) break;
            if (bl) {
                stringBuilder.insert(0, c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void func_27278_a(String string, int n, int n2, int n3, int n4) {
        if (this.field_46125_m) {
            string = this.func_46121_b(string);
        }
        this.func_46124_b(string, n, n2, n3, n4);
    }

    private void func_46124_b(String string, int n, int n2, int n3, int n4) {
        this.func_46122_b(string, n, n2, n3, n4, false);
    }

    private void func_46122_b(String string, int n, int n2, int n3, int n4, boolean bl) {
        String[] stringArray = string.split("\n");
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.func_46124_b(stringArray[i], n, n2, n3, n4);
                n2 += this.func_27277_a(stringArray[i], n3);
            }
            return;
        }
        String[] stringArray2 = string.split(" ");
        int n5 = 0;
        String string2 = "";
        while (n5 < stringArray2.length) {
            String string3 = string2 + stringArray2[n5++] + " ";
            while (n5 < stringArray2.length && this.func_871_a(string3 + stringArray2[n5]) < n3) {
                string3 = string3 + stringArray2[n5++] + " ";
            }
            while (this.func_871_a(string3) > n3) {
                int n6 = 0;
                while (this.func_871_a(string3.substring(0, n6 + 1)) <= n3) {
                    ++n6;
                }
                if (string3.substring(0, n6).trim().length() > 0) {
                    String string4 = string3.substring(0, n6);
                    if (string4.lastIndexOf("\u00a7") >= 0) {
                        string2 = "\u00a7" + string4.charAt(string4.lastIndexOf("\u00a7") + 1);
                    }
                    this.func_50101_a(string4, n, n2, n4, bl);
                    n2 += this.field_41063_b;
                }
                string3 = string2 + string3.substring(n6);
            }
            if (this.func_871_a(string3.trim()) <= 0) continue;
            if (string3.lastIndexOf("\u00a7") >= 0) {
                string2 = "\u00a7" + string3.charAt(string3.lastIndexOf("\u00a7") + 1);
            }
            this.func_50101_a(string3, n, n2, n4, bl);
            n2 += this.field_41063_b;
        }
    }

    public int func_27277_a(String string, int n) {
        String[] stringArray = string.split("\n");
        if (stringArray.length > 1) {
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                n2 += this.func_27277_a(stringArray[i], n);
            }
            return n2;
        }
        String[] stringArray2 = string.split(" ");
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray2.length) {
            String string2 = stringArray2[n3++] + " ";
            while (n3 < stringArray2.length && this.func_871_a(string2 + stringArray2[n3]) < n) {
                string2 = string2 + stringArray2[n3++] + " ";
            }
            while (this.func_871_a(string2) > n) {
                int n5 = 0;
                while (this.func_871_a(string2.substring(0, n5 + 1)) <= n) {
                    ++n5;
                }
                if (string2.substring(0, n5).trim().length() > 0) {
                    n4 += this.field_41063_b;
                }
                string2 = string2.substring(n5);
            }
            if (string2.trim().length() <= 0) continue;
            n4 += this.field_41063_b;
        }
        if (n4 < this.field_41063_b) {
            n4 += this.field_41063_b;
        }
        return n4;
    }

    public void func_44032_a(boolean bl) {
        this.field_44037_j = bl;
    }

    public void func_46123_b(boolean bl) {
        this.field_46125_m = bl;
    }

    public List func_50108_c(String string, int n) {
        return Arrays.asList(this.func_50113_d(string, n).split("\n"));
    }

    String func_50113_d(String string, int n) {
        int n2 = this.func_50102_e(string, n);
        if (string.length() <= n2) {
            return string;
        }
        String string2 = string.substring(0, n2);
        String string3 = FontRenderer.func_50114_c(string2) + string.substring(n2 + (string.charAt(n2) == ' ' ? 1 : 0));
        return string2 + "\n" + this.func_50113_d(string3, n);
    }

    private int func_50102_e(String string, int n) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string.charAt(n2);
            switch (c) {
                case '\u00a7': {
                    char c2;
                    if (n2 == n3) break;
                    if ((c2 = string.charAt(++n2)) == 'l' || c2 == 'L') {
                        bl = true;
                        break;
                    }
                    if (c2 != 'r' && c2 != 'R') break;
                    bl = false;
                    break;
                }
                case ' ': {
                    n5 = n2;
                }
                default: {
                    n4 += this.func_50105_a(c);
                    if (!bl) break;
                    ++n4;
                }
            }
            if (c == '\n') {
                n5 = ++n2;
                break;
            }
            if (n4 > n) break;
        }
        if (n2 != n3 && n5 != -1 && n5 < n2) {
            return n5;
        }
        return n2;
    }

    private static boolean func_50110_b(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean func_50109_c(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R';
    }

    private static String func_50114_c(String string) {
        String string2 = "";
        int n = -1;
        int n2 = string.length();
        while ((n = string.indexOf(167, n + 1)) != -1) {
            if (n >= n2 - 1) continue;
            char c = string.charAt(n + 1);
            if (FontRenderer.func_50110_b(c)) {
                string2 = "\u00a7" + c;
                continue;
            }
            if (!FontRenderer.func_50109_c(c)) continue;
            string2 = string2 + "\u00a7" + c;
        }
        return string2;
    }

    public static String func_52014_d(String string) {
        return field_52015_r.matcher(string).replaceAll("");
    }
}

