/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagCompound;

public class CompressedStreamTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound func_1138_a(InputStream inputStream) {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_1141_a(dataInputStream);
            return nBTTagCompound;
        }
        finally {
            dataInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void func_1143_a(NBTTagCompound nBTTagCompound, OutputStream outputStream) {
        DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(outputStream));
        try {
            CompressedStreamTools.func_1139_a(nBTTagCompound, dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound func_40592_a(byte[] byArray) {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_1141_a(dataInputStream);
            return nBTTagCompound;
        }
        finally {
            dataInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] func_40591_a(NBTTagCompound nBTTagCompound) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(byteArrayOutputStream));
        try {
            CompressedStreamTools.func_1139_a(nBTTagCompound, dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void func_35621_a(NBTTagCompound nBTTagCompound, File file) {
        File file2 = new File(file.getAbsolutePath() + "_tmp");
        if (file2.exists()) {
            file2.delete();
        }
        CompressedStreamTools.func_35620_b(nBTTagCompound, file2);
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            throw new IOException("Failed to delete " + file);
        }
        file2.renameTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void func_35620_b(NBTTagCompound nBTTagCompound, File file) {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        try {
            CompressedStreamTools.func_1139_a(nBTTagCompound, dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound func_35622_a(File file) {
        if (!file.exists()) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_1141_a(dataInputStream);
            return nBTTagCompound;
        }
        finally {
            dataInputStream.close();
        }
    }

    public static NBTTagCompound func_1141_a(DataInput dataInput) {
        NBTBase nBTBase = NBTBase.func_734_b(dataInput);
        if (nBTBase instanceof NBTTagCompound) {
            return (NBTTagCompound)nBTBase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_1139_a(NBTTagCompound nBTTagCompound, DataOutput dataOutput) {
        NBTBase.func_738_a(nBTTagCompound, dataOutput);
    }
}

