/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EnumOS1;
import net.minecraft.src.IsoImageBuffer;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.TerrainTextureManager;
import net.minecraft.src.ThreadRunIsoClient;
import net.minecraft.src.World;
import net.minecraft.src.WorldSettings;
import net.minecraft.src.WorldType;

public class CanvasIsomPreview
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener,
Runnable {
    private int field_1793_a = 0;
    private int field_1792_b = 2;
    private boolean field_1791_c = true;
    private World field_1790_d;
    private File field_1789_e;
    private boolean field_1788_f = true;
    private List field_1787_g = Collections.synchronizedList(new LinkedList());
    private IsoImageBuffer[][] field_1786_h = new IsoImageBuffer[64][64];
    private int field_1785_i;
    private int field_1784_j;
    private int field_1783_k;
    private int field_1782_l;

    public File func_1263_a() {
        if (this.field_1789_e == null) {
            this.field_1789_e = this.func_1264_a("minecraft");
        }
        return this.field_1789_e;
    }

    public File func_1264_a(String string) {
        File file;
        String string2 = System.getProperty("user.home", ".");
        switch (CanvasIsomPreview.func_1269_e()) {
            case linux: 
            case solaris: {
                file = new File(string2, '.' + string + '/');
                break;
            }
            case windows: {
                String string3 = System.getenv("APPDATA");
                if (string3 != null) {
                    file = new File(string3, "." + string + '/');
                    break;
                }
                file = new File(string2, '.' + string + '/');
                break;
            }
            case macos: {
                file = new File(string2, "Library/Application Support/" + string);
                break;
            }
            default: {
                file = new File(string2, string + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS1 func_1269_e() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("win")) {
            return EnumOS1.windows;
        }
        if (string.contains("mac")) {
            return EnumOS1.macos;
        }
        if (string.contains("solaris")) {
            return EnumOS1.solaris;
        }
        if (string.contains("sunos")) {
            return EnumOS1.solaris;
        }
        if (string.contains("linux")) {
            return EnumOS1.linux;
        }
        if (string.contains("unix")) {
            return EnumOS1.linux;
        }
        return EnumOS1.unknown;
    }

    public CanvasIsomPreview() {
        this.field_1789_e = this.func_1263_a();
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.field_1786_h[i][j] = new IsoImageBuffer(null, i, j);
            }
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.setBackground(Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_1270_b(String string) {
        this.field_1784_j = 0;
        this.field_1785_i = 0;
        this.field_1790_d = new World(new SaveHandler(new File(this.field_1789_e, "saves"), string, false), string, new WorldSettings(new Random().nextLong(), 0, true, false, WorldType.field_48635_b));
        this.field_1790_d.field_1046_e = 0;
        List list = this.field_1787_g;
        synchronized (list) {
            this.field_1787_g.clear();
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    this.field_1786_h[i][j].func_888_a(this.field_1790_d, i, j);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_1266_a(int n) {
        List list = this.field_1787_g;
        synchronized (list) {
            this.field_1790_d.field_1046_e = n;
            this.field_1787_g.clear();
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    this.field_1786_h[i][j].func_888_a(this.field_1790_d, i, j);
                }
            }
        }
    }

    public void func_1272_b() {
        new ThreadRunIsoClient(this).start();
        for (int i = 0; i < 8; ++i) {
            new Thread(this).start();
        }
    }

    public void func_1273_c() {
        this.field_1788_f = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsoImageBuffer func_1267_a(int n, int n2) {
        int n3 = n & 0x3F;
        int n4 = n2 & 0x3F;
        IsoImageBuffer isoImageBuffer = this.field_1786_h[n3][n4];
        if (isoImageBuffer.field_1354_c == n && isoImageBuffer.field_1353_d == n2) {
            return isoImageBuffer;
        }
        List list = this.field_1787_g;
        synchronized (list) {
            this.field_1787_g.remove(isoImageBuffer);
        }
        isoImageBuffer.func_889_a(n, n2);
        return isoImageBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TerrainTextureManager terrainTextureManager = new TerrainTextureManager();
        while (this.field_1788_f) {
            IsoImageBuffer isoImageBuffer = null;
            List list = this.field_1787_g;
            synchronized (list) {
                if (this.field_1787_g.size() > 0) {
                    isoImageBuffer = (IsoImageBuffer)this.field_1787_g.remove(0);
                }
            }
            if (isoImageBuffer != null) {
                if (this.field_1793_a - isoImageBuffer.field_1350_g < 2) {
                    terrainTextureManager.func_799_a(isoImageBuffer);
                    this.repaint();
                } else {
                    isoImageBuffer.field_1349_h = false;
                }
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void update(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
    }

    public void func_1265_d() {
        BufferStrategy bufferStrategy = this.getBufferStrategy();
        if (bufferStrategy == null) {
            this.createBufferStrategy(2);
            return;
        }
        this.func_1268_a((Graphics2D)bufferStrategy.getDrawGraphics());
        bufferStrategy.show();
    }

    public void func_1268_a(Graphics2D graphics2D) {
        int n;
        Object object;
        ++this.field_1793_a;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setClip(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.translate(this.getWidth() / 2, this.getHeight() / 2);
        graphics2D.scale(this.field_1792_b, this.field_1792_b);
        graphics2D.translate(this.field_1785_i, this.field_1784_j);
        if (this.field_1790_d != null) {
            object = this.field_1790_d.func_22137_s();
            graphics2D.translate(-(((ChunkCoordinates)object).field_22395_a + ((ChunkCoordinates)object).field_22396_c), -(-((ChunkCoordinates)object).field_22395_a + ((ChunkCoordinates)object).field_22396_c) + 64);
        }
        object = graphics2D.getClipBounds();
        graphics2D.setColor(new Color(-15724512));
        graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        int n2 = 16;
        int n3 = 3;
        int n4 = ((Rectangle)object).x / n2 / 2 - 2 - n3;
        int n5 = (((Rectangle)object).x + ((Rectangle)object).width) / n2 / 2 + 1 + n3;
        int n6 = ((Rectangle)object).y / n2 - 1 - n3 * 2;
        int n7 = (((Rectangle)object).y + ((Rectangle)object).height + 16 + 128) / n2 + 1 + n3 * 2;
        for (n = n6; n <= n7; ++n) {
            for (int i = n4; i <= n5; ++i) {
                int n8 = i - (n >> 1);
                int n9 = i + (n + 1 >> 1);
                IsoImageBuffer isoImageBuffer = this.func_1267_a(n8, n9);
                isoImageBuffer.field_1350_g = this.field_1793_a;
                if (!isoImageBuffer.field_1352_e) {
                    if (isoImageBuffer.field_1349_h) continue;
                    isoImageBuffer.field_1349_h = true;
                    this.field_1787_g.add(isoImageBuffer);
                    continue;
                }
                isoImageBuffer.field_1349_h = false;
                if (isoImageBuffer.field_1351_f) continue;
                int n10 = i * n2 * 2 + (n & 1) * n2;
                int n11 = n * n2 - 128 - 16;
                graphics2D.drawImage((Image)isoImageBuffer.field_1348_a, n10, n11, null);
            }
        }
        if (this.field_1791_c) {
            graphics2D.setTransform(affineTransform);
            n = this.getHeight() - 32 - 4;
            graphics2D.setColor(new Color(Integer.MIN_VALUE, true));
            graphics2D.fillRect(4, this.getHeight() - 32 - 4, this.getWidth() - 8, 32);
            graphics2D.setColor(Color.WHITE);
            String string = "F1 - F5: load levels   |   0-9: Set time of day   |   Space: return to spawn   |   Double click: zoom   |   Escape: hide this text";
            graphics2D.drawString(string, this.getWidth() / 2 - graphics2D.getFontMetrics().stringWidth(string) / 2, n + 20);
        }
        graphics2D.dispose();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.field_1792_b;
        int n2 = mouseEvent.getY() / this.field_1792_b;
        this.field_1785_i += n - this.field_1783_k;
        this.field_1784_j += n2 - this.field_1782_l;
        this.field_1783_k = n;
        this.field_1782_l = n2;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.field_1792_b = 3 - this.field_1792_b;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.field_1792_b;
        int n2 = mouseEvent.getY() / this.field_1792_b;
        this.field_1783_k = n;
        this.field_1782_l = n2;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 48) {
            this.func_1266_a(11);
        }
        if (keyEvent.getKeyCode() == 49) {
            this.func_1266_a(10);
        }
        if (keyEvent.getKeyCode() == 50) {
            this.func_1266_a(9);
        }
        if (keyEvent.getKeyCode() == 51) {
            this.func_1266_a(7);
        }
        if (keyEvent.getKeyCode() == 52) {
            this.func_1266_a(6);
        }
        if (keyEvent.getKeyCode() == 53) {
            this.func_1266_a(5);
        }
        if (keyEvent.getKeyCode() == 54) {
            this.func_1266_a(3);
        }
        if (keyEvent.getKeyCode() == 55) {
            this.func_1266_a(2);
        }
        if (keyEvent.getKeyCode() == 56) {
            this.func_1266_a(1);
        }
        if (keyEvent.getKeyCode() == 57) {
            this.func_1266_a(0);
        }
        if (keyEvent.getKeyCode() == 112) {
            this.func_1270_b("World1");
        }
        if (keyEvent.getKeyCode() == 113) {
            this.func_1270_b("World2");
        }
        if (keyEvent.getKeyCode() == 114) {
            this.func_1270_b("World3");
        }
        if (keyEvent.getKeyCode() == 115) {
            this.func_1270_b("World4");
        }
        if (keyEvent.getKeyCode() == 116) {
            this.func_1270_b("World5");
        }
        if (keyEvent.getKeyCode() == 32) {
            this.field_1784_j = 0;
            this.field_1785_i = 0;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.field_1791_c = !this.field_1791_c;
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static /* synthetic */ boolean func_1271_a(CanvasIsomPreview canvasIsomPreview) {
        return canvasIsomPreview.field_1788_f;
    }
}

