/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.src.AnvilChunkLoaderPending;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityList;
import net.minecraft.src.ExtendedBlockStorage;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IThreadedFileIO;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.NextTickListEntry;
import net.minecraft.src.NibbleArray;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.ThreadedFileIOBase;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class AnvilChunkLoader
implements IThreadedFileIO,
IChunkLoader {
    private List field_48451_a = new ArrayList();
    private Set field_48449_b = new HashSet();
    private Object field_48450_c = new Object();
    private final File field_48448_d;

    public AnvilChunkLoader(File file) {
        this.field_48448_d = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_813_a(World world, int n, int n2) {
        NBTTagCompound nBTTagCompound = null;
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(n, n2);
        Object object = this.field_48450_c;
        synchronized (object) {
            if (this.field_48449_b.contains(chunkCoordIntPair)) {
                for (int i = 0; i < this.field_48451_a.size(); ++i) {
                    if (!((AnvilChunkLoaderPending)this.field_48451_a.get((int)i)).field_48427_a.equals(chunkCoordIntPair)) continue;
                    nBTTagCompound = ((AnvilChunkLoaderPending)this.field_48451_a.get((int)i)).field_48426_b;
                    break;
                }
            }
        }
        if (nBTTagCompound == null) {
            object = RegionFileCache.func_22194_c(this.field_48448_d, n, n2);
            if (object != null) {
                nBTTagCompound = CompressedStreamTools.func_1141_a((DataInput)object);
            } else {
                return null;
            }
        }
        return this.func_48443_a(world, n, n2, nBTTagCompound);
    }

    protected Chunk func_48443_a(World world, int n, int n2, NBTTagCompound nBTTagCompound) {
        if (!nBTTagCompound.func_751_b("Level")) {
            System.out.println("Chunk file at " + n + "," + n2 + " is missing level data, skipping");
            return null;
        }
        if (!nBTTagCompound.func_743_k("Level").func_751_b("Sections")) {
            System.out.println("Chunk file at " + n + "," + n2 + " is missing block data, skipping");
            return null;
        }
        Chunk chunk = this.func_48444_a(world, nBTTagCompound.func_743_k("Level"));
        if (!chunk.func_1017_a(n, n2)) {
            System.out.println("Chunk file at " + n + "," + n2 + " is in the wrong location; relocating. (Expected " + n + ", " + n2 + ", got " + chunk.field_1531_j + ", " + chunk.field_1530_k + ")");
            nBTTagCompound.func_758_a("xPos", n);
            nBTTagCompound.func_758_a("zPos", n2);
            chunk = this.func_48444_a(world, nBTTagCompound.func_743_k("Level"));
        }
        chunk.func_25124_i();
        return chunk;
    }

    public void func_812_a(World world, Chunk chunk) {
        world.func_663_l();
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound.func_762_a("Level", nBTTagCompound2);
            this.func_48445_a(chunk, world, nBTTagCompound2);
            this.func_48446_a(chunk.func_40740_k(), nBTTagCompound);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_48446_a(ChunkCoordIntPair chunkCoordIntPair, NBTTagCompound nBTTagCompound) {
        Object object = this.field_48450_c;
        synchronized (object) {
            if (this.field_48449_b.contains(chunkCoordIntPair)) {
                for (int i = 0; i < this.field_48451_a.size(); ++i) {
                    if (!((AnvilChunkLoaderPending)this.field_48451_a.get((int)i)).field_48427_a.equals(chunkCoordIntPair)) continue;
                    this.field_48451_a.set(i, new AnvilChunkLoaderPending(chunkCoordIntPair, nBTTagCompound));
                    return;
                }
            }
            this.field_48451_a.add(new AnvilChunkLoaderPending(chunkCoordIntPair, nBTTagCompound));
            this.field_48449_b.add(chunkCoordIntPair);
            ThreadedFileIOBase.field_40573_a.func_40567_a(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_40550_A_() {
        AnvilChunkLoaderPending anvilChunkLoaderPending = null;
        Object object = this.field_48450_c;
        synchronized (object) {
            if (this.field_48451_a.size() <= 0) {
                return false;
            }
            anvilChunkLoaderPending = (AnvilChunkLoaderPending)this.field_48451_a.remove(0);
            this.field_48449_b.remove(anvilChunkLoaderPending.field_48427_a);
        }
        if (anvilChunkLoaderPending != null) {
            try {
                this.func_48447_a(anvilChunkLoaderPending);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    private void func_48447_a(AnvilChunkLoaderPending anvilChunkLoaderPending) {
        DataOutputStream dataOutputStream = RegionFileCache.func_22190_d(this.field_48448_d, anvilChunkLoaderPending.field_48427_a.field_189_a, anvilChunkLoaderPending.field_48427_a.field_188_b);
        CompressedStreamTools.func_1139_a(anvilChunkLoaderPending.field_48426_b, dataOutputStream);
        dataOutputStream.close();
    }

    public void func_815_b(World world, Chunk chunk) {
    }

    public void func_814_a() {
    }

    public void func_811_b() {
    }

    private void func_48445_a(Chunk chunk, World world, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2;
        world.func_663_l();
        nBTTagCompound.func_758_a("xPos", chunk.field_1531_j);
        nBTTagCompound.func_758_a("zPos", chunk.field_1530_k);
        nBTTagCompound.func_750_a("LastUpdate", world.func_22139_r());
        nBTTagCompound.func_48183_a("HeightMap", chunk.field_48501_f);
        nBTTagCompound.func_748_a("TerrainPopulated", chunk.field_1527_n);
        ExtendedBlockStorage[] extendedBlockStorageArray = chunk.func_48495_i();
        NBTTagList nBTTagList = new NBTTagList("Sections");
        for (ExtendedBlockStorage object : extendedBlockStorageArray) {
            if (object == null || object.func_48700_f() == 0) continue;
            nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_761_a("Y", (byte)(object.func_48707_c() >> 4 & 0xFF));
            nBTTagCompound2.func_747_a("Blocks", object.func_48692_g());
            if (object.func_48704_i() != null) {
                nBTTagCompound2.func_747_a("Add", object.func_48704_i().field_1109_a);
            }
            nBTTagCompound2.func_747_a("Data", object.func_48697_j().field_1109_a);
            nBTTagCompound2.func_747_a("SkyLight", object.func_48714_l().field_1109_a);
            nBTTagCompound2.func_747_a("BlockLight", object.func_48705_k().field_1109_a);
            nBTTagList.func_742_a(nBTTagCompound2);
        }
        nBTTagCompound.func_762_a("Sections", nBTTagList);
        nBTTagCompound.func_747_a("Biomes", chunk.func_48493_m());
        chunk.field_1523_r = false;
        NBTTagList nBTTagList2 = new NBTTagList();
        for (int i = 0; i < chunk.field_48502_j.length; ++i) {
            for (Entity entity : chunk.field_48502_j[i]) {
                chunk.field_1523_r = true;
                nBTTagCompound2 = new NBTTagCompound();
                if (!entity.func_358_c(nBTTagCompound2)) continue;
                nBTTagList2.func_742_a(nBTTagCompound2);
            }
        }
        nBTTagCompound.func_762_a("Entities", nBTTagList2);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (TileEntity tileEntity : chunk.field_1529_l.values()) {
            nBTTagCompound2 = new NBTTagCompound();
            tileEntity.func_481_b(nBTTagCompound2);
            nBTTagList3.func_742_a(nBTTagCompound2);
        }
        nBTTagCompound.func_762_a("TileEntities", nBTTagList3);
        List list = world.func_41081_a(chunk, false);
        if (list != null) {
            long l = world.func_22139_r();
            NBTTagList nBTTagList4 = new NBTTagList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                nBTTagCompound3.func_758_a("i", nextTickListEntry.field_1365_d);
                nBTTagCompound3.func_758_a("x", nextTickListEntry.field_1361_a);
                nBTTagCompound3.func_758_a("y", nextTickListEntry.field_1360_b);
                nBTTagCompound3.func_758_a("z", nextTickListEntry.field_1366_c);
                nBTTagCompound3.func_758_a("t", (int)(nextTickListEntry.field_1364_e - l));
                nBTTagList4.func_742_a(nBTTagCompound3);
            }
            nBTTagCompound.func_762_a("TileTicks", nBTTagList4);
        }
    }

    private Chunk func_48444_a(World world, NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        Object object;
        NBTTagList nBTTagList2;
        NBTTagList nBTTagList3;
        Object object2;
        int n = nBTTagCompound.func_756_e("xPos");
        int n2 = nBTTagCompound.func_756_e("zPos");
        Chunk chunk = new Chunk(world, n, n2);
        chunk.field_48501_f = nBTTagCompound.func_48182_l("HeightMap");
        chunk.field_1527_n = nBTTagCompound.func_760_m("TerrainPopulated");
        NBTTagList nBTTagList4 = nBTTagCompound.func_753_l("Sections");
        int n3 = 16;
        ExtendedBlockStorage[] extendedBlockStorageArray = new ExtendedBlockStorage[n3];
        for (int i = 0; i < nBTTagList4.func_740_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList4.func_741_a(i);
            byte by = nBTTagCompound2.func_746_c("Y");
            object2 = new ExtendedBlockStorage(by << 4);
            ((ExtendedBlockStorage)object2).func_48706_a(nBTTagCompound2.func_759_j("Blocks"));
            if (nBTTagCompound2.func_751_b("Add")) {
                ((ExtendedBlockStorage)object2).func_48710_a(new NibbleArray(nBTTagCompound2.func_759_j("Add"), 4));
            }
            ((ExtendedBlockStorage)object2).func_48701_b(new NibbleArray(nBTTagCompound2.func_759_j("Data"), 4));
            ((ExtendedBlockStorage)object2).func_48713_d(new NibbleArray(nBTTagCompound2.func_759_j("SkyLight"), 4));
            ((ExtendedBlockStorage)object2).func_48695_c(new NibbleArray(nBTTagCompound2.func_759_j("BlockLight"), 4));
            ((ExtendedBlockStorage)object2).func_48708_d();
            extendedBlockStorageArray[by] = object2;
        }
        chunk.func_48500_a(extendedBlockStorageArray);
        if (nBTTagCompound.func_751_b("Biomes")) {
            chunk.func_48497_a(nBTTagCompound.func_759_j("Biomes"));
        }
        if ((nBTTagList3 = nBTTagCompound.func_753_l("Entities")) != null) {
            for (int i = 0; i < nBTTagList3.func_740_c(); ++i) {
                NBTTagCompound nBTTagCompound3 = (NBTTagCompound)nBTTagList3.func_741_a(i);
                object2 = EntityList.func_1081_a(nBTTagCompound3, world);
                chunk.field_1523_r = true;
                if (object2 == null) continue;
                chunk.func_1000_a((Entity)object2);
            }
        }
        if ((nBTTagList2 = nBTTagCompound.func_753_l("TileEntities")) != null) {
            for (int i = 0; i < nBTTagList2.func_740_c(); ++i) {
                object2 = (NBTTagCompound)nBTTagList2.func_741_a(i);
                object = TileEntity.func_477_c((NBTTagCompound)object2);
                if (object == null) continue;
                chunk.func_1001_a((TileEntity)object);
            }
        }
        if (nBTTagCompound.func_751_b("TileTicks") && (nBTTagList = nBTTagCompound.func_753_l("TileTicks")) != null) {
            for (int i = 0; i < nBTTagList.func_740_c(); ++i) {
                object = (NBTTagCompound)nBTTagList.func_741_a(i);
                world.func_41083_e(((NBTTagCompound)object).func_756_e("x"), ((NBTTagCompound)object).func_756_e("y"), ((NBTTagCompound)object).func_756_e("z"), ((NBTTagCompound)object).func_756_e("i"), ((NBTTagCompound)object).func_756_e("t"));
            }
        }
        return chunk;
    }
}

