/*
 * Decompiled with CFR 0.152.
 */
package argo.format;

import argo.format.JsonEscapedString;
import argo.format.JsonFormatter;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TreeSet;

public final class CompactJsonFormatter
implements JsonFormatter {
    public String func_27327_a(JsonRootNode jsonRootNode) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.func_27329_a(jsonRootNode, stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Coding failure in Argo:  StringWriter gave an IOException", iOException);
        }
        return stringWriter.toString();
    }

    public void func_27329_a(JsonRootNode jsonRootNode, Writer writer) {
        this.func_27328_a(jsonRootNode, writer);
    }

    private void func_27328_a(JsonNode jsonNode, Writer writer) {
        boolean bl = true;
        switch (jsonNode.func_27218_a()) {
            case ARRAY: {
                writer.append('[');
                for (JsonNode jsonNode2 : jsonNode.func_27215_d()) {
                    if (!bl) {
                        writer.append(',');
                    }
                    bl = false;
                    this.func_27328_a(jsonNode2, writer);
                }
                writer.append(']');
                break;
            }
            case OBJECT: {
                writer.append('{');
                for (JsonStringNode jsonStringNode : new TreeSet(jsonNode.func_27214_c().keySet())) {
                    if (!bl) {
                        writer.append(',');
                    }
                    bl = false;
                    this.func_27328_a(jsonStringNode, writer);
                    writer.append(':');
                    this.func_27328_a((JsonNode)jsonNode.func_27214_c().get(jsonStringNode), writer);
                }
                writer.append('}');
                break;
            }
            case STRING: {
                writer.append('\"').append(new JsonEscapedString(jsonNode.func_27216_b()).toString()).append('\"');
                break;
            }
            case NUMBER: {
                writer.append(jsonNode.func_27216_b());
                break;
            }
            case FALSE: {
                writer.append("false");
                break;
            }
            case TRUE: {
                writer.append("true");
                break;
            }
            case NULL: {
                writer.append("null");
                break;
            }
            default: {
                throw new RuntimeException("Coding failure in Argo:  Attempt to format a JsonNode of unknown type [" + (Object)((Object)jsonNode.func_27218_a()) + "];");
            }
        }
    }
}

