/*
 * Decompiled with CFR 0.152.
 */
public class PCtr_GuiTeleporter
implements PC_IGresBase {
    private PCtr_TileEntityTeleporter teleporter;
    private PC_GresCheckBox checkItems;
    private PC_GresCheckBox checkAnimals;
    private PC_GresCheckBox checkMobs;
    private PC_GresCheckBox checkPlayers;
    private PC_GresCheckBox checkSneak;
    private PC_GresRadioButton checkN;
    private PC_GresRadioButton checkS;
    private PC_GresRadioButton checkE;
    private PC_GresRadioButton checkW;
    private String field = "";
    private int type = 0;
    private static final int SENDER = 1;
    private static final int RECEIVER = 2;
    private String error = "";
    private boolean isnew = false;
    private PC_GresTextEdit edit;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget buttonOK;
    private PC_GresWidget txError;

    public PCtr_GuiTeleporter(PCtr_TileEntityTeleporter te2) {
        this(te2, false);
    }

    public PCtr_GuiTeleporter(PCtr_TileEntityTeleporter te2, boolean newt) {
        this.isnew = newt;
        this.teleporter = te2;
        if (this.teleporter.isSender()) {
            this.type = 1;
            this.field = new String(this.teleporter.target);
        } else if (this.teleporter.isReceiver()) {
            this.type = 2;
            this.field = new String(this.teleporter.identifier);
        } else {
            PC_Logger.warning("openned gui for invalid teleporter device.");
        }
    }

    @Override
    public yw getPlayer() {
        return PC_Utils.mc().h;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        String aa2 = "";
        if (this.type == 1) {
            aa2 = PC_Lang.tr("pc.gui.teleporter.titleSender");
        }
        if (this.type == 2) {
            aa2 = PC_Lang.tr("pc.gui.teleporter.titleTarget");
        }
        PC_GresWindow w2 = new PC_GresWindow(aa2);
        PC_GresWidget vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg2.add(new PC_GresLabel(this.type == 1 ? PC_Lang.tr("pc.gui.teleporter.linksTo") : PC_Lang.tr("pc.gui.teleporter.deviceId")));
        this.edit = new PC_GresTextEdit(this.field, 20, PC_GresTextEdit.PC_GresInputType.TEXT);
        vg2.add(this.edit);
        w2.add(vg2);
        PC_GresWidget hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        hg2.add(this.txError);
        w2.add(hg2);
        if (this.type == 1) {
            PC_GresWidget vg1 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg1.add(new PC_GresLabel(PC_Lang.tr("pc.gui.teleporter.teleportGroup")));
            hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg2 = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkItems = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.items")).check(this.teleporter.items);
            vg2.add(this.checkItems);
            this.checkAnimals = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.animals")).check(this.teleporter.animals);
            vg2.add(this.checkAnimals);
            hg2.add(vg2);
            vg2 = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkMobs = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.monsters")).check(this.teleporter.monsters);
            vg2.add(this.checkMobs);
            this.checkPlayers = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.players")).check(this.teleporter.players);
            vg2.add(this.checkPlayers);
            hg2.add(vg2);
            vg1.add(hg2);
            this.checkSneak = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.sneak")).check(this.teleporter.sneakTrigger);
            vg1.add(this.checkSneak);
            w2.add(vg1);
        } else if (this.type == 2) {
            PC_GresRadioButton.PC_GresRadioGroup group = new PC_GresRadioButton.PC_GresRadioGroup();
            PC_GresWidget vg1 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg1.add(new PC_GresLabel(PC_Lang.tr("pc.gui.teleporter.outputDirection")));
            hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg2 = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkN = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.north"), group).check(this.teleporter.direction.equals("N"));
            vg2.add(this.checkN);
            this.checkS = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.south"), group).check(this.teleporter.direction.equals("S"));
            vg2.add(this.checkS);
            hg2.add(vg2);
            vg2 = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkE = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.east"), group).check(this.teleporter.direction.equals("E"));
            vg2.add(this.checkE);
            this.checkW = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.west"), group).check(this.teleporter.direction.equals("W"));
            vg2.add(this.checkW);
            hg2.add(vg2);
            vg1.add(hg2);
            w2.add(vg1);
        }
        hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg2.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg2.add(this.buttonOK);
        w2.add(hg2);
        gui.add(w2);
        gui.setCanShiftTransfer(false);
        this.actionPerformed(this.edit, gui);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget == this.buttonCancel) {
            gui.close();
        } else if (widget == this.buttonOK) {
            if (!this.edit.getText().equals("")) {
                if (this.type == 1) {
                    this.teleporter.target = new String(this.edit.getText());
                    PC_Logger.finest("setting target to " + this.edit.getText());
                } else {
                    if (this.isnew) {
                        PCtr_TeleporterHelper.registerNewDevice(this.teleporter.j, this.teleporter.k, this.teleporter.l, this.edit.getText());
                    } else {
                        PCtr_TeleporterHelper.renameDevice(this.teleporter.identifier, this.edit.getText());
                    }
                    this.teleporter.identifier = new String(this.edit.getText());
                    PC_Logger.finest("setting id to " + this.edit.getText());
                }
            } else {
                return;
            }
            if (this.type == 1) {
                this.teleporter.items = this.checkItems.isChecked();
                this.teleporter.animals = this.checkAnimals.isChecked();
                this.teleporter.monsters = this.checkMobs.isChecked();
                this.teleporter.players = this.checkPlayers.isChecked();
                this.teleporter.sneakTrigger = this.checkSneak.isChecked();
            } else if (this.type == 2) {
                if (this.checkN.isChecked()) {
                    this.teleporter.direction = "N";
                }
                if (this.checkS.isChecked()) {
                    this.teleporter.direction = "S";
                }
                if (this.checkE.isChecked()) {
                    this.teleporter.direction = "E";
                }
                if (this.checkW.isChecked()) {
                    this.teleporter.direction = "W";
                }
            }
            this.teleporter.j();
            this.teleporter.i.c(this.teleporter.j, this.teleporter.k, this.teleporter.l, this.teleporter.j, this.teleporter.k, this.teleporter.l);
            this.teleporter.i.k(this.teleporter.j, this.teleporter.k, this.teleporter.l);
            gui.close();
        } else if (widget == this.edit) {
            boolean valid = true;
            if (this.type == 2) {
                if (PCtr_TeleporterHelper.targetExistsExcept(this.edit.getText(), this.teleporter.getCoord())) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errIdUsed");
                    valid = false;
                } else if (this.edit.getText().equals("")) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errIdRequired");
                    valid = false;
                } else {
                    this.error = "";
                }
            } else if (this.type == 1) {
                if (!PCtr_TeleporterHelper.targetExistsExcept(this.edit.getText(), this.teleporter.getCoord())) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errIdNotFound");
                } else if (!PCtr_TeleporterHelper.isTargetInThisDimension(this.edit.getText())) {
                    int dim = PCtr_TeleporterHelper.getTargetDimension(this.edit.getText());
                    switch (dim) {
                        case 1: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDimEnd");
                            break;
                        }
                        case 0: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDimWorld");
                            break;
                        }
                        case -1: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDimnether");
                            break;
                        }
                        default: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDim");
                        }
                    }
                    valid = false;
                } else if (this.edit.getText().equals("")) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errTargetRequired");
                    valid = false;
                } else {
                    this.error = "";
                }
            }
            if (this.edit.getText().equals("")) {
                valid = false;
            }
            this.buttonOK.enable(valid);
            this.txError.setText(this.error);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonCancel, gui);
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(io iinventory) {
    }
}

