/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import java.util.Random;

public class PCmo_EntityMiner
extends nn
implements io {
    private static final double FUEL_STRENGTH = 0.9;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private Random U = new Random();
    private yw fakePlayer;
    public String commandList = "";
    public int currentCommand = -1;
    private int realCommand = -1;
    private int stepCounter = 0;
    public String commandListSaved = "";
    public boolean paused = false;
    public boolean keyboardControlled = false;
    public boolean programmingGuiOpen = false;
    private boolean upStepLaid = false;
    private boolean bridgeDone = false;
    private PC_CoordI target = new PC_CoordI();
    private int rotationRemaining = 0;
    public int level = 1;
    private static final double[] MOTION_SPEED = new double[]{0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.11, 0.12};
    public boolean minerBeingCreated = false;
    public String program = "";
    public byte DESTROY = 0;
    public static final byte COBBLE = 1;
    public static final byte DIRT = 2;
    public static final byte GRAVEL = 4;
    public boolean keepAllFuel = false;
    public boolean torchesOnlyOnFloor = false;
    public boolean compressBlocks = false;
    public boolean miningEnabled = true;
    public boolean bridgeEnabled = false;
    public boolean lavaFillingEnabled = true;
    public boolean waterFillingEnabled = false;
    private int fuelBuffer = 0;
    private int fuelAllocated = 0;
    private int waitingForFuel = 0;
    private int[] mineCounter = new int[]{-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0};
    private int miningTickCounter = 0;
    boolean openedGui = false;
    private aan[] inventory = new aan[54];

    public boolean tryToSpawnMinerAt(aan itemstack, yw entityplayer, xd world, PC_CoordI position) {
        int steel = pb.ai.bO;
        int chest = pb.au.bO;
        String eMinerStructure = PC_Lang.tr("pc.miner.build.errInvalidStructure");
        String eMinerCrystals = PC_Lang.tr("pc.miner.build.errMissingCrystals");
        block0: for (int yy2 = position.y; yy2 >= position.y - 1; --yy2) {
            for (int xx2 = position.x - 1; xx2 <= position.x + 1; ++xx2) {
                for (int zz2 = position.z - 1; zz2 <= position.z + 1; ++zz2) {
                    PC_CoordI pos = new PC_CoordI(xx2, yy2, zz2);
                    if (pos.getId(world) != steel || pos.offset(1, 0, 0).getId(world) != steel || pos.offset(0, 0, 1).getId(world) != steel || pos.offset(1, 0, 1).getId(world) != steel) continue;
                    if (pos.offset(0, 1, 0).getId(world) == steel && pos.offset(1, 1, 0).getId(world) == chest && pos.offset(0, 1, 1).getId(world) == steel && pos.offset(1, 1, 1).getId(world) == chest) {
                        if (this.spawnMinerAt(world, pos, 0)) {
                            itemstack.a(1, (acq)entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    if (pos.offset(0, 1, 0).getId(world) == chest && pos.offset(1, 1, 0).getId(world) == chest && pos.offset(0, 1, 1).getId(world) == steel && pos.offset(1, 1, 1).getId(world) == steel) {
                        if (this.spawnMinerAt(world, pos, 3)) {
                            itemstack.a(1, (acq)entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    if (pos.offset(0, 1, 0).getId(world) == chest && pos.offset(1, 1, 0).getId(world) == steel && pos.offset(0, 1, 1).getId(world) == chest && pos.offset(1, 1, 1).getId(world) == steel) {
                        if (this.spawnMinerAt(world, pos, 2)) {
                            itemstack.a(1, (acq)entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    if (pos.offset(0, 1, 0).getId(world) == steel && pos.offset(1, 1, 0).getId(world) == steel && pos.offset(0, 1, 1).getId(world) == chest && pos.offset(1, 1, 1).getId(world) == chest) {
                        if (this.spawnMinerAt(world, pos, 1)) {
                            itemstack.a(1, (acq)entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    PC_Utils.chatMsg(eMinerStructure, false);
                    break block0;
                }
            }
        }
        return false;
    }

    private void removeSpawnStructure(xd world, PC_CoordI pos) {
        for (int x2 = 0; x2 <= 1; ++x2) {
            for (int z2 = 0; z2 <= 1; ++z2) {
                for (int y2 = 0; y2 <= 1; ++y2) {
                    pos.offset(x2, y2, z2).setBlock(world, 0, 0);
                }
            }
        }
    }

    private boolean spawnMinerAt(xd world, PC_CoordI pos, int rot) {
        this.minerBeingCreated = true;
        io inv = null;
        block0: for (int x2 = pos.x - 1; x2 <= pos.x + 1; ++x2) {
            for (int z2 = pos.z - 1; z2 <= pos.z + 1; ++z2) {
                inv = PC_InvUtils.getCompositeInventoryAt(world, x2, pos.y + 1, z2);
                if (inv != null) break block0;
            }
        }
        if (inv == null) {
            return false;
        }
        int cnt = PC_InvUtils.countPowerCrystals(inv);
        if (cnt == 0) {
            return false;
        }
        PC_InvUtils.moveStacks(inv, this);
        this.removeSpawnStructure(world, pos);
        this.minerBeingCreated = false;
        this.f();
        this.c((double)pos.x + 1.0, pos.y, (double)pos.z + 1.0, (float)rot * 90.0f, 0.0f);
        this.target = new PC_CoordI(pos.x + 1, pos.y, pos.z + 1);
        world.a(this);
        return true;
    }

    private void updateLevel() {
        if (!this.minerBeingCreated) {
            int cnt = PC_InvUtils.countPowerCrystals(this);
            if (cnt == 0) {
                this.turnIntoBlocks();
                return;
            }
            this.level = Math.min(cnt, 8);
            this.bridgeEnabled &= this.level >= 3;
            this.waterFillingEnabled &= this.level >= 6;
            this.lavaFillingEnabled &= this.level >= 4;
        }
    }

    private void turnIntoBlocks() {
        this.minerBeingCreated = true;
        int xh2 = (int)Math.round(this.o);
        int y2 = (int)Math.floor(this.p + (double)1.0E-4f);
        int zh2 = (int)Math.round(this.q);
        int yaw = this.u < 45.0f || this.u > 315.0f ? 0 : (this.u < 135.0f ? 1 : (this.u < 215.0f ? 2 : (this.u < 315.0f ? 3 : 0)));
        int xl2 = xh2 - 1;
        int zl2 = zh2 - 1;
        for (int x2 = xl2; x2 <= xh2; ++x2) {
            for (int z2 = zl2; z2 <= zh2; ++z2) {
                this.k.g(x2, y2, z2, pb.ai.bO);
                if (yaw == 0 && x2 == xh2 || yaw == 1 && z2 == zh2 || yaw == 2 && x2 == xl2 || yaw == 3 && z2 == zl2) {
                    this.k.g(x2, y2 + 1, z2, pb.au.bO);
                    continue;
                }
                this.k.g(x2, y2 + 1, z2, pb.ai.bO);
            }
        }
        io inv = null;
        block2: for (int x3 = xl2; x3 <= xh2; ++x3) {
            for (int k2 = zl2; k2 <= zh2; ++k2) {
                inv = PC_InvUtils.getCompositeInventoryAt(this.k, x3, y2 + 1, k2);
                if (inv != null) break block2;
            }
        }
        if (inv != null) {
            PC_InvUtils.moveStacks(this, inv);
        } else {
            PC_Logger.warning("Despawning miner - the chest blocks weren't found.");
        }
        this.A();
        if (this.openedGui) {
            ModLoader.getMinecraftInstance().h.af();
            ModLoader.openGUI(ModLoader.getMinecraftInstance().h, new zn(ModLoader.getMinecraftInstance().h.ap, inv));
        }
    }

    public PCmo_EntityMiner(xd world) {
        super(world);
        this.h = true;
        this.a(1.3f, 1.4f);
        this.H = 0.0f;
        this.fakePlayer = new PC_FakePlayer(world);
        this.T = 1.0f;
        this.R = 0.6f;
        this.ab = true;
    }

    public PCmo_EntityMiner(xd world, double dx2, double dy2, double dz2) {
        this(world);
        this.d(dx2, dy2 + (double)this.H, dz2);
        this.r = 0.0;
        this.s = 0.0;
        this.t = 0.0;
        this.l = dx2;
        this.m = dy2;
        this.n = dz2;
        this.target.x = (int)dx2;
        this.target.y = (int)dy2;
        this.target.z = (int)dz2;
    }

    @Override
    protected boolean e_() {
        return false;
    }

    @Override
    protected void b() {
        this.ac.a(17, new Integer(0));
        this.ac.a(18, new Integer(1));
        this.ac.a(19, new Integer(0));
    }

    @Override
    public wu b(nn entity) {
        return entity.y;
    }

    @Override
    public wu f_() {
        return this.y;
    }

    @Override
    public boolean d_() {
        return true;
    }

    @Override
    public double l() {
        return 1.0;
    }

    @Override
    public boolean g_() {
        return this.k.a(this.y.b(-0.1f, -0.4f, -0.1f), acn.g);
    }

    @Override
    public boolean a(md damagesource, int i2) {
        if (damagesource != md.j && (this.k.F || this.G || damagesource.b() == null && damagesource != md.l)) {
            return true;
        }
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() + i2 * 7);
        this.K();
        if (this.getDamageTaken() > 40) {
            if (this.i != null) {
                this.i.h(this);
            }
            this.turnIntoBlocks();
        }
        return true;
    }

    @Override
    public void k() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11);
    }

    @Override
    public boolean l_() {
        return !this.G;
    }

    @Override
    public void a(double d2, double d1, double d22, float f2, float f1, int i2) {
        this.r = this.velocityX;
        this.s = this.velocityY;
        this.t = this.velocityZ;
    }

    @Override
    public void a(double d2, double d1, double d22) {
        this.r = d2;
        this.s = d1;
        this.t = d22;
    }

    @Override
    public float h_() {
        return 1.0f;
    }

    private boolean shouldDestroyStack(aan stack) {
        if (stack == null) {
            return true;
        }
        if (stack.c == pb.w.bO) {
            return (this.DESTROY & 1) != 0;
        }
        if (stack.c == pb.v.bO) {
            return (this.DESTROY & 2) != 0;
        }
        if (stack.c == pb.F.bO) {
            return (this.DESTROY & 4) != 0;
        }
        return false;
    }

    public void setDestroyFlags(byte flags) {
        this.DESTROY = flags;
    }

    public byte getDestroyFlags() {
        return this.DESTROY;
    }

    public void resetEverything() {
        this.t = 0.0;
        this.r = 0.0;
        this.commandList = "";
        this.commandListSaved = "";
        this.currentCommand = -1;
        this.alignToBlocks();
        this.paused = false;
        this.resetStatus();
    }

    public void pauseProgram() {
        if (this.paused) {
            return;
        }
        this.commandListSaved = new String(this.commandList);
        String instruction = Character.toString(PCmo_Command.getCharFromInt(this.currentCommand).charValue());
        if (this.stepCounter > 0 && PCmo_Command.isCommandMove(this.currentCommand)) {
            instruction = (this.currentCommand == 0 ? "" : "-") + Integer.toString(this.stepCounter);
        } else if (instruction.equals("?")) {
            instruction = "";
        }
        this.commandListSaved = instruction + " " + this.commandListSaved;
        this.commandList = "";
        this.resetStatus();
        this.paused = true;
    }

    public void resumeProgram() {
        if (!this.paused) {
            return;
        }
        this.resetStatus();
        this.commandList = new String(this.commandListSaved.trim());
        this.commandListSaved = "";
        this.paused = false;
    }

    public void runNewProgram() throws PCmo_CommandException {
        String parsed = PCmo_Command.parseCode(this.program);
        this.keyboardControlled = false;
        this.paused = false;
        PCmo_MinerControlHandler.disconnectMinerFromKeyboardControl(this, true);
        this.alignToBlocks();
        this.resetStatus();
        this.commandList = parsed;
        this.commandListSaved = "";
    }

    private void resetStatus() {
        this.currentCommand = -1;
        this.roundRotation();
        this.target.x = (int)this.o;
        this.target.z = (int)this.q;
        this.resetMineCounter();
        this.stepCounter = 0;
        this.waitingForFuel = 0;
        this.fuelAllocated = 0;
        this.bridgeDone = false;
        this.upStepLaid = false;
    }

    public void setKeyboardControl(boolean yes) {
        this.keyboardControlled = yes;
        if (yes) {
            this.pauseProgram();
            PCmo_MinerControlHandler.setMinerForKeyboardControl(this, false);
        } else {
            PCmo_MinerControlHandler.disconnectMinerFromKeyboardControl(this, false);
            this.resumeProgram();
        }
    }

    public boolean canReceiveKeyboardCommand() {
        if (this.openedGui) {
            return false;
        }
        this.commandList = this.commandList.trim();
        return true;
    }

    public void receiveKeyboardCommand(int i2) {
        if (i2 == -3) {
            this.resetEverything();
            this.setKeyboardControl(false);
            try {
                this.runNewProgram();
            }
            catch (PCmo_CommandException e2) {
                // empty catch block
            }
        }
        if (i2 == -2) {
            this.resetEverything();
        } else {
            Character chr = PCmo_Command.getCharFromInt(i2);
            if (chr.equals(Character.valueOf('?'))) {
                return;
            }
            this.commandList = this.commandList + chr.toString();
        }
    }

    public void appendCode(String code) throws PCmo_CommandException {
        this.commandList = this.commandList + " " + PCmo_Command.parseCode(code);
    }

    public void setCode(String code) throws PCmo_CommandException {
        this.commandList = PCmo_Command.parseCode(code);
    }

    private int getNextCommand() {
        if (this.commandList.length() > 0) {
            Character first = Character.valueOf(this.commandList.charAt(0));
            int cmd = PCmo_Command.getIntFromChar(first);
            if (cmd != -1) {
                this.commandList = this.commandList.substring(1);
                if (cmd == 0 || cmd == 3 || cmd == 9) {
                    this.stepCounter = 1;
                }
                return cmd;
            }
            if (Character.isDigit(first.charValue()) || first.equals(Character.valueOf('-'))) {
                String numbuff = Character.toString(first.charValue());
                this.commandList = this.commandList.substring(1);
                while (this.commandList.length() > 0 && Character.isDigit((first = Character.valueOf(this.commandList.charAt(0))).charValue())) {
                    numbuff = numbuff + first.toString();
                    this.commandList = this.commandList.substring(1);
                }
                try {
                    this.stepCounter = Integer.valueOf(numbuff);
                    cmd = this.stepCounter > 0 ? 0 : 3;
                    this.stepCounter = Math.abs(this.stepCounter);
                    if (this.stepCounter == 0) {
                        return -1;
                    }
                    return cmd;
                }
                catch (NumberFormatException nfe) {
                    return -1;
                }
            }
            this.commandList = this.commandList.substring(1);
            return this.getNextCommand();
        }
        return -1;
    }

    private boolean isMinerAtTargetPos() {
        if (this.currentCommand == 0 || this.currentCommand == 9) {
            if (this.u == 0.0f) {
                return this.o <= (double)this.target.x;
            }
            if (this.u == 90.0f) {
                return this.q <= (double)this.target.z;
            }
            if (this.u == 180.0f) {
                return this.o >= (double)this.target.x;
            }
            if (this.u == 270.0f) {
                return this.q >= (double)this.target.z;
            }
        } else if (this.currentCommand == 3) {
            if (this.u == 0.0f) {
                return this.o >= (double)this.target.x;
            }
            if (this.u == 90.0f) {
                return this.q >= (double)this.target.z;
            }
            if (this.u == 180.0f) {
                return this.o <= (double)this.target.x;
            }
            if (this.u == 270.0f) {
                return this.q <= (double)this.target.z;
            }
        }
        return true;
    }

    private double getTargetDistanceX() {
        return Math.abs(this.o - (double)this.target.x);
    }

    private double getTargetDistanceZ() {
        return Math.abs(this.q - (double)this.target.z);
    }

    private void roundRotation() {
        if (this.u < 0.0f) {
            this.u = this.w = 360.0f - this.u;
        }
        if (this.u > 360.0f) {
            this.u = this.w = this.u - 360.0f;
        }
        if (this.u >= 315.0f || this.u < 45.0f) {
            this.u = 0.0f;
            this.w = 0.0f;
        }
        if (this.u >= 45.0f && this.u < 135.0f) {
            this.u = 90.0f;
            this.w = 90.0f;
        }
        if (this.u >= 135.0f && this.u < 215.0f) {
            this.u = 180.0f;
            this.w = 180.0f;
        }
        if (this.u >= 215.0f && this.u < 315.0f) {
            this.u = 270.0f;
            this.w = 270.0f;
        }
        this.rotationRemaining = 0;
    }

    private void alignToBlocks() {
        this.d(Math.round(this.o), this.p, Math.round(this.q));
    }

    private void prepareForCommandExecution() {
        if (this.currentCommand > -1) {
            this.realCommand = this.currentCommand;
            this.l = this.o = (double)((int)Math.round(this.o));
            this.l = this.q = (double)((int)Math.round(this.q));
            int x2 = (int)Math.round(this.o);
            int z2 = (int)Math.round(this.q);
            int y2 = (int)Math.floor(this.p + (double)1.0E-4f);
            this.roundRotation();
            if (this.currentCommand == 10) {
                this.depositToNearbyChest();
                this.currentCommand = -1;
            } else {
                if (this.currentCommand == 11) {
                    this.turnIntoBlocks();
                    return;
                }
                if (this.currentCommand == 14) {
                    this.bridgeEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 15) {
                    this.bridgeEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 12) {
                    this.miningEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 13) {
                    this.miningEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 16) {
                    this.lavaFillingEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 17) {
                    this.lavaFillingEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 18) {
                    this.waterFillingEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 19) {
                    this.waterFillingEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 8) {
                    if (!this.miningEnabled) {
                        this.currentCommand = -1;
                    } else {
                        this.resetMineCounter();
                        this.mineCounter[4] = -1;
                        this.mineCounter[5] = -1;
                    }
                } else if (this.currentCommand == 9) {
                    if (!this.miningEnabled) {
                        this.currentCommand = -1;
                    } else if (this.addFuelForCost(this.getStepCost())) {
                        this.resetMineCounter();
                        if (this.u == 0.0f) {
                            this.target = new PC_CoordI(x2 - 1, y2, z2);
                        }
                        if (this.u == 90.0f) {
                            this.target = new PC_CoordI(x2, y2, z2 - 1);
                        }
                        if (this.u == 180.0f) {
                            this.target = new PC_CoordI(x2 + 1, y2, z2);
                        }
                        if (this.u == 270.0f) {
                            this.target = new PC_CoordI(x2, y2, z2 + 1);
                        }
                        if (!this.isOnHalfStep()) {
                            this.mineCounter[6] = -1;
                            this.mineCounter[7] = -1;
                            this.mineCounter[8] = -1;
                            this.mineCounter[9] = -1;
                            this.mineCounter[10] = -1;
                            this.mineCounter[11] = -1;
                            this.upStepLaid = false;
                        } else {
                            this.currentCommand = 0;
                            switch ((int)Math.floor(this.u)) {
                                case 0: {
                                    this.layHalfStep(x2 - 2, y2, z2 - 1, false);
                                    this.layHalfStep(x2 - 2, y2, z2, false);
                                    break;
                                }
                                case 90: {
                                    this.layHalfStep(x2 - 1, y2, z2 - 2, false);
                                    this.layHalfStep(x2, y2, z2 - 2, false);
                                    break;
                                }
                                case 180: {
                                    this.layHalfStep(x2 + 1, y2, z2 - 1, false);
                                    this.layHalfStep(x2 + 1, y2, z2, false);
                                    break;
                                }
                                case 270: {
                                    this.layHalfStep(x2 - 1, y2, z2 + 1, false);
                                    this.layHalfStep(x2, y2, z2 + 1, false);
                                }
                            }
                        }
                    }
                } else if (this.currentCommand == 0) {
                    if (this.addFuelForCost(this.getStepCost())) {
                        this.resetMineCounter();
                        this.bridgeDone = false;
                        if (this.u == 0.0f) {
                            this.target.x = x2 - 1;
                            this.target.z = z2;
                        }
                        if (this.u == 90.0f) {
                            this.target.z = z2 - 1;
                            this.target.x = x2;
                        }
                        if (this.u == 180.0f) {
                            this.target.x = x2 + 1;
                            this.target.z = z2;
                        }
                        if (this.u == 270.0f) {
                            this.target.z = z2 + 1;
                            this.target.x = x2;
                        }
                    }
                } else if (this.currentCommand == 3) {
                    if (this.addFuelForCost(this.getStepCost())) {
                        this.bridgeDone = false;
                        if (this.u == 0.0f) {
                            this.target.x = x2 + 1;
                            this.target.z = z2;
                        }
                        if (this.u == 90.0f) {
                            this.target.z = z2 + 1;
                            this.target.x = x2;
                        }
                        if (this.u == 180.0f) {
                            this.target.x = x2 - 1;
                            this.target.z = z2;
                        }
                        if (this.u == 270.0f) {
                            this.target.z = z2 - 1;
                            this.target.x = x2;
                        }
                    }
                } else if (this.currentCommand == 1) {
                    this.rotationRemaining = -90;
                } else if (this.currentCommand == 2) {
                    this.rotationRemaining = 90;
                } else if (this.currentCommand == 5) {
                    if (this.u == 0.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                    if (this.u == 180.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                    if (this.u == 90.0f) {
                        this.currentCommand = -1;
                    }
                    if (this.u == 270.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = this.U.nextBoolean() ? 180 : -180;
                    }
                } else if (this.currentCommand == 4) {
                    if (this.u == 0.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                    if (this.u == 180.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                    if (this.u == 90.0f) {
                        this.currentCommand = 1;
                        int n2 = this.rotationRemaining = this.U.nextBoolean() ? 180 : -180;
                    }
                    if (this.u == 270.0f) {
                        this.currentCommand = -1;
                    }
                } else if (this.currentCommand == 6) {
                    if (this.u == 0.0f) {
                        this.currentCommand = 1;
                        int n3 = this.rotationRemaining = this.U.nextBoolean() ? 180 : -180;
                    }
                    if (this.u == 180.0f) {
                        this.currentCommand = -1;
                    }
                    if (this.u == 90.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                    if (this.u == 270.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                } else if (this.currentCommand == 7) {
                    if (this.u == 0.0f) {
                        this.currentCommand = -1;
                    }
                    if (this.u == 180.0f) {
                        this.currentCommand = 1;
                        int n4 = this.rotationRemaining = this.U.nextBoolean() ? 180 : -180;
                    }
                    if (this.u == 90.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                    if (this.u == 270.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                } else {
                    this.currentCommand = -1;
                }
            }
        }
    }

    private int getStepCost() {
        return gk.a(this.level / 2, 1, 4);
    }

    private boolean shouldMakeEffects() {
        return this.k.a((nn)this, 17.0) != null && mod_PCcore.soundsEnabled;
    }

    private void playMotionEffect() {
        if (!this.shouldMakeEffects()) {
            return;
        }
        this.k.a(this, "random.click", 0.02f, 0.8f);
    }

    private void playMiningEffect(PC_CoordI pos, int block_index) {
        ++this.miningTickCounter;
        if (!this.shouldMakeEffects()) {
            return;
        }
        int id2 = pos.getId(this.k);
        pb block = pb.m[id2];
        if (this.miningTickCounter % 8 == 0 && block != null) {
            ModLoader.getMinecraftInstance().C.b(block.cb.a(), (float)pos.x + 0.5f, (float)pos.y + 0.5f, (float)pos.z + 0.5f, (block.cb.b() + 1.0f) / 8.0f, block.cb.c() * 0.5f);
        }
        if (block != null) {
            ModLoader.getMinecraftInstance().j.a(pos.x, pos.y, pos.z, block_index < 4 ? this.getSideFromYaw() : (block_index < 6 ? 1 : 0));
        }
    }

    private int getSideFromYaw() {
        if (this.u == 0.0f) {
            return 5;
        }
        if (this.u == 90.0f) {
            return 3;
        }
        if (this.u == 180.0f) {
            return 4;
        }
        if (this.u == 270.0f) {
            return 2;
        }
        return 1;
    }

    private void harvestBlock_do(PC_CoordI pos) {
        int id2 = pos.getId(this.k);
        int meta = pos.getMeta(this.k);
        if (!this.shouldIgnoreBlockForHarvesting(pos, id2)) {
            if (pb.m[id2] instanceof PC_ICropBlock) {
                if (!((PC_ICropBlock)((Object)pb.m[id2])).isMature(this.k, pos)) {
                    return;
                }
                if (this.shouldMakeEffects()) {
                    this.k.g(2001, pos.x, pos.y, pos.z, id2 + (meta << 12));
                }
                for (aan stack : ((PC_ICropBlock)((Object)pb.m[id2])).machineHarvest(this.k, pos)) {
                    pb.m[id2].a(this.k, pos.x, pos.y, pos.z, stack);
                }
            } else if (PC_CropHarvestingManager.isBlockRegisteredCrop(id2)) {
                if (PC_CropHarvestingManager.canHarvestBlock(id2, meta)) {
                    aan[] harvested;
                    for (aan stack : harvested = PC_CropHarvestingManager.getHarvestedStacks(id2, meta)) {
                        if (this.shouldMakeEffects()) {
                            this.k.g(2001, pos.x, pos.y, pos.z, id2 + (meta << 12));
                        }
                        pb.m[id2].a(this.k, pos.x, pos.y, pos.z, stack);
                    }
                    int newMeta = PC_CropHarvestingManager.getReplantMeta(id2);
                    if (newMeta == -1) {
                        this.k.g(pos.x, pos.y, pos.z, 0);
                    } else {
                        this.k.f(pos.x, pos.y, pos.z, newMeta);
                    }
                    return;
                }
            } else {
                pb.m[id2].a(this.k, this.fakePlayer, pos.x, pos.y, pos.z, meta);
                pos.setBlock(this.k, 0, 0);
                if (this.shouldMakeEffects()) {
                    this.k.g(2001, pos.x, pos.y, pos.z, id2 + (meta << 12));
                }
            }
        }
    }

    private void performMiningUpdate(PC_CoordI pos, int loc) {
        int id2 = pos.getId(this.k);
        if (loc == 4 || loc == 5) {
            this.bridgeBuilding_do(pos.offset(0, -1, 0));
        }
        if (this.mineCounter[loc] <= 0) {
            if (this.shouldIgnoreBlockForHarvesting(pos, id2)) {
                if (this.mineCounter[loc] < 0) {
                    this.mineCounter[loc] = 0;
                }
                return;
            }
            if (pb.m[id2] != null) {
                int cost = this.getBlockMiningCost(pos, id2);
                if (id2 == 7 && this.level == 8 && pos.y == 0) {
                    cost = -1;
                }
                if (cost > 0 && this.addFuelForCost(cost)) {
                    this.mineCounter[loc] = cost;
                }
            }
        }
        if (this.waitingForFuel == 0 && this.mineCounter[loc] > 0) {
            int step = this.level;
            if (this.mineCounter[loc] < step) {
                step = this.mineCounter[loc];
                this.mineCounter[loc] = 0;
            } else {
                int n2 = loc;
                this.mineCounter[n2] = this.mineCounter[n2] - step;
            }
            this.consumeAllocatedFuel(step);
            if (this.mineCounter[loc] == 0) {
                this.harvestBlock_do(pos);
            }
        }
        if (this.mineCounter[loc] != 0 && pb.m[id2] != null) {
            this.playMiningEffect(pos, loc);
        }
    }

    private boolean isMiningInProgress() {
        for (int counter : this.mineCounter) {
            if (counter == 0) continue;
            return true;
        }
        return false;
    }

    private boolean isMiningDone() {
        return !this.isMiningInProgress();
    }

    private void resetMineCounter() {
        int i2;
        for (int element : this.mineCounter) {
            this.fuelAllocated -= element;
            if (this.fuelAllocated > 0) continue;
            this.fuelAllocated = 0;
            break;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            this.mineCounter[i2] = -1;
        }
        for (i2 = 4; i2 < this.mineCounter.length; ++i2) {
            this.mineCounter[i2] = 0;
        }
    }

    private boolean shouldIgnoreBlockForHarvesting(PC_CoordI pos, int id2) {
        if (id2 == 0 || pb.m[id2] == null || pb.m[id2] instanceof pt || id2 == pb.ar.bO || id2 == pb.be.bO || id2 == pb.bH.bO || pb.m[id2] instanceof agv || id2 == 55 || id2 == 70 || id2 == 72 || PC_BlockUtils.hasFlag(this.k, pos, "LIFT") || PC_BlockUtils.hasFlag(this.k, pos, "BELT")) {
            return true;
        }
        boolean flag = false;
        if (pb.m[id2] instanceof PC_ICropBlock) {
            boolean bl2 = flag = !((PC_ICropBlock)((Object)pb.m[id2])).isMature(this.k, pos);
        }
        if (PC_CropHarvestingManager.isBlockRegisteredCrop(id2)) {
            boolean bl3 = flag = !PC_CropHarvestingManager.canHarvestBlock(id2, pos.getMeta(this.k));
        }
        return flag && pb.m[id2].c(this.k, pos.x, pos.y, pos.z) == null;
    }

    private boolean isBlockUnbreakable(int id2) {
        return id2 == 7;
    }

    private boolean canHarvestBlockWithCurrentLevel(PC_CoordI pos, int id2) {
        if (id2 == 7 && this.level == 8) {
            return true;
        }
        if (this.isBlockUnbreakable(id2) || PC_BlockUtils.hasFlag(this.k, pos, "HARVEST_STOP")) {
            return false;
        }
        switch (this.level) {
            case 1: {
                return pb.m[id2].cd != acn.e && pb.m[id2].cd != acn.f && id2 != mod_PCcore.powerCrystal.bO;
            }
            case 2: {
                return id2 != 49 && id2 != 14 && id2 != 21 && id2 != 22 && id2 != 41 && id2 != 56 && id2 != 57 && id2 != 73 && id2 != 74 && id2 != mod_PCcore.powerCrystal.bO;
            }
            case 3: {
                return id2 != 49 && id2 != 56 && id2 != 57 && id2 != mod_PCcore.powerCrystal.bO;
            }
            case 4: {
                return id2 != 49;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private int getBlockMiningCost(PC_CoordI pos, int id2) {
        if (!this.canHarvestBlockWithCurrentLevel(pos, id2)) {
            return -1;
        }
        if (this.shouldIgnoreBlockForHarvesting(pos, id2)) {
            return 0;
        }
        if (pb.m[id2].cd != acn.e && pb.m[id2].cd != acn.f) {
            return 10;
        }
        if (id2 == 73 || id2 == 74 || id2 == 21 || id2 == 14) {
            return 100;
        }
        if (id2 == 16 || id2 == 15 || id2 == 42 || id2 == 98) {
            return 30;
        }
        if (id2 == 56 || id2 == 57 || id2 == 14) {
            return 150;
        }
        if (id2 == 49) {
            return 600;
        }
        if (id2 == 7) {
            return 2000;
        }
        if (id2 == mod_PCcore.powerCrystal.bO) {
            return 100;
        }
        return 20;
    }

    private boolean isLocationEmpty(PC_CoordI pos) {
        boolean notempty = false;
        notempty |= !this.checkIfAir(pos.offset(0, 0, 0), true);
        notempty |= !this.checkIfAir(pos.offset(-1, 0, 0), true);
        notempty |= !this.checkIfAir(pos.offset(0, 0, -1), true);
        notempty |= !this.checkIfAir(pos.offset(-1, 0, -1), true);
        notempty |= !this.checkIfAir(pos.offset(0, 1, 0), false);
        notempty |= !this.checkIfAir(pos.offset(-1, 1, 0), false);
        notempty |= !this.checkIfAir(pos.offset(0, 1, -1), false);
        return !(notempty |= !this.checkIfAir(pos.offset(-1, 1, -1), false));
    }

    private boolean checkIfAir(PC_CoordI pos, boolean lower) {
        int id2 = pos.getId(this.k);
        if (lower && id2 == pb.ak.bO) {
            return true;
        }
        pb block = pb.m[id2];
        return block == null || block.c(this.k, pos.x, pos.y, pos.z) == null;
    }

    private boolean isOnHalfStep() {
        return this.p - Math.floor(this.p + 1.0E-4) >= 0.4;
    }

    private boolean performBridgeBuilding() {
        if (!this.bridgeEnabled) {
            return true;
        }
        int y2 = (int)Math.floor(this.p - (double)0.9999f);
        if (this.isOnHalfStep()) {
            return true;
        }
        if (!this.bridgeBuilding_do(this.target.offset(0, -1, 0))) {
            return false;
        }
        if (!this.bridgeBuilding_do(this.target.offset(-1, -1, 0))) {
            return false;
        }
        if (!this.bridgeBuilding_do(this.target.offset(0, -1, -1))) {
            return false;
        }
        return this.bridgeBuilding_do(this.target.offset(-1, -1, -1));
    }

    private boolean bridgeBuilding_do(PC_CoordI pos) {
        if (this.checkIfAir(pos, false)) {
            if (this.level < 3) {
                this.currentCommand = -1;
                return false;
            }
            aan fill = this.getBlockForBuilding();
            if (fill == null) {
                return false;
            }
            int id2 = fill.c;
            int meta = fill.i();
            pos.setBlock(this.k, id2, meta);
            if (this.shouldMakeEffects()) {
                this.k.a((float)pos.x + 0.5f, (double)((float)pos.y + 0.5f), (double)((float)pos.z + 0.5f), pb.m[id2].cb.d(), (pb.m[id2].cb.b() + 1.0f) / 2.0f, pb.m[id2].cb.c() * 0.8f);
            }
        }
        return true;
    }

    private void layHalfStep(int x2, int y2, int z2, boolean step) {
        int id2;
        int dmg;
        if (step && this.k.a(x2, y2, z2) == 0 && (dmg = this.getDamageForHalfStep()) != -1) {
            this.k.d(x2, y2, z2, pb.ak.bO, dmg);
        }
        if ((id2 = this.k.a(x2, y2 + (step ? -1 : 0), z2)) == 0 || id2 == 8 || id2 == 9 || id2 == 10 || id2 == 11 || pb.m[id2].c(this.k, x2, y2, z2) == null) {
            aan fill = this.getBlockForBuilding();
            if (fill == null) {
                return;
            }
            id2 = fill.c;
            int meta = fill.i();
            this.k.d(x2, y2 + (step ? -1 : 0), z2, id2, meta);
            if (this.shouldMakeEffects()) {
                this.k.a((float)x2 + 0.5f, (double)((float)y2 + (float)(step ? -1 : 0) + 0.5f), (double)((float)z2 + 0.5f), pb.m[id2].cb.d(), (pb.m[id2].cb.b() + 1.0f) / 2.0f, pb.m[id2].cb.c() * 0.8f);
            }
        }
    }

    private int getDamageForHalfStep() {
        for (int pass = 0; pass < 3; ++pass) {
            for (int i2 = 0; i2 < this.a(); ++i2) {
                if (!this.isItemGoodForHalfStep(this.k_(i2), pass)) continue;
                aan returned = this.a(i2, 1);
                if (returned.c == pb.ak.bO) {
                    return returned.i();
                }
                return this.getDamageFromMaterialForHalfStep(returned.c);
            }
        }
        return -1;
    }

    private int getDamageFromMaterialForHalfStep(int id2) {
        switch (id2) {
            case 1: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 24: {
                return 1;
            }
            case 45: {
                return 4;
            }
            case 98: {
                return 5;
            }
        }
        return 3;
    }

    private boolean isItemGoodForHalfStep(aan is2, int pass) {
        if (is2 == null) {
            return false;
        }
        int id2 = is2.c;
        if (pass == 0) {
            return id2 == pb.w.bO || id2 == pb.ak.bO;
        }
        if (pass == 1) {
            return id2 == pb.x.bO || id2 == pb.t.bO;
        }
        if (pass == 2) {
            return id2 == pb.Q.bO || id2 == pb.bm.bO || id2 == pb.al.bO;
        }
        return false;
    }

    private aan getBlockForBuilding() {
        for (int pass = 0; pass < 3; ++pass) {
            for (int i2 = 0; i2 < this.a(); ++i2) {
                if (!this.isBlockGoodForBuilding(this.k_(i2), pass)) continue;
                return this.a(i2, 1);
            }
        }
        return null;
    }

    private boolean isBlockGoodForBuilding(aan is2, int pass) {
        if (is2 == null) {
            return false;
        }
        if (!(is2.a() instanceof vd)) {
            return false;
        }
        int id2 = is2.c;
        if (PC_BlockUtils.hasFlag(is2, "NO_BUILD")) {
            return false;
        }
        if (id2 == pb.E.bO || id2 == pb.F.bO) {
            return false;
        }
        if (pass == 0) {
            return id2 == 2 || id2 == 3 || id2 == 4;
        }
        if (pass == 1) {
            return id2 == 5 || id2 == 1 || id2 == 24 || id2 == 87;
        }
        if (id2 == 15 || id2 == 14 || id2 == 56) {
            return false;
        }
        return id2 != mod_PCcore.powerCrystal.bO && pb.m[is2.c] != null && pb.m[is2.c].cd.a();
    }

    private void compressInv() {
        if (this.level < 5) {
            return;
        }
        if (!this.compressBlocks) {
            return;
        }
        int sand = 0;
        int diamond = 0;
        int lapis = 0;
        int glowstone = 0;
        int snowball = 0;
        for (int pass = 0; pass < 3; ++pass) {
            for (int i2 = 0; i2 < this.a(); ++i2) {
                if (this.k_(i2) == null) continue;
                if (this.k_((int)i2).c == pb.E.bO) {
                    sand += this.k_((int)i2).a;
                    this.a(i2, null);
                    continue;
                }
                if (this.k_((int)i2).c == yr.n.bQ) {
                    diamond += this.k_((int)i2).a;
                    this.a(i2, null);
                    continue;
                }
                if (this.k_((int)i2).c == yr.aD.bQ) {
                    snowball += this.k_((int)i2).a;
                    this.a(i2, null);
                    continue;
                }
                if (this.k_((int)i2).c == yr.aT.bQ) {
                    glowstone += this.k_((int)i2).a;
                    this.a(i2, null);
                    continue;
                }
                if (this.k_((int)i2).c != yr.aW.bQ || this.k_(i2).i() != 4) continue;
                lapis += this.k_((int)i2).a;
                this.a(i2, null);
            }
        }
        if (sand > 0) {
            aan remaining;
            while (sand >= 4 && PC_InvUtils.addItemStackToInventory(this, new aan(pb.Q.bO, 1, 0))) {
                sand -= 4;
            }
            if (sand > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new aan(pb.E.bO, sand, 0))) {
                this.a(remaining, 1.0f);
            }
        }
        if (snowball > 0) {
            aan remaining;
            while (snowball >= 4 && PC_InvUtils.addItemStackToInventory(this, new aan(pb.aU.bO, 1, 0))) {
                snowball -= 4;
            }
            if (snowball > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new aan(yr.aD.bQ, snowball, 0))) {
                this.a(remaining, 1.0f);
            }
        }
        if (glowstone > 0) {
            aan remaining;
            while (glowstone >= 4 && PC_InvUtils.addItemStackToInventory(this, new aan(pb.bd.bO, 1, 0))) {
                glowstone -= 4;
            }
            if (glowstone > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new aan(yr.aT.bQ, glowstone, 0))) {
                this.a(remaining, 1.0f);
            }
        }
        if (diamond > 0) {
            aan remaining;
            while (diamond >= 9 && PC_InvUtils.addItemStackToInventory(this, new aan(pb.ax.bO, 1, 0))) {
                diamond -= 9;
            }
            if (diamond > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new aan(yr.n.bQ, diamond, 0))) {
                this.a(remaining, 1.0f);
            }
        }
        if (lapis > 0) {
            aan remaining;
            while (lapis >= 9 && PC_InvUtils.addItemStackToInventory(this, new aan(pb.O.bO, 1, 0))) {
                lapis -= 9;
            }
            if (lapis > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new aan(yr.aW.bQ, lapis, 4))) {
                this.a(remaining, 1.0f);
            }
        }
    }

    private void fillLavaNearby() {
        if (this.level < 4 || !this.lavaFillingEnabled) {
            return;
        }
        int y1 = (int)Math.floor(this.p + (double)1.0E-4f);
        int x1 = (int)Math.round(this.o);
        int z1 = (int)Math.round(this.q);
        boolean replace = true;
        for (int x2 = x1 - 2; x2 <= x1 + 1; ++x2) {
            for (int y2 = y1 - 1; y2 <= y1 + 2; ++y2) {
                for (int z2 = z1 - 2; z2 <= z1 + 1; ++z2) {
                    aan fill;
                    boolean bl2 = replace = y2 != y1 && y2 != y1 + 1 || x2 != x1 && x2 != x1 - 1 || z2 != z1 && z2 != z1 - 1;
                    if (x2 == x1 - 2 && y2 == y1 - 1 || x2 == x1 - 2 && y2 == y1 + 2 || x2 == x1 + 1 && y2 == y1 - 1 || x2 == x1 + 1 && y2 == y1 + 2 || z2 == z1 - 2 && y2 == y1 - 1 || z2 == z1 - 2 && y2 == y1 + 2 || z2 == z1 + 1 && y2 == y1 - 1 || z2 == z1 + 1 && y2 == y1 + 2 || x2 == x1 - 2 && z2 == z1 - 2 || x2 == x1 - 2 && z2 == z1 + 1 || x2 == x1 + 1 && z2 == z1 - 2 || x2 == x1 + 1 && z2 == z1 + 1) continue;
                    switch ((int)Math.floor(this.u)) {
                        case 180: {
                            if (x2 != x1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 270: {
                            if (z2 != z1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 0: {
                            if (x2 != x1 + 1) break;
                            replace = false;
                            break;
                        }
                        case 90: {
                            if (z2 != z1 + 1) break;
                            replace = false;
                        }
                    }
                    int id2 = this.k.a(x2, y2, z2);
                    if (id2 != 10 && id2 != 11) continue;
                    this.lavaFillBucket();
                    int fillId = 0;
                    int fillMeta = 0;
                    if (replace && (fill = this.getBlockForBuilding()) != null) {
                        fillId = fill.c;
                        fillMeta = fill.i();
                    }
                    this.k.d(x2, y2, z2, fillId, fillMeta);
                    if (pb.m[fillId] == null || !this.shouldMakeEffects()) continue;
                    this.k.a((float)x2 + 0.5f, (double)((float)y2 + 0.5f), (double)((float)z2 + 0.5f), pb.m[fillId].cb.d(), (pb.m[fillId].cb.b() + 1.0f) / 2.0f, pb.m[fillId].cb.c() * 0.8f);
                }
            }
        }
    }

    private void fillWaterNearby() {
        if (this.level < 6 || !this.waterFillingEnabled) {
            return;
        }
        int y1 = (int)Math.floor(this.p + 0.0);
        int x1 = (int)Math.round(this.o);
        int z1 = (int)Math.round(this.q);
        boolean replace = true;
        for (int x2 = x1 - 2; x2 <= x1 + 1; ++x2) {
            for (int y2 = y1 - 1; y2 <= y1 + 2; ++y2) {
                for (int z2 = z1 - 2; z2 <= z1 + 1; ++z2) {
                    aan fill;
                    boolean bl2 = replace = y2 != y1 && y2 != y1 + 1 || x2 != x1 && x2 != x1 - 1 || z2 != z1 && z2 != z1 - 1;
                    if (x2 == x1 - 2 && y2 == y1 - 1 || x2 == x1 - 2 && y2 == y1 + 2 || x2 == x1 + 1 && y2 == y1 - 1 || x2 == x1 + 1 && y2 == y1 + 2 || z2 == z1 - 2 && y2 == y1 - 1 || z2 == z1 - 2 && y2 == y1 + 2 || z2 == z1 + 1 && y2 == y1 - 1 || z2 == z1 + 1 && y2 == y1 + 2 || x2 == x1 - 2 && z2 == z1 - 2 || x2 == x1 - 2 && z2 == z1 + 1 || x2 == x1 + 1 && z2 == z1 - 2 || x2 == x1 + 1 && z2 == z1 + 1) continue;
                    switch ((int)Math.floor(this.u)) {
                        case 180: {
                            if (x2 != x1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 270: {
                            if (z2 != z1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 0: {
                            if (x2 != x1 + 1) break;
                            replace = false;
                            break;
                        }
                        case 90: {
                            if (z2 != z1 + 1) break;
                            replace = false;
                        }
                    }
                    int id2 = this.k.a(x2, y2, z2);
                    if (id2 != 8 && id2 != 9) continue;
                    int fillId = 0;
                    int fillMeta = 0;
                    if (replace && (fill = this.getBlockForBuilding()) != null) {
                        fillId = fill.c;
                        fillMeta = fill.i();
                    }
                    this.k.d(x2, y2, z2, fillId, fillMeta);
                    if (pb.m[fillId] == null || !this.shouldMakeEffects()) continue;
                    this.k.a((float)x2 + 0.5f, (double)((float)y2 + 0.5f), (double)((float)z2 + 0.5f), pb.m[fillId].cb.d(), (pb.m[fillId].cb.b() + 1.0f) / 2.0f, pb.m[fillId].cb.c() * 0.8f);
                }
            }
        }
    }

    private void burriedFix(boolean targetPos) {
        int y1 = (int)Math.floor(this.p + (double)1.0E-4f);
        if (this.isOnHalfStep()) {
            ++y1;
        }
        int x1 = targetPos ? this.target.x : (int)Math.round(this.o);
        int z1 = targetPos ? this.target.z : (int)Math.round(this.q);
        for (int x2 = x1 - 1; x2 <= x1; ++x2) {
            for (int y2 = y1; y2 <= y1 + 1; ++y2) {
                for (int z2 = z1 - 1; z2 <= z1; ++z2) {
                    int id2 = this.k.a(x2, y2, z2);
                    if (id2 == 0 || !(pb.m[id2] instanceof yp) && id2 != pb.w.bO && id2 != pb.v.bO) continue;
                    this.harvestBlock_do(new PC_CoordI(x2, y2, z2));
                }
            }
        }
    }

    private void depositToNearbyChest() {
        int y1 = (int)Math.floor(this.p + (double)1.0E-4f);
        int x1 = (int)Math.round(this.o);
        int z1 = (int)Math.round(this.q);
        for (int x2 = x1 - 2; x2 <= x1 + 1; ++x2) {
            for (int y2 = y1; y2 <= y1 + 1; ++y2) {
                for (int z2 = z1 - 2; z2 <= z1 + 1; ++z2) {
                    io chest = PC_InvUtils.getCompositeInventoryAt(this.k, x2, y2, z2);
                    if (chest == null) continue;
                    for (int i2 = 0; i2 < this.a(); ++i2) {
                        boolean stored = false;
                        boolean crystal = false;
                        aan stack = this.k_(i2);
                        if (!(stack == null || stack.c == mod_PCcore.powerDust.bQ || stack.c == pb.aq.bO || stack.c == yr.aw.bQ || stack.c == yr.ay.bQ || this.keepAllFuel && PC_InvUtils.getFuelValue(stack, 0.9) != 0)) {
                            if (stack.c == mod_PCcore.powerCrystal.bO) {
                                if (stack.a <= 1) continue;
                                crystal = true;
                                stack = this.k_(i2).k();
                                --stack.a;
                                this.a(i2, stack.a);
                            }
                            stored = PC_InvUtils.addWholeItemStackToInventory(chest, stack);
                        }
                        if (!stored || crystal) continue;
                        this.a(i2, null);
                    }
                    if (this.shouldMakeEffects()) {
                        this.k.a(this, "random.pop", 0.2f, 0.5f + this.U.nextFloat() * 0.3f);
                    }
                    return;
                }
            }
        }
    }

    private void performTorchPlacing() {
        if (this.level < 3) {
            return;
        }
        int y2 = (int)Math.floor(this.p + (double)1.0E-4f);
        int x2 = (int)Math.round(this.o);
        int z2 = (int)Math.round(this.q);
        if (this.a(1.0f) > 0.2f) {
            return;
        }
        if (this.g_()) {
            return;
        }
        if (!this.hasTorch()) {
            return;
        }
        int leftX = x2;
        int leftZ = z2;
        int rightX = x2;
        int rightZ = z2;
        if (this.u == 0.0f) {
            rightZ = z2 - 1;
            leftZ = z2;
        }
        if (this.u == 90.0f) {
            rightX = x2;
            leftX = x2 - 1;
        }
        if (this.u == 180.0f) {
            leftZ = z2 - 1;
            rightZ = z2;
            rightX = leftX = x2 - 1;
        }
        if (this.u == 270.0f) {
            rightX = x2 - 1;
            leftX = x2;
            leftZ = rightZ = z2 - 1;
        }
        pb torch = pb.aq;
        if (!this.torchesOnlyOnFloor) {
            if (this.k.a(rightX, y2 + 1, rightZ) == 0 && torch.e(this.k, rightX, y2 + 1, rightZ)) {
                this.k.g(rightX, y2 + 1, rightZ, torch.bO);
                this.getTorch();
                return;
            }
            if (this.k.a(leftX, y2 + 1, leftZ) == 0 && torch.e(this.k, leftX, y2 + 1, leftZ)) {
                this.k.g(leftX, y2 + 1, leftZ, torch.bO);
                this.getTorch();
                return;
            }
        }
        if (this.k.a(rightX, y2, rightZ) == 0 && torch.e(this.k, rightX, y2, rightZ)) {
            this.k.g(rightX, y2, rightZ, torch.bO);
            if (this.realCommand != 9) {
                pb.aq.c(this.k, rightX, y2, rightZ, 1);
            }
            this.getTorch();
            return;
        }
        if (this.k.a(leftX, y2, leftZ) == 0 && torch.e(this.k, leftX, y2, leftZ)) {
            this.k.g(leftX, y2, leftZ, torch.bO);
            if (this.realCommand != 9) {
                pb.aq.c(this.k, leftX, y2, leftZ, 1);
            }
            this.getTorch();
            return;
        }
    }

    private boolean getTorch() {
        for (int i2 = 0; i2 < this.a(); ++i2) {
            if (this.k_(i2) == null || this.k_((int)i2).c != pb.aq.bO) continue;
            this.a(i2, 1);
            return true;
        }
        return false;
    }

    private boolean hasTorch() {
        for (int i2 = 0; i2 < this.a(); ++i2) {
            if (this.k_(i2) == null || this.k_((int)i2).c != pb.aq.bO) continue;
            return true;
        }
        return false;
    }

    private boolean lavaFillBucket() {
        for (int i2 = 0; i2 < this.a(); ++i2) {
            int id2;
            if (this.k_(i2) == null || (id2 = this.k_((int)i2).c) != yr.aw.bQ) continue;
            this.a(i2, new aan(yr.ay, 1, 0));
            return true;
        }
        return false;
    }

    @Override
    public void J_() {
        int j1;
        List list;
        double d7;
        super.J_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        this.l = this.o;
        this.m = this.p;
        this.n = this.q;
        boolean stop = this.programmingGuiOpen;
        if (!stop) {
            if (this.waitingForFuel > 0 && this.addFuelForCost(this.waitingForFuel)) {
                this.waitingForFuel = 0;
                this.prepareForCommandExecution();
            }
            this.releaseAllocatedFuelIfNoLongerNeeded();
            if (this.waitingForFuel < 0) {
                this.waitingForFuel = 0;
            }
            if (this.currentCommand == -1 && this.waitingForFuel != 0) {
                this.waitingForFuel = 0;
            }
            if (this.waitingForFuel == 0) {
                if (PCmo_Command.isCommandTurn(this.currentCommand)) {
                    this.t = 0.0;
                    this.r = 0.0;
                    this.o = this.target.x;
                    this.q = this.target.z;
                    if (Math.abs(this.rotationRemaining) < 3) {
                        this.currentCommand = -1;
                        this.o = this.target.x;
                        this.q = this.target.z;
                        this.rotationRemaining = 0;
                        this.roundRotation();
                    } else {
                        this.playMotionEffect();
                        int step = gk.a(this.level, 3, 7);
                        step = gk.a(step, 0, Math.abs(this.rotationRemaining));
                        int incr = this.rotationRemaining > 0 ? step : -step;
                        this.u += (float)incr;
                        if (this.u < 0.0f) {
                            this.u = this.w = 360.0f + this.u;
                        }
                        if (this.u > 360.0f) {
                            this.u = this.w = this.u - 360.0f;
                        }
                        this.rotationRemaining -= incr;
                    }
                }
                if (this.currentCommand != -1) {
                    this.burriedFix(false);
                }
                if (PCmo_Command.isCommandMove(this.currentCommand) || this.currentCommand == 9 && this.isMiningDone()) {
                    this.roundRotation();
                    this.performTorchPlacing();
                    if (this.isMinerAtTargetPos()) {
                        this.consumeAllocatedFuel(this.getStepCost());
                        this.fillLavaNearby();
                        this.fillWaterNearby();
                        if (this.getTargetDistanceX() > 0.03125) {
                            this.o = this.l = (double)this.target.x;
                        }
                        if (this.getTargetDistanceZ() > 0.03125) {
                            this.q = this.n = (double)this.target.z;
                        }
                        --this.stepCounter;
                        if (this.stepCounter <= 0) {
                            this.currentCommand = -1;
                            if (this.commandList.length() == 0) {
                                this.r = 0.0;
                                this.t = 0.0;
                            }
                            this.stepCounter = 0;
                        } else {
                            this.prepareForCommandExecution();
                        }
                    }
                }
                if (PCmo_Command.isCommandMove(this.currentCommand) || this.currentCommand == 8 || this.currentCommand == 9) {
                    boolean canMove;
                    this.roundRotation();
                    boolean fw2 = this.currentCommand == 0;
                    boolean dwn = this.currentCommand == 8;
                    boolean up2 = this.currentCommand == 9;
                    boolean back = this.currentCommand == 3;
                    int x2 = (int)Math.round(this.o);
                    int y2 = (int)Math.floor(this.p + (double)1.0E-4f);
                    if (this.isOnHalfStep()) {
                        ++y2;
                    }
                    int z2 = (int)Math.round(this.q);
                    boolean bridgeOk = true;
                    if (!this.bridgeDone && (bridgeOk = this.performBridgeBuilding())) {
                        this.bridgeDone = true;
                    }
                    if (this.isMiningInProgress() || !bridgeOk) {
                        this.t = 0.0;
                        this.r = 0.0;
                    }
                    boolean miningDone = this.isMiningDone();
                    boolean bl2 = canMove = bridgeOk && !dwn && (!up2 || miningDone);
                    if (up2 && !miningDone) {
                        this.performMiningUpdate(new PC_CoordI(x2, y2 + 2, z2), 8);
                        this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 + 2, z2), 9);
                        this.performMiningUpdate(new PC_CoordI(x2, y2 + 2, z2 - 1), 10);
                        this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 + 2, z2 - 1), 11);
                    }
                    double motionAdd = MOTION_SPEED[this.level - 1] * (double)(fw2 || up2 ? 1 : -1) * 0.5;
                    if (this.u == 180.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x2 + 1, y2, z2 - 1), 0);
                            this.performMiningUpdate(new PC_CoordI(x2 + 1, y2, z2), 1);
                            this.performMiningUpdate(new PC_CoordI(x2 + 1, y2 + 1, z2), 2);
                            this.performMiningUpdate(new PC_CoordI(x2 + 1, y2 + 1, z2 - 1), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x2 + 1, y2 - 1, z2 - 1), 4);
                                this.performMiningUpdate(new PC_CoordI(x2 + 1, y2 - 1, z2), 5);
                            }
                            if (up2) {
                                this.performMiningUpdate(new PC_CoordI(x2 + 1, y2 + 2, z2 - 1), 6);
                                this.performMiningUpdate(new PC_CoordI(x2 + 1, y2 + 2, z2), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y2)) && canMove) {
                            this.r += motionAdd;
                        }
                        this.t = 0.0;
                    }
                    if (this.u == 270.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x2 - 1, y2, z2 + 1), 0);
                            this.performMiningUpdate(new PC_CoordI(x2, y2, z2 + 1), 1);
                            this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 + 1, z2 + 1), 2);
                            this.performMiningUpdate(new PC_CoordI(x2, y2 + 1, z2 + 1), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 - 1, z2 + 1), 4);
                                this.performMiningUpdate(new PC_CoordI(x2, y2 - 1, z2 + 1), 5);
                            }
                            if (up2) {
                                this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 + 2, z2 + 1), 6);
                                this.performMiningUpdate(new PC_CoordI(x2, y2 + 2, z2 + 1), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y2)) && canMove) {
                            this.t += motionAdd;
                        }
                        this.r = 0.0;
                    }
                    if (this.u == 0.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x2 - 2, y2, z2 - 1), 0);
                            this.performMiningUpdate(new PC_CoordI(x2 - 2, y2, z2), 1);
                            this.performMiningUpdate(new PC_CoordI(x2 - 2, y2 + 1, z2), 2);
                            this.performMiningUpdate(new PC_CoordI(x2 - 2, y2 + 1, z2 - 1), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x2 - 2, y2 - 1, z2 - 1), 4);
                                this.performMiningUpdate(new PC_CoordI(x2 - 2, y2 - 1, z2), 5);
                            }
                            if (up2) {
                                this.performMiningUpdate(new PC_CoordI(x2 - 2, y2 + 2, z2 - 1), 6);
                                this.performMiningUpdate(new PC_CoordI(x2 - 2, y2 + 2, z2), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y2)) && canMove) {
                            this.r -= motionAdd;
                        }
                        this.t = 0.0;
                    }
                    if (this.u == 90.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x2 - 1, y2, z2 - 2), 0);
                            this.performMiningUpdate(new PC_CoordI(x2, y2, z2 - 2), 1);
                            this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 + 1, z2 - 2), 2);
                            this.performMiningUpdate(new PC_CoordI(x2, y2 + 1, z2 - 2), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 - 1, z2 - 2), 4);
                                this.performMiningUpdate(new PC_CoordI(x2, y2 - 1, z2 - 2), 5);
                            }
                            if (up2) {
                                this.performMiningUpdate(new PC_CoordI(x2 - 1, y2 + 2, z2 - 2), 6);
                                this.performMiningUpdate(new PC_CoordI(x2, y2 + 2, z2 - 2), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y2)) && canMove) {
                            this.t -= motionAdd;
                        }
                        this.r = 0.0;
                    }
                    if (dwn && !this.isMiningInProgress()) {
                        this.currentCommand = -1;
                    }
                    if (up2 && this.isMiningDone() && !this.upStepLaid) {
                        switch ((int)Math.floor(this.u)) {
                            case 0: {
                                this.layHalfStep(x2 - 2, y2, z2 - 1, true);
                                this.layHalfStep(x2 - 2, y2, z2, true);
                                break;
                            }
                            case 90: {
                                this.layHalfStep(x2 - 1, y2, z2 - 2, true);
                                this.layHalfStep(x2, y2, z2 - 2, true);
                                break;
                            }
                            case 180: {
                                this.layHalfStep(x2 + 1, y2, z2 - 1, true);
                                this.layHalfStep(x2 + 1, y2, z2, true);
                                break;
                            }
                            case 270: {
                                this.layHalfStep(x2 - 1, y2, z2 + 1, true);
                                this.layHalfStep(x2, y2, z2 + 1, true);
                            }
                        }
                        this.upStepLaid = true;
                    }
                    if (!(this.miningEnabled && this.isMiningInProgress() && this.currentCommand != 3 || this.isLocationEmpty(this.target.setY(y2)))) {
                        this.burriedFix(fw2 && this.miningEnabled);
                        if (!this.isLocationEmpty(this.target.setY(y2))) {
                            if (!this.miningEnabled || this.currentCommand == 3) {
                                this.currentCommand = -1;
                                this.resetMineCounter();
                                this.consumeAllocatedFuel(this.getStepCost());
                                this.target.x = (int)Math.round(this.o);
                                this.target.z = (int)Math.round(this.q);
                                this.target.y = (int)Math.round(this.p + (double)0.001f);
                                this.stepCounter = 0;
                            }
                            this.t = 0.0;
                            this.r = 0.0;
                        }
                    }
                }
            }
        }
        if (!this.z) {
            this.s -= 0.04;
        }
        if (this.r < -(d7 = MOTION_SPEED[this.level - 1])) {
            this.r = -d7;
        }
        if (this.r > d7) {
            this.r = d7;
        }
        if (this.t < -d7) {
            this.t = -d7;
        }
        if (this.t > d7) {
            this.t = d7;
        }
        if (!stop && this.z && this.currentCommand == -1 && this.commandList.length() > 0) {
            int oldCmd = this.currentCommand;
            this.currentCommand = this.getNextCommand();
            if (this.currentCommand != -1 && this.currentCommand != oldCmd) {
                this.alignToBlocks();
            }
            if (this.currentCommand == -1 && !this.keyboardControlled) {
                this.alignToBlocks();
            }
            this.prepareForCommandExecution();
            if (this.currentCommand != -1) {
                this.d(true);
            }
        }
        if (this.currentCommand == -1 && this.commandList.length() == 0) {
            this.r = 0.0;
            this.t = 0.0;
            this.d(false);
        }
        if (Math.abs(this.r) > 1.0E-4 || Math.abs(this.t) > 1.0E-4) {
            this.playMotionEffect();
        }
        if ((list = this.k.a(fq.class, this.y.b(1.5, 0.5, 1.5))) != null && list.size() > 0) {
            for (j1 = 0; j1 < list.size(); ++j1) {
                boolean compress;
                fq entity = (fq)list.get(j1);
                if (entity.c >= 7) continue;
                int id2 = entity.a.c;
                int dmg = entity.a.i();
                boolean xtal = id2 == mod_PCcore.powerCrystal.bO;
                boolean bl3 = compress = id2 == pb.E.bO || id2 == yr.aD.bQ || id2 == yr.n.bQ || id2 == yr.aW.bQ && dmg == 4 || id2 == yr.aT.bQ;
                if (this.shouldDestroyStack(entity.a)) {
                    entity.A();
                    continue;
                }
                if (PC_InvUtils.addItemStackToInventory(this, entity.a)) {
                    entity.A();
                }
                if (xtal) {
                    this.updateLevel();
                }
                if (!compress || !this.compressBlocks) continue;
                this.compressInv();
            }
        }
        if ((list = this.k.b((nn)this, this.y.b(0.2, 0.01, 0.2))) != null && list.size() > 0) {
            for (j1 = 0; j1 < list.size(); ++j1) {
                nn entity = (nn)list.get(j1);
                if (entity instanceof rt || entity instanceof bz || entity.G) continue;
                if (entity instanceof nm) {
                    PC_InvUtils.addItemStackToInventory(this, new aan(yr.l, 1, 0));
                    entity.A();
                    return;
                }
                double motionX_prev = this.r;
                double motionY_prev = this.s;
                double motionZ_prev = this.t;
                entity.g(this);
                this.r = motionX_prev;
                this.s = motionY_prev;
                this.t = motionZ_prev;
            }
        }
        this.b(Math.min(this.r, this.getTargetDistanceX()), this.s, Math.min(this.t, this.getTargetDistanceZ()));
        this.r *= 0.7;
        this.t *= 0.7;
    }

    @Override
    public void g(nn entity) {
        if (entity.i == this || entity.j == this) {
            return;
        }
        double d2 = entity.o - this.o;
        double d1 = entity.q - this.q;
        double d22 = gk.a(d2, d1);
        if (d22 >= (double)0.01f) {
            d22 = gk.a(d22);
            d2 /= d22;
            d1 /= d22;
            double d3 = 1.0 / d22;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d2 *= d3;
            d1 *= d3;
            d2 *= (double)0.05f;
            d1 *= (double)0.05f;
            this.al = true;
            entity.c(d2 *= (double)(1.0f - this.T), 0.0, d1 *= (double)(1.0f - this.T));
        }
    }

    @Override
    protected void b(ady tag) {
        ady code = new ady();
        code.a("CommandList", this.commandList);
        code.a("CurrentCommand", (short)this.currentCommand);
        code.a("RealCommand", (short)this.realCommand);
        code.a("StepCounter", (short)this.stepCounter);
        code.a("CommandListSaved", this.commandListSaved);
        code.a("Program", this.program);
        code.a("Paused", this.paused);
        code.a("Keyboard", this.keyboardControlled);
        tag.a("MinerCode", (gh)code);
        ady status = new ady();
        status.a("Level", (byte)this.level);
        status.a("RotationRemaining", (short)this.rotationRemaining);
        PC_Utils.writeWrappedToNBT(status, "target", this.target);
        status.a("fuelBuffer", this.fuelBuffer);
        status.a("fuelAllocated", this.fuelAllocated);
        status.a("waitingForFuel", this.waitingForFuel);
        status.a("miningEnabled", this.miningEnabled);
        status.a("bridgeEnabled", this.bridgeEnabled);
        status.a("lavaFillingEnabled", this.lavaFillingEnabled);
        status.a("waterEnabled", this.waterFillingEnabled);
        status.a("keepAllFuel", this.keepAllFuel);
        status.a("torchesOnlyOnFloor", this.torchesOnlyOnFloor);
        status.a("craftCompress", this.compressBlocks);
        status.a("Destroy", this.DESTROY);
        status.a("waitingForFuel", this.waitingForFuel);
        status.a("mineTime0", this.mineCounter[0]);
        status.a("mineTime1", this.mineCounter[1]);
        status.a("mineTime2", this.mineCounter[2]);
        status.a("mineTime3", this.mineCounter[3]);
        status.a("mineTime4", this.mineCounter[4]);
        status.a("mineTime5", this.mineCounter[5]);
        tag.a("MinerStatus", (gh)status);
        no nbttaglist = new no();
        for (int i2 = 0; i2 < this.inventory.length; ++i2) {
            if (this.inventory[i2] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i2);
            this.inventory[i2].b(nbttagcompound1);
            nbttaglist.a(nbttagcompound1);
        }
        tag.a("Items", nbttaglist);
    }

    @Override
    protected void a(ady tag) {
        ady code = tag.m("MinerCode");
        this.commandList = code.j("CommandList");
        this.currentCommand = code.e("CurrentCommand");
        this.realCommand = code.e("RealCommand");
        this.stepCounter = code.e("StepCounter");
        this.commandListSaved = code.j("CommandListSaved");
        this.program = code.j("Program");
        this.paused = code.o("Paused");
        this.keyboardControlled = code.o("Keyboard");
        ady status = tag.m("MinerStatus");
        this.level = gk.a(status.d("Level"), 1, 8);
        this.rotationRemaining = status.e("RotationRemaining");
        PC_Utils.readWrappedFromNBT(status, "target", this.target);
        this.fuelBuffer = status.f("fuelBuffer");
        this.fuelAllocated = status.f("fuelAllocated");
        this.waitingForFuel = status.f("waitingForFuel");
        this.miningEnabled = status.o("miningEnabled");
        this.bridgeEnabled = status.o("bridgeEnabled");
        this.lavaFillingEnabled = status.o("lavaFillingEnabled");
        this.waterFillingEnabled = status.o("waterEnabled");
        this.keepAllFuel = status.o("keepAllFuel");
        this.torchesOnlyOnFloor = status.o("torchesOnlyOnFloor");
        this.compressBlocks = status.o("craftCompress");
        this.DESTROY = status.d("Destroy");
        this.waitingForFuel = status.f("waitingForFuel");
        this.mineCounter[0] = status.f("mineTime0");
        this.mineCounter[1] = status.f("mineTime1");
        this.mineCounter[2] = status.f("mineTime2");
        this.mineCounter[3] = status.f("mineTime3");
        this.mineCounter[4] = status.f("mineTime4");
        this.mineCounter[5] = status.f("mineTime5");
        no nbttaglist = tag.n("Items");
        this.inventory = new aan[this.a()];
        for (int i2 = 0; i2 < nbttaglist.d(); ++i2) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i2);
            int j2 = nbttagcompound1.d("Slot") & 0xFF;
            if (j2 < 0 || j2 >= this.inventory.length) continue;
            this.inventory[j2] = aan.a(nbttagcompound1);
        }
        if (this.keyboardControlled) {
            PCmo_MinerControlHandler.setMinerForKeyboardControl(this, true);
        }
    }

    @Override
    public boolean c(yw entityplayer) {
        if (this.i != null && this.i instanceof yw && this.i != entityplayer) {
            return true;
        }
        if (!this.k.F) {
            if (entityplayer.V()) {
                this.programmingGuiOpen = true;
                this.openedGui = true;
                PC_Utils.openGres(entityplayer, new PCmo_GuiMinerConsole(this));
                return true;
            }
            if (entityplayer.av() != null && entityplayer.av().c == mod_PCcore.activator.bQ) {
                this.setKeyboardControl(!this.keyboardControlled);
            } else if (entityplayer.av() != null && entityplayer.av().c == yr.D.bQ) {
                PC_Utils.chatMsg(this.u + "\u00b0", true);
                PC_Utils.chatMsg("PROGRAM: " + this.program, false);
                PC_Utils.chatMsg("Buffer: " + this.commandList.length() + " commands.", false);
                PC_Utils.chatMsg("Inctruction = " + Character.toString(PCmo_Command.getCharFromInt(this.currentCommand).charValue()) + ", Step counter = " + this.stepCounter, false);
                PC_Utils.chatMsg("FUEL: burning = " + this.fuelBuffer + ", allocated = " + this.fuelAllocated + ", deficit = " + this.waitingForFuel, false);
                PC_Utils.chatMsg("bridge = " + this.bridgeEnabled + ", mining = " + this.miningEnabled + ", destroy_flags = " + this.DESTROY, false);
            } else {
                this.openedGui = true;
                ModLoader.openGUI(entityplayer, new zn(entityplayer.ap, this));
            }
        }
        return true;
    }

    public void setDamageTaken(int i2) {
        this.ac.b(19, i2);
    }

    public int getDamageTaken() {
        return this.ac.c(19);
    }

    public void setTimeSinceHit(int i2) {
        this.ac.b(17, i2);
    }

    public int getTimeSinceHit() {
        return this.ac.c(17);
    }

    public void setForwardDirection(int i2) {
        this.ac.b(18, i2);
    }

    public int getForwardDirection() {
        return this.ac.c(18);
    }

    @Override
    public int a() {
        return 54;
    }

    @Override
    public aan k_(int i2) {
        return this.inventory[i2];
    }

    @Override
    public int d() {
        return 64;
    }

    @Override
    public aan a(int i2, int j2) {
        if (this.inventory[i2] != null) {
            if (this.inventory[i2].a <= j2) {
                aan itemstack = this.inventory[i2];
                this.inventory[i2] = null;
                this.j();
                return itemstack;
            }
            aan itemstack1 = this.inventory[i2].a(j2);
            if (this.inventory[i2].a == 0) {
                this.inventory[i2] = null;
            }
            this.j();
            return itemstack1;
        }
        return null;
    }

    @Override
    public void a(int i2, aan itemstack) {
        this.inventory[i2] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
        this.j();
    }

    @Override
    public String c() {
        return PC_Lang.tr("pc.miner.chestName");
    }

    @Override
    public boolean a_(yw entityplayer) {
        return entityplayer.f(this.o, this.p, this.q) <= 64.0;
    }

    @Override
    public void e() {
    }

    @Override
    public void f() {
        this.openedGui = false;
        this.updateLevel();
    }

    @Override
    public void j() {
    }

    private void consumeAllocatedFuel(int count) {
        this.fuelAllocated -= count;
        this.fuelBuffer -= count;
        if (this.fuelBuffer < 0) {
            this.fuelBuffer = 0;
        }
        if (this.fuelAllocated < 0) {
            this.fuelAllocated = 0;
        }
    }

    private void releaseAllocatedFuelIfNoLongerNeeded() {
        if (!this.isMiningInProgress() && this.currentCommand == -1) {
            this.fuelAllocated = 0;
        }
    }

    private boolean addFuelForCost(int cost) {
        if (this.fuelBuffer - this.fuelAllocated >= cost) {
            this.fuelAllocated += cost;
            return true;
        }
        for (int s2 = 0; s2 < this.a(); ++s2) {
            aan stack = this.k_(s2);
            int bt2 = PC_InvUtils.getFuelValue(stack, 0.9);
            if (bt2 <= 0) continue;
            this.fuelBuffer += bt2;
            if (stack.a().m()) {
                this.a(s2, new aan(stack.a().l(), 1, 0));
            } else {
                this.a(s2, 1);
            }
            if (this.fuelBuffer - this.fuelAllocated < cost) continue;
            this.fuelAllocated += cost;
            return true;
        }
        if (this.fuelBuffer - this.fuelAllocated >= cost) {
            this.fuelAllocated += cost;
            return true;
        }
        this.waitingForFuel += cost - (this.fuelBuffer + this.fuelAllocated);
        return false;
    }

    @Override
    public aan b(int par1) {
        if (this.inventory[par1] != null) {
            aan itemstack = this.inventory[par1];
            this.inventory[par1] = null;
            return itemstack;
        }
        return null;
    }
}

