/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Random;

public class PCmo_Command {
    private static final int COUNT = 20;
    public static String[] names = new String[20];
    public static Character[] chars = new Character[20];
    private static Random random = new Random();
    public static final int FORWARD = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int BACKWARD = 3;
    public static final int SOUTH = 4;
    public static final int NORTH = 5;
    public static final int EAST = 6;
    public static final int WEST = 7;
    public static final int DOWN = 8;
    public static final int UP = 9;
    public static final int DEPOSIT = 10;
    public static final int DISASSEMBLY = 11;
    public static final int MINING_ENABLE = 12;
    public static final int MINING_DISABLE = 13;
    public static final int BRIDGE_ENABLE = 14;
    public static final int BRIDGE_DISABLE = 15;
    public static final int LAVA_ENABLE = 16;
    public static final int LAVA_DISABLE = 17;
    public static final int WATER_ENABLE = 18;
    public static final int WATER_DISABLE = 19;
    public static final int RESET = -2;
    public static final int RUN_PROGRAM = -3;
    private static Hashtable vars;

    public static boolean isCommandTurn(int i2) {
        return i2 == 1 || i2 == 2;
    }

    public static boolean isCommandMove(int i2) {
        return i2 == 0 || i2 == 3;
    }

    public static boolean isCommandVertical(int i2) {
        return i2 == 9 || i2 == 8;
    }

    public static boolean isCommandCompass(int i2) {
        return i2 == 4 || i2 == 5 || i2 == 6 || i2 == 7;
    }

    public static boolean isCommandOption(int i2) {
        return i2 >= 12;
    }

    public static String getNameFromInt(int num) {
        if (num < 0 || num >= 20) {
            return "BAD_CMD";
        }
        return names[num];
    }

    public static Character getCharFromInt(int num) {
        if (num < 0 || num >= 20) {
            return Character.valueOf('?');
        }
        return Character.valueOf(chars[num].charValue());
    }

    public static int getIntFromChar(Character chr) {
        for (int i2 = 0; i2 < 20; ++i2) {
            if (!Character.valueOf(chars[i2].charValue()).equals(chr)) continue;
            return i2;
        }
        return -1;
    }

    private static void setVar(char index, int value) throws PCmo_CommandException {
        if (!Character.isLetter(Character.valueOf(index).charValue())) {
            throw new PCmo_CommandException("Bad variable name '" + index + "'.");
        }
        vars.put(Character.valueOf(index), value);
    }

    private static int getVar(char index) throws PCmo_CommandException {
        Object obj = vars.get(Character.valueOf(index));
        if (obj == null) {
            throw new PCmo_CommandException("Var '" + index + "' not initialized.");
        }
        if (!(obj instanceof Integer)) {
            throw new PCmo_CommandException("'" + index + "' not Integer.");
        }
        return (Integer)obj;
    }

    private static String parseEvaluateVars(String input) throws PCmo_CommandException {
        if (input.indexOf("<") == -1) {
            if (input.indexOf(">") != -1) {
                throw new PCmo_CommandException("Invalid var field syntax.");
            }
            return input;
        }
        if (input.indexOf(">") == -1) {
            throw new PCmo_CommandException("Invalid var field syntax.");
        }
        int pos = 0;
        int pos2 = 0;
        int lastVarEnd = 0;
        String output = "";
        String piece = "";
        while (true) {
            pos = input.indexOf("<", lastVarEnd);
            pos2 = input.indexOf(">", pos);
            if (pos < 0 || pos2 < 0) break;
            output = output + input.substring(lastVarEnd, pos);
            piece = input.substring(pos, pos2 + 1);
            lastVarEnd = pos2 + 1;
            int var = PCmo_Command.parseSingleVar(piece, false);
            if (var <= 0) continue;
            output = output + "," + Integer.toString(var) + ",";
        }
        output = output + input.substring(lastVarEnd, input.length());
        return output;
    }

    private static int parseLoopCount(String code) throws PCmo_CommandException {
        try {
            if (!Character.isDigit(Character.valueOf(code.charAt(0)).charValue()) && code.charAt(0) != '-') {
                throw new NumberFormatException();
            }
            int n2 = Integer.valueOf(code);
            if (n2 > 0) {
                return n2;
            }
            throw new PCmo_CommandException("Invalid loop count.");
        }
        catch (NumberFormatException nfe) {
            return PCmo_Command.parseSingleVar(code, true);
        }
    }

    private static int parseSingleVar(String code, boolean requireValue) throws PCmo_CommandException {
        String local = new String(code);
        if (code == null) {
            throw new PCmo_CommandException("parseSingleVar: NullPointer");
        }
        if (code.charAt(0) == '<' && code.charAt(code.length() - 1) == '>') {
            local = local.substring(1, local.length() - 1);
        }
        if (local.matches("[A-Z]{1}")) {
            return PCmo_Command.getVar(local.charAt(0));
        }
        if (local.matches("[\\-]?[0-9]+")) {
            return PCmo_Command.readInt(local, 0);
        }
        if (local.matches("RND\\*[\\-]?[0-9]+")) {
            try {
                return random.nextInt(PCmo_Command.readInt(local, 4));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
        }
        if (local.matches("RND\\*[A-Z]{1}")) {
            try {
                return random.nextInt(PCmo_Command.getVar(local.charAt(4)));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
        }
        if (local.matches("[A-Z]{1}[+\\-*%/]{1}RND\\*[0-9]+")) {
            try {
                return PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(0)), local.charAt(1), random.nextInt(PCmo_Command.readInt(local, 6)));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
        }
        if (local.matches("RND\\*[0-9]+[+\\-*%/]{1}[A-Z]{1}")) {
            try {
                return PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(local.length() - 1)), local.charAt(local.length() - 2), random.nextInt(PCmo_Command.readInt(local, 4)));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
        }
        if (local.matches("[\\-]?[0-9]+[+\\-*%/]{1}RND\\*[0-9]+")) {
            try {
                return PCmo_Command.numOp(PCmo_Command.readInt(local, 0), local.charAt(local.indexOf("RND") - 1), random.nextInt(PCmo_Command.readInt(local, local.indexOf("RND")) + 4));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
        }
        if (local.matches("RND\\*[0-9]+\\+[0-9]+")) {
            try {
                return PCmo_Command.numOp(PCmo_Command.readInt(local, local.indexOf("+") + 1), '+', random.nextInt(PCmo_Command.readInt(local, 4)));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
        }
        if (local.matches("[A-Z]{1}[+\\-%/*]{1}[0-9]+")) {
            char operation = local.charAt(1);
            int num = PCmo_Command.readInt(local, 2);
            int var = PCmo_Command.getVar(local.charAt(0));
            return PCmo_Command.numOp(var, operation, num);
        }
        if (local.matches("[A-Z]{1}[+\\-%/*]{1}[0-9]+")) {
            char operation = local.charAt(1);
            int var1 = PCmo_Command.getVar(local.charAt(0));
            int var2 = PCmo_Command.getVar(local.charAt(2));
            return PCmo_Command.numOp(var1, operation, var2);
        }
        if (requireValue) {
            throw new PCmo_CommandException("Loop count needs value!");
        }
        if (local.matches("[A-Z]{1}=[\\-]?[0-9]+")) {
            PCmo_Command.setVar(local.charAt(0), PCmo_Command.readInt(local, 2));
            return 0;
        }
        if (local.matches("[A-Z]{1}=RND\\*[0-9]+")) {
            try {
                PCmo_Command.setVar(local.charAt(0), random.nextInt(PCmo_Command.readInt(local, 6)));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
            return 0;
        }
        if (local.matches("[A-Z]{1}=[A-Z]{1}[+\\-*%/]{1}RND\\*[0-9]+")) {
            try {
                PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(2)), local.charAt(3), random.nextInt(PCmo_Command.readInt(local, 8))));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
            return 0;
        }
        if (local.matches("[A-Z]{1}=RND\\*[0-9]+[+\\-*%/]{1}[A-Z]{1}")) {
            try {
                PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(local.length() - 1)), local.charAt(local.length() - 2), random.nextInt(PCmo_Command.readInt(local, 6))));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
            return 0;
        }
        if (local.matches("[A-Z]{1}[+\\-*%/]{1}=RND\\*[0-9]+")) {
            try {
                PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(0)), local.charAt(1), random.nextInt(PCmo_Command.readInt(local, 7))));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
            return 0;
        }
        if (local.matches("[A-Z]{1}=[\\-]?[0-9]+[+\\-*%/]{1}RND\\*[0-9]+")) {
            try {
                PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.readInt(local, 2), local.charAt(local.indexOf("RND") - 1), random.nextInt(PCmo_Command.readInt(local, local.indexOf("RND")) + 4)));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
            return 0;
        }
        if (local.matches("[A-Z]{1}=RND\\*[0-9]+\\+[0-9]+")) {
            try {
                PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.readInt(local, local.indexOf("+") + 1), '+', random.nextInt(PCmo_Command.readInt(local, 6))));
            }
            catch (IllegalArgumentException iae) {
                throw new PCmo_CommandException("Negative random.");
            }
            return 0;
        }
        if (local.matches("[A-Z]{1}\\+\\+")) {
            PCmo_Command.setVar(local.charAt(0), PCmo_Command.getVar(local.charAt(0)) + 1);
            return 0;
        }
        if (local.matches("[A-Z]{1}\\-\\-")) {
            PCmo_Command.setVar(local.charAt(0), PCmo_Command.getVar(local.charAt(0)) - 1);
            return 0;
        }
        if (local.matches("[A-Z]{1}[+\\-%/*]{1}=[\\-]?[0-9]+")) {
            PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(0)), local.charAt(1), PCmo_Command.readInt(local, 3)));
            return 0;
        }
        if (local.matches("[A-Z]{1}[+\\-%/*]{1}=[A-Z]{1}")) {
            PCmo_Command.setVar(local.charAt(0), PCmo_Command.numOp(PCmo_Command.getVar(local.charAt(0)), local.charAt(1), PCmo_Command.getVar(local.charAt(3))));
            return 0;
        }
        if (local.matches("[A-Z]{1}=[A-Z]{1}[+\\-%/*]{1}[0-9]+")) {
            char var1 = local.charAt(0);
            char operation = local.charAt(3);
            int num = PCmo_Command.readInt(local, 4);
            int var2 = PCmo_Command.getVar(local.charAt(2));
            PCmo_Command.setVar(var1, PCmo_Command.numOp(var2, operation, num));
            return 0;
        }
        if (local.matches("[A-Z]{1}=[A-Z]{1}[+\\-%/*][A-Z]{1}")) {
            char operation = local.charAt(3);
            char var1 = local.charAt(0);
            int var2 = PCmo_Command.getVar(local.charAt(2));
            int var3 = PCmo_Command.getVar(local.charAt(4));
            PCmo_Command.setVar(var1, PCmo_Command.numOp(var2, operation, var3));
            return 0;
        }
        if (local.matches("[A-Z]{1}=[A-Z]{1}")) {
            PCmo_Command.setVar(local.charAt(0), PCmo_Command.getVar(local.charAt(2)));
            return 0;
        }
        throw new PCmo_CommandException("Invalid variable syntax.");
    }

    private static int numOp(int a2, char operation, int b2) {
        if (operation == '+') {
            return a2 + b2;
        }
        if (operation == '-') {
            return a2 - b2;
        }
        if (operation == '*') {
            return a2 * b2;
        }
        if (operation == '/') {
            return (int)Math.round((double)a2 / (double)b2);
        }
        if (operation == '%') {
            return a2 % b2;
        }
        return 0;
    }

    private static boolean parseGetEquationResult(String eq2) throws PCmo_CommandException {
        String local = eq2.replace("==", "=");
        local = local.replace("=>", ">=");
        if ((local = local.replace("=<", "<=")).matches(".+=.+")) {
            int b2;
            int a2 = PCmo_Command.parseSingleVar(local.substring(0, local.indexOf("=")), true);
            return a2 == (b2 = PCmo_Command.parseSingleVar(local.substring(local.indexOf("=") + 1, local.length()), true));
        }
        if (local.matches(".+!=.+")) {
            int b3;
            int a3 = PCmo_Command.parseSingleVar(local.substring(0, local.indexOf("!=")), true);
            return a3 != (b3 = PCmo_Command.parseSingleVar(local.substring(local.indexOf("!=") + 2, local.length()), true));
        }
        if (local.matches(".+>.+")) {
            int b4;
            int a4 = PCmo_Command.parseSingleVar(local.substring(0, local.indexOf(">")), true);
            return a4 > (b4 = PCmo_Command.parseSingleVar(local.substring(local.indexOf(">") + 1, local.length()), true));
        }
        if (local.matches(".+<.+")) {
            int b5;
            int a5 = PCmo_Command.parseSingleVar(local.substring(0, local.indexOf("<")), true);
            return a5 < (b5 = PCmo_Command.parseSingleVar(local.substring(local.indexOf("<") + 1, local.length()), true));
        }
        if (local.matches(".+>=.+")) {
            int b6;
            int a6 = PCmo_Command.parseSingleVar(local.substring(0, local.indexOf(">=")), true);
            return a6 >= (b6 = PCmo_Command.parseSingleVar(local.substring(local.indexOf(">=") + 2, local.length()), true));
        }
        if (local.matches(".+<=.+")) {
            int b7;
            int a7 = PCmo_Command.parseSingleVar(local.substring(0, local.indexOf("<=")), true);
            return a7 <= (b7 = PCmo_Command.parseSingleVar(local.substring(local.indexOf("<=") + 2, local.length()), true));
        }
        if (local.equals("RND")) {
            return random.nextBoolean();
        }
        throw new PCmo_CommandException("Invalid condition syntax.");
    }

    private static int readInt(String str, int pos) throws PCmo_CommandException {
        if (str.length() <= pos) {
            throw new PCmo_CommandException("Number expected.");
        }
        Character chr = Character.valueOf(str.charAt(pos));
        if (Character.isDigit(chr.charValue()) || chr.equals(Character.valueOf('-'))) {
            String numbuff = Character.toString(chr.charValue());
            ++pos;
            while (pos < str.length() && Character.isDigit((chr = Character.valueOf(str.charAt(pos))).charValue())) {
                numbuff = numbuff + chr.toString();
                ++pos;
            }
            try {
                return Integer.valueOf(numbuff);
            }
            catch (NumberFormatException nfe) {
                throw new PCmo_CommandException("Number expected.");
            }
        }
        throw new PCmo_CommandException("Number expected.");
    }

    public static String parseCode(String str) throws PCmo_CommandException {
        try {
            PC_Logger.fine("Parsing Miner's code:\n" + str);
            PC_Logger.finer("Erasing vars.");
            vars.clear();
            String local = new String(str);
            PC_Logger.finer("Removing spaces, endlines, converting brackets.");
            local = PCmo_Command.parseBatchReplace(local);
            PC_Logger.finer("Replacing aliases with one-letter commands.");
            local = PCmo_Command.parseReplaceAliases(local);
            PC_Logger.finer("Checking loops consistency.");
            if (!PCmo_Command.parseLoopConsistencyCheck(local)) {
                PC_Logger.warning("Loop consistency check failed, broken loops found!");
                throw new PCmo_CommandException("Unclosed or broken loops.");
            }
            PC_Logger.finer("Expanding loops, if-else statements, variables.");
            local = PCmo_Command.parseExpandLoops(local);
            PC_Logger.finer("Removing unknown commands from the output code.");
            local = PCmo_Command.parseRemoveUnknown(local);
            PC_Logger.finer("Output code:\n" + local);
            PC_Logger.fine("Parsing completed.");
            return local;
        }
        catch (PCmo_CommandException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            PC_Logger.finer("Unexpected throwable!");
            throw new PCmo_CommandException("Parse error.");
        }
    }

    private static String parseBatchReplace(String str) {
        String tmp = str.toUpperCase();
        tmp = tmp.replace(" ", "");
        tmp = tmp.replace("[", "(");
        tmp = tmp.replaceAll("[#']{1}.+$", "");
        tmp = tmp.replace("\n", "");
        tmp = tmp.replace("\r", "");
        tmp = tmp.replace("\t", "");
        tmp = tmp.replace("]", ")");
        tmp = tmp.replace("!", "/");
        tmp = tmp.replace("(LOOP", "(@");
        return tmp;
    }

    private static String parseReplaceAliases(String str) {
        String tmp = new String(str);
        tmp = tmp.replace("(MINING:ON)", "*");
        tmp = tmp.replace("(MINING)", "*");
        tmp = tmp.replace("(MINE)", "*");
        tmp = tmp.replace("(MI)", "*");
        tmp = tmp.replace("(M)", "*");
        tmp = tmp.replace("(MINE:ON)", "*");
        tmp = tmp.replace("(MI:ON)", "*");
        tmp = tmp.replace("(M:ON)", "*");
        tmp = tmp.replace("(MINING:OFF)", "%");
        tmp = tmp.replace("(/MINING)", "%");
        tmp = tmp.replace("(/MINE)", "%");
        tmp = tmp.replace("(/MI)", "%");
        tmp = tmp.replace("(/M)", "%");
        tmp = tmp.replace("(MINE:OFF)", "%");
        tmp = tmp.replace("(MI:OFF)", "%");
        tmp = tmp.replace("(M:OFF)", "%");
        tmp = tmp.replace("(BRIDGE:OFF)", "P");
        tmp = tmp.replace("(/BRIDGE)", "P");
        tmp = tmp.replace("(/BR)", "P");
        tmp = tmp.replace("(/B)", "P");
        tmp = tmp.replace("(BR:OFF)", "P");
        tmp = tmp.replace("(B:OFF)", "P");
        tmp = tmp.replace("(BRIDGE:ON)", "O");
        tmp = tmp.replace("(BRIDGE)", "O");
        tmp = tmp.replace("(BR)", "O");
        tmp = tmp.replace("(B)", "O");
        tmp = tmp.replace("(BR:ON)", "O");
        tmp = tmp.replace("(B:ON)", "O");
        tmp = tmp.replace("(LAVA:ON)", "I");
        tmp = tmp.replace("(LAVA)", "I");
        tmp = tmp.replace("(L)", "I");
        tmp = tmp.replace("(L:ON)", "I");
        tmp = tmp.replace("(LAVA:OFF)", "J");
        tmp = tmp.replace("(/LAVA)", "J");
        tmp = tmp.replace("(/L)", "J");
        tmp = tmp.replace("(L:OFF)", "J");
        tmp = tmp.replace("(WATER:ON)", "Y");
        tmp = tmp.replace("(WATER)", "Y");
        tmp = tmp.replace("(W)", "Y");
        tmp = tmp.replace("(W:ON)", "Y");
        tmp = tmp.replace("(WATER:OFF)", "Z");
        tmp = tmp.replace("(/WATER)", "Z");
        tmp = tmp.replace("(/W)", "Z");
        tmp = tmp.replace("(W:OFF)", "Z");
        tmp = tmp.replace("(DROP)", "Q");
        tmp = tmp.replace("(DEPOSIT)", "Q");
        tmp = tmp.replace("(EJECT)", "Q");
        tmp = tmp.replace("(STORE)", "Q");
        tmp = tmp.replace("(DIE)", "X");
        tmp = tmp.replace("(HALT)", "X");
        tmp = tmp.replace("(TOBLOCKS)", "X");
        tmp = tmp.replace("(BLOCKS)", "X");
        return tmp;
    }

    private static boolean parseLoopConsistencyCheck(String source) {
        int openLoops = 0;
        for (int pos = 0; pos < source.length(); ++pos) {
            Character chr = Character.valueOf(source.charAt(pos));
            if (Character.valueOf(chr.charValue()).equals(Character.valueOf('('))) {
                ++openLoops;
            }
            if (!Character.valueOf(chr.charValue()).equals(Character.valueOf(')'))) continue;
            --openLoops;
        }
        return openLoops == 0;
    }

    private static String parseIfElse(String source) throws PCmo_CommandException {
        PC_Logger.finer("Parsing IF-ELSE " + source);
        String local = new String(source);
        if (!Character.valueOf(local.charAt(0)).equals(Character.valueOf('('))) {
            PC_Logger.warning("error 1: " + local);
            throw new PCmo_CommandException("Bad if-else syntax.");
        }
        if (!Character.valueOf(local.charAt(local.length() - 1)).equals(Character.valueOf(')'))) {
            PC_Logger.warning("error 2: " + local);
            throw new PCmo_CommandException("Bad if-else syntax.");
        }
        local = local.substring(1, local.length() - 1);
        int qmark = local.indexOf("?");
        int ddot = local.indexOf(":");
        if (qmark == -1 || ddot > -1 && ddot < qmark) {
            PC_Logger.warning("error 3: " + local);
            throw new PCmo_CommandException("Bad if-else syntax.");
        }
        String equation = local.substring(0, qmark);
        if (PCmo_Command.parseGetEquationResult(equation)) {
            PC_Logger.finest("true, qmark=" + qmark + ", ddot=" + ddot);
            PC_Logger.finest("parsing->" + local.substring(qmark + 1, ddot > qmark ? ddot : local.length()));
            return PCmo_Command.parseExpandLoops(local.substring(qmark + 1, ddot > qmark ? ddot : local.length()));
        }
        PC_Logger.finest("false, qmark=" + qmark + ", ddot=" + ddot);
        if (ddot != -1) {
            return PCmo_Command.parseExpandLoops(local.substring(ddot + 1, local.length()));
        }
        return "";
    }

    private static String parseExpandLoops(String source) throws PCmo_CommandException {
        return PCmo_Command.parseExpandLoops(source, 0);
    }

    private static String parseExpandLoops(String source, int recursion) throws PCmo_CommandException {
        if (++recursion > 5000) {
            PC_Logger.warning("Recursion limit exceeded.");
            throw new PCmo_CommandException("Recursion limit exceeded.");
        }
        String output = new String("");
        int openLoops = 0;
        int posOpen = 0;
        int posClosed = 0;
        int repeatCount = 0;
        int pos = 0;
        boolean ifElse = false;
        if (source.indexOf("(") == -1) {
            return PCmo_Command.parseEvaluateVars(source);
        }
        if (source.indexOf("@") == -1) {
            ifElse = true;
        }
        if (source.indexOf(":") == -1) {
            PC_Logger.warning(": not found");
            if (!ifElse) {
                throw new PCmo_CommandException("Invalid loop syntax.");
            }
        }
        if (source.indexOf(")") == -1) {
            PC_Logger.warning(") not found");
            throw new PCmo_CommandException("Unclosed brackets.");
        }
        block4: while (pos < source.length()) {
            Character chr = Character.valueOf(source.charAt(pos));
            pos = source.indexOf("(", posClosed);
            if (pos > 0) {
                output = output + PCmo_Command.parseEvaluateVars(source.substring(posClosed, pos));
            }
            if (pos == -1) {
                output = output + PCmo_Command.parseEvaluateVars(source.substring(posClosed));
                break;
            }
            if (Character.valueOf(source.charAt(pos + 1)).equals(Character.valueOf('@'))) {
                String numbuf;
                ++pos;
                int posLimiter = source.indexOf(":", posClosed);
                ++pos;
                try {
                    numbuf = source.substring(pos, posLimiter);
                }
                catch (StringIndexOutOfBoundsException ee2) {
                    throw new PCmo_CommandException("Loop syntax error.");
                }
                repeatCount = PCmo_Command.parseLoopCount(numbuf);
                posOpen = pos = posLimiter + 1;
                openLoops = 1;
                while (pos < source.length()) {
                    chr = Character.valueOf(source.charAt(pos));
                    if (Character.valueOf(chr.charValue()).equals(Character.valueOf('('))) {
                        ++openLoops;
                    }
                    if (Character.valueOf(chr.charValue()).equals(Character.valueOf(')'))) {
                        --openLoops;
                    }
                    if (openLoops == 0) {
                        String repeated = source.substring(posOpen, pos);
                        boolean novars = false;
                        String parsedRep = "";
                        if (repeated.indexOf("<") == -1 && repeated.indexOf("?") == -1) {
                            novars = true;
                        }
                        if (novars) {
                            parsedRep = PCmo_Command.parseExpandLoops(repeated);
                        }
                        while (repeatCount > 0) {
                            if (!novars) {
                                parsedRep = PCmo_Command.parseExpandLoops(repeated);
                            }
                            output = output + "," + parsedRep + ",";
                            --repeatCount;
                        }
                        openLoops = 0;
                        posClosed = pos + 1;
                        continue block4;
                    }
                    ++pos;
                }
                if (openLoops <= 0) continue;
                throw new PCmo_CommandException("Unclosed loops.");
            }
            int ifElseStart = pos++;
            openLoops = 1;
            while (pos < source.length()) {
                chr = Character.valueOf(source.charAt(pos));
                if (Character.valueOf(chr.charValue()).equals(Character.valueOf('('))) {
                    ++openLoops;
                }
                if (Character.valueOf(chr.charValue()).equals(Character.valueOf(')'))) {
                    --openLoops;
                }
                if (openLoops == 0) {
                    output = output + PCmo_Command.parseIfElse(source.substring(ifElseStart, pos + 1));
                    openLoops = 0;
                    posClosed = pos + 1;
                    continue block4;
                }
                ++pos;
            }
        }
        return output;
    }

    private static String parseRemoveUnknown(String code) throws PCmo_CommandException {
        String str = new String(code);
        str = str.replaceAll(",+", ",");
        str = str.replaceAll("([^0-9]),", "$1");
        str = str.replaceAll(",([^0-9])", "$1");
        str = str.replaceAll("^,", "");
        str = str.replaceAll(",$", "");
        String codeBuffer = "";
        while (str.length() > 0) {
            Character chr = Character.valueOf(str.charAt(0));
            if (!(PCmo_Command.getIntFromChar(chr) != -1 || Character.isDigit(chr.charValue()) || chr.equals(Character.valueOf('-')) || chr.equals(Character.valueOf(',')))) {
                throw new PCmo_CommandException("'" + chr.toString() + "' is not a valid command.");
            }
            codeBuffer = codeBuffer + chr.toString();
            str = str.substring(1);
        }
        return codeBuffer;
    }

    static {
        PCmo_Command.names[0] = "FORWARD";
        PCmo_Command.names[1] = "TURN_LEFT";
        PCmo_Command.names[2] = "TURN_RIGHT";
        PCmo_Command.names[3] = "BACKWARD";
        PCmo_Command.names[4] = "FORWARD";
        PCmo_Command.names[5] = "TURN_LEFT";
        PCmo_Command.names[6] = "TURN_RIGHT";
        PCmo_Command.names[7] = "BACKWARD";
        PCmo_Command.names[8] = "MINE_DOWN";
        PCmo_Command.names[9] = "MINE_UP";
        PCmo_Command.names[10] = "DEPOSIT";
        PCmo_Command.names[11] = "TO_BLOCKS";
        PCmo_Command.names[12] = "MINING_ENABLE";
        PCmo_Command.names[13] = "MINING_DISABLE";
        PCmo_Command.names[14] = "BRIDGE_ENABLE";
        PCmo_Command.names[15] = "BRIDGE_DISABLE";
        PCmo_Command.names[16] = "LAVA_ENABLE";
        PCmo_Command.names[17] = "LAVA_DISABLE";
        PCmo_Command.names[18] = "WATER_ENABLE";
        PCmo_Command.names[19] = "WATER_DISABLE";
        PCmo_Command.chars[0] = Character.valueOf('F');
        PCmo_Command.chars[1] = Character.valueOf('L');
        PCmo_Command.chars[2] = Character.valueOf('R');
        PCmo_Command.chars[3] = Character.valueOf('B');
        PCmo_Command.chars[4] = Character.valueOf('S');
        PCmo_Command.chars[5] = Character.valueOf('N');
        PCmo_Command.chars[6] = Character.valueOf('E');
        PCmo_Command.chars[7] = Character.valueOf('W');
        PCmo_Command.chars[8] = Character.valueOf('D');
        PCmo_Command.chars[9] = Character.valueOf('U');
        PCmo_Command.chars[10] = Character.valueOf('Q');
        PCmo_Command.chars[11] = Character.valueOf('X');
        PCmo_Command.chars[12] = Character.valueOf('*');
        PCmo_Command.chars[13] = Character.valueOf('%');
        PCmo_Command.chars[14] = Character.valueOf('O');
        PCmo_Command.chars[15] = Character.valueOf('P');
        PCmo_Command.chars[16] = Character.valueOf('I');
        PCmo_Command.chars[17] = Character.valueOf('J');
        PCmo_Command.chars[18] = Character.valueOf('Y');
        PCmo_Command.chars[19] = Character.valueOf('Z');
        vars = new Hashtable();
    }
}

