/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class PCma_BeamTracer
extends PC_BeamTracerBase {
    private boolean reflectMirror = false;
    private boolean reflectPrism = false;
    private static final float[] mirrorAngle = new float[16];
    private static final int[] mirrorTo45;
    private static final int n = 0;
    private static final PC_CoordI[] prismMove;
    private ArrayList usedPrisms = new ArrayList();

    public PCma_BeamTracer(xd worldObj, PC_IBeamHandler handler) {
        super(worldObj, handler);
    }

    public PC_BeamTracerBase setReflectedByMirror(boolean state) {
        this.reflectMirror = state;
        return this;
    }

    public PC_BeamTracerBase setReflectedByPrism(boolean state) {
        this.reflectPrism = state;
        return this;
    }

    @Override
    public void flash() {
        this.usedPrisms.clear();
        super.flash();
    }

    private PC_CoordI getPrismOutputMove(int side) {
        return prismMove[side];
    }

    private int getPrismSideFacingMove(PC_CoordI move) {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!prismMove[i2].equals(move.getInverted())) continue;
            return i2;
        }
        return -1;
    }

    private static float getAngleFromMove(PC_CoordI move) {
        float beamAngle = 0.0f;
        if (move.x == 0 && move.z == -1) {
            beamAngle = 0.0f;
        }
        if (move.x == 1 && move.z == -1) {
            beamAngle = 45.0f;
        }
        if (move.x == 1 && move.z == 0) {
            beamAngle = 90.0f;
        }
        if (move.x == 1 && move.z == 1) {
            beamAngle = 135.0f;
        }
        if (move.x == 0 && move.z == 1) {
            beamAngle = 180.0f;
        }
        if (move.x == -1 && move.z == 1) {
            beamAngle = 225.0f;
        }
        if (move.x == -1 && move.z == 0) {
            beamAngle = 270.0f;
        }
        if (move.x == -1 && move.z == -1) {
            beamAngle = 315.0f;
        }
        return beamAngle;
    }

    private static PC_CoordI getMoveFromAngle(float angle) {
        int angleint = Math.round(angle);
        switch (angleint) {
            case 0: {
                return new PC_CoordI(0, 0, -1);
            }
            case 45: {
                return new PC_CoordI(1, 0, -1);
            }
            case 90: {
                return new PC_CoordI(1, 0, 0);
            }
            case 135: {
                return new PC_CoordI(1, 0, 1);
            }
            case 180: {
                return new PC_CoordI(0, 0, 1);
            }
            case 225: {
                return new PC_CoordI(-1, 0, 1);
            }
            case 270: {
                return new PC_CoordI(-1, 0, 0);
            }
            case 315: {
                return new PC_CoordI(-1, 0, -1);
            }
        }
        return null;
    }

    private static float angleDiff(float firstAngle, float secondAngle) {
        float difference;
        for (difference = secondAngle - firstAngle; difference < -180.0f; difference += 360.0f) {
        }
        while (difference > 180.0f) {
            difference -= 360.0f;
        }
        return difference;
    }

    private static float fixAngle(float angle) {
        while (angle > 360.0f) {
            angle -= 360.0f;
        }
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public PC_BeamTracerBase.result onBlockHit(PC_CoordI coord, PC_CoordI move, PC_CoordI moveOld, PC_Color color, int remainingLength) {
        int id2 = this.world.a(coord.x, coord.y, coord.z);
        int meta = this.world.e(coord.x, coord.y, coord.z);
        if (pb.m[id2] == null) {
            return PC_BeamTracerBase.result.CONTINUE;
        }
        if (id2 == mod_PCmachines.optical.bO) {
            if (PCma_BlockOptical.isMirror(this.world, coord.x, coord.y, coord.z) && this.reflectMirror) {
                int mirrorColor = PCma_BlockOptical.getMirrorColor(this.world, coord.x, coord.y, coord.z);
                if (mirrorColor == -1 || mirrorColor == color.getMeta()) {
                    if (move.x == 0 && move.z == 0) {
                        moveOld.setTo(move);
                        int a2 = mirrorTo45[meta];
                        PC_CoordI reflected = PCma_BeamTracer.getMoveFromAngle(a2).getInverted();
                        move.x = reflected.x;
                        move.z = reflected.z;
                        return PC_BeamTracerBase.result.CONTINUE_DIR_CHANGE;
                    }
                    float beamAngle = PCma_BeamTracer.getAngleFromMove(move);
                    float mAngle = mirrorAngle[meta];
                    float diff = PCma_BeamTracer.angleDiff(beamAngle, mAngle);
                    float beamNew = beamAngle + diff * 2.0f;
                    beamNew = PCma_BeamTracer.fixAngle(beamNew);
                    moveOld.setTo(move);
                    PC_CoordI reflected = PCma_BeamTracer.getMoveFromAngle(beamNew).getInverted();
                    move.x = reflected.x;
                    move.z = reflected.z;
                    return PC_BeamTracerBase.result.CONTINUE_DIR_CHANGE;
                }
            } else if (PCma_BlockOptical.isPrism(this.world, coord.x, coord.y, coord.z) && this.reflectPrism) {
                int h2;
                if (this.usedPrisms.contains(coord)) {
                    return PC_BeamTracerBase.result.STOP;
                }
                this.usedPrisms.add(coord.copy());
                PCma_TileEntityOptical prism = PCma_BlockOptical.getTE(this.world, coord.x, coord.y, coord.z);
                int sideCount = 0;
                int[] side = new int[10];
                int thisPrismSide = this.getPrismSideFacingMove(move);
                for (h2 = 0; h2 < 10; ++h2) {
                    if (!prism.getPrismSide(h2) || h2 == thisPrismSide) continue;
                    side[sideCount] = h2;
                    ++sideCount;
                }
                if (sideCount >= 1) {
                    for (h2 = 0; h2 < sideCount; ++h2) {
                        PC_CoordI newMove = this.getPrismOutputMove(side[h2]).copy();
                        if (color.isVisible()) {
                            this.spawnParticles(coord, newMove, 2, color);
                        }
                        this.forkBeam(coord, newMove, color, remainingLength / Math.round((float)sideCount * 0.75f));
                    }
                }
                if (sideCount > 0) {
                    return PC_BeamTracerBase.result.STOP;
                }
                return PC_BeamTracerBase.result.CONTINUE;
            }
            return PC_BeamTracerBase.result.CONTINUE;
        }
        return PC_BeamTracerBase.result.FALLBACK;
    }

    static {
        for (int a2 = 0; a2 < 8; ++a2) {
            PCma_BeamTracer.mirrorAngle[a2] = (float)a2 * 22.5f;
            PCma_BeamTracer.mirrorAngle[a2 + 8] = (float)a2 * 22.5f;
        }
        mirrorTo45 = new int[]{0, 0, 45, 90, 90, 90, 135, 180, 180, 180, 225, 270, 270, 270, 315, 0};
        prismMove = new PC_CoordI[]{new PC_CoordI(0, -1, 0), new PC_CoordI(0, 1, 0), new PC_CoordI(1, 0, 0), new PC_CoordI(1, 0, 1), new PC_CoordI(0, 0, 1), new PC_CoordI(-1, 0, 1), new PC_CoordI(-1, 0, 0), new PC_CoordI(-1, 0, -1), new PC_CoordI(0, 0, -1), new PC_CoordI(1, 0, -1)};
    }
}

