/*
 * Decompiled with CFR 0.152.
 */
public class PClo_GuiRadioChannel
implements PC_IGresBase {
    private String errMsg = "";
    public static final int RECEIVER = 1;
    public static final int TRANSMITTER = 0;
    private int type;
    private PC_CoordI pos;
    private String oldChannel;
    private String editedString;
    private int dim = 0;
    private PC_GresWidget buttonOK;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget edit;
    private PC_GresWidget txError;

    public PClo_GuiRadioChannel(int dimen, PC_CoordI blockPos, String s2, int radiotype) {
        this.editedString = s2;
        this.oldChannel = new String(s2);
        this.type = radiotype;
        this.pos = blockPos;
        this.dim = dimen;
    }

    @Override
    public yw getPlayer() {
        return PC_Utils.mc().h;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        String title = "";
        title = this.type == 0 ? PC_Lang.tr("tile.PCloRadio.tx.name") : PC_Lang.tr("tile.PCloRadio.rx.name");
        PC_GresWindow w2 = new PC_GresWindow(title);
        w2.setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        PC_GresWidget vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg2.add(new PC_GresLabel(PC_Lang.tr("pc.gui.radio.channel")));
        this.edit = new PC_GresTextEdit(this.editedString, 8, PC_GresTextEdit.PC_GresInputType.TEXT).setMinWidth(130);
        vg2.add(this.edit);
        w2.add(vg2);
        PC_GresWidget hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        hg2.add(this.txError);
        w2.add(hg2);
        hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg2.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg2.add(this.buttonOK);
        w2.add(hg2);
        gui.add(w2);
        gui.setPausesGame(true);
        this.actionPerformed(this.edit, gui);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget.getId() == 0) {
            String newChannel = this.edit.getText().trim();
            PClo_TileEntityRadio ter = PClo_BlockRadio.getTE(PC_Utils.mc().f, this.pos.x, this.pos.y, this.pos.z);
            if (this.type == 0) {
                PClo_RadioManager.setTransmitterChannel(this.dim, this.pos, this.oldChannel, newChannel, ter.isActive());
            } else {
                PClo_RadioManager.setReceiverChannel(this.dim, this.pos, newChannel);
            }
            ter.channel = newChannel;
            ter.dim = this.dim;
            if (this.type == 1) {
                boolean bl2 = ter.active = PClo_RadioManager.getSignalStrength(newChannel) > 0;
                if (ter.active) {
                    PC_Utils.mc().f.f(this.pos.x, this.pos.y, this.pos.z, 1);
                }
            }
            PC_Utils.mc().f.a(this.pos.x, this.pos.y, this.pos.z, mod_PClogic.radio.bO, 1);
            gui.close();
        } else if (widget.getId() == 1) {
            gui.close();
        }
        if (widget == this.edit) {
            if (this.edit.getText().trim().length() == 0) {
                this.errMsg = "pc.gui.radio.errChannel";
                this.txError.setText(PC_Lang.tr(this.errMsg));
            } else {
                this.txError.setText("");
            }
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(io iinventory) {
    }
}

