/*
 * Decompiled with CFR 0.152.
 */
public class PClo_GuiPulsar
implements PC_IGresBase {
    private PC_GresWidget buttonOK;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget editDelay;
    private PC_GresWidget editHold;
    private PC_GresWidget txError;
    private PC_GresWidget txConvDelay;
    private PC_GresWidget txConvHold;
    private boolean errorDelay = false;
    private boolean errorHold = false;
    private PClo_TileEntityPulsar pulsar;
    private PC_GresCheckBox checkSilent;
    private int delay_ticks;
    private int hold_ticks;

    public PClo_GuiPulsar(PClo_TileEntityPulsar tep) {
        this.pulsar = tep;
        this.delay_ticks = this.pulsar.delay;
        this.hold_ticks = this.pulsar.holdtime;
    }

    @Override
    public yw getPlayer() {
        return PC_Utils.mc().h;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        PC_GresWindow w2 = new PC_GresWindow(PC_Lang.tr("tile.PCloRedstonePulsar.name"));
        w2.setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        PC_GresWidget hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        PC_GresWidget vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg2.add(new PC_GresLabel(PC_Lang.tr("pc.gui.pulsar.delay")));
        this.editDelay = new PC_GresTextEdit(PC_Utils.doubleToString(PC_Utils.ticksToSecs(this.delay_ticks)), 8, PC_GresTextEdit.PC_GresInputType.UNSIGNED_FLOAT);
        vg2.add(this.editDelay);
        this.txConvDelay = new PC_GresLabelMultiline("", this.editDelay.getMinSize().x).setMinRows(2).setColor(0, 0x606060);
        vg2.add(this.txConvDelay);
        hg2.add(vg2);
        vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg2.add(new PC_GresLabel(PC_Lang.tr("pc.gui.pulsar.hold")));
        this.editHold = new PC_GresTextEdit(PC_Utils.doubleToString(PC_Utils.ticksToSecs(this.hold_ticks)), 8, PC_GresTextEdit.PC_GresInputType.UNSIGNED_FLOAT);
        vg2.add(this.editHold);
        this.txConvHold = new PC_GresLabelMultiline("", this.editDelay.getMinSize().x).setMinRows(2).setColor(0, 0x606060);
        vg2.add(this.txConvHold);
        hg2.add(vg2);
        w2.add(hg2);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        w2.add(this.txError);
        hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.checkSilent = new PC_GresCheckBox(PC_Lang.tr("pc.gui.pulsar.silent")).check(this.pulsar.silent);
        hg2.add(this.checkSilent);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg2.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg2.add(this.buttonOK);
        w2.add(hg2);
        gui.add(w2);
        gui.setPausesGame(false);
        this.actionPerformed(this.editHold, gui);
        this.actionPerformed(this.editDelay, gui);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget.getId() == 0) {
            this.pulsar.setDelay(this.delay_ticks);
            this.pulsar.setHoldTime(this.hold_ticks);
            this.pulsar.setSilent(this.checkSilent.isChecked());
            gui.close();
        } else if (widget.getId() == 1) {
            gui.close();
        }
        if (widget == this.editDelay || widget == this.editHold) {
            try {
                double time = Double.valueOf(this.editDelay.getText());
                this.delay_ticks = PC_Utils.secsToTicks(time);
                this.errorDelay = this.delay_ticks < 2 || this.delay_ticks > 150000;
            }
            catch (NumberFormatException nfe) {
                this.errorDelay = true;
            }
            catch (NullPointerException npe) {
                this.errorDelay = true;
            }
            String conv = "";
            if (!this.errorDelay) {
                conv = conv + "= " + this.delay_ticks + " " + PC_Lang.tr("pc.gui.gate.delayer.ticks");
                if (this.delay_ticks >= 1200) {
                    conv = conv + "\n= " + PC_Utils.formatTimeTicks(this.delay_ticks);
                }
            }
            this.txConvDelay.setText(conv);
            try {
                double time = Double.valueOf(this.editHold.getText());
                this.hold_ticks = PC_Utils.secsToTicks(time);
                this.errorHold = this.hold_ticks >= this.delay_ticks - 1 || this.hold_ticks < 1;
            }
            catch (NumberFormatException nfe) {
                this.errorHold = true;
            }
            catch (NullPointerException npe) {
                this.errorHold = true;
            }
            conv = "";
            if (!this.errorHold) {
                conv = conv + "= " + this.hold_ticks + " " + PC_Lang.tr("pc.gui.gate.delayer.ticks");
                if (this.hold_ticks >= 1200) {
                    conv = conv + "\n= " + PC_Utils.formatTimeTicks(this.hold_ticks);
                }
            }
            this.txConvHold.setText(conv);
        }
        if (this.errorDelay) {
            this.txError.setText(PC_Lang.tr("pc.gui.pulsar.errDelay"));
        } else if (this.errorHold) {
            this.txError.setText(PC_Lang.tr("pc.gui.pulsar.errHold"));
        } else {
            this.txError.setText("");
        }
        this.buttonOK.enable(!this.errorDelay && !this.errorHold);
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(io iinventory) {
    }
}

